/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.mobile.ui.widget.SwipeMenu;
import com.yy.mobile.ui.widget.SwipeMenuItem;
import com.yy.mobile.ui.widget.SwipeMenuLayout;
import com.yy.mobile.ui.widget.SwipeMenuListView;
import java.util.List;

public class SwipeMenuView
extends LinearLayout
implements View.OnClickListener {
    private SwipeMenuListView mListView;
    private SwipeMenuLayout mLayout;
    private SwipeMenu mMenu;
    private OnSwipeItemClickListener onItemClickListener;
    private int position;

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public SwipeMenuView(SwipeMenu menu, SwipeMenuListView listView) {
        super(menu.getContext());
        this.mListView = listView;
        this.mMenu = menu;
        List<SwipeMenuItem> items = menu.getMenuItems();
        int id2 = 0;
        for (SwipeMenuItem item : items) {
            this.addItem(item, id2++);
        }
    }

    private void addItem(SwipeMenuItem item, int id2) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(item.getWidth(), -1);
        LinearLayout parent = new LinearLayout(this.getContext());
        parent.setId(id2);
        parent.setGravity(17);
        parent.setOrientation(1);
        parent.setLayoutParams((ViewGroup.LayoutParams)params);
        parent.setBackgroundDrawable(item.getBackground());
        parent.setOnClickListener((View.OnClickListener)this);
        this.addView((View)parent);
        if (item.getIcon() != null) {
            parent.addView((View)this.createIcon(item));
        }
        if (!TextUtils.isEmpty((CharSequence)item.getTitle())) {
            parent.addView((View)this.createTitle(item));
        }
    }

    private ImageView createIcon(SwipeMenuItem item) {
        ImageView iv = new ImageView(this.getContext());
        iv.setImageDrawable(item.getIcon());
        return iv;
    }

    private TextView createTitle(SwipeMenuItem item) {
        TextView tv = new TextView(this.getContext());
        tv.setText((CharSequence)item.getTitle());
        tv.setGravity(17);
        tv.setTextSize((float)item.getTitleSize());
        tv.setTextColor(item.getTitleColor());
        return tv;
    }

    public void onClick(View v) {
        if (this.onItemClickListener != null && this.mLayout.isOpen()) {
            this.onItemClickListener.onItemClick(this, this.mMenu, v.getId());
        }
    }

    public OnSwipeItemClickListener getOnSwipeItemClickListener() {
        return this.onItemClickListener;
    }

    public void setOnSwipeItemClickListener(OnSwipeItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setLayout(SwipeMenuLayout mLayout) {
        this.mLayout = mLayout;
    }

    public static interface OnSwipeItemClickListener {
        public void onItemClick(SwipeMenuView var1, SwipeMenu var2, int var3);
    }
}

