/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.core.view.MotionEventCompat;
import com.yy.mobile.ui.widget.SwipeMenu;
import com.yy.mobile.ui.widget.SwipeMenuAdapter;
import com.yy.mobile.ui.widget.SwipeMenuCreator;
import com.yy.mobile.ui.widget.SwipeMenuLayout;
import com.yy.mobile.ui.widget.SwipeMenuView;
import com.yy.mobile.util.ResolutionUtils;

public class SwipeMenuListView
extends ListView {
    private static final int TOUCH_STATE_NONE = 0;
    private static final int TOUCH_STATE_X = 1;
    private static final int TOUCH_STATE_Y = 2;
    private int maxY = 5;
    private int maxX = 3;
    private float mDownX;
    private float mDownY;
    private int mTouchState;
    private int mTouchPosition;
    private SwipeMenuLayout mTouchView;
    private OnSwipeListener mOnSwipeListener;
    private SwipeMenuCreator mMenuCreator;
    private OnMenuItemClickListener mOnMenuItemClickListener;
    private Interpolator mCloseInterpolator;
    private Interpolator mOpenInterpolator;
    float threshold = ResolutionUtils.convertDpToPixel((float)4.0f, (Context)this.getContext());
    Boolean canParentScroll = true;
    ViewGroup parentScrollView;

    public SwipeMenuListView(Context context) {
        super(context);
        this.init();
    }

    public SwipeMenuListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public SwipeMenuListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.maxX = this.dp2px(this.maxX);
        this.maxY = this.dp2px(this.maxY);
        this.mTouchState = 0;
    }

    public void setAdapter(ListAdapter adapter) {
        super.setAdapter((ListAdapter)new SwipeMenuAdapter(this.getContext(), adapter){

            @Override
            public void createMenu(SwipeMenu menu) {
                if (SwipeMenuListView.this.mMenuCreator != null) {
                    SwipeMenuListView.this.mMenuCreator.create(menu);
                }
            }

            @Override
            public void onItemClick(SwipeMenuView view, SwipeMenu menu, int index) {
                boolean flag = false;
                if (SwipeMenuListView.this.mOnMenuItemClickListener != null) {
                    flag = SwipeMenuListView.this.mOnMenuItemClickListener.onMenuItemClick(view.getPosition(), menu, index);
                }
                if (SwipeMenuListView.this.mTouchView != null && !flag) {
                    SwipeMenuListView.this.mTouchView.smoothCloseMenu();
                }
            }
        });
    }

    public void setCloseInterpolator(Interpolator interpolator) {
        this.mCloseInterpolator = interpolator;
    }

    public void setOpenInterpolator(Interpolator interpolator) {
        this.mOpenInterpolator = interpolator;
    }

    public Interpolator getOpenInterpolator() {
        return this.mOpenInterpolator;
    }

    public Interpolator getCloseInterpolator() {
        return this.mCloseInterpolator;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.setParentScrollAble(false);
        if (ev.getAction() != 0 && this.mTouchView == null) {
            return super.onTouchEvent(ev);
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        action = ev.getAction();
        switch (action) {
            case 0: {
                this.canParentScroll = true;
                int oldPos = this.mTouchPosition;
                this.mDownX = ev.getX();
                this.mDownY = ev.getY();
                this.mTouchState = 0;
                this.mTouchPosition = this.pointToPosition((int)ev.getX(), (int)ev.getY());
                if (this.mTouchPosition == oldPos && this.mTouchView != null && this.mTouchView.isOpen()) {
                    this.mTouchState = 1;
                    this.mTouchView.onSwipe(ev);
                    return true;
                }
                View view = this.getChildAt(this.mTouchPosition - this.getFirstVisiblePosition());
                if (this.mTouchView != null && this.mTouchView.isOpen()) {
                    this.mTouchView.smoothCloseMenu();
                    this.mTouchView = null;
                    return super.onTouchEvent(ev);
                }
                if (view instanceof SwipeMenuLayout) {
                    this.mTouchView = (SwipeMenuLayout)view;
                }
                if (this.mTouchView == null) break;
                this.mTouchView.onSwipe(ev);
                break;
            }
            case 2: {
                float dy = Math.abs(ev.getY() - this.mDownY);
                float dx = Math.abs(ev.getX() - this.mDownX);
                if (dx > this.threshold) {
                    this.canParentScroll = false;
                }
                if (dy > this.threshold && this.canParentScroll.booleanValue()) {
                    this.setParentScrollAble(true);
                }
                if (this.mTouchState == 1) {
                    if (this.mTouchView != null) {
                        this.mTouchView.onSwipe(ev);
                    }
                    this.getSelector().setState(new int[]{0});
                    ev.setAction(3);
                    super.onTouchEvent(ev);
                    return true;
                }
                if (this.mTouchState != 0) break;
                if (Math.abs(dy) > (float)this.maxY) {
                    this.mTouchState = 2;
                    break;
                }
                if (!(dx > (float)this.maxX)) break;
                this.mTouchState = 1;
                if (this.mOnSwipeListener == null) break;
                this.mOnSwipeListener.onSwipeStart(this.mTouchPosition);
                break;
            }
            case 1: {
                this.setParentScrollAble(false);
                this.canParentScroll = true;
                if (this.mTouchState != 1) break;
                if (this.mTouchView != null) {
                    this.mTouchView.onSwipe(ev);
                    if (!this.mTouchView.isOpen()) {
                        this.mTouchPosition = -1;
                        this.mTouchView = null;
                    }
                }
                if (this.mOnSwipeListener != null) {
                    this.mOnSwipeListener.onSwipeEnd(this.mTouchPosition);
                }
                ev.setAction(3);
                super.onTouchEvent(ev);
                return true;
            }
            case 3: {
                this.setParentScrollAble(false);
                this.canParentScroll = true;
                break;
            }
        }
        return super.onTouchEvent(ev);
    }

    public void smoothOpenMenu(int position) {
        View view;
        if (position >= this.getFirstVisiblePosition() && position <= this.getLastVisiblePosition() && (view = this.getChildAt(position - this.getFirstVisiblePosition())) instanceof SwipeMenuLayout) {
            this.mTouchPosition = position;
            if (this.mTouchView != null && this.mTouchView.isOpen()) {
                this.mTouchView.smoothCloseMenu();
            }
            this.mTouchView = (SwipeMenuLayout)view;
            this.mTouchView.smoothOpenMenu();
        }
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    public void setMenuCreator(SwipeMenuCreator menuCreator) {
        this.mMenuCreator = menuCreator;
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener onMenuItemClickListener) {
        this.mOnMenuItemClickListener = onMenuItemClickListener;
    }

    public void setOnSwipeListener(OnSwipeListener onSwipeListener) {
        this.mOnSwipeListener = onSwipeListener;
    }

    public void setParentScrollView(ViewGroup parentScrollView) {
        this.parentScrollView = parentScrollView;
    }

    private void setParentScrollAble(boolean flag) {
        this.parentScrollView.requestDisallowInterceptTouchEvent(!flag);
    }

    public static interface OnSwipeListener {
        public void onSwipeStart(int var1);

        public void onSwipeEnd(int var1);
    }

    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(int var1, SwipeMenu var2, int var3);
    }
}

