/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.AutowiredDoc;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseDarkModeActivity;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.provincecity.City;
import com.yy.mobile.util.provincecity.Province;
import com.yy.mobile.util.provincecity.ProvinceCityUtil;
import java.util.List;
import tv.athena.util.FP;

@Route(path="/person/select/city", name="\u9009\u62e9\u6240\u5728\u57ce\u5e02")
@RouteDoc(desc="\u9009\u62e9\u6240\u5728\u57ce\u5e02", minVer="7.17.0", eg=" yymobile://person/select/city")
public class SelectProvinceCityActivity
extends BaseDarkModeActivity {
    public static final String KEY_SELECTED_PROVINCE_STR = "selected_province_str";
    public static final String KEY_SELECTED_CITY_STR = "selected_city_str";
    public static final String KEY_SELECTED_PROVINCE_INT = "selected_province_int";
    public static final String KEY_SELECTED_CITY_INT = "selected_city_int";
    public static final String FROM_CITY = "from_city";
    public static final String FROM_HOMETOWN = "from_hometown";
    public static final int HOMETOEN_RESULT_CODE = 7;
    public static final int CITY_RESULT_CODE = 8;
    @AutowiredDoc(desc="\u6765\u6e90", minVer="7.20", eg="city")
    @Autowired(name="from")
    String mFrom = "";
    private static final String TAG = "SelectProvinceCityActiv";
    private ProvinceListAdapter mProvinceListAdapter;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_select_province_city);
        this.mFrom = this.getIntent().getStringExtra("from");
        MLog.info((Object)TAG, (String)"mFrom:%s", (Object[])new Object[]{this.mFrom});
        ListView lvProvince = (ListView)this.findViewById(R.id.lv_province);
        this.mProvinceListAdapter = new ProvinceListAdapter((Context)this, ProvinceCityUtil.instance((Context)this).getProvinces());
        lvProvince.setAdapter((ListAdapter)this.mProvinceListAdapter);
        SimpleTitleBar mTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                SelectProvinceCityActivity.this.goBack();
            }
        });
        mTitleBar.setTitlte("\u9009\u62e9\u6240\u5728\u5730");
    }

    public void goBack() {
        if (this.mProvinceListAdapter.mIsProvince) {
            this.finish();
        } else {
            this.mProvinceListAdapter.mIsProvince = true;
            this.mProvinceListAdapter.notifyDataSetChanged();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                this.goBack();
                break;
            }
        }
        return true;
    }

    private class ProvinceListAdapter
    extends BaseAdapter {
        public boolean mIsProvince = true;
        private List<Province> mProvinceList;
        private Context mContext;
        private int mSelectProvinceIndex = 0;

        ProvinceListAdapter(Context context, List<Province> provinceList) {
            this.mContext = context;
            this.mProvinceList = provinceList;
        }

        public int getCount() {
            if (this.mIsProvince) {
                return this.mProvinceList.size();
            }
            return this.mProvinceList.get(this.mSelectProvinceIndex).getCityList().size();
        }

        public Object getItem(int position) {
            if (this.mIsProvince) {
                return this.mProvinceList.get(position).getName();
            }
            return ((City)this.mProvinceList.get(this.mSelectProvinceIndex).getCityList().get(position)).getName();
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            LayoutInflater inflater;
            if (this.mContext == null) {
                if (parent == null) {
                    return null;
                }
                inflater = LayoutInflater.from((Context)parent.getContext());
            } else {
                inflater = LayoutInflater.from((Context)this.mContext);
            }
            ViewHolder viewHolder = null;
            if (convertView == null) {
                viewHolder = new ViewHolder();
                convertView = inflater.inflate(R.layout.layout_select_province_city_item, null);
                viewHolder.textView = (TextView)convertView.findViewById(R.id.item_name);
                viewHolder.imageView = convertView.findViewById(R.id.item_icon);
                viewHolder.divider = convertView.findViewById(R.id.divider);
                convertView.setTag((Object)viewHolder);
            }
            viewHolder = (ViewHolder)convertView.getTag();
            viewHolder.imageView.setVisibility(this.mIsProvince ? 0 : 4);
            viewHolder.divider.setVisibility(position == 0 ? 8 : 0);
            viewHolder.textView.setText((CharSequence)this.getItem(position).toString());
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ProvinceListAdapter.this.mIsProvince) {
                        ProvinceListAdapter.this.mIsProvince = false;
                        ProvinceListAdapter.this.mSelectProvinceIndex = position;
                        ProvinceListAdapter.this.notifyDataSetChanged();
                        return;
                    }
                    if (ProvinceListAdapter.this.mSelectProvinceIndex < ProvinceListAdapter.this.mProvinceList.size() && position < ((Province)ProvinceListAdapter.this.mProvinceList.get(ProvinceListAdapter.this.mSelectProvinceIndex)).getCityList().size()) {
                        Intent i = new Intent();
                        i.putExtra(SelectProvinceCityActivity.KEY_SELECTED_PROVINCE_STR, ((Province)ProvinceListAdapter.this.mProvinceList.get(ProvinceListAdapter.this.mSelectProvinceIndex)).getName());
                        i.putExtra(SelectProvinceCityActivity.KEY_SELECTED_PROVINCE_INT, Integer.parseInt(((Province)ProvinceListAdapter.this.mProvinceList.get(ProvinceListAdapter.this.mSelectProvinceIndex)).getId()));
                        i.putExtra(SelectProvinceCityActivity.KEY_SELECTED_CITY_STR, ((City)((Province)ProvinceListAdapter.this.mProvinceList.get(ProvinceListAdapter.this.mSelectProvinceIndex)).getCityList().get(position)).getName());
                        i.putExtra(SelectProvinceCityActivity.KEY_SELECTED_CITY_INT, Integer.parseInt(((City)((Province)ProvinceListAdapter.this.mProvinceList.get(ProvinceListAdapter.this.mSelectProvinceIndex)).getCityList().get(position)).getId()));
                        if (!FP.empty((CharSequence)SelectProvinceCityActivity.this.mFrom)) {
                            switch (SelectProvinceCityActivity.this.mFrom) {
                                case "from_city": {
                                    SelectProvinceCityActivity.this.setResult(8, i);
                                    break;
                                }
                                case "from_hometown": {
                                    SelectProvinceCityActivity.this.setResult(7, i);
                                    break;
                                }
                                default: {
                                    SelectProvinceCityActivity.this.setResult(7, i);
                                    break;
                                }
                            }
                        } else {
                            SelectProvinceCityActivity.this.setResult(7, i);
                        }
                    }
                    SelectProvinceCityActivity.this.finish();
                }
            });
            return convertView;
        }

        private class ViewHolder {
            TextView textView;
            View imageView;
            View divider;

            private ViewHolder() {
            }
        }
    }
}

