/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.webviewutil;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshWebView;
import com.yy.mobile.http.httpsparser.HttpsParser;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.common.IJsSupportWebApi;
import com.yy.mobile.ui.sharpgirls.WebViewUtilsKt;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.js.bridge.WVJSBridgeClient;
import com.yy.mobile.ui.utils.js.v2.v2ApiModule.DataModule;
import com.yy.mobile.ui.utils.js.v2.v2ApiModule.MobileAct;
import com.yy.mobile.ui.utils.js.v2.v2ApiModule.UiModule;
import com.yy.mobile.ui.utils.js.v2.v2ApiModule.device.DeviceModule;
import com.yy.mobile.ui.webview.delegate.IDownLoadFileInfo;
import com.yy.mobile.ui.webview.delegate.UIDelegate;
import com.yy.mobile.ui.webview.purewebview.IAppearanceCallback;
import com.yy.mobile.ui.webview.purewebview.IPureWebview;
import com.yy.mobile.ui.webview.purewebview.IWebviewCommonMethod;
import com.yy.mobile.ui.webview.purewebview.PureWebviewUtil;
import com.yy.mobile.ui.webview.webviewclient.ClientParams;
import com.yy.mobile.ui.webview.webviewclient.CommonWebViewClient;
import com.yy.mobile.ui.webview.webviewclient.DoNothingClient;
import com.yy.mobile.ui.webview.webviewclient.PullAppClient;
import com.yy.mobile.ui.webview.webviewclient.PullBrowserClient;
import com.yy.mobile.ui.webview.webviewclient.SchemeDoNothingClient;
import com.yy.mobile.ui.webviewutil.BaseWebChromeClient;
import com.yy.mobile.ui.webviewutil.BaseWebviewClient;
import com.yy.mobile.ui.webviewutil.SimpleAppearanceCallback;
import com.yy.mobile.ui.webviewutil.YYWebviewFeature;
import com.yy.mobile.ui.webviewutil.statusfragment.LoadingFragment;
import com.yy.mobile.ui.webviewutil.statusfragment.NetworkErrorFragment;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.javascript.JavaScriptInterface;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.Env;
import com.yymobile.core.download.DownLoadFileInfo;
import com.yymobile.core.download.IDownLoadCore;
import com.yymobilecore.R;
import org.json.JSONObject;

public class PureWebview
implements IPureWebview,
IWebviewCommonMethod {
    private static final String TAG = "PureWebview";
    private static final String CLIENT_LOAD_URL = "objc://clientLoadUrl/";
    private PullToRefreshWebView mPtrWebView;
    private WebView webView;
    private String mCurrentUrl = "";
    private CommonWebViewClient mClient;
    private boolean mCanDownload = true;
    private static final String WEB_URL_UA = "selfDefUA";
    private Context mcontext;
    private YYWebViewClient webViewClient;
    private BaseWebChromeClient mBridgeChromeClient;
    private IAppearanceCallback mAppearanceCallback;
    private IWebViewEventListener mWebViewEventListener;
    private YYWebviewFeature mWebViewFeature = new YYWebviewFeature();
    private JavaScriptInterface yyjsInterfaceV2 = null;
    private boolean mRecvError = false;
    private boolean lastPageLoadSuccess = false;
    private IJsSupportWebApi mIJsSupportWebApi;
    private boolean isOpenStatus = false;
    private View statusParentView;
    public static final String STATUS_TAG = "STATUS_TAG";
    private PullToRefreshBase.OnRefreshListener2<WebView> mRefreshListener = new PullToRefreshBase.OnRefreshListener2<WebView>(){

        public void onPullDownToRefresh(PullToRefreshBase<WebView> refreshView) {
            if (!PureWebview.this.isNetworkAvailable()) {
                if (!PureWebview.this.lastPageLoadSuccess) {
                    PureWebview.this.showNetworkErr();
                }
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PureWebview.this.mPtrWebView.onRefreshComplete();
                    }
                }, 500L);
            } else {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((String)PureWebview.TAG, (String)("iamwsbear, WebViewClient onPullDownToRefresh url = " + PureWebview.this.mCurrentUrl + ", this = " + this));
                }
                if (PureWebview.this.webView != null) {
                    PureWebview.this.webView.setDownloadListener(null);
                }
                PureWebview.this.setUrl(PureWebview.this.getCurrentUrl(), true);
            }
        }

        public void onPullUpToRefresh(PullToRefreshBase<WebView> refreshView) {
        }
    };
    private UIDelegate uiDelegate = new UIDelegate(){
        private Dialog mLoginDialog;

        public void delegateProgress(JSONObject param) {
        }

        public void delegateLoginDialog(JSONObject param) {
            if (this.mLoginDialog == null) {
                AlertDialog.Builder builder = new AlertDialog.Builder(PureWebview.this.mcontext);
                builder.setPositiveButton(R.string.str_login, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Activity context = (Activity)PureWebview.this.mcontext;
                        if (context != null) {
                            NavigationUtils.toLogin((Context)context, true, false);
                        }
                        dialog.dismiss();
                    }
                });
                builder.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                builder.setTitle(R.string.info_title);
                builder.setMessage(R.string.str_login_dlg_title);
                this.mLoginDialog = builder.create();
            }
            if (!this.mLoginDialog.isShowing()) {
                this.mLoginDialog.show();
            }
        }

        public void delegateToast(JSONObject param) {
        }

        public void delegateSetWebHeight(final JSONObject param) {
            if (PureWebview.this.webView != null) {
                PureWebview.this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int yPxHeight = Integer.parseInt(param.get("height").toString());
                            yPxHeight = yPxHeight > 80 ? yPxHeight : 80;
                            float scale = ((PureWebview)PureWebview.this).mcontext.getResources().getDisplayMetrics().density;
                            int yDPHeight = (int)((float)yPxHeight * scale + 0.5f);
                            if (PureWebview.this.mAppearanceCallback != null) {
                                MLog.info((String)PureWebview.TAG, (String)(" height2=" + param.toString() + ",yDPHeight=" + yDPHeight + ",scale=" + scale));
                                PureWebview.this.mAppearanceCallback.changeHeight(yDPHeight);
                            }
                            if (PureWebview.this.mWebViewEventListener != null) {
                                PureWebview.this.mWebViewEventListener.changeHeight(yDPHeight);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((String)PureWebview.TAG, (String)(" error=" + e.getMessage()));
                        }
                    }
                });
            }
        }

        public void delegatePlayAnim(JSONObject param) {
        }

        public void delegateDownLoadFile(IDownLoadFileInfo downLoadFileInfo) {
            if (downLoadFileInfo instanceof DownLoadFileInfo) {
                ((IDownLoadCore)CoreFactory.getCore(IDownLoadCore.class)).addFileToDownLoadList((DownLoadFileInfo)downLoadFileInfo, -1);
            }
        }

        public void delegateRefreshEable(final Boolean isRefresh) {
            if (PureWebview.this.mPtrWebView != null) {
                PureWebview.this.mPtrWebView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (PureWebview.this.mPtrWebView != null) {
                            if (isRefresh.booleanValue()) {
                                PureWebview.this.mPtrWebView.setMode(PullToRefreshBase.Mode.PULL_FROM_START);
                            } else {
                                PureWebview.this.mPtrWebView.setMode(PullToRefreshBase.Mode.DISABLED);
                            }
                        }
                    }
                });
            }
        }

        public void delegateCloseWebDialog() {
        }
    };

    public PureWebview(Context context, PureWebviewUtil.BuilderParamter builderParamter) {
        if (context == null || !(context instanceof Activity)) {
            throw new NullPointerException("null point about context in purewebview which is null or not activity");
        }
        this.mcontext = context;
        if (builderParamter != null && builderParamter.isOpenStatus) {
            PullToRefreshWebView tempPtrWebview;
            LayoutInflater inflater = LayoutInflater.from((Context)this.mcontext);
            this.statusParentView = inflater.inflate(R.layout.pure_fragment_web, null);
            this.mPtrWebView = tempPtrWebview = (PullToRefreshWebView)this.statusParentView.findViewById(R.id.ptr_webview);
            this.mPtrWebView.setOnRefreshListener(this.mRefreshListener);
            this.webView = (WebView)this.mPtrWebView.getRefreshableView();
        } else {
            this.mPtrWebView = new PullToRefreshWebView(context);
            this.mPtrWebView.setOnRefreshListener(this.mRefreshListener);
            this.webView = (WebView)this.mPtrWebView.getRefreshableView();
        }
        this.doUserSetting(builderParamter);
        this.init(context);
        if (!StringUtils.isNullOrEmpty((String)this.mCurrentUrl)) {
            this.loadUrl(this.mCurrentUrl);
        }
    }

    public WebView getWebView() {
        return this.webView;
    }

    public PullToRefreshWebView getPullToRefreshWebView() {
        return this.mPtrWebView;
    }

    public View getRootView() {
        return this.isOpenStatus ? this.statusParentView : this.mPtrWebView;
    }

    public void setWebViewEventLister(IWebViewEventListener mWebViewEventListener) {
        this.mWebViewEventListener = mWebViewEventListener;
    }

    private void init(Context context) {
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
            am.getMemoryInfo(mi);
            MLog.info((String)TAG, (String)("oncreateview the current memory left:" + mi.availMem));
            if (Build.VERSION.SDK_INT >= 19) {
                if (Env.instance().getWebSetting() == Env.WebSetting.Debug) {
                    WebView.setWebContentsDebuggingEnabled((boolean)true);
                } else {
                    WebView.setWebContentsDebuggingEnabled((boolean)false);
                }
            }
        }
        catch (Exception e) {
            MLog.error((String)TAG, (String)("webviewfragment setWebContentsDebuggingEnabled is error, error message is:" + e.getMessage()));
        }
        this.doWebSetting();
        this.doWebClientFilter(this.mCurrentUrl);
        this.setExtraUAFromUrl(this.mCurrentUrl);
    }

    public void setIJsSupportWebApi(IJsSupportWebApi iJsSupportWebApi) {
        this.mIJsSupportWebApi = iJsSupportWebApi;
    }

    private void doUserSetting(PureWebviewUtil.BuilderParamter p) {
        if (p != null) {
            if (p.isInvisible) {
                this.mPtrWebView.setVisibility(4);
            }
            if (p.isDisablePull) {
                this.mPtrWebView.setMode(PullToRefreshBase.Mode.DISABLED);
            }
            if (p.isDisableJavascript) {
                this.webView.getSettings().setJavaScriptEnabled(false);
            }
            if (p.isTrans) {
                this.webView.setBackgroundColor(0);
                if (this.webView.getBackground() != null) {
                    this.webView.getBackground().setAlpha(0);
                }
            }
            if (!StringUtils.isNullOrEmpty((String)p.url)) {
                this.mCurrentUrl = p.url;
            }
            if (p.isWebviewFeatureSet) {
                this.mWebViewFeature.setFeatureValue(p.webviewFeature);
            }
            if (p.isOpenStatus) {
                this.isOpenStatus = true;
            }
        }
    }

    public void setAppearanceCallback(IAppearanceCallback appearanceCallback) {
        this.mAppearanceCallback = appearanceCallback;
        if (this.mBridgeChromeClient == null) {
            return;
        }
        this.mBridgeChromeClient.setAppearanceCallack(this.mAppearanceCallback);
    }

    private void applyWebViewFeature() {
        if (null == this.webView) {
            MLog.error((String)TAG, (String)"warnning: fail apply webview feature, target webview is null.");
            return;
        }
        try {
            if (this.mWebViewFeature.isSupportFeature(1)) {
                MLog.info((String)TAG, (String)"applyWebViewFeature: support js true");
                this.webView.getSettings().setJavaScriptEnabled(true);
            } else {
                MLog.info((String)TAG, (String)"applyWebViewFeature: support false");
                this.webView.getSettings().setJavaScriptEnabled(false);
            }
        }
        catch (Throwable t) {
            MLog.info((String)TAG, (String)("t=" + t));
        }
        if (this.mWebViewFeature.isSupportFeature(8)) {
            MLog.info((String)TAG, (String)"applyWebViewFeature: clear cache");
            this.webView.clearCache(true);
        }
        this.setCacheMode();
        if (this.mWebViewFeature.isSupportFeature(32)) {
            MLog.info((String)TAG, (String)"applyWebViewFeature: clear from data");
            this.webView.clearFormData();
        }
        if (this.mWebViewFeature.isSupportFeature(64)) {
            MLog.info((String)TAG, (String)"applyWebViewFeature: clear history");
            this.webView.clearHistory();
        }
        this.webView.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
    }

    private void setCacheMode() {
        if (this.mWebViewFeature.isSupportFeature(16)) {
            MLog.info((String)TAG, (String)"applyWebViewFeature: enable cache");
            if (Build.VERSION.SDK_INT >= 11) {
                this.webView.getSettings().setCacheMode(-1);
            } else {
                this.webView.getSettings().setCacheMode(0);
            }
        } else {
            MLog.info((String)TAG, (String)"applyWebViewFeature: disable cache");
            this.webView.getSettings().setCacheMode(2);
        }
    }

    private void doWebSetting() {
        this.webViewClient = new YYWebViewClient(this.webView);
        this.webView.setWebViewClient((WebViewClient)this.webViewClient);
        this.applyWebViewFeature();
        WebViewUtilsKt.removeUnSafeJavascriptInterface(this.webView);
        this.webView.getSettings().setBuiltInZoomControls(false);
        if (this.yyjsInterfaceV2 == null) {
            this.yyjsInterfaceV2 = new JavaScriptInterface(this.webView);
            this.yyjsInterfaceV2.addApiModule((IApiModule)new DataModule());
            this.yyjsInterfaceV2.addApiModule((IApiModule)DeviceModule.sharedInstance());
            this.yyjsInterfaceV2.addApiModule((IApiModule)MobileAct.sharedInstance());
            this.yyjsInterfaceV2.addApiModule((IApiModule)new UiModule((Activity)this.mcontext, this.mIJsSupportWebApi, this.uiDelegate, this));
        }
        this.webView.addJavascriptInterface((Object)this.yyjsInterfaceV2, "AndroidJSInterfaceV2");
        this.webView.getSettings().setUseWideViewPort(true);
        String newUA = this.webView.getSettings().getUserAgentString() + WVJSBridgeClient.sharedVersionString();
        this.webView.getSettings().setUserAgentString(newUA);
        this.webView.getSettings().setDomStorageEnabled(true);
        this.mBridgeChromeClient = new BaseWebChromeClient();
        if (this.mAppearanceCallback == null) {
            this.mAppearanceCallback = new SimpleAppearanceCallback((Activity)this.mcontext);
        }
        this.mBridgeChromeClient.setAppearanceCallack(this.mAppearanceCallback);
        this.webView.setWebChromeClient((WebChromeClient)this.mBridgeChromeClient);
    }

    private void doWebClientFilter(String url) {
        String download2;
        if (StringUtils.isEmptyString((String)url)) {
            return;
        }
        url = HttpsParser.convertToHttps((String)url);
        Uri uri = Uri.parse((String)url.trim());
        String filterIdListStr = uri.getQueryParameter("selfDefFilterIdList");
        String scheme = uri.getQueryParameter("selfDefFilterScheme");
        if (StringUtils.isEmptyString((String)filterIdListStr) || StringUtils.isEmptyString((String)scheme)) {
            return;
        }
        String[] idList = filterIdListStr.split(",");
        if (idList != null && idList.length > 0) {
            String[] schemeList = scheme.split("!");
            if (idList != null && idList.length > 0 && schemeList != null && schemeList.length > 0) {
                for (int i = 0; i < schemeList.length; ++i) {
                    int size = idList.length;
                    ClientParams params = new ClientParams();
                    params.scheme = schemeList[i];
                    params.filterIdList = new int[size];
                    for (int j = 0; j < size; ++j) {
                        params.filterIdList[j] = StringUtils.safeParseInt((String)idList[j]);
                    }
                    this.addWebViweClientFilterList(params);
                }
            }
        }
        if ("0".equals(download2 = uri.getQueryParameter("selfDefDownload"))) {
            this.mCanDownload = false;
        }
    }

    public void addWebViweClientFilterList(ClientParams paramsObj) {
        if (paramsObj.filterIdList != null && paramsObj.filterIdList.length > 0) {
            int size = paramsObj.filterIdList.length;
            for (int i = size - 1; i >= 0; --i) {
                PullAppClient client = null;
                int filterId = paramsObj.filterIdList[i];
                if (CommonWebViewClient.ClientType.valueOf((int)filterId) == CommonWebViewClient.ClientType.APP) {
                    client = new PullAppClient();
                } else if (CommonWebViewClient.ClientType.valueOf((int)filterId) == CommonWebViewClient.ClientType.BROWSER) {
                    client = new PullBrowserClient();
                } else if (CommonWebViewClient.ClientType.valueOf((int)filterId) == CommonWebViewClient.ClientType.HOSTNOTHING) {
                    client = new DoNothingClient();
                } else if (CommonWebViewClient.ClientType.valueOf((int)filterId) == CommonWebViewClient.ClientType.SCHEMENOTHING) {
                    client = new SchemeDoNothingClient();
                }
                if (client == null) continue;
                client.setParams(paramsObj);
                this.addWebViewClientFilter((CommonWebViewClient)client);
            }
        }
    }

    private void addWebViewClientFilter(CommonWebViewClient client) {
        if (this.mClient != null && client != null) {
            client.setDecorate(this.mClient);
            this.mClient = client;
        } else {
            this.mClient = client;
        }
    }

    private void setExtraUAFromUrl(String url) {
        String ua;
        Uri uri = Uri.parse((String)url);
        if (uri != null && !TextUtils.isEmpty((CharSequence)(ua = uri.getQueryParameter(WEB_URL_UA)))) {
            String newUA = this.webView.getSettings().getUserAgentString() + ua;
            this.webView.getSettings().setUserAgentString(newUA);
        }
    }

    public void setWebViewDownLoadListener() {
        if (this.webView != null) {
            this.webView.setDownloadListener((DownloadListener)new WebViewDownLoadListener());
        }
    }

    private void showNetworkErr() {
        if (this.mcontext == null || !(this.mcontext instanceof Activity) || !this.isOpenStatus || this.statusParentView == null) {
            return;
        }
        View view = this.statusParentView.findViewById(R.id.status_layout);
        if (view.getId() <= 0) {
            MLog.error((String)TAG, (String)"iamwsbear, had not set layout id ");
            return;
        }
        NetworkErrorFragment fragment = NetworkErrorFragment.newInstance();
        fragment.setListener(new View.OnClickListener(){

            public void onClick(View view) {
                PureWebview.this.showLoading(0, 0);
                PureWebview.this.setUrl(PureWebview.this.getCurrentUrl(), true);
            }
        });
        ((Activity)this.mcontext).getFragmentManager().beginTransaction().replace(view.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    private void showLoading(int drawable2, int tips) {
        if (this.mcontext == null || !(this.mcontext instanceof Activity) || !this.isOpenStatus || this.statusParentView == null) {
            return;
        }
        View status = this.statusParentView.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            return;
        }
        LoadingFragment fragment = LoadingFragment.newInstance(drawable2, tips);
        ((Activity)this.mcontext).getFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    private void hideStatus() {
        if (this.mcontext == null || !(this.mcontext instanceof Activity) || !this.isOpenStatus || this.statusParentView == null) {
            return;
        }
        Fragment fragment = ((Activity)this.mcontext).getFragmentManager().findFragmentByTag(STATUS_TAG);
        if (fragment != null) {
            ((Activity)this.mcontext).getFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
        } else if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)"status fragment is NULL");
        }
    }

    public void setUrl(String url) {
        this.setUrl(url, false);
    }

    public void setUrl(String url, boolean force) {
        if (this.webView == null || this.mcontext == null) {
            return;
        }
        if (FP.empty((CharSequence)url)) {
            Toast.makeText((Context)this.mcontext, (CharSequence)this.mcontext.getString(R.string.yy_web_null_error), (int)1).show();
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)TAG, (String)"iamwsbear, setUrl, url is nulll");
            }
            return;
        }
        url = HttpsParser.convertToHttps((String)url);
        if (force) {
            this.loadUrl(url);
        } else {
            if (url.equals(this.mCurrentUrl)) {
                return;
            }
            this.loadUrl(url);
        }
        this.doWebClientFilter(this.mCurrentUrl);
        this.setExtraUAFromUrl(this.mCurrentUrl);
    }

    private void loadUrl(String url) {
        MLog.info((String)TAG, (String)("iamwsbear, loadUrl, url = " + url));
        if (this.webView == null) {
            return;
        }
        this.mCurrentUrl = url;
        this.webView.getSettings().setBlockNetworkImage(true);
        this.webView.loadUrl(url);
        this.mRecvError = false;
    }

    public void loadJavaScript(String javaScript) {
        if (this.webView != null) {
            if (Build.VERSION.SDK_INT <= 18) {
                this.webView.loadUrl(javaScript);
            } else {
                try {
                    this.webView.evaluateJavascript(javaScript, null);
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (Throwable)e);
                    this.webView.loadUrl(javaScript);
                }
            }
        }
    }

    public boolean isNetworkAvailable() {
        return NetworkUtils.isNetworkStrictlyAvailable((Context)this.mcontext);
    }

    public String getCurrentUrl() {
        return this.mCurrentUrl;
    }

    public void release() {
        if (this.webView != null && this.yyjsInterfaceV2 != null) {
            this.yyjsInterfaceV2.release();
        }
        if (this.webViewClient != null) {
            this.webViewClient.destory();
        }
        if (this.webView != null) {
            ViewGroup viewGroup = (ViewGroup)this.webView.getParent();
            if (viewGroup != null) {
                viewGroup.removeView((View)this.webView);
            }
            this.webView.destroy();
            this.webView = null;
        }
    }

    class YYWebViewClient
    extends BaseWebviewClient {
        private boolean mStartDownloadRes;

        YYWebViewClient(WebView webView) {
            super(webView);
            this.mStartDownloadRes = false;
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)PureWebview.TAG, (String)("iamwsbear, WebViewClient shouldOverrideUrlLoading webView =" + view + ",---url = " + url));
            }
            if (url.startsWith(PureWebview.CLIENT_LOAD_URL)) {
                url = url.substring(PureWebview.CLIENT_LOAD_URL.length());
            }
            if (PureWebview.this.mClient != null) {
                CommonWebViewClient.LoadValue val = PureWebview.this.mClient.shouldOverrideUrlLoading(view, url);
                if (CommonWebViewClient.LoadValue.TRUE.equals((Object)val)) {
                    return true;
                }
                if (CommonWebViewClient.LoadValue.FALSE.equals((Object)val)) {
                    return false;
                }
            }
            if (!StringUtils.isEmptyString((String)url) && url.startsWith("http")) {
                PureWebview.this.mCurrentUrl = url;
            }
            if (PureWebview.this.mAppearanceCallback != null) {
                PureWebview.this.mAppearanceCallback.shouldOverrideUrlLoading(view, url);
            }
            if (PureWebview.this.mWebViewEventListener != null) {
                PureWebview.this.mWebViewEventListener.shouldOverrideUrlLoading(view, url);
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        @Override
        public void onLoadResource(WebView view, String url) {
            MLog.info((String)PureWebview.TAG, (String)("iamwsbear, WebViewClient onLoadResource url = " + url));
            super.onLoadResource(view, url);
            this.mStartDownloadRes = true;
        }

        @Override
        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            MLog.info((String)PureWebview.TAG, (String)("iamwsbear, WebViewClient onReceivedError failingUrl = " + failingUrl + " errorCode = " + errorCode + " description = " + description));
            PureWebview.this.mRecvError = true;
            PureWebview.this.showNetworkErr();
            if (PureWebview.this.mAppearanceCallback != null) {
                PureWebview.this.mAppearanceCallback.onReceivedError(view, errorCode, description, failingUrl);
            }
            if (PureWebview.this.mWebViewEventListener != null) {
                PureWebview.this.mWebViewEventListener.onReceivedError(view, errorCode, description, failingUrl);
            }
        }

        public void onPageStarted(WebView view, String url, Bitmap favIcon) {
            MLog.info((String)PureWebview.TAG, (String)("iamwsbear, WebViewClient onPageStarted url = " + url + ",----WebView=" + view));
            super.onPageStarted(view, url, favIcon);
            if (url != null && !url.contains("file://")) {
                PureWebview.this.mCurrentUrl = url;
            }
            if (PureWebview.this.mAppearanceCallback != null) {
                PureWebview.this.mAppearanceCallback.onPageStarted(view, url, favIcon);
            }
            if (PureWebview.this.mWebViewEventListener != null) {
                PureWebview.this.mWebViewEventListener.onPageStarted(view, url, favIcon);
            }
        }

        @Override
        @TargetApi(value=14)
        public void onPageFinished(WebView view, String url) {
            MLog.info((String)PureWebview.TAG, (String)("iamwsbear, WebViewClient onPageFinished url = " + url + ",----WebView=" + view));
            view.getSettings().setBlockNetworkImage(false);
            if (PureWebview.this.mCanDownload) {
                PureWebview.this.setWebViewDownLoadListener();
            }
            super.onPageFinished(view, url);
            PureWebview.this.hideStatus();
            if (PureWebview.this.mRecvError) {
                PureWebview.this.showNetworkErr();
            } else {
                PureWebview.this.lastPageLoadSuccess = true;
            }
            if (PureWebview.this.mPtrWebView != null) {
                PureWebview.this.mPtrWebView.onRefreshComplete();
            }
            if (PureWebview.this.mAppearanceCallback != null) {
                PureWebview.this.mAppearanceCallback.onPageFinished(view, url);
            }
            if (PureWebview.this.mWebViewEventListener != null) {
                PureWebview.this.mWebViewEventListener.onPageFinished(view, url);
            }
            if (this.mStartDownloadRes) {
                this.mStartDownloadRes = false;
            }
        }
    }

    private class WebViewDownLoadListener
    implements DownloadListener {
        private WebViewDownLoadListener() {
        }

        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
            MLog.info((String)PureWebview.TAG, (String)("url=" + url + ",userAgent=" + userAgent + ",contentDisposition=" + contentDisposition + ",mimetype=" + mimetype + ",contentLength=" + contentLength));
            Uri uri = Uri.parse((String)url);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            if (PureWebview.this.mcontext != null) {
                if (intent.resolveActivity(PureWebview.this.mcontext.getPackageManager()) != null) {
                    PureWebview.this.mcontext.startActivity(intent);
                } else {
                    MLog.info((String)PureWebview.TAG, (String)("can not found activity by this intent:" + intent));
                    Toast.makeText((Context)PureWebview.this.mcontext, (CharSequence)"\u4e0b\u8f7d\u5931\u8d25", (int)0).show();
                }
            }
        }
    }
}

