/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.webviewutil;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.webkit.MimeTypeMap;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.ui.dialog.DialogLinkManager;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class BaseWebviewClient
extends WebViewClient {
    private static final String TAG = "BaseWebviewClient";
    private WeakReference<WebView> mWebViewHolder;
    private String mCurrentURLString = "";
    private boolean ignoreSslError = false;

    public BaseWebviewClient(WebView webView) {
        if (webView != null) {
            this.mWebViewHolder = new WeakReference<WebView>(webView);
        } else {
            MLog.error((String)TAG, (String)"WVJSBridgeClient must create with a webview not nullable.");
        }
    }

    public void destory() {
        WebView view = (WebView)this.mWebViewHolder.get();
        if (view != null) {
            this.mWebViewHolder.clear();
        }
    }

    private void startActivity(Intent intent) {
        try {
            Activity activity2 = YYActivityManager.INSTANCE.getCurrentActivity();
            MLog.info((Object)TAG, (String)"startActivity, current: %s, intent: %s", (Object[])new Object[]{activity2, intent});
            if (activity2 != null) {
                activity2.startActivity(intent);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"start activity error", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("kuiannan load web url = " + url));
        }
        if (url.startsWith("weixin://wap/pay?appid")) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            this.startActivity(intent);
            return true;
        }
        if (url.startsWith("intent://platformapi/startapp?")) {
            try {
                Intent intent = null;
                try {
                    intent = Intent.parseUri((String)url, (int)1);
                    intent.addCategory("android.intent.category.BROWSABLE");
                    intent.setComponent(null);
                    if (Build.VERSION.SDK_INT >= 15) {
                        intent.setSelector(null);
                    }
                }
                catch (URISyntaxException e) {
                    MLog.error((String)TAG, (String)e.getMessage());
                }
                this.startActivity(intent);
            }
            catch (Exception e) {
                MLog.error((String)TAG, (String)e.getMessage());
            }
            return true;
        }
        MimeTypeMap.getSingleton();
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if ("mp4".equalsIgnoreCase(extension)) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)TAG, (String)("mp4 url " + url));
            }
        } else {
            this.safetyLoadUrl(view, url);
        }
        return true;
    }

    private void safetyLoadUrl(final WebView view, final String url) {
        if (view != null && url != null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        view.loadUrl(url);
                    }
                    catch (Exception e) {
                        MLog.error((Object)BaseWebviewClient.TAG, (Throwable)e);
                    }
                }
            });
        }
    }

    public void onLoadResource(WebView view, String url) {
        super.onLoadResource(view, url);
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("onLoadResource url = " + url));
        }
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        MLog.error((String)TAG, (String)("onReceivedError errorCode:" + errorCode + ",description:" + description + ",failingUrl:" + failingUrl));
        view.clearView();
        this.safetyLoadUrl(view, "file:///android_asset/load_page_fail.html");
    }

    public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
        String errorMsg = "";
        if (error != null) {
            errorMsg = error.toString();
        }
        MLog.info((Object)"WVJSBridgeClient", (String)"onReceivedSslError=%s,%s", (Object[])new Object[]{errorMsg, this.ignoreSslError});
        if (this.ignoreSslError) {
            handler.proceed();
            return;
        }
        Activity activity2 = YYActivityManager.INSTANCE.getCurrentActivity();
        if (activity2 != null) {
            DialogLinkManager dialogManager = new DialogLinkManager((Context)activity2);
            dialogManager.showDialog((IBaseDialog)new OkCancelDialog((CharSequence)"\u5f53\u524d\u7f51\u7ad9\u8bc1\u4e66\u975e\u6cd5\u6216\u5305\u542b\u9519\u8bef\uff0c\u662f\u5426\u4fe1\u4efb\u5e76\u7ee7\u7eed\u8bbf\u95ee", (CharSequence)"\u7ee7\u7eed\u8bbf\u95ee", (CharSequence)"\u53d6\u6d88", false, new OkCancelDialogListener(){

                public void onCancel() {
                    BaseWebviewClient.this.ignoreSslError = false;
                    MLog.info((String)"WVJSBridgeClient", (String)"onReceivedSslError onCancel");
                    handler.cancel();
                }

                public void onOk() {
                    MLog.info((String)"WVJSBridgeClient", (String)"onReceivedSslError onOk");
                    BaseWebviewClient.this.ignoreSslError = true;
                    handler.proceed();
                }
            }));
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("web onPageFinished url = " + url));
        }
        if (!this.mCurrentURLString.equalsIgnoreCase(url)) {
            this.mCurrentURLString = url;
        }
    }
}

