/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.rest;

import android.app.Activity;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.fragment.app.FragmentActivity;
import com.alibaba.android.arouter.facade.annotation.RestRoute;
import com.yy.mobile.RxBus;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.homeapi.model.HostLifeCircleEvent;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onOpenWebPopWindow_EventArgs;
import com.yy.mobile.ui.deeplink.DeepLinkBackManager;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.rest.base.INavParam;
import com.yy.mobile.ui.utils.rest.base.IRestApiEx;
import com.yy.mobile.ui.utils.rest.base.IRestApiList;
import com.yy.mobile.ui.utils.rest.base.NavRestApi;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.onepiece.request.OnepieceGetH5VersionAction;
import com.yymobile.core.webview.popup.WebViewPopupBuilder;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WebCtrlApiList
implements IRestApiList {
    private static final String TAG = "WebCtrlApiList";
    private static final String AUTHORITY = "Web";

    public List<IRestApiEx> getList() {
        ArrayList<IRestApiEx> list = new ArrayList<IRestApiEx>();
        list.add(this.gotoWeb());
        list.add(this.gotoOnePieceWeb());
        list.add(this.gotoAsynWeb());
        list.add(this.gotoWebPopupWindow());
        list.add(this.gotoExWebPopupWindow());
        return list;
    }

    @RestRoute(authority="Web", path="AsynWebView/Features/#/Url/*", eg="yymobile://Web/AsynWebView/Features/{features}/Url/{url}", desc="\u8df3\u8f6cwebview\uff0c\u517c\u5bb9ios asynwebview, features(\u6574\u578b\uff0c\u65e0\u7528\uff0c\u4e00\u822c\u586b5)")
    private IRestApiEx gotoAsynWeb() {
        return new NavRestApi(){

            public String getAuthority() {
                return WebCtrlApiList.AUTHORITY;
            }

            public String getPath() {
                return "AsynWebView/Features/#/Url/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                Uri uri = param.uri;
                List segments = uri.getPathSegments();
                int features = Integer.valueOf((String)segments.get(2));
                String url = String.valueOf(segments.get(4));
                WebCtrlApiList.this.handleWeb(param, features, url);
            }
        };
    }

    @RestRoute(authority="Web", path="Features/#/Url/*", eg="yymobile://Web/Features/{features}/Url/{url}", desc="\u8df3\u8f6cweb\u9875\u9762,features(\u6574\u578b\uff0c\u65e0\u7528\uff0c\u4e00\u822c\u586b5)")
    private IRestApiEx gotoWeb() {
        return new NavRestApi(){

            public String getAuthority() {
                return WebCtrlApiList.AUTHORITY;
            }

            public String getPath() {
                return "Features/#/Url/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                Uri uri = param.uri;
                List segments = uri.getPathSegments();
                int features = Integer.valueOf((String)segments.get(1));
                String url = String.valueOf(segments.get(3));
                WebCtrlApiList.this.handleWeb(param, features, url);
            }
        };
    }

    @RestRoute(authority="Web", path="OnePiece/Features/#/Url/*", eg="yymobile://Web/OnePiece/Features/{features}/Url/{url}", desc="\u8df3\u8f6c\u4e00\u4ef6web\u9875\u9762\uff0cfeatures(\u6574\u578b\uff0c\u65e0\u7528\uff0c\u4e00\u822c\u586b5)")
    private IRestApiEx gotoOnePieceWeb() {
        return new NavRestApi(){

            public String getAuthority() {
                return WebCtrlApiList.AUTHORITY;
            }

            public String getPath() {
                return "OnePiece/Features/#/Url/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                Uri uri = param.uri;
                List segments = uri.getPathSegments();
                int features = Integer.valueOf((String)segments.get(2));
                String url = String.valueOf(segments.get(4));
                WebCtrlApiList.this.handleOnePieceWeb(param, features, url);
            }
        };
    }

    @RestRoute(authority="Web", path="WebPopupWindow/*/*/*/*/*/*/*", eg="yymobile://Web/WebPopupWindow/{url}/{dimAlpha}/{backGroundColor}/{backGroundAlpha}/{cancelable}/{width}/{height}", desc="\u8df3\u8f6cweb\u534a\u7a97")
    private IRestApiEx gotoWebPopupWindow() {
        return new NavRestApi(){
            private Disposable mDisposable;

            public String getAuthority() {
                return WebCtrlApiList.AUTHORITY;
            }

            public String getPath() {
                return "WebPopupWindow/*/*/*/*/*/*/*";
            }

            public void run() {
                final INavParam param = (INavParam)this.getParam();
                Uri uri = param.uri;
                MLog.info((String)WebCtrlApiList.TAG, (String)("gotoWebPopupWindow run uri:" + uri));
                List segments = uri.getPathSegments();
                final String url = (String)segments.get(1);
                final String dimAlpha = (String)segments.get(2);
                final String backGroundColor = (String)segments.get(3);
                final String backGroundAlpha = (String)segments.get(4);
                final String cancelable = (String)segments.get(5);
                final String width = (String)segments.get(6);
                final String height = (String)segments.get(7);
                MLog.info((String)WebCtrlApiList.TAG, (String)("gotoWebPopupWindow url:" + url + " dimAlpha:" + dimAlpha + " backGroundColor:" + backGroundColor + " backGroundAlpha" + backGroundAlpha + " cancelable:" + cancelable + " width:" + width + " height:" + height));
                Activity act = param.context;
                MLog.info((String)WebCtrlApiList.TAG, (String)("activity:" + act));
                if (YYActivityManager.INSTANCE.getMainActivity() == null) {
                    this.mDisposable = RxBus.getDefault().register(HostLifeCircleEvent.class).subscribe((Consumer)new Consumer<HostLifeCircleEvent>(){

                        public void accept(HostLifeCircleEvent hostLifeCircleEvent) throws Exception {
                            if (hostLifeCircleEvent.getMState().equals("ACTIVITY_ONRESUME")) {
                                Activity activity2 = YYActivityManager.INSTANCE.getMainActivity();
                                WebCtrlApiList.this.showWebPopupWindow((FragmentActivity)activity2, param.mBundle, width, height, url, dimAlpha, backGroundColor, backGroundAlpha, cancelable);
                                RxUtils.dispose((Disposable)mDisposable);
                            }
                        }
                    }, RxUtils.errorConsumer((String)WebCtrlApiList.TAG));
                } else {
                    if (act == null) {
                        act = YYActivityManager.INSTANCE.getCurrentActivity();
                    }
                    WebCtrlApiList.this.showWebPopupWindow((FragmentActivity)act, param.mBundle, width, height, url, dimAlpha, backGroundColor, backGroundAlpha, cancelable);
                }
            }
        };
    }

    private IRestApiEx gotoExWebPopupWindow() {
        return new NavRestApi(){
            private Disposable mDisposable;

            public String getAuthority() {
                return WebCtrlApiList.AUTHORITY;
            }

            public String getPath() {
                return "WebPopupWindow/*/*/*/*/*/*/*/*/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                Uri uri = param.uri;
                MLog.info((String)WebCtrlApiList.TAG, (String)("gotoWebPopupWindow run uri:" + uri));
                List segments = uri.getPathSegments();
                final String url = (String)segments.get(1);
                final String dimAlpha = (String)segments.get(2);
                final String backGroundColor = (String)segments.get(3);
                final String backGroundAlpha = (String)segments.get(4);
                final String cancelable = (String)segments.get(5);
                final String width = (String)segments.get(6);
                final String height = (String)segments.get(7);
                final String landScapeWidth = (String)segments.get(8);
                final String landScapeHeight = (String)segments.get(9);
                MLog.info((String)WebCtrlApiList.TAG, (String)("gotoWebPopupWindow url:" + url + " dimAlpha:" + dimAlpha + " backGroundColor:" + backGroundColor + " backGroundAlpha" + backGroundAlpha + " cancelable:" + cancelable + " width:" + width + " height:" + height + " landScapeWidth:" + landScapeWidth + " landScapeHeight:" + landScapeHeight));
                Activity act = param.context;
                MLog.info((String)WebCtrlApiList.TAG, (String)("activity:" + act));
                if (YYActivityManager.INSTANCE.getMainActivity() == null) {
                    this.mDisposable = RxBus.getDefault().register(HostLifeCircleEvent.class).subscribe((Consumer)new Consumer<HostLifeCircleEvent>(){

                        public void accept(HostLifeCircleEvent hostLifeCircleEvent) throws Exception {
                            if (hostLifeCircleEvent.getMState().equals("ACTIVITY_ONRESUME")) {
                                Activity activity2 = YYActivityManager.INSTANCE.getMainActivity();
                                WebCtrlApiList.this.showWebPopupWindow((FragmentActivity)activity2, width, height, url, dimAlpha, backGroundColor, backGroundAlpha, cancelable, landScapeWidth, landScapeHeight);
                                RxUtils.dispose((Disposable)mDisposable);
                            }
                        }
                    }, RxUtils.errorConsumer((String)WebCtrlApiList.TAG));
                } else {
                    if (act == null) {
                        act = YYActivityManager.INSTANCE.getCurrentActivity();
                    }
                    WebCtrlApiList.this.showWebPopupWindow((FragmentActivity)act, width, height, url, dimAlpha, backGroundColor, backGroundAlpha, cancelable, landScapeWidth, landScapeHeight);
                }
            }
        };
    }

    private void showWebPopupWindow(FragmentActivity activity2, Bundle bundle, String width, String height, String url, String dimAlpha, String backGroundColor, String backGroundAlpha, String cancelable) {
        boolean isRedRain;
        boolean bl = isRedRain = bundle != null && bundle.getInt("is_red_packet_rain") == 1;
        if (isRedRain) {
            new WebViewPopupBuilder().setPortritSize(Integer.parseInt(width), Integer.parseInt(height)).setUrl(url).setDimAlpha(Float.parseFloat(dimAlpha)).setBackgroundColor(backGroundColor).setBackgroundColorAlpha(Float.parseFloat(backGroundAlpha)).setCancelable(true).setBizFrom("is_red_packet_rain").isFullScreen(true).setCloseBtn(true, Integer.valueOf(R.drawable.ic_red_packet_rain_close), 0.1, 0.84).show(activity2);
        } else {
            new WebViewPopupBuilder().setPortritSize(Integer.parseInt(width), Integer.parseInt(height)).setUrl(url).setDimAlpha(Float.parseFloat(dimAlpha)).setBackgroundColor(backGroundColor).setBackgroundColorAlpha(Float.parseFloat(backGroundAlpha)).setCancelable(true).show(activity2);
        }
    }

    private void showWebPopupWindow(FragmentActivity activity2, String width, String height, String url, String dimAlpha, String backGroundColor, String backGroundAlpha, String cancelable, String lWidth, String lHeight) {
        new WebViewPopupBuilder().setPortritSize(Integer.parseInt(width), Integer.parseInt(height)).setUrl(url).setDimAlpha(Float.parseFloat(dimAlpha)).setBackgroundColor(backGroundColor).setBackgroundColorAlpha(Float.parseFloat(backGroundAlpha)).setCancelable(true).setLandscapeDesignedPXSize(Integer.parseInt(lWidth), Integer.parseInt(lHeight)).show(activity2);
    }

    private void handleWeb(final INavParam param, int features, final String encodeUrl) {
        final Activity act = param.context;
        act.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String url = "";
                if (!FP.empty((CharSequence)encodeUrl)) {
                    url = Uri.decode((String)encodeUrl);
                }
                int isRefresh = WebCtrlApiList.this.parseUrlToGetRefresh(url, "isRefresh");
                int isReshPart1 = WebCtrlApiList.this.parseUrlToGetRefresh(url, "isReshPart");
                DeepLinkBackManager.Companion.getInstance().handleDeeplinkH5(url);
                try {
                    if (((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
                        boolean isGoHistory = WebCtrlApiList.this.parseUrlToGetRefresh(url, "goHistory") == 1;
                        IMobileLiveClient_onOpenWebPopWindow_EventArgs eventArgs = new IMobileLiveClient_onOpenWebPopWindow_EventArgs(url);
                        eventArgs.isGoHistory = isGoHistory;
                        RxBus.getDefault().post((Object)eventArgs);
                        return;
                    }
                }
                catch (Throwable ex) {
                    MLog.error((Object)WebCtrlApiList.TAG, (Throwable)ex);
                }
                MLog.info((String)WebCtrlApiList.TAG, (String)" toJSSupportedWebView handleWeb...");
                if (isRefresh == 1 || isReshPart1 == 1) {
                    NavigationUtils.toJSSupportedWebView(act, url, isReshPart1 == 1 ? 7200 : 7100, isRefresh, isReshPart1, "", "", param.mBundle);
                } else {
                    NavigationUtils.toJSSupportedWebView(act, url, null, true, 17, false, false, false, false, "", "", param.uri == null ? "" : param.uri.toString(), param.mBundle);
                }
            }
        });
    }

    private void handleOnePieceWeb(INavParam param, int features, final String encodeUrl) {
        final Activity act = param.context;
        act.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String url = "";
                if (!FP.empty((CharSequence)encodeUrl)) {
                    url = Uri.decode((String)encodeUrl);
                }
                final int isRefresh = WebCtrlApiList.this.parseUrlToGetRefresh(url, "isRefresh");
                final int isReshPart = WebCtrlApiList.this.parseUrlToGetRefresh(url, "isReshPart");
                MLog.info((String)WebCtrlApiList.TAG, (String)" toJSSupportedWebView handleOnePieceWeb...");
                if (!TextUtils.isEmpty((CharSequence)url)) {
                    final String finalUrl = url;
                    Disposable disposable2 = YYStore.INSTANCE.dispatch((ReqAction)new OnepieceGetH5VersionAction()).subscribe((Consumer)new Consumer<String>(){

                        public void accept(String s) throws Exception {
                            String url2 = finalUrl;
                            url2 = s == null || TextUtils.isEmpty((CharSequence)s) ? url2.replace("yijian-universal-proxy", "2.4") : url2.replace("yijian-universal-proxy", s);
                            NavigationUtils.toOnePieceJSSupportedWebView(act, url2, isReshPart == 1 ? 7200 : 7100, isRefresh, isReshPart);
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        public void accept(Throwable throwable) throws Exception {
                            NavigationUtils.toOnePieceJSSupportedWebView(act, finalUrl.replace("yijian-universal-proxy", "2.4"), isReshPart == 1 ? 7200 : 7100, isRefresh, isReshPart);
                        }
                    });
                }
            }
        });
    }

    private int parseUrlToGetRefresh(String url, String tag) {
        try {
            HashMap<String, String> urlParamsList = this.parseUriParams(Uri.parse((String)url));
            if (urlParamsList.containsKey(tag)) {
                return StringUtils.safeParseInt((String)urlParamsList.get(tag));
            }
        }
        catch (Exception e) {
            MLog.info((String)TAG, (String)e.getMessage());
            return 0;
        }
        return 0;
    }

    private HashMap<String, String> parseUriParams(Uri uri) {
        int end;
        HashMap<String, String> params = new HashMap<String, String>();
        String queryParams = uri.getEncodedQuery();
        if (FP.empty((CharSequence)queryParams)) {
            return params;
        }
        int start = 0;
        do {
            int next;
            end = (next = queryParams.indexOf(38, start)) == -1 ? queryParams.length() : next;
            int separator = queryParams.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            String name = queryParams.substring(start, separator);
            String value = separator < end ? queryParams.substring(separator + 1, end) : "";
            params.put(Uri.decode((String)name), Uri.decode((String)value));
        } while ((start = end + 1) < queryParams.length());
        return params;
    }
}

