/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.rest;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import androidx.fragment.app.FragmentActivity;
import com.alibaba.android.arouter.facade.annotation.RestRoute;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.login.ILoginPromptCore;
import com.yy.mobile.ui.anchorInfoCard.uicore.IAnchorInfoCardCore;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.rest.base.INavParam;
import com.yy.mobile.ui.utils.rest.base.IRestApiEx;
import com.yy.mobile.ui.utils.rest.base.IRestApiList;
import com.yy.mobile.ui.utils.rest.base.NavRestApi;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import java.util.ArrayList;
import java.util.List;

public class UserInfoApiList
extends EmptyEventCompat
implements IRestApiList {
    private static final String TAG = "UserInfoApiList";
    private static final String AUTHORITY = "UserInfo";

    public List<IRestApiEx> getList() {
        ArrayList<IRestApiEx> list = new ArrayList<IRestApiEx>();
        list.add(this.gotoUserInfo());
        list.add(this.gotoUserInfoPage());
        list.add(this.gotoUserInfoCard());
        return list;
    }

    @RestRoute(authority="UserInfo", path="Live/UserInfoCard/*/*/*", eg="yymobile://UserInfo/Live/UserInfoCard/{uid}/{isAnchor}/{anchorName}", desc="\u8df3\u8f6c\u7528\u6237\u4e2a\u4eba\u8d44\u6599\u5361, isAnchor(1\u4e3b\u64ad\uff0c0\u975e\u4e3b\u64ad)")
    public IRestApiEx gotoUserInfoCard() {
        return new NavRestApi(){

            public String getAuthority() {
                return UserInfoApiList.AUTHORITY;
            }

            public String getPath() {
                return "Live/UserInfoCard/*/*/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                final Activity context = param.context;
                Uri uri = param.uri;
                String uidStr = (String)uri.getPathSegments().get(2);
                final long uid = StringUtils.safeParseLong((String)uidStr);
                String isAnchorStr = (String)uri.getPathSegments().get(3);
                final int isAnchor = StringUtils.safeParseInt((String)isAnchorStr);
                MLog.info((String)UserInfoApiList.AUTHORITY, (String)("user info " + uid + "," + isAnchor));
                if (context == null) {
                    MLog.error((String)UserInfoApiList.AUTHORITY, (String)" context is null");
                    return;
                }
                context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (context != null && context instanceof FragmentActivity) {
                            FragmentActivity act = (FragmentActivity)context;
                            if (uid != 0L) {
                                if (isAnchor == 1) {
                                    ((IAnchorInfoCardCore)ICoreManagerBase.getCore(IAnchorInfoCardCore.class)).showAnchorInfoCard(act.getSupportFragmentManager(), uid, false);
                                } else {
                                    ((IAnchorInfoCardCore)ICoreManagerBase.getCore(IAnchorInfoCardCore.class)).showPersonalInfoCard(act.getSupportFragmentManager(), uid, false);
                                }
                            } else {
                                MLog.info((String)UserInfoApiList.AUTHORITY, (String)"your uid is 0");
                            }
                        }
                    }
                });
            }
        };
    }

    @RestRoute(authority="UserInfo", path="UserInfoPage/*/*", eg="yymobile://UserInfo/UserInfoPage/{uid}/{isAnchor}", desc="\u8df3\u8f6c\u7528\u6237\u4fe1\u606f\u9875, isAnchor(1\u4e3b\u64ad\uff0c0\u975e\u4e3b\u64ad)")
    public IRestApiEx gotoUserInfo() {
        return new NavRestApi(){

            public String getAuthority() {
                return UserInfoApiList.AUTHORITY;
            }

            public String getPath() {
                return "UserInfoPage/*/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                final Activity context = param.context;
                Uri uri = param.uri;
                String uidStr = (String)uri.getPathSegments().get(1);
                final long uid = StringUtils.safeParseLong((String)uidStr);
                String isAnchorStr = (String)uri.getPathSegments().get(2);
                final int isAnchor = StringUtils.safeParseInt((String)isAnchorStr);
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (uid == 0L) {
                            if (LoginUtil.isLogined()) {
                                NavigationUtils.toMainTab(context, "/Me/Home");
                            } else {
                                ((ILoginPromptCore)ICoreManagerBase.getCore(ILoginPromptCore.class)).showLoginDialog(context);
                            }
                        } else if (isAnchor == 1) {
                            NavigationUtils.toPersonPage((Context)context, uid);
                        } else {
                            NavigationUtils.toUserInfo((Context)context, uid);
                        }
                    }
                });
            }
        };
    }

    @RestRoute(authority="UserInfo", path="UserInfoPage/*", eg="yymobile://UserInfo/UserInfoPage/{uid}", desc="\u8df3\u8f6c\u4e2a\u4eba\u9875\u9762")
    public IRestApiEx gotoUserInfoPage() {
        return new NavRestApi(){

            public String getAuthority() {
                return UserInfoApiList.AUTHORITY;
            }

            public String getPath() {
                return "UserInfoPage/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                Activity context = param.context;
                Uri uri = param.uri;
                String uidStr = (String)uri.getPathSegments().get(1);
                long uid = StringUtils.safeParseLong((String)uidStr);
                if (uid == 0L) {
                    MLog.info((String)UserInfoApiList.TAG, (String)"gotoUserInfoPage uid is 0");
                    if (!LoginUtil.isLogined()) {
                        ((ILoginPromptCore)ICoreManagerBase.getCore(ILoginPromptCore.class)).showLoginDialog(context);
                    }
                    return;
                }
                NavigationUtils.toPersonPage((Context)context, uid);
            }
        };
    }
}

