/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.rest;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import com.alibaba.android.arouter.facade.annotation.RestRoute;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.login.ILoginPromptCore;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.rest.base.INavParam;
import com.yy.mobile.ui.utils.rest.base.IRestApiEx;
import com.yy.mobile.ui.utils.rest.base.IRestApiList;
import com.yy.mobile.ui.utils.rest.base.NavRestApi;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.im.request.IsMyFriendAction;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;

public class PersonalCenterApiList
implements IRestApiList {
    private static final String TAG = "PersonalCenterApiList";
    private static final String AUTHORITY = "PersonalCenter";

    public List<IRestApiEx> getList() {
        ArrayList<IRestApiEx> list = new ArrayList<IRestApiEx>();
        list.add(this.toUserGallery());
        list.add(this.gotoPersonalCenter());
        list.add(this.gotoPersonalCenterAndOpenTab());
        list.add(this.tiebaGotoPersonalCenter());
        return list;
    }

    @RestRoute(authority="PersonalCenter", path="*", eg="yymobile://PersonalCenter/{uid}", desc="\u8df3\u8f6c\u4e2a\u4eba\u4e2d\u5fc3")
    public IRestApiEx gotoPersonalCenter() {
        return new NavRestApi(){

            public String getAuthority() {
                return PersonalCenterApiList.AUTHORITY;
            }

            public String getPath() {
                return "*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                final Activity context = param.context;
                Uri uri = param.uri;
                String uidStr = (String)uri.getPathSegments().get(0);
                final long uid = Long.valueOf(uidStr);
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (uid == 0L) {
                            if (LoginUtil.isLogined()) {
                                NavigationUtils.toMainTab(context, "/Me/Home");
                            } else {
                                ((ILoginPromptCore)ICoreManagerBase.getCore(ILoginPromptCore.class)).showLoginDialog(context);
                            }
                        } else {
                            NavigationUtils.toPersonPage((Context)context, uid);
                        }
                    }
                });
            }
        };
    }

    @RestRoute(authority="PersonalCenter", path="*/*", eg="yymobile://PersonalCenter/{uid}/{tabId}", desc="\u8df3\u8f6c\u4e2a\u4eba\u9875tab")
    public IRestApiEx gotoPersonalCenterAndOpenTab() {
        return new NavRestApi(){

            public String getAuthority() {
                return PersonalCenterApiList.AUTHORITY;
            }

            public String getPath() {
                return "*/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                final Activity context = param.context;
                Uri uri = param.uri;
                String uidStr = (String)uri.getPathSegments().get(0);
                final long uid = StringUtils.safeParseLong((String)uidStr);
                String tabIdStr = (String)uri.getPathSegments().get(1);
                final int tabId = StringUtils.safeParseInt((String)tabIdStr);
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (uid == 0L) {
                            if (LoginUtil.isLogined()) {
                                NavigationUtils.toMainTab(context, "/Me/Home");
                            } else {
                                ((ILoginPromptCore)ICoreManagerBase.getCore(ILoginPromptCore.class)).showLoginDialog(context);
                            }
                        } else {
                            NavigationUtils.toPersonPage((Context)context, uid, tabId);
                        }
                    }
                });
            }
        };
    }

    @RestRoute(authority="PersonalCenter", path="*/*/*/*/*", eg="yymobile://PersonalCenter/{uid}/{isAnchor}/*/*/*", desc="\u8d34\u5427\u8df3\u8f6c\u4e2a\u4eba\u4e2d\u5fc3\uff0c\u5df2\u5e9f\u5f03")
    public IRestApiEx tiebaGotoPersonalCenter() {
        return new NavRestApi(){

            public String getAuthority() {
                return PersonalCenterApiList.AUTHORITY;
            }

            public String getPath() {
                return "*/*/*/*/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                final Activity context = param.context;
                Uri uri = param.uri;
                String uidStr = (String)uri.getPathSegments().get(1);
                final String isAnchor = (String)uri.getPathSegments().get(2);
                final long uid = Long.valueOf(uidStr);
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((String)"hsj", (String)("tiebaGotoPersonalCenter uid=" + uid));
                }
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (uid == 0L) {
                            if (LoginUtil.isLogined()) {
                                NavigationUtils.toMainTab(context, "/Me/Home");
                            } else {
                                ((ILoginPromptCore)ICoreManagerBase.getCore(ILoginPromptCore.class)).showLoginDialog(context);
                            }
                        } else if (isAnchor != null && !isAnchor.equals("0")) {
                            NavigationUtils.toPersonPage((Context)context, uid);
                        } else {
                            YYStore.INSTANCE.dispatch((ReqAction)new IsMyFriendAction(uid)).subscribe((Consumer)new Consumer<Boolean>(){

                                public void accept(@NonNull Boolean isFriend) throws Exception {
                                    if (isFriend.booleanValue()) {
                                        NavigationUtils.toProfile((Context)context, uid);
                                    } else {
                                        NavigationUtils.toUserInfo((Context)context, uid);
                                    }
                                }
                            }, RxUtils.errorConsumer((String)PersonalCenterApiList.TAG));
                        }
                    }
                });
            }
        };
    }

    @RestRoute(authority="PersonalCenter", path="toUserGallery/*", eg="yymobile://PersonalCenter/toUserGallery/{uid}", desc="\u8df3\u8f6c\u4e2a\u4eba\u76f8\u518c")
    public IRestApiEx toUserGallery() {
        return new NavRestApi(){

            public void run() {
                INavParam param = (INavParam)this.getParam();
                final Activity act = param.context;
                final Uri uri = param.uri;
                act.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        List sidStr = uri.getPathSegments();
                        if (sidStr != null && sidStr.size() > 1) {
                            long urderId = Long.valueOf((String)sidStr.get(1));
                            NavigationUtils.toUserGallery((Context)act, urderId, true);
                        }
                    }
                });
            }

            public String getAuthority() {
                return PersonalCenterApiList.AUTHORITY;
            }

            public String getPath() {
                return "toUserGallery/*";
            }
        };
    }
}

