/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.rest;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.alibaba.android.arouter.facade.annotation.RestRoute;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.rest.base.INavParam;
import com.yy.mobile.ui.utils.rest.base.IRestApiEx;
import com.yy.mobile.ui.utils.rest.base.IRestApiList;
import com.yy.mobile.ui.utils.rest.base.NavRestApi;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreManager;
import com.yymobile.core.messagenotifycenter.IMessageNotifyCenterCore;
import com.yymobile.core.messagenotifycenter.templetmessage.ClassifyTemplateMessage;
import java.util.ArrayList;
import java.util.List;

public class MessageCenterApiList
implements IRestApiList {
    private static final String TAG = "MessageCenterApiList";
    private static final String AUTHORITY = "MessageCenter";

    public List<IRestApiEx> getList() {
        ArrayList<IRestApiEx> list = new ArrayList<IRestApiEx>();
        list.add(this.gotoMessageCenter());
        list.add(this.gotoMessageDetail());
        list.add(this.gotoHistoryMessageList());
        list.add(this.gotoInteractiveMessageList());
        list.add(this.gotoSystemMessageList());
        return list;
    }

    @RestRoute(authority="MessageCenter", path="MessageMainPage", desc="\u8df3\u8f6c\u6d88\u606f\u4e2d\u5fc3")
    public IRestApiEx gotoMessageCenter() {
        return new NavRestApi(){

            public String getAuthority() {
                return MessageCenterApiList.AUTHORITY;
            }

            public String getPath() {
                return "MessageMainPage";
            }

            public void run() {
                final INavParam param = (INavParam)this.getParam();
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        NavigationUtils.toMessageCenterActivity((Context)param.context);
                        MLog.info((String)MessageCenterApiList.TAG, (String)"shobal gotoMessageCenter");
                    }
                });
            }
        };
    }

    @RestRoute(authority="MessageCenter", path="MessageDetailPage", desc="\u8df3\u8f6c\u6d88\u606f\u8be6\u60c5\u9875\u9762")
    public IRestApiEx gotoMessageDetail() {
        return new NavRestApi(){

            public String getAuthority() {
                return MessageCenterApiList.AUTHORITY;
            }

            public String getPath() {
                return "MessageDetailPage";
            }

            public void run() {
                final INavParam param = (INavParam)this.getParam();
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        NavigationUtils.toMessageDetailActivity((Context)param.context, (Bundle)param.custom);
                        MLog.info((String)MessageCenterApiList.TAG, (String)"shobal gotoMessageDetail");
                    }
                });
            }
        };
    }

    @RestRoute(authority="MessageCenter", path="HistoryMessageList/*", eg="yymobile://MessageCenter/HistoryMessageList/{classifyId}", desc="\u8df3\u8f6c\u5386\u53f2\u6d88\u606f\u9875\u9762")
    public IRestApiEx gotoHistoryMessageList() {
        return new NavRestApi(){

            public String getAuthority() {
                return MessageCenterApiList.AUTHORITY;
            }

            public String getPath() {
                return "HistoryMessageList/*";
            }

            public void run() {
                try {
                    final INavParam param = (INavParam)this.getParam();
                    Uri uri = param.uri;
                    List segments = uri.getPathSegments();
                    final int classifyId = Integer.valueOf((String)segments.get(1));
                    param.context.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            ClassifyTemplateMessage type = ((IMessageNotifyCenterCore)CoreManager.getCore(IMessageNotifyCenterCore.class)).queryClassifyInfoByClassifyId(classifyId);
                            String title = "";
                            title = type != null ? type.classifyName : "\u6d88\u606f";
                            NavigationUtils.toMessageHistoryActivity((Context)param.context, title, classifyId);
                            MLog.info((String)MessageCenterApiList.TAG, (String)"shobal HistoryMessageList");
                        }
                    });
                }
                catch (Throwable throwable) {
                    MLog.error((String)"HistoryMessageList", (String)("error=" + throwable));
                }
            }
        };
    }

    @RestRoute(authority="MessageCenter", path="InteractiveMessageList/*", eg="yymobile://MessageCenter/InteractiveMessageList/{classifyId}", desc="\u8df3\u8f6c\u4e92\u52a8\u4fe1\u606f\u5217\u8868")
    public IRestApiEx gotoInteractiveMessageList() {
        return new NavRestApi(){

            public String getAuthority() {
                return MessageCenterApiList.AUTHORITY;
            }

            public String getPath() {
                return "InteractiveMessageList/*";
            }

            public void run() {
                try {
                    final INavParam param = (INavParam)this.getParam();
                    Uri uri = param.uri;
                    List segments = uri.getPathSegments();
                    int classifyId = Integer.valueOf((String)segments.get(1));
                    param.context.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            String title = "";
                            NavigationUtils.toInteractiveMessageActivity((Context)param.context);
                        }
                    });
                }
                catch (Throwable throwable) {
                    MLog.error((String)"InteractiveMessageList", (String)("error=" + throwable));
                }
            }
        };
    }

    @RestRoute(authority="MessageCenter", path="SystemMessageList/*", eg="yymobile://MessageCenter/SystemMessageList/{classifyId}", desc="\u8df3\u8f6c\u7cfb\u7edf\u6d88\u606f\u9875\u9762")
    public IRestApiEx gotoSystemMessageList() {
        return new NavRestApi(){

            public String getAuthority() {
                return MessageCenterApiList.AUTHORITY;
            }

            public String getPath() {
                return "SystemMessageList/*";
            }

            public void run() {
                try {
                    final INavParam param = (INavParam)this.getParam();
                    Uri uri = param.uri;
                    List segments = uri.getPathSegments();
                    int classifyId = Integer.valueOf((String)segments.get(1));
                    param.context.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            String title = "";
                            NavigationUtils.toSystemMessageActivity((Context)param.context);
                        }
                    });
                }
                catch (Throwable throwable) {
                    MLog.error((String)"SystemMessageList", (String)("error=" + throwable));
                }
            }
        };
    }
}

