/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.rest;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.alibaba.android.arouter.facade.annotation.RestRoute;
import com.duowan.mobile.main.kinds.Kinds;
import com.yy.mobile.abtest.nav.FastPopSubPageAb;
import com.yy.mobile.ui.deeplink.DeepLinkBackManager;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.rest.base.INavParam;
import com.yy.mobile.ui.utils.rest.base.IRestApiEx;
import com.yy.mobile.ui.utils.rest.base.IRestApiList;
import com.yy.mobile.ui.utils.rest.base.NavRestApi;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import com.yymobile.core.live.livenav.LiveNavInfo;
import com.yymobile.core.live.livenav.SubLiveNavItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LivingApiList
implements IRestApiList {
    private static final String TAG = "LivingApiList";
    private static final String AUTHORITY = "YY5LiveIndex";

    public List<IRestApiEx> getList() {
        ArrayList<IRestApiEx> list = new ArrayList<IRestApiEx>();
        list.add(this.gotoPreviewPage());
        list.add(this.gotoTopicListPage());
        list.add(this.gotoLabelListPage());
        list.add(this.gotoNewSubPage());
        list.add(this.gotoMobileLiveFeature());
        list.add(this.gotoAnchorStartPredict());
        return list;
    }

    @RestRoute(authority="YY5LiveIndex", path="previewList", desc="\u8df3\u8f6c\u9884\u544a\u9875\u9762")
    public IRestApiEx gotoPreviewPage() {
        return new NavRestApi(){

            public String getAuthority() {
                return LivingApiList.AUTHORITY;
            }

            public String getPath() {
                return "previewList";
            }

            public void run() {
                final INavParam param = (INavParam)this.getParam();
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String id2 = param.uri.getQueryParameter("itemId");
                        int itemId = -1;
                        if (id2 != null && !id2.equals("")) {
                            itemId = Integer.valueOf(id2);
                        }
                        NavigationUtils.toLivingPerviewPage(param.context, itemId);
                    }
                });
            }
        };
    }

    @RestRoute(authority="YY5LiveIndex", path="PopSubLivePage/*/*/*/*", eg="yymobile://YY5LiveIndex/PopSubLivePage/{topBiz}/{subBiz}/{topServ}/{subServ}?aggregateType=xxx", desc="\u6253\u5f00\u4e8c\u7ea7\u9875\u9762")
    public IRestApiEx gotoNewSubPage() {
        return new NavRestApi(){

            public String getAuthority() {
                return LivingApiList.AUTHORITY;
            }

            public String getPath() {
                return "PopSubLivePage/*/*/*/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                LivingApiList.this.jumpLivingMorePage(param.uri, param.context);
            }
        };
    }

    public void jumpLivingMorePage(final Uri uri, final Activity context) {
        Runnable biz = new Runnable(){

            @Override
            public void run() {
                MLog.info((String)"gotoNewSubPage", (String)("uri: " + uri.toString()));
                String value = uri.getQueryParameter("aggregateType");
                List segments = uri.getPathSegments();
                if (FP.empty((Collection)segments) || segments.size() < 5) {
                    MLog.error((String)"gotoNewSubPage", (String)("param error! uri=" + uri));
                    return;
                }
                LiveNavInfo navInfo = new LiveNavInfo();
                navInfo.biz = (String)segments.get(1);
                SubLiveNavItem subNavInfo = new SubLiveNavItem();
                subNavInfo.biz = (String)segments.get(2);
                try {
                    navInfo.serv = Integer.valueOf((String)segments.get(3));
                    subNavInfo.serv = Integer.valueOf((String)segments.get(3));
                }
                catch (NumberFormatException e) {
                    MLog.info((String)"gotoNewSubPage", (String)(e == null ? "" : e.getMessage()));
                }
                if (uri != null) {
                    DeepLinkBackManager.Companion.getInstance().handleDeeplinkSubPage(uri);
                }
                NavigationUtils.toLivingMorePage(context, (String)segments.get(4), navInfo, subNavInfo, 1, value, "", "");
            }
        };
        boolean from = TextUtils.equals((CharSequence)((FastPopSubPageAb)Kinds.of(FastPopSubPageAb.class)).isFromStartMain(), (CharSequence)"yes");
        MLog.info((String)TAG, (String)("FastPopSubPageAb:" + from));
        if (from) {
            biz.run();
        } else {
            context.runOnUiThread(biz);
        }
    }

    @RestRoute(authority="YY5LiveIndex", path="topicList", desc="\u8df3\u8f6c\u4e13\u9898\u5217\u8868\u9875\u9762")
    public IRestApiEx gotoTopicListPage() {
        return new NavRestApi(){

            public String getAuthority() {
                return LivingApiList.AUTHORITY;
            }

            public String getPath() {
                return "topicList";
            }

            public void run() {
                final INavParam param = (INavParam)this.getParam();
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        NavigationUtils.toLivingTopicListPage(param.context);
                    }
                });
            }
        };
    }

    @RestRoute(authority="YY5LiveIndex", path="labelList/*/*", eg="yymobile://YY5LiveIndex/labelList/{label}/{from}", desc="\u8df3\u8f6c\u6807\u7b7e\u5217\u8868\u9875\u9762")
    public IRestApiEx gotoLabelListPage() {
        return new NavRestApi(){

            public String getAuthority() {
                return LivingApiList.AUTHORITY;
            }

            public String getPath() {
                return "labelList/*/*";
            }

            public void run() {
                final INavParam param = (INavParam)this.getParam();
                Uri uri = param.uri;
                List segments = uri.getPathSegments();
                final String label = (String)segments.get(1);
                final String from = (String)segments.get(2);
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (param != null) {
                            NavigationUtils.toLivingLabelPage(param.context, label, from);
                        }
                    }
                });
            }
        };
    }

    @RestRoute(authority="MobileLive", path="FeatureBlock/*", desc="\u8df3\u8f6c\u73b0\u573a\u4e13\u9898")
    public IRestApiEx gotoMobileLiveFeature() {
        return new NavRestApi(){

            public String getAuthority() {
                return "MobileLive";
            }

            public String getPath() {
                return "FeatureBlock/*";
            }

            public void run() {
                final INavParam param = (INavParam)this.getParam();
                Uri uri = param.uri;
                List segments = uri.getPathSegments();
                final String id2 = (String)segments.get(1);
                MLog.info((String)LivingApiList.TAG, (String)("run()-->uri=" + uri + ", id=" + id2));
                if (BlankUtil.isBlank((String)id2)) {
                    return;
                }
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        NavigationUtils.toLivingTopicDetailPage((Context)param.context, Integer.parseInt(id2));
                        MLog.info((String)LivingApiList.TAG, (String)"hongzhou gotoLiveTopicDetailPage");
                    }
                });
            }
        };
    }

    @RestRoute(authority="MobileLive", path="PreViewId/*", desc="\u5148\u8df3\u5230\u9996\u9875\uff0c\u4e3b\u64ad\u9884\u544a\u5f00\u64ad")
    public IRestApiEx gotoAnchorStartPredict() {
        return new NavRestApi(){

            public String getAuthority() {
                return "MobileLive";
            }

            public String getPath() {
                return "PreViewId/*";
            }

            public void run() {
                final INavParam param = (INavParam)this.getParam();
                Uri uri = param.uri;
                List segments = uri.getPathSegments();
                String previewid = (String)segments.get(1);
                MLog.info((String)"MobileLiveApiList", (String)("run()-->uri=" + uri + ", previewid=" + previewid));
                if (BlankUtil.isBlank((String)previewid)) {
                    return;
                }
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MLog.info((String)LivingApiList.TAG, (String)" gotoAnchorStartPredict...");
                        NavigationUtils.toMobileLiveCameraPerviewViaMain(param.context);
                    }
                });
            }
        };
    }
}

