/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.rest;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import com.alibaba.android.arouter.facade.annotation.RestRoute;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.rest.base.INavParam;
import com.yy.mobile.ui.utils.rest.base.IRestApiEx;
import com.yy.mobile.ui.utils.rest.base.IRestApiList;
import com.yy.mobile.ui.utils.rest.base.NavRestApi;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class AnchorGalleryApiList
implements IRestApiList {
    private static final String TAG = "AnchorGalleryApiList";
    private static final String AUTHORITY = "AnchorGallery";

    public List<IRestApiEx> getList() {
        ArrayList<IRestApiEx> list = new ArrayList<IRestApiEx>();
        list.add(this.gotoAnchorGallery());
        list.add(this.gotoAnchorGallery2());
        list.add(this.gotoGallery());
        return list;
    }

    @RestRoute(authority="AnchorGallery", path="Album/*", eg="yymobile://AnchorGallery/Album/{json}", desc="\u8df3\u8f6c\u7528\u6237\u76f8\u518c")
    private IRestApiEx gotoAnchorGallery() {
        return new NavRestApi(){

            public String getAuthority() {
                return AnchorGalleryApiList.AUTHORITY;
            }

            public String getPath() {
                return "Album/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                final Activity act = param.context;
                final Uri uri = param.uri;
                act.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String decodeJsonStr = null;
                        try {
                            decodeJsonStr = uri.getLastPathSegment();
                            if (FP.empty((CharSequence)decodeJsonStr)) {
                                MLog.warn((String)AnchorGalleryApiList.TAG, (String)"[goto].[gotoAnchorGallery].decodeJsonStr=null");
                                return;
                            }
                            NavigationUtils.toGalleryNewDetailMsgCenterActivity((Context)act, decodeJsonStr, 2, 103);
                        }
                        catch (Throwable e) {
                            MLog.error((String)AnchorGalleryApiList.TAG, (String)("[gotoAnchorGallery].error=" + e));
                        }
                    }
                });
            }
        };
    }

    @RestRoute(authority="AnchorGallery", path="PhotoDetail/*/*/*", eg="yymobile://AnchorGallery/PhotoDetail/{uid}/{albumId}/{photoId}", desc="\u8df3\u8f6c\u7528\u6237\u76f8\u518c")
    private IRestApiEx gotoAnchorGallery2() {
        return new NavRestApi(){

            public String getAuthority() {
                return AnchorGalleryApiList.AUTHORITY;
            }

            public String getPath() {
                return "PhotoDetail/*/*/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                final Activity act = param.context;
                final Uri uri = param.uri;
                act.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        List segments = uri.getPathSegments();
                        String anchorIdStr = (String)segments.get(1);
                        String albumIdStr = (String)segments.get(2);
                        String photoIdStr = (String)segments.get(3);
                        long anchorId = StringUtils.safeParseLong((String)anchorIdStr);
                        long albumId = StringUtils.safeParseLong((String)albumIdStr);
                        long photoId = StringUtils.safeParseLong((String)photoIdStr);
                        if (anchorId != 0L && photoId != 0L) {
                            NavigationUtils.toGalleryNewDetailActivity((Context)act, anchorId, albumId, photoId, 3, 104);
                        } else {
                            MLog.warn((String)AnchorGalleryApiList.TAG, (String)"[kaede][jumptoanchoralbum]error anchor id or album id or photoId is 0");
                        }
                    }
                });
            }
        };
    }

    @RestRoute(authority="AnchorGallery", path="Gallery/*/*/*", eg="yymobile://AnchorGallery/Gallery/{uid}/{albumId}/{albumName}", desc="\u8df3\u8f6c\u7528\u6237\u76f8\u518c")
    private IRestApiEx gotoGallery() {
        return new NavRestApi(){

            public String getAuthority() {
                return AnchorGalleryApiList.AUTHORITY;
            }

            public String getPath() {
                return "Gallery/*/*/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                final Activity act = param.context;
                final Uri uri = param.uri;
                act.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        List segments = uri.getPathSegments();
                        String anchorIdStr = (String)segments.get(1);
                        String albumIdStr = (String)segments.get(2);
                        String albumName = (String)segments.get(3);
                        long anchorId = StringUtils.safeParseLong((String)anchorIdStr);
                        long albumId = StringUtils.safeParseLong((String)albumIdStr);
                        if (anchorId != 0L && albumId != 0L) {
                            NavigationUtils.toStaggeredGridAcitivity((Context)act, anchorId, albumName, albumId);
                        } else {
                            MLog.warn((String)AnchorGalleryApiList.TAG, (String)"[kaede][jumptoanchoralbum]error anchor id or album id is 0");
                        }
                    }
                });
            }
        };
    }
}

