/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.v2.v2ApiModule.uimodulemethod;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.view.Window;
import com.duowan.mobile.jsannotation.JsMethod;
import com.duowan.mobile.jsannotation.Param;
import com.duowan.mobile.jsannotation.ParamType;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.ILivePluginCore;
import org.json.JSONObject;

public class GetScreenSize {
    private static final String TAG = "GetScreenSize";
    private static final String description = "\u83b7\u53d6\u5c4f\u5e55\u5c3a\u5bf8";

    @JsMethod(module="ui", methodName="getScreenSize", description="\u83b7\u53d6\u5c4f\u5e55\u5c3a\u5bf8")
    public String invoke(@Param(type=ParamType.CONTEXT) Context context, @Param(type=ParamType.JS_CALLBACK) IApiModule.IJSCallback callback) {
        JSONObject jsonObject = new JSONObject();
        Rect rectangle = new Rect();
        try {
            Window window;
            Activity act = context != null && context instanceof Activity ? (Activity)context : null;
            Window window2 = window = act != null ? act.getWindow() : null;
            if (window != null) {
                window.getDecorView().getWindowVisibleDisplayFrame(rectangle);
            }
            ScreenUtil.getInstance();
            int statusBarHeight = ScreenUtil.getStatusBarHeight();
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)TAG, (String)("webviewcontrol:topheight" + statusBarHeight));
            }
            int webViewControllerScreenWidth = ((ILivePluginCore)ICoreManagerBase.getCore(ILivePluginCore.class)).getWebViewControllerScreenWidth();
            int webViewControllerScreenHeight = ((ILivePluginCore)ICoreManagerBase.getCore(ILivePluginCore.class)).getWebViewControllerScreenHeight();
            float webViewControllerScreenScale = ((ILivePluginCore)ICoreManagerBase.getCore(ILivePluginCore.class)).getWebViewControllerScreenScale();
            if (webViewControllerScreenWidth == 0 || webViewControllerScreenHeight == 0) {
                DisplayMetrics dm = new DisplayMetrics();
                if (act != null) {
                    if (act.getWindowManager() != null && act.getWindowManager().getDefaultDisplay() != null) {
                        act.getWindowManager().getDefaultDisplay().getMetrics(dm);
                    }
                    float scale = dm.density;
                    MLog.info((String)TAG, (String)("webviewcontrol:" + scale));
                    int tempw = ResolutionUtils.getScreenWidth((Context)act);
                    int temph = ResolutionUtils.getScreenHeight((Context)act);
                    if (tempw < temph) {
                        if (scale != 0.0f) {
                            jsonObject.put("w", (double)((float)tempw / scale));
                            jsonObject.put("h", (double)((float)(temph - statusBarHeight) / scale));
                        } else {
                            jsonObject.put("w", tempw);
                            jsonObject.put("h", temph - statusBarHeight);
                        }
                    } else if (scale != 0.0f) {
                        jsonObject.put("w", (double)((float)temph / scale));
                        jsonObject.put("h", (double)((float)(tempw - statusBarHeight) / scale));
                    } else {
                        jsonObject.put("w", temph);
                        jsonObject.put("h", tempw - statusBarHeight);
                    }
                }
            } else if (webViewControllerScreenScale != 0.0f) {
                jsonObject.put("w", (double)((float)webViewControllerScreenWidth / webViewControllerScreenScale));
                jsonObject.put("h", (double)((float)webViewControllerScreenHeight / webViewControllerScreenScale));
            } else {
                jsonObject.put("w", webViewControllerScreenWidth);
                jsonObject.put("h", webViewControllerScreenHeight);
            }
            if (callback != null) {
                callback.invokeCallback(JSONObject.quote((String)jsonObject.toString()));
            }
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)TAG, (String)("webviewcontrol:screentsize" + jsonObject.toString()));
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return JsonParser.toJson((Object)jsonObject.toString());
    }
}

