/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.v2.v2ApiModule.device.method;

import android.content.Context;
import android.location.LocationManager;
import com.duowan.mobile.jsannotation.JsMethod;
import com.duowan.mobile.jsannotation.Param;
import com.duowan.mobile.jsannotation.ParamType;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.js.JsLifecycleProvider;
import com.yy.mobile.ui.utils.js.v2.v2ApiModule.device.method.GetLocation$$EventBinder;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.foundation.ILocationClient_onReceiveLocation_EventArgs;
import com.yymobile.core.foundation.ILocationCore;
import com.yymobile.core.foundation.LocationCache;
import com.yymobile.core.im.TaskIDUtil;
import org.json.JSONObject;

public class GetLocation
extends EmptyEventCompat
implements JsLifecycleProvider {
    private static final String TAG = "GetLocation";
    private static final String description = "\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e";
    private IApiModule.IJSCallback locationInfoCallback;
    private long locationReqTaskId;
    private EventBinder mEventBinder;

    public GetLocation() {
        ICoreManagerBase.addClient((Object)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsMethod(module="device", methodName="getLocation", description="\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e")
    public String invoke(@Param(type=ParamType.JS_CALLBACK) IApiModule.IJSCallback callback) {
        MLog.info((String)TAG, (String)"[getLocationInfo]");
        JSONObject resultJson = new JSONObject();
        String jsonStr = "";
        try {
            long taskID = TaskIDUtil.getInstance().getTaskID();
            LocationCache locationCache = ((ILocationCore)ICoreManagerBase.getCore(ILocationCore.class)).getCacheRecentLocationInfo();
            if (locationCache == null) {
                locationCache = ((ILocationCore)ICoreManagerBase.getCore(ILocationCore.class)).getRecentLocationInfo(taskID, 3);
                this.locationReqTaskId = taskID;
            }
            boolean isGPSOpen = this.isOpenGPS(BasicConfig.getInstance().getAppContext());
            MLog.info((String)TAG, (String)("[getLocationInfo] isGPSOpen=" + isGPSOpen));
            if (locationCache != null && isGPSOpen) {
                JSONObject location = new JSONObject();
                location.put("longitude", (Object)(locationCache.longitude + ""));
                location.put("latitude", (Object)(locationCache.latitude + ""));
                location.put("district", (Object)locationCache.district);
                location.put("country", (Object)locationCache.country);
                location.put("province", (Object)locationCache.province);
                location.put("city", (Object)locationCache.city);
                resultJson.put("code", 0);
                resultJson.put("data", (Object)location);
                resultJson.put("msg", (Object)"location info is exist !");
                MLog.info((String)TAG, (String)("[getLocation] locationInfo=" + resultJson.toString()));
                jsonStr = resultJson.toString();
            } else {
                this.locationInfoCallback = callback;
                this.locationReqTaskId = taskID;
                resultJson.put("code", 1);
                resultJson.put("data", (Object)"");
                if (!isGPSOpen) {
                    resultJson.put("msg", (Object)"device do not open gps !");
                } else {
                    resultJson.put("msg", (Object)"location info is loading !");
                }
                MLog.info((String)TAG, (String)"[onReceiveLocation] locationCache is null");
                jsonStr = resultJson.toString();
            }
        }
        catch (Throwable throwable) {
            MLog.error((String)TAG, (String)("getLocation error! throwable=" + throwable));
            jsonStr = "{\"code\":\"1\",\"msg\":\"" + throwable.toString() + "\"}";
        }
        finally {
            if (callback != null) {
                callback.invokeCallback("'" + jsonStr + "'");
            }
        }
        return jsonStr;
    }

    public final boolean isOpenGPS(Context context) {
        if (context != null) {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            boolean gps = locationManager.isProviderEnabled("gps");
            boolean network = locationManager.isProviderEnabled("network");
            if (gps || network) {
                return true;
            }
        }
        return false;
    }

    @BusEvent
    public void onReceiveLocation(ILocationClient_onReceiveLocation_EventArgs busEventArgs) {
        long taskID = busEventArgs.getTaskID();
        LocationCache locationCache = busEventArgs.getLocation();
        MLog.info((String)TAG, (String)("[onReceiveLocation] locationCache=" + locationCache));
        if (this.locationReqTaskId == taskID && locationCache != null && this.locationInfoCallback != null) {
            try {
                JSONObject resultJson = new JSONObject();
                JSONObject location = new JSONObject();
                location.put("longitude", (Object)(locationCache.longitude + ""));
                location.put("latitude", (Object)(locationCache.latitude + ""));
                resultJson.put("code", 0);
                resultJson.put("data", (Object)location);
                resultJson.put("msg", (Object)"location info is loaded !");
                MLog.info((String)TAG, (String)("[onReceiveLocation] locationInfo=" + resultJson.toString()));
                this.locationInfoCallback.invokeCallback("'" + resultJson.toString() + "'");
                this.locationReqTaskId = 0L;
                this.locationInfoCallback = null;
            }
            catch (Throwable throwable) {
                MLog.error((String)TAG, (String)("[onReceiveLocation] getLocation error! throwable=" + throwable));
            }
        }
    }

    public void release() {
        ICoreManagerBase.removeClient((Object)((Object)this));
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new GetLocation$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

