/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.v2.v2ApiModule.datamodulemethod;

import android.content.Context;
import com.duowan.mobile.jsannotation.JsMethod;
import com.duowan.mobile.jsannotation.Param;
import com.duowan.mobile.jsannotation.ParamType;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.javascript.ResultData;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.subscribe.FollowResult;
import com.yymobile.core.subscribe.ISubscribeCore;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class UnFollowAnchor {
    private static final String TAG = "UnFollowAnchor";
    private static final String description = "\u53d6\u6d88\u5173\u6ce8\u4e3b\u64ad";

    @JsMethod(module="data", methodName="unFollowAnchor", description="\u53d6\u6d88\u5173\u6ce8\u4e3b\u64ad")
    public String unFollowAnchor(@Param(type=ParamType.JSON_PARAM) String param, final @Param(type=ParamType.JS_CALLBACK) IApiModule.IJSCallback callback) {
        MLog.info((String)TAG, (String)"unFollowAnchor: called");
        ResultData resultData = new ResultData();
        try {
            JSONObject jsonObject = new JSONObject(param);
            final long anchorID = jsonObject.optLong("anchorID");
            if (anchorID == 0L) {
                resultData.code = -1;
                resultData.msg = "anchorID is null";
                if (callback != null) {
                    callback.invokeCallback("'" + JsonParser.toJson((Object)resultData) + "'");
                }
                return JsonParser.toJson((Object)resultData);
            }
            final FollowResult followResult = new FollowResult();
            if (!NetworkUtils.isNetworkStrictlyAvailable((Context)BasicConfig.getInstance().getAppContext())) {
                followResult.result = 0;
                followResult.error = "unFollow failure network is unavailable";
                String json = JsonParser.toJson((Object)followResult);
                if (callback != null) {
                    callback.invokeCallback("'" + json + "'");
                }
                return "";
            }
            ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).unSubscribeObservable(anchorID).timeout(5000L, TimeUnit.MILLISECONDS).subscribe(new CompletableObserver(){

                public void onSubscribe(Disposable d2) {
                }

                public void onComplete() {
                    followResult.result = 1;
                    followResult.error = "";
                    ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).clearCache(anchorID);
                    this.invokeCallback();
                }

                public void onError(Throwable e) {
                    followResult.result = 0;
                    followResult.error = e.getMessage();
                    this.invokeCallback();
                }

                private void invokeCallback() {
                    String json = JsonParser.toJson((Object)followResult);
                    MLog.info((String)UnFollowAnchor.TAG, (String)("followResult==" + json));
                    if (callback != null) {
                        callback.invokeCallback("'" + json + "'");
                    }
                }
            });
        }
        catch (Throwable e) {
            resultData.code = -1;
            resultData.msg = e == null ? "" : e.getMessage();
        }
        return JsonParser.toJson((Object)resultData);
    }
}

