/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.v2.v2ApiModule.datamodulemethod;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.duowan.mobile.jsannotation.JsMethod;
import com.duowan.mobile.jsannotation.Param;
import com.duowan.mobile.jsannotation.ParamType;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.javascript.ResultData;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.subscribe.FollowResult;
import com.yymobile.core.subscribe.ISubscribeClient;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yymobile.core.subscribe.SubscribeClients;
import com.yymobile.core.subscribe.SubscribeInfo;
import java.util.List;
import org.json.JSONObject;

public class SetFollowAnchor {
    private static final String TAG = "SetFollowAnchor";
    private static final String description = "\u8bbe\u7f6e\u5173\u6ce8\u4e3b\u64ad";
    private Runnable followAnchorRunnable;
    private Handler mHandler = new Handler(Looper.getMainLooper());

    @JsMethod(module="data", methodName="setFollowAnchor", description="\u8bbe\u7f6e\u5173\u6ce8\u4e3b\u64ad")
    public String setFollowAnchor(@Param(type=ParamType.JSON_PARAM) String param, final @Param(type=ParamType.JS_CALLBACK) IApiModule.IJSCallback callback) {
        MLog.info((String)TAG, (String)"setFollowAnchor: called");
        ResultData resultData = new ResultData();
        try {
            JSONObject jsonObject = new JSONObject(param);
            final long anchorID = jsonObject.optLong("anchorID");
            if (anchorID == 0L) {
                resultData.code = -1;
                resultData.msg = "anchorID is null";
                if (callback != null) {
                    callback.invokeCallback("'" + JsonParser.toJson((Object)resultData) + "'");
                }
                return JsonParser.toJson((Object)resultData);
            }
            final FollowResult followResult = new FollowResult();
            if (!NetworkUtils.isNetworkStrictlyAvailable((Context)BasicConfig.getInstance().getAppContext())) {
                followResult.result = 0;
                followResult.error = "follow failure network is unavailable";
                String json = JsonParser.toJson((Object)followResult);
                if (callback != null) {
                    callback.invokeCallback("'" + json + "'");
                }
                return "";
            }
            final ISubscribeClient client = new ISubscribeClient(){

                public void onGetSubscribeList(long uid, List<SubscribeInfo> list, boolean isLastPage) {
                }

                public void onSubscribeResult(long anchorUid, boolean success, String errorMsg) {
                    ICoreManagerBase.removeClient((Object)this);
                    if (SetFollowAnchor.this.followAnchorRunnable != null) {
                        SetFollowAnchor.this.mHandler.removeCallbacks(SetFollowAnchor.this.followAnchorRunnable);
                    }
                    if (anchorID == anchorUid) {
                        if (success) {
                            followResult.result = 1;
                            followResult.error = "";
                            ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).clearCache(anchorUid);
                        } else {
                            followResult.result = 0;
                            followResult.error = "follow failure";
                        }
                        String json = JsonParser.toJson((Object)followResult);
                        MLog.info((String)SetFollowAnchor.TAG, (String)("followResult==" + json));
                        if (callback != null) {
                            callback.invokeCallback("'" + json + "'");
                        }
                    }
                }

                public void onUnSubscribeResult(long anchorUid, boolean success) {
                }

                public void onQuerySubscribeNumResult(long uid, long count) {
                }
            };
            SubscribeClients.removeCallBack((ISubscribeClient)client);
            SubscribeClients.addCallBack((ISubscribeClient)client);
            if (this.followAnchorRunnable != null) {
                this.mHandler.removeCallbacks(this.followAnchorRunnable);
            }
            ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).subscribe(anchorID);
            this.followAnchorRunnable = new Runnable(){

                @Override
                public void run() {
                    SubscribeClients.removeCallBack((ISubscribeClient)client);
                    followResult.result = 0;
                    followResult.error = "follow failure,time out ";
                    String json = JsonParser.toJson((Object)followResult);
                    if (callback != null) {
                        callback.invokeCallback("'" + json + "'");
                    }
                }
            };
            this.mHandler.postDelayed(this.followAnchorRunnable, 5000L);
        }
        catch (Throwable e) {
            resultData.code = -1;
            resultData.msg = e == null ? "" : e.getMessage();
        }
        return JsonParser.toJson((Object)resultData);
    }
}

