/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.v2.v2ApiModule.datamodulemethod;

import com.duowan.mobile.jsannotation.JsMethod;
import com.duowan.mobile.jsannotation.Param;
import com.duowan.mobile.jsannotation.ParamType;
import com.google.gson.Gson;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.util.SHAUtils;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.utils.CommonParamUtil;
import com.yymobile.core.wspx.FreeDataAuthRes;
import com.yymobile.core.wspx.NewFreeDataServiceMgr;
import com.yymobile.core.wspx.utils.VpnDesedeUtil;
import org.json.JSONObject;

public class FreeDataSignCache {
    private static final String TAG = "FreeDataSignCache";
    private static final String description = "\u8054\u901a\u514d\u6d41\u9875\u9762\u56de\u4f20\u7684\u52a0\u5bc6\u4e32";

    @JsMethod(module="data", methodName="unicomFreeData", description="\u8054\u901a\u514d\u6d41\u9875\u9762\u56de\u4f20\u7684\u52a0\u5bc6\u4e32")
    public String freeDataSignCache(@Param(type=ParamType.JSON_PARAM) String param, @Param(type=ParamType.JS_CALLBACK) IApiModule.IJSCallback callback) {
        MLog.info((String)TAG, (String)("freeDataSignCache param = " + param));
        if (param != null) {
            try {
                JSONObject jsonObject = new JSONObject(param);
                String sign = jsonObject.optString("signString");
                String decodeSign = VpnDesedeUtil.decrypt((String)sign, (String)"Xwo@Prod#2020");
                MLog.info((String)TAG, (String)("freeDataSignCache decodeSign = " + decodeSign));
                this.notifyServiceUpdate(decodeSign);
                NewFreeDataServiceMgr.INSTANCE.saveSign(decodeSign);
            }
            catch (Exception e) {
                MLog.error((String)TAG, (String)("freeDataSignCache error msg = " + e));
            }
        }
        return JsonParser.toJson((Object)"");
    }

    private void notifyServiceUpdate(String decodeSign) {
        RequestParam param = CommonParamUtil.fillCommonParamPrivacy();
        Gson gson = new Gson();
        long curTime = System.currentTimeMillis();
        FreeDataAuthRes authRes = (FreeDataAuthRes)gson.fromJson(decodeSign, FreeDataAuthRes.class);
        String beforeSign = authRes.getPhoneNumber() + authRes.getPackageId() + authRes.getOperType() + curTime + "e526b103cadf5c0c566812f25b465626c2d0db6";
        String afterSign = SHAUtils.getSHA256((String)beforeSign);
        MLog.info((String)TAG, (String)("notifyServiceUpdate beforeSign = " + beforeSign + ", afterSign = " + afterSign));
        param.put("phoneNumber", authRes.getPhoneNumber());
        param.put("packageId", authRes.getPackageId());
        param.put("operType", authRes.getOperType());
        param.put("time", String.valueOf(curTime));
        param.put("sign", afterSign);
        String url = NewFreeDataServiceMgr.INSTANCE.getNOTIFY_REQ_URL();
        MLog.info((String)TAG, (String)("notifyServiceUpdate reqUrl = " + url + "?" + param));
        RequestManager.instance().submitStringQueryRequest(url, param, (ResponseListener)new ResponseListener<String>(){

            public void onResponse(String response) {
                MLog.info((String)FreeDataSignCache.TAG, (String)("notifyServiceUpdate res = " + response));
            }
        }, new ResponseErrorListener(){

            public void onErrorResponse(RequestError error) {
                MLog.error((String)FreeDataSignCache.TAG, (String)("notifyServiceUpdate error msg: " + error));
            }
        });
    }
}

