/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.v2.v2ApiModule.datamodulemethod;

import android.annotation.SuppressLint;
import android.content.Context;
import com.duowan.mobile.jsannotation.JsMethod;
import com.duowan.mobile.jsannotation.Param;
import com.duowan.mobile.jsannotation.ParamType;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.javascript.ResultData;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.subscribe.FollowResult;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yymobile.core.subscribe.SubscribeProtocol;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class FollowAnchor {
    private static final String TAG = "FollowAnchor";
    private static final String description = "\u5173\u6ce8\u4e3b\u64ad";

    @JsMethod(module="data", methodName="followAnchor", description="\u5173\u6ce8\u4e3b\u64ad")
    @SuppressLint(value={"CheckResult"})
    public String followAnchor(@Param(type=ParamType.JSON_PARAM) String param, final @Param(type=ParamType.JS_CALLBACK) IApiModule.IJSCallback callback) {
        MLog.info((String)TAG, (String)"followAnchor: called");
        ResultData resultData = new ResultData();
        try {
            JSONObject jsonObject = new JSONObject(param);
            final long anchorID = jsonObject.optLong("anchorID");
            if (anchorID == 0L) {
                resultData.code = -1;
                resultData.msg = "anchorID is null";
                if (callback != null) {
                    callback.invokeCallback("'" + JsonParser.toJson((Object)resultData) + "'");
                }
                return JsonParser.toJson((Object)resultData);
            }
            final FollowResult followResult = new FollowResult();
            if (!NetworkUtils.isNetworkStrictlyAvailable((Context)BasicConfig.getInstance().getAppContext())) {
                followResult.result = 0;
                followResult.error = "follow failure network is unavailable";
                String json = JsonParser.toJson((Object)followResult);
                if (callback != null) {
                    callback.invokeCallback("'" + json + "'");
                }
                return "";
            }
            ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).subscribeSingle(anchorID).timeout(5000L, TimeUnit.MILLISECONDS).subscribe((Consumer)new Consumer<SubscribeProtocol.BookAnchorRsp>(){

                public void accept(SubscribeProtocol.BookAnchorRsp rsp) throws Exception {
                    if (rsp.isSuccess()) {
                        followResult.result = 1;
                        followResult.error = "";
                        ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).clearCache(anchorID);
                    } else {
                        followResult.result = 0;
                        followResult.error = "\u5173\u6ce8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5";
                    }
                    FollowAnchor.this.invokeCallback(followResult, callback);
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) throws Exception {
                    followResult.result = 0;
                    followResult.error = "\u5173\u6ce8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5";
                    FollowAnchor.this.invokeCallback(followResult, callback);
                }
            });
        }
        catch (Throwable e) {
            resultData.code = -1;
            resultData.msg = e == null ? "" : e.getMessage();
        }
        return JsonParser.toJson((Object)resultData);
    }

    private void invokeCallback(FollowResult followResult, @Param(type=ParamType.JS_CALLBACK) IApiModule.IJSCallback callback) {
        String json = JsonParser.toJson((Object)followResult);
        MLog.info((String)TAG, (String)("followResult==" + json));
        if (callback != null) {
            callback.invokeCallback("'" + json + "'");
        }
    }
}

