/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.v2.v2ApiModule.datamodulemethod;

import android.content.Context;
import com.duowan.mobile.jsannotation.JsMethod;
import com.duowan.mobile.jsannotation.Param;
import com.duowan.mobile.jsannotation.ParamType;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.js.JsLifecycleProvider;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.javascript.ResultData;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.subscribe.ISubscribeCore;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONObject;

public class BatchQueryFollowStatus
implements JsLifecycleProvider {
    private static final String TAG = "BatchQueryFollowStatus";
    private static final String description = "\u6279\u91cf\u67e5\u8be2\u5f53\u524d\u7528\u6237\u5bf9\u67d0\u4e00\u6279\u7528\u6237\u7684\u5173\u6ce8\u72b6\u6001";
    private CompositeDisposable mDisposable = new CompositeDisposable();

    @JsMethod(module="data", methodName="batchQueryFollowStatus", description="\u6279\u91cf\u67e5\u8be2\u5f53\u524d\u7528\u6237\u5bf9\u67d0\u4e00\u6279\u7528\u6237\u7684\u5173\u6ce8\u72b6\u6001")
    public String batchQueryFollowStatus(@Param(type=ParamType.JSON_PARAM) String param, final @Param(type=ParamType.JS_CALLBACK) IApiModule.IJSCallback callback) {
        block10: {
            MLog.info((String)TAG, (String)("batchQueryFollowStatus: param=" + param));
            try {
                JSONObject jsonObject = new JSONObject(param);
                JSONArray jsonArray = jsonObject.optJSONArray("userIDs");
                if (jsonArray == null) {
                    ResultData resultData = new ResultData();
                    resultData.code = -1;
                    resultData.msg = "userIDs is null";
                    if (callback != null) {
                        callback.invokeCallback("'" + JsonParser.toJson((Object)resultData) + "'");
                    }
                    return JsonParser.toJson((Object)resultData);
                }
                ArrayList<Long> uids = new ArrayList<Long>();
                for (int t = 0; t < jsonArray.length(); ++t) {
                    uids.add(jsonArray.optLong(t));
                }
                if (!NetworkUtils.isNetworkStrictlyAvailable((Context)BasicConfig.getInstance().getAppContext())) {
                    ResultData resultData = new ResultData();
                    resultData.code = -1;
                    resultData.msg = "batchQueryFollowStatus failure network is unavailable";
                    String json = JsonParser.toJson((Object)resultData);
                    if (callback != null) {
                        callback.invokeCallback("'" + json + "'");
                    }
                    return json;
                }
                if (!LoginUtil.isLogined()) {
                    ResultData resultData = new ResultData();
                    resultData.code = -1;
                    resultData.msg = "batchQueryFollowStatus failure user not login";
                    String json = JsonParser.toJson((Object)resultData);
                    if (callback != null) {
                        callback.invokeCallback("'" + json + "'");
                    }
                    return json;
                }
                MLog.info((String)TAG, (String)"queryBookAnchorBatchReq..");
                ISubscribeCore core = (ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class);
                if (core != null) {
                    this.mDisposable.add(core.querySubscribeAllObservable(uids).timeout(5000L, TimeUnit.MILLISECONDS).subscribe((Consumer)new Consumer<Map<Long, Boolean>>(){

                        public void accept(Map<Long, Boolean> friendList) throws Exception {
                            if (LoginUtil.isLogined()) {
                                MLog.info((String)BatchQueryFollowStatus.TAG, (String)("onQueryBookAnchorBatchResult: uid=" + LoginUtil.getUid() + ", friendList=" + friendList));
                                ResultData resultData = new ResultData();
                                resultData.code = 0;
                                resultData.data = friendList;
                                if (callback != null) {
                                    callback.invokeCallback("'" + JsonParser.toJson((Object)resultData) + "'");
                                }
                            }
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        public void accept(Throwable throwable) throws Exception {
                            ResultData resultData = new ResultData();
                            resultData.code = -1;
                            resultData.msg = throwable instanceof TimeoutException ? "batchQueryFollowStatus failure,time out " : "batchQueryFollowStatus failure, unknown ";
                            String json = JsonParser.toJson((Object)resultData);
                            if (callback != null) {
                                MLog.info((String)BatchQueryFollowStatus.TAG, (String)("invokeCallback: " + json));
                                callback.invokeCallback("'" + json + "'");
                            }
                        }
                    }));
                }
            }
            catch (Throwable e) {
                ResultData resultData = new ResultData();
                resultData.code = -1;
                resultData.msg = e.getMessage();
                String json = JsonParser.toJson((Object)resultData);
                if (callback == null) break block10;
                callback.invokeCallback("'" + json + "'");
            }
        }
        return "";
    }

    public void release() {
        this.mDisposable.dispose();
    }
}

