/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.v2.v2ApiModule;

import android.content.Context;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.mobile.js.JsBinders;
import com.yy.mobile.js.JsLifecycleProvider;
import com.yy.mobile.js.JsModuleFinder;
import com.yy.mobile.model.collection.ImmutableMap;
import com.yy.mobile.model.store.HostState;
import com.yy.mobile.model.store.HostStore;
import com.yy.mobile.ui.utils.js.v2.v2ApiModule.JsMethodManager;
import com.yy.mobile.ui.utils.js.v2.v2ApiModule.datamodulemethod.SetTimer;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.javascript.ResultData;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.jscallmethod.IJsMethodPluginCore;
import com.yymobile.core.webbus.IWebBusCore;
import com.yymobile.core.webbus.WebComponentProxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataModule
extends EmptyEventCompat
implements IApiModule {
    private static final String TAG = "DataModule";
    private JsModuleFinder finder = new JsModuleFinder("data");
    public static final String MODULE_NAME = "data";
    private IDataCallback mCallback;
    private String mWebId;
    private H5RegisterPushCallback mH5RegisterPushCallback;
    private IApiModule.IApiMethod getWebCache = new IApiModule.IApiMethod(){

        public String methodName() {
            return "getWebCache";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity2) {
            try {
                if (DataModule.this.mCallback != null && !FP.empty((CharSequence)param)) {
                    JSONObject jsonObject = new JSONObject(param);
                    String value = DataModule.this.mCallback.getWebCache(jsonObject.optString("key"));
                    MLog.info((String)DataModule.TAG, (String)("[DataModule].getWebCache key=" + jsonObject.optString("key") + ",value=" + value));
                    if (callback != null) {
                        callback.invokeCallback("'" + JsonParser.toJson((Object)value) + "'");
                    }
                    return JsonParser.toJson((Object)value);
                }
            }
            catch (Throwable t) {
                MLog.error((String)DataModule.TAG, (String)("[getWebCache].error=" + t));
            }
            if (callback != null) {
                callback.invokeCallback("'[]'");
            }
            return JsonParser.toJson((Object)"");
        }
    };
    private IApiModule.IApiMethod updateWebCache = new IApiModule.IApiMethod(){

        public String methodName() {
            return "updateWebCache";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity2) {
            ResultData resultData;
            block5: {
                MLog.debug((String)DataModule.TAG, (String)("updateWebCache param = " + param + " callback = " + callback));
                resultData = new ResultData();
                try {
                    JSONObject pramObj = new JSONObject(param);
                    Iterator it = pramObj.keys();
                    if (it != null) {
                        while (it.hasNext()) {
                            String key = (String)it.next();
                            if (DataModule.this.mCallback == null) continue;
                            DataModule.this.mCallback.updateWebCache(key, pramObj.optString(key));
                        }
                    }
                    if (callback != null) {
                        callback.invokeCallback(JSONObject.quote((String)JsonParser.toJson((Object)resultData)));
                    }
                }
                catch (Throwable e) {
                    resultData.code = -1;
                    resultData.msg = "invalid param";
                    MLog.error((String)DataModule.TAG, (String)("[WebInterface].[DataModule].[setWebCache] error=" + e));
                    if (callback == null) break block5;
                    callback.invokeCallback(JSONObject.quote((String)JsonParser.toJson((Object)resultData)));
                    MLog.debug((String)DataModule.TAG, (String)"update web cache invoke when exception");
                }
            }
            return JsonParser.toJson((Object)resultData);
        }
    };
    private IApiModule.IApiMethod webDataToServer = new IApiModule.IApiMethod(){

        public String methodName() {
            return "webDataToServer";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity2) {
            ResultData resultData = new ResultData();
            MLog.info((String)DataModule.TAG, (String)("webDataToServer invoke param = " + param + "callback = " + callback));
            try {
                JSONObject jSONObject = new JSONObject(param);
            }
            catch (Exception e) {
                resultData.code = -1;
                resultData.msg = "invalid json param";
            }
            if (callback != null) {
                callback.invokeCallback("'" + JsonParser.toJson((Object)resultData) + "'");
            }
            if (DataModule.this.mCallback != null) {
                DataModule.this.mCallback.onActWebData(param);
            }
            return JsonParser.toJson((Object)resultData);
        }
    };
    private IApiModule.IApiMethod webBusRegister = new IApiModule.IApiMethod(){

        public String methodName() {
            return "webBusRegister";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity2) {
            MLog.info((String)this.methodName(), (String)("param:" + param));
            ResultData resultData = new ResultData();
            try {
                JSONObject jsonObject = new JSONObject(param);
                if (jsonObject.has("webid") && jsonObject.has("methods")) {
                    DataModule.this.mWebId = jsonObject.optString("webid");
                    JSONArray jsonArray = jsonObject.optJSONArray("methods");
                    ArrayList<String> methods = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        methods.add(jsonArray.getString(i));
                    }
                    resultData.code = 0;
                    if (ICoreManagerBase.getCore(IWebBusCore.class) != null) {
                        resultData.code = ((IWebBusCore)ICoreManagerBase.getCore(IWebBusCore.class)).registerWebComponent(DataModule.this.mWebId, methods, new WebComponentProxy(){

                            public void invokeJsMethod(String method, JSONObject param) {
                                if (DataModule.this.mCallback != null) {
                                    DataModule.this.mCallback.invokeJs(method, param);
                                }
                            }
                        });
                    }
                }
            }
            catch (Throwable t) {
                MLog.error((String)this.methodName(), (String)("error=" + t));
            }
            String resultJson = JsonParser.toJson((Object)resultData);
            if (callback != null) {
                callback.invokeCallback("'" + resultJson + "'");
            }
            return resultJson;
        }
    };
    private IApiModule.IApiMethod setTimer;
    private IApiModule.IApiMethod mh5RegisterPushMethod = new IApiModule.IApiMethod(){

        public String methodName() {
            return "registerPush";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity2) {
            if (DataModule.this.mH5RegisterPushCallback != null) {
                MLog.info((Object)DataModule.TAG, (String)"mh5RegisterPushMethod invoke, param: %s", (Object[])new Object[]{param});
                DataModule.this.mH5RegisterPushCallback.onRegisterH5Push(param);
            } else {
                MLog.error((String)DataModule.TAG, (String)"mh5RegisterPushMethod invoke, h5 register callback is null");
            }
            if (callback != null) {
                callback.invokeCallback("registerPush");
            }
            return "registerPush";
        }
    };

    public DataModule() {
        this.onEventBind();
        MLog.debug((String)TAG, (String)"init dataModule");
    }

    public DataModule(IDataCallback callback) {
        this.mCallback = callback;
        this.onEventBind();
        MLog.debug((String)TAG, (String)"init dataModule with callback");
    }

    public String moduleName() {
        return MODULE_NAME;
    }

    private Context getContext() {
        return null;
    }

    public String invoke(String method, String param, IApiModule.IJSCallback callback) {
        String returnValue = "";
        MLog.debug((String)TAG, (String)("dataModule invoke method = " + method + " param = " + param));
        if ("webDataToServer".equals(method)) {
            returnValue = this.webDataToServer.invoke(param, callback, this.getContext());
        } else if ("updateWebCache".equals(method)) {
            returnValue = this.updateWebCache.invoke(param, callback, this.getContext());
        } else if ("getWebCache".equals(method)) {
            returnValue = this.getWebCache.invoke(param, callback, this.getContext());
        } else if ("webBusRegister".equals(method)) {
            returnValue = this.webBusRegister.invoke(param, callback, this.getContext());
        } else if ("registerPush".equals(method)) {
            returnValue = this.mh5RegisterPushMethod.invoke(param, callback, this.getContext());
        } else if ("setTimer".equals(method)) {
            if (this.setTimer == null) {
                this.setTimer = new SetTimer();
            }
            returnValue = this.setTimer.invoke(param, callback, this.getContext());
        } else if (JsMethodManager.isHasDataMethod(method) && this.mCallback != null) {
            returnValue = this.mCallback.invokeFromWebPage(MODULE_NAME, method, param, callback, this.getContext());
        } else {
            IApiModule.IApiMethod apiMethod;
            IApiModule.IApiMethod apiMethod1;
            returnValue = this.finder.invoke(method, param, callback, null);
            if (!JsBinders.INSTANCE.getNOT_FOUND_METHOD().equals(returnValue)) {
                return returnValue;
            }
            Map methods1 = ((IJsMethodPluginCore)ICoreManagerBase.getCore(IJsMethodPluginCore.class)).getDataMethods();
            if (methods1 != null && (apiMethod1 = (IApiModule.IApiMethod)methods1.get(method)) != null) {
                returnValue = apiMethod1.invoke(param, callback, this.getContext());
                return returnValue;
            }
            ImmutableMap methods = ((HostState)HostStore.INSTANCE.getState()).getDataModuleApiMethods();
            if (methods != null && (apiMethod = (IApiModule.IApiMethod)methods.get(method)) != null) {
                returnValue = apiMethod.invoke(param, callback, this.getContext());
                return returnValue;
            }
        }
        return returnValue;
    }

    public void setH5RegisterPushCallback(H5RegisterPushCallback h5RegisterPushCallback) {
        this.mH5RegisterPushCallback = h5RegisterPushCallback;
    }

    public void release() {
        this.onEventUnBind();
        if (ICoreManagerBase.getCore(IWebBusCore.class) != null) {
            ((IWebBusCore)ICoreManagerBase.getCore(IWebBusCore.class)).unRegisterWebComponent(this.mWebId);
        }
        if (this.setTimer instanceof JsLifecycleProvider) {
            ((JsLifecycleProvider)this.setTimer).release();
        }
        if (this.finder != null) {
            this.finder.release();
        }
        this.mH5RegisterPushCallback = null;
        this.mCallback = null;
    }

    public static interface IDataCallback {
        public void onActWebData(String var1);

        public void updateWebCache(String var1, String var2);

        public String getWebCache(String var1);

        public void registerCallBackEvent(String var1, IApiModule.IJSCallback var2);

        public void invokeJs(String var1, JSONObject var2);

        public String invokeFromWebPage(String var1, String var2, String var3, IApiModule.IJSCallback var4, Context var5);
    }

    public static interface H5RegisterPushCallback {
        public void onRegisterH5Push(String var1);
    }
}

