/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.v2.v2ApiModule;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.AndPermission;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.event.webview.IWebViewClient_requestFinishActivity_EventArgs;
import com.yy.mobile.js.JsBinders;
import com.yy.mobile.js.JsModuleFinder;
import com.yy.mobile.plugin.main.events.IAuthClient_onKickOff_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onCurrentMultiKick_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onRequestJoinChannelError_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onRequestJoinChannelExist_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelInfo_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelMicStateClient_channelMicStateControlMic_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelMicStateClient_channelMicStateMicTurn_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelMicStateClient_channelMicaddMicOperaFailed_EventArgs;
import com.yy.mobile.policy.dialog.IPerConstantKt;
import com.yy.mobile.policy.dialog.PermissionTips;
import com.yy.mobile.sdkwrapper.yylive.LiveProtocol;
import com.yy.mobile.sdkwrapper.yylive.event.JoinTimeoutEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.KickOffnotifyEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.MicStatusChangeEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.MicStatusChangeEventArgsWrapper;
import com.yy.mobile.sdkwrapper.yylive.event.MicStatusOperFailedEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.MicStatusTimeoutEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.MultiKickOffNotifyEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.MultiKickOffResEventArgs;
import com.yy.mobile.ui.utils.js.v2.v2ApiModule.BaseApiModule;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.basechannel.SessMultiKick;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelModule
extends BaseApiModule {
    public static final String MODULE_NAME = "channel";
    private static final String TAG = "ChannelModule";
    private IDataCallback mCallback;
    private CompositeDisposable mCompositeDisposable;
    private boolean isMute = false;
    private long mCurrentChannelTopSid = 0L;
    private JsModuleFinder finder = new JsModuleFinder("channel");
    private static RxBus rxBus = RxBus.create((int)128, (String)"JavascriptAPI");
    public IApiModule.IApiMethod joinChannel = new IApiModule.IApiMethod(){

        public String methodName() {
            return "joinChannel";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity2) {
            try {
                MLog.info((Object)ChannelModule.TAG, (String)"method=%s,param=%s", (Object[])new Object[]{"joinChannel", param});
                if (!TextUtils.isEmpty((CharSequence)param)) {
                    JSONObject obj = new JSONObject(param);
                    ChannelModule.this.doJoinChannel(StringUtils.string2long((String)obj.optString("sid"), (long)0L), StringUtils.string2long((String)obj.optString("subsid"), (long)0L));
                }
            }
            catch (Throwable e) {
                MLog.error((Object)ChannelModule.TAG, (Throwable)e);
            }
            return null;
        }
    };
    public IApiModule.IApiMethod openMic = new IApiModule.IApiMethod(){

        public String methodName() {
            return "openMic";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity2) {
            MLog.info((String)ChannelModule.TAG, (String)"invoke: openMic call doOpenMic()");
            ChannelModule.this.doOpenMic();
            callback.invokeCallback(ChannelModule.this.newJSResponseString(0, ""));
            return null;
        }
    };
    public IApiModule.IApiMethod closeMic = new IApiModule.IApiMethod(){

        public String methodName() {
            return "closeMic";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity2) {
            MLog.info((String)ChannelModule.TAG, (String)"invoke: closeMic call doCloseMic()");
            ChannelModule.this.doCloseMic();
            callback.invokeCallback(ChannelModule.this.newJSResponseString(0, ""));
            return null;
        }
    };
    public IApiModule.IApiMethod leaveChannel = new IApiModule.IApiMethod(){

        public String methodName() {
            return "leaveChannel";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity2) {
            MLog.info((String)ChannelModule.TAG, (String)"invoke: openMic call leaveChannel()");
            ChannelModule.this.doLeaveChannel();
            if (callback != null) {
                callback.invokeCallback(ChannelModule.this.newJSResponseString(0, ""));
            }
            return null;
        }
    };

    public ChannelModule() {
    }

    public ChannelModule(IDataCallback callback) {
        this.mCallback = callback;
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        this.unSubscribeChannelEvents();
        this.autoLeaveChannel();
    }

    @Override
    public String moduleName() {
        return MODULE_NAME;
    }

    @Override
    public Context getContext() {
        return null;
    }

    @Override
    public String invoke(String method, String param, IApiModule.IJSCallback callback) {
        String returnValue = "";
        MLog.debug((String)TAG, (String)("ChannelModule invoke method = " + method + " param = " + param));
        if ("joinChannel".equals(method)) {
            returnValue = this.joinChannel.invoke(param, callback, this.getContext());
        } else if ("openMic".equals(method)) {
            returnValue = this.openMic.invoke(param, callback, this.getContext());
        } else if ("closeMic".equals(method)) {
            returnValue = this.closeMic.invoke(param, callback, this.getContext());
        } else if ("leaveChannel".equals(method)) {
            returnValue = this.leaveChannel.invoke(param, callback, this.getContext());
        } else {
            returnValue = this.finder.invoke(method, param, callback, null);
            if (!JsBinders.INSTANCE.getNOT_FOUND_METHOD().equals(returnValue)) {
                return returnValue;
            }
        }
        return returnValue;
    }

    @Override
    public void release() {
        this.onEventUnBind();
        if (this.finder != null) {
            this.finder.release();
        }
        this.mCallback = null;
    }

    private JSONObject newJSErrorObject(int code, String message) {
        JSONObject error = new JSONObject();
        try {
            error.put("code", code);
            error.put("message", (Object)message);
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return error;
    }

    private void autoLeaveChannel() {
        if (this.mCurrentChannelTopSid > 0L) {
            LiveProtocol.Factory.get().release();
            IChannelLinkCore channelLinkCore = ICoreManagerBase.getChannelLinkCore();
            if (channelLinkCore != null && channelLinkCore.getCurrentChannelInfo() != null && channelLinkCore.getCurrentChannelInfo().topSid == this.mCurrentChannelTopSid) {
                this.doLeaveChannel();
            }
        }
    }

    private String newJSResponseString(int code, String message) {
        return String.format("'%s'", this.newJSErrorObject(code, message).toString());
    }

    private void subscribeChannelEvents(final long topSid, final long subSid) {
        LiveProtocol.Factory.get().initEventHandler(rxBus);
        this.mCurrentChannelTopSid = topSid;
        if (this.mCompositeDisposable != null) {
            this.mCompositeDisposable.clear();
        }
        this.mCompositeDisposable = new CompositeDisposable();
        this.mCompositeDisposable.addAll(new Disposable[]{RxBus.getDefault().register(IWebViewClient_requestFinishActivity_EventArgs.class).subscribe((Consumer)new Consumer<IWebViewClient_requestFinishActivity_EventArgs>(){

            public void accept(IWebViewClient_requestFinishActivity_EventArgs args) throws Exception {
                ChannelModule.this.autoLeaveChannel();
            }
        }, RxUtils.errorConsumer((String)TAG)), RxBus.getDefault().register(IChannelLinkClient_onJoinChannelSuccess_EventArgs.class).filter((Predicate)new Predicate<IChannelLinkClient_onJoinChannelSuccess_EventArgs>(){

            public boolean test(IChannelLinkClient_onJoinChannelSuccess_EventArgs args) throws Exception {
                ChannelInfo info = args.getInfo();
                return info != null && info.topSid == topSid;
            }
        }).subscribe((Consumer)new Consumer<IChannelLinkClient_onJoinChannelSuccess_EventArgs>(){

            public void accept(IChannelLinkClient_onJoinChannelSuccess_EventArgs args) throws Exception {
                ChannelInfo info = args.getInfo();
                if (ChannelModule.this.mCallback != null && info != null) {
                    JSONObject params = new JSONObject();
                    params.put("sid", (Object)String.valueOf(info.topSid));
                    params.put("subsid", (Object)String.valueOf(info.subSid));
                    ChannelModule.this.mCallback.invokeJSCallback("subChannelChanged", params);
                }
            }
        }, RxUtils.errorConsumer((String)TAG)), RxBus.getDefault().register(IChannelLinkClient_leaveCurrentChannel_EventArgs.class).subscribe((Consumer)new Consumer<IChannelLinkClient_leaveCurrentChannel_EventArgs>(){

            public void accept(IChannelLinkClient_leaveCurrentChannel_EventArgs args) throws Exception {
                ChannelInfo info = args.getInfo();
                if (info != null && info.topSid == topSid) {
                    MLog.info((String)ChannelModule.TAG, (String)"accept: IChannelLinkClient_leaveCurrentChannel_EventArgs");
                    ChannelModule.this.onMicStateChanged();
                }
            }
        }, RxUtils.errorConsumer((String)TAG)), RxBus.getDefault().register(IChannelLinkClient_onRequestJoinChannelExist_EventArgs.class).filter((Predicate)new Predicate<IChannelLinkClient_onRequestJoinChannelExist_EventArgs>(){

            public boolean test(IChannelLinkClient_onRequestJoinChannelExist_EventArgs args) throws Exception {
                ChannelInfo info = args.getChannelInfo();
                return info != null && info.topSid == topSid;
            }
        }).subscribe((Consumer)new Consumer<IChannelLinkClient_onRequestJoinChannelExist_EventArgs>(){

            public void accept(IChannelLinkClient_onRequestJoinChannelExist_EventArgs args) throws Exception {
                if (args.getError() != null && ChannelModule.this.mCallback != null) {
                    CoreError error = args.getError();
                    ChannelModule.this.mCallback.invokeJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(1, error.message));
                }
            }
        }, RxUtils.errorConsumer((String)TAG)), RxBus.getDefault().register(IChannelLinkClient_onRequestJoinChannelError_EventArgs.class).subscribe((Consumer)new Consumer<IChannelLinkClient_onRequestJoinChannelError_EventArgs>(){

            public void accept(IChannelLinkClient_onRequestJoinChannelError_EventArgs args) throws Exception {
                CoreError error = args.getError();
                if (error != null && error.code != 19) {
                    ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(1, error.message));
                }
            }
        }, RxUtils.errorConsumer((String)TAG)), RxBus.getDefault().register(IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs.class).subscribe((Consumer)new Consumer<IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs>(){

            public void accept(IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs args) throws Exception {
                List uids;
                if (ChannelModule.this.mCallback != null && (uids = args.getMicList()) != null) {
                    JSONArray list = new JSONArray();
                    for (Long uid : uids) {
                        JSONObject item = new JSONObject();
                        item.put("uid", (Object)String.valueOf(uid));
                        list.put((Object)item);
                    }
                    JSONObject params = new JSONObject();
                    params.put("uidlist", (Object)list);
                    ChannelModule.this.mCallback.invokeJSCallback("maiXuChanged", params);
                }
            }
        }, RxUtils.errorConsumer((String)TAG)), RxBus.getDefault().register(IChannelLinkClient_updateCurrentChannelInfo_EventArgs.class).subscribe((Consumer)new Consumer<IChannelLinkClient_updateCurrentChannelInfo_EventArgs>(){

            public void accept(IChannelLinkClient_updateCurrentChannelInfo_EventArgs args) throws Exception {
                ChannelInfo info = args.getChannelInfo();
                if (info != null) {
                    if (info.topSid == topSid && info.subSid != subSid) {
                        JSONObject params = new JSONObject();
                        params.put("sid", (Object)String.valueOf(info.topSid));
                        params.put("subsid", (Object)String.valueOf(info.subSid));
                        ChannelModule.this.doJSCallback("subChannelChanged", params);
                    } else if (info.topSid != topSid) {
                        ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(4, "\u8fdb\u5165\u4e86\u5176\u4ed6\u9891\u9053"));
                    }
                }
            }
        }, RxUtils.errorConsumer((String)TAG)), RxBus.getDefault().register(IChannelMicStateClient_channelMicStateControlMic_EventArgs.class).subscribe((Consumer)new Consumer<IChannelMicStateClient_channelMicStateControlMic_EventArgs>(){

            public void accept(IChannelMicStateClient_channelMicStateControlMic_EventArgs args) throws Exception {
                ChannelInfo info = args.getChannelInfo();
                MLog.info((String)ChannelModule.TAG, (String)"subscribeChannelEvents accept:IChannelMicStateClient_channelMicStateControlMic_EventArgs");
                if (info != null && info.topSid == topSid) {
                    ChannelModule.this.isMute = args.getIsControlMicMic();
                    MLog.info((Object)ChannelModule.TAG, (String)"subscribeChannelEvents accept:IChannelMicStateClient_channelMicStateControlMic_EventArgsisMute:%b, call onMicStateChanged", (Object[])new Object[]{ChannelModule.this.isMute});
                    ChannelModule.this.onMicStateChanged(args.getTime());
                }
            }
        }, RxUtils.errorConsumer((String)TAG)), RxBus.getDefault().register(IChannelMicStateClient_channelMicaddMicOperaFailed_EventArgs.class).filter((Predicate)new Predicate<IChannelMicStateClient_channelMicaddMicOperaFailed_EventArgs>(){

            public boolean test(IChannelMicStateClient_channelMicaddMicOperaFailed_EventArgs args) throws Exception {
                return args.getChannelInfo() != null && args.getChannelInfo().topSid == topSid;
            }
        }).subscribe((Consumer)new Consumer<IChannelMicStateClient_channelMicaddMicOperaFailed_EventArgs>(){

            public void accept(IChannelMicStateClient_channelMicaddMicOperaFailed_EventArgs args) throws Exception {
                if (ChannelModule.this.mCallback != null) {
                    ChannelModule.this.mCallback.invokeJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(2, "\u52a0\u5165\u9ea6\u5e8f\u5931\u8d25"));
                }
            }
        }, RxUtils.errorConsumer((String)TAG)), RxBus.getDefault().register(IChannelMicStateClient_channelMicStateMicTurn_EventArgs.class).subscribe((Consumer)new Consumer<IChannelMicStateClient_channelMicStateMicTurn_EventArgs>(){

            public void accept(IChannelMicStateClient_channelMicStateMicTurn_EventArgs args) throws Exception {
                ChannelInfo info = args.getChannelInfo();
                MLog.info((String)ChannelModule.TAG, (String)"subscribeChannelEvents accept:IChannelMicStateClient_channelMicStateMicTurn_EventArgs");
                if (info != null && info.topSid == topSid) {
                    MLog.info((String)ChannelModule.TAG, (String)"subscribeChannelEvents accept:IChannelMicStateClient_channelMicStateMicTurn_EventArgscall onMicStateChanged");
                    ChannelModule.this.onMicStateChanged(args.getTime());
                }
            }
        }, RxUtils.errorConsumer((String)TAG)), RxBus.getDefault().register(IAuthClient_onKickOff_EventArgs.class).subscribe((Consumer)new Consumer<IAuthClient_onKickOff_EventArgs>(){

            public void accept(IAuthClient_onKickOff_EventArgs args) throws Exception {
                ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(6, "\u5728\u53e6\u4e00\u53f0\u7ec8\u7aef\u767b\u5f55"));
            }
        }, RxUtils.errorConsumer((String)TAG)), RxBus.getDefault().register(IChannelLinkClient_onCurrentMultiKick_EventArgs.class).subscribe((Consumer)new Consumer<IChannelLinkClient_onCurrentMultiKick_EventArgs>(){

            public void accept(IChannelLinkClient_onCurrentMultiKick_EventArgs args) throws Exception {
                if (ChannelModule.this.mCallback != null) {
                    final SessMultiKick kick = args.getKick();
                    ChannelModule.this.mCallback.showDialog("\u4f60\u5728\u5176\u4ed6\u8bbe\u5907\u4e0a\u5df2\u767b\u5f55\u9891\u9053\uff0c\u662f\u5426\u786e\u8ba4\u624b\u673a\u7aef\u8fdb\u5165\u9891\u9053\uff0c\u5e76\u5c06\u5176\u4ed6\u8bbe\u5907\u8e22\u51fa\u9891\u9053\uff1f", new IAlertDialogCallBack(){

                        @Override
                        public void onPositiveButtonClicked() {
                            MLog.info((String)ChannelModule.TAG, (String)"onCurrentMultiKick onOk et.sid = ");
                            ICoreManagerBase.getChannelLinkCore().joinChannelByKickMulti(kick.getTopSid(), 0L, kick, "3", null);
                        }

                        @Override
                        public void onMiddleButtonClicked() {
                        }

                        @Override
                        public void onNegativeButtonClicked() {
                            MLog.debug((String)ChannelModule.TAG, (String)"onNegativeButtonClicked");
                            ChannelModule.this.doLeaveChannel();
                        }
                    });
                }
            }
        }, RxUtils.errorConsumer((String)TAG)), rxBus.register(MicStatusOperFailedEventArgs.class).subscribe((Consumer)new Consumer<MicStatusOperFailedEventArgs>(){

            public void accept(MicStatusOperFailedEventArgs args) throws Exception {
                ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(3, ""));
            }
        }, RxUtils.errorConsumer((String)TAG)), rxBus.register(JoinTimeoutEventArgs.class).subscribe((Consumer)new Consumer<JoinTimeoutEventArgs>(){

            public void accept(JoinTimeoutEventArgs args) throws Exception {
                ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(1, ""));
            }
        }, RxUtils.errorConsumer((String)TAG)), rxBus.register(MultiKickOffNotifyEventArgs.class).subscribe((Consumer)new Consumer<MultiKickOffNotifyEventArgs>(){

            public void accept(MultiKickOffNotifyEventArgs args) throws Exception {
                if (args.getTopSid() == topSid) {
                    ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(5, "\u88ab\u5176\u4ed6\u9891\u9053\u6324\u51fa"));
                }
            }
        }, RxUtils.errorConsumer((String)TAG)), rxBus.register(MultiKickOffResEventArgs.class).subscribe((Consumer)new Consumer<MultiKickOffResEventArgs>(){

            public void accept(MultiKickOffResEventArgs args) throws Exception {
                ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(7, "\u5df2\u7ecf\u8fdb\u5165\u4e86\u5176\u4ed6\u9891\u9053"));
            }
        }, RxUtils.errorConsumer((String)TAG)), rxBus.register(KickOffnotifyEventArgs.class).subscribe((Consumer)new Consumer<KickOffnotifyEventArgs>(){

            public void accept(KickOffnotifyEventArgs args) throws Exception {
                ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(5, "\u5df2\u7ecf\u88ab\u8e22\u51fa\u9891\u9053"));
            }
        }, RxUtils.errorConsumer((String)TAG)), rxBus.register(MicStatusChangeEventArgsWrapper.class).subscribe((Consumer)new Consumer<MicStatusChangeEventArgsWrapper>(){

            public void accept(MicStatusChangeEventArgsWrapper args) throws Exception {
                MicStatusTimeoutEventArgs data;
                MicStatusChangeEventArgs event = args.getArgs();
                MLog.info((String)ChannelModule.TAG, (String)"subscribeChannelEvents accept: MicStatusChangeEventArgsWrapper");
                if (event.getmMicEvtType() == 9 && (data = (MicStatusTimeoutEventArgs)event).getUid() == LoginUtil.getUid()) {
                    MLog.info((String)ChannelModule.TAG, (String)"subscribeChannelEvents accept: MicStatusChangeEventArgsWrapper call onMicStateChanged");
                    ChannelModule.this.onMicStateChanged(0L);
                }
            }
        }, RxUtils.errorConsumer((String)TAG))});
    }

    private void unSubscribeChannelEvents() {
        if (this.mCompositeDisposable != null) {
            this.mCompositeDisposable.clear();
            this.mCompositeDisposable = null;
        }
    }

    private void doLeaveChannel() {
        MLog.info((String)TAG, (String)"doLeaveChannel");
        IChannelLinkCore channelLinkCore = ICoreManagerBase.getChannelLinkCore();
        if (channelLinkCore != null) {
            channelLinkCore.leaveChannel();
        }
    }

    private void doJoinChannel(long topSid, long subSid) {
        this.subscribeChannelEvents(topSid, subSid);
        ChannelInfo info = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo();
        if (info == null || info.topSid != topSid || info.subSid != subSid) {
            ICoreManagerBase.getChannelLinkCore().joinChannel(topSid, subSid, "", null);
        }
    }

    private void doOpenMic() {
        if (AndPermission.hasPermissions((Context)BasicConfig.getInstance().getAppContext(), (String[])new String[]{"android.permission.RECORD_AUDIO"})) {
            this.doOpenMicInternal();
            return;
        }
        AndPermission.with((Context)BasicConfig.getInstance().getAppContext()).runtime().permission(new String[]{"android.permission.RECORD_AUDIO"}).onGranted((Action)new Action<List<String>>(){

            public void onAction(List<String> data) {
                ChannelModule.this.doOpenMicInternal();
            }
        }).onDenied((Action)new Action<List<String>>(){

            public void onAction(List<String> data) {
                MLog.info((String)ChannelModule.TAG, (String)"doOpenMic onDenied mic permission");
                ChannelModule.this.doOpenMicInternal();
                Activity activity2 = YYActivityManager.INSTANCE.getCurrentActivity();
                if (activity2 != null) {
                    IPerConstantKt.showPermissionTipsDialog((Activity)activity2, (String)PermissionTips.INSTANCE.getMICROPHONE(), (String[])data.toArray(new String[0]), null, null);
                }
            }
        }).start();
    }

    private void doOpenMicInternal() {
        MLog.info((String)TAG, (String)"open mic");
        if (((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).checkRecordAuth()) {
            ICoreManagerBase.getChannelLinkCore().openMicToGroup();
        } else {
            this.doJSCallback("errorInfo", this.newJSErrorObject(3, "\u65e0\u6cd5\u6253\u5f00\u9ea6\u514b\u98ce"));
        }
    }

    private void doCloseMic() {
        MLog.info((String)TAG, (String)"close mic");
        ICoreManagerBase.getChannelLinkCore().closeMicToGroup();
    }

    private void doJSCallback(String fn, JSONObject params) {
        if (this.mCallback != null) {
            this.mCallback.invokeJSCallback(fn, params);
        }
    }

    private void onMicStateChanged() {
        MLog.info((String)TAG, (String)"onMicStateChanged");
        this.onMicStateChanged(ICoreManagerBase.getChannelLinkCore().getTopMicIntervall());
    }

    private void onMicStateChanged(long time) {
        long uid = LoginUtil.getUid();
        long topMicId = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
        boolean isMicQueueEmpty = topMicId == 0L;
        int isMicFree = this.isMute ? 0 : 1;
        MLog.info((Object)TAG, (String)"onMicStateChanged: uid:%d, topMicId:%d, isMute:%b, isMicFree:%d", (Object[])new Object[]{uid, topMicId, this.isMute, isMicFree});
        JSONObject params = new JSONObject();
        try {
            params.put("maixuState", isMicFree);
            params.put("maixuTime", isMicQueueEmpty ? 0L : time);
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        this.doJSCallback("micStateChanged", params);
        MLog.info((Object)TAG, (String)"onMicStateChanged: isOpenMic:%b", (Object[])new Object[]{ICoreManagerBase.getChannelLinkCore().isOpenMic()});
        if (isMicFree == 1 && topMicId == uid && !ICoreManagerBase.getChannelLinkCore().isOpenMic()) {
            this.doOpenMic();
        } else {
            this.doCloseMic();
        }
    }

    public static interface IAlertDialogCallBack {
        public void onPositiveButtonClicked();

        public void onMiddleButtonClicked();

        public void onNegativeButtonClicked();
    }

    public static interface IDataCallback {
        public void invokeJSCallback(String var1, JSONObject var2);

        public void showDialog(String var1, IAlertDialogCallBack var2);
    }

    public static interface JSCallbacks {
        public static final String SUB_CHANNEL_CHANGED = "subChannelChanged";
        public static final String MAIXU_CHANGED = "maiXuChanged";
        public static final String MIC_STATE_CHANGED = "micStateChanged";
        public static final String ERR_INFO = "errorInfo";
        public static final int ERROR_CODE_JOIN_CHANNEL_FAILED = 1;
        public static final int ERROR_CODE_JOIN_MAIXU_FAILED = 2;
        public static final int ERROR_CODE_OPEN_MIC_FAILED = 3;
        public static final int ERROR_CODE_JOIN_OTHER_CHANNEL = 4;
        public static final int ERROR_CODE_KICK_OFF = 5;
        public static final int ERROR_CODE_LOGIN_SESSION_LOSS = 6;
        public static final int ERROR_CODE_JOIN_CHANNEL_IN_OTHER_DEVICE = 7;
    }
}

