/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.v2.v2ApiModule;

import android.content.Context;
import android.text.TextUtils;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseApiModule
extends EmptyEventCompat
implements IApiModule {
    private List<IApiModule.IApiMethod> mHandlers;

    public BaseApiModule() {
        this.onEventBind();
    }

    public abstract String moduleName();

    public abstract Context getContext();

    public String invoke(String method, String param, IApiModule.IJSCallback callback) {
        String returnValue = "";
        IApiModule.IApiMethod handler = this.findHandlerByMethodName(method);
        if (handler != null) {
            returnValue = handler.invoke(param, callback, this.getContext());
        }
        return returnValue;
    }

    public void release() {
        this.onEventUnBind();
    }

    protected IApiModule.IApiMethod findHandlerByMethodName(String method) {
        for (IApiModule.IApiMethod handler : this.getAllHandlers()) {
            if (!TextUtils.equals((CharSequence)handler.methodName(), (CharSequence)method)) continue;
            return handler;
        }
        return null;
    }

    protected List<IApiModule.IApiMethod> getAllHandlers() {
        if (this.mHandlers == null) {
            this.mHandlers = new ArrayList<IApiModule.IApiMethod>();
            this.mHandlers.addAll(this.getAllHandlersByFields());
        }
        return this.mHandlers;
    }

    protected List<IApiModule.IApiMethod> getAllHandlersByFields() {
        Field[] fields;
        ArrayList<IApiModule.IApiMethod> handlers = new ArrayList<IApiModule.IApiMethod>();
        for (Field f : fields = ((Object)((Object)this)).getClass().getDeclaredFields()) {
            if (!IApiModule.IApiMethod.class.isAssignableFrom(f.getType())) continue;
            try {
                handlers.add((IApiModule.IApiMethod)f.get((Object)this));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return handlers;
    }
}

