/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.bridge;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.MimeTypeMap;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.yy.mobile.baseapi.AppidPlatform;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.ui.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.js.bridge.IBridgeClient;
import com.yy.mobile.ui.utils.js.bridge.IJavascriptCallback;
import com.yy.mobile.ui.utils.js.bridge.INativeHandler;
import com.yy.mobile.ui.utils.js.bridge.JSBridge;
import com.yy.mobile.ui.utils.js.bridge.UploadMessage;
import com.yy.mobile.util.AssetsUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class WVJSBridgeClient
extends WebViewClient
implements IBridgeClient {
    private static final String TAG = "WVJSBridgeClient";
    public static final String kMessageSpartor = "__WVJB_MESSAGE_SEPERATOR__";
    public static final String kCustomProtocolScheme = "wvjbscheme";
    public static final String kQueueHasMessage = "__WVJB_QUEUE_MESSAGE__";
    public static final String KEY_RESPONSE_DATA = "responseData";
    public static final String KEY_RESPONSE_ID = "responseId";
    public static final String KEY_HANDLER_NAME = "handlerName";
    public static final String KEY_CALLBACK_ID = "callbackId";
    public static final String KEY_DATA = "data";
    private static final String WVJSBridgeObject = "wvJSBridgeObject";
    private WeakReference<WebView> mWebViewHolder;
    private String mCurrentURLString = "";
    private long uniqueId = 1L;
    private HashMap<String, IJavascriptCallback> mResponseCallbacks = new HashMap();
    private HashMap<String, INativeHandler> mMessageHandlers = new HashMap();
    private ArrayList<JSONObject> mStartupMessageQueue = null;
    private boolean mInsertJS = false;
    private boolean ignoreSslError = false;
    private static String JSBridgeScript = AssetsUtils.getStringFromFile((AssetManager)BasicConfig.getInstance().getAppContext().getAssets(), (String)"WebViewJavascriptBridge.js", (String)"UTF-8");
    public static final String BRIDGE_EVENT_HANDLER = "brdigeEventHandler";
    public static final String BRIDGE_API_UNSUPPORTED_EVENT = "ApiUnSupportedEvent";

    public static String defaultUserAgentString() {
        return "Mozilla/5.0 (Linux; Android 4.4; Nexus 4 Build/KRT16H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36";
    }

    public static String sharedVersionString() {
        VersionUtil.Ver ver = VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext());
        String edition = AppidPlatform.getAppId();
        return " YY(ClientVersion:" + ver.getVersionNameWithoutSnapshot() + ",ClientVerCode:" + ver.toString() + "\uff0cClientEdition:" + edition + ")";
    }

    public WVJSBridgeClient(WebView webView, String url) {
        if (webView != null) {
            this.mWebViewHolder = new WeakReference<WebView>(webView);
            JSBridge bridge = new JSBridge(this);
            webView.addJavascriptInterface((Object)bridge, WVJSBridgeObject);
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)TAG, (String)("WVJSBridgeClient addJavascriptInterface wvJSBridgeObject, webView=" + webView + ",----bridge=" + bridge + ",----url=" + url));
            }
        } else {
            MLog.error((String)TAG, (String)"WVJSBridgeClient must create with a webview not nullable.");
        }
    }

    public void send(Object message) {
        this.send(message, null);
    }

    public void send(Object message, IJavascriptCallback callback) {
        this.sendData(message, callback, null);
    }

    @Override
    public void registerHandler(String handlerName, INativeHandler handler) {
        this.mMessageHandlers.put(handlerName, handler);
    }

    @Override
    public void unregisterhndler(String handlerName) {
        this.mMessageHandlers.remove(handlerName);
    }

    @Override
    public void destory() {
        WebView view = (WebView)this.mWebViewHolder.get();
        if (view != null) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)TAG, (String)("WVJSBridgeClient removeJavascriptInterface. view=" + view));
            }
            WVJSBridgeClient.removeJavascriptInterface(view, WVJSBridgeObject);
            this.mWebViewHolder.clear();
        }
        this.mMessageHandlers.clear();
        this.mResponseCallbacks.clear();
        if (this.mStartupMessageQueue != null) {
            this.mStartupMessageQueue.clear();
        }
    }

    @Override
    public void jsHandlerNotFound(String callbackId, String handlerName) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("xuwakao, jsHandlerNotFound callbackId =  " + callbackId + ", handlerName = " + handlerName));
        }
        if (this.mResponseCallbacks.containsKey(callbackId)) {
            IJavascriptCallback callback = this.mResponseCallbacks.get(callbackId);
            callback.onJsHandlerNotFound(callbackId, handlerName);
        }
    }

    @Override
    public void callHandler(String handlerName) {
        this.callHandler(handlerName, null);
    }

    @Override
    public void callHandler(String handlerName, Object data) {
        this.callHandler(handlerName, data, null);
    }

    @Override
    public void callHandler(String handlerName, Object data, IJavascriptCallback callback) {
        this.sendData(data, callback, handlerName);
    }

    @Override
    public void reset() {
        if (this.mStartupMessageQueue != null) {
            this.mStartupMessageQueue.clear();
        }
        this.mStartupMessageQueue = new ArrayList();
        this.mResponseCallbacks.clear();
        this.uniqueId = 1L;
    }

    @Override
    public void returnValueFromJavaScript(String msgs) {
        String[] messageJsons;
        if (TextUtils.isEmpty((CharSequence)msgs)) {
            return;
        }
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("xuwakao, returnValueFromJavaScript msgs = " + msgs));
        }
        for (String msgJson : messageJsons = msgs.split(kMessageSpartor)) {
            try {
                INativeHandler handler;
                IJavascriptCallback callback;
                JSONObject msg = new JSONObject(msgJson);
                String responseId = msg.optString(KEY_RESPONSE_ID);
                if (!FP.empty((CharSequence)responseId)) {
                    callback = this.mResponseCallbacks.get(responseId);
                    if (callback == null) {
                        return;
                    }
                    callback.callback(msg.get(KEY_RESPONSE_DATA));
                    this.mResponseCallbacks.remove(responseId);
                    continue;
                }
                callback = null;
                final String callbackID = msg.optString(KEY_CALLBACK_ID);
                callback = callbackID != null && !callbackID.equals("") ? new IJavascriptCallback(){

                    @Override
                    public void callback(Object data) {
                        try {
                            JSONObject responseData = new JSONObject();
                            responseData.put(WVJSBridgeClient.KEY_RESPONSE_ID, (Object)callbackID);
                            responseData.put(WVJSBridgeClient.KEY_RESPONSE_DATA, data);
                            WVJSBridgeClient.this.queueMessage(responseData);
                        }
                        catch (Throwable throwable) {
                            MLog.error((Object)WVJSBridgeClient.TAG, (Throwable)throwable);
                        }
                    }

                    @Override
                    public void onJsHandlerNotFound(String callbackId, String handlerName) {
                    }
                } : new IJavascriptCallback(){

                    @Override
                    public void callback(Object data) {
                    }

                    @Override
                    public void onJsHandlerNotFound(String callbackId, String handlerName) {
                    }
                };
                String handlerName = msg.optString(KEY_HANDLER_NAME);
                if (handlerName != null && !handlerName.equals("")) {
                    handler = this.mMessageHandlers.get(handlerName);
                    if (handler == null) {
                        MLog.error((String)"WVJSBridgeClient returnValueFromJavaScript", (String)("no such handler " + handlerName));
                        this.tryDispatchUnSupportAPIEvent(handlerName);
                        return;
                    }
                } else {
                    return;
                }
                try {
                    String dataString = msg.optString(KEY_DATA);
                    if (dataString.startsWith("{")) {
                        handler.call(new JSONObject(dataString), callback);
                        continue;
                    }
                    if (dataString.startsWith("[")) {
                        handler.call(new JSONArray(dataString), callback);
                        continue;
                    }
                    dataString = dataString.equals("") ? null : dataString;
                    handler.call(dataString, callback);
                }
                catch (Throwable throwable) {
                    MLog.error((Object)TAG, (Throwable)throwable);
                }
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, (Throwable)throwable);
            }
        }
    }

    private void queueMessage(JSONObject msg) {
        if (this.mStartupMessageQueue != null) {
            this.mStartupMessageQueue.add(msg);
        } else {
            this.dispathMessage(msg);
        }
    }

    private void dispathMessage(JSONObject msg) {
        WebView view = (WebView)this.mWebViewHolder.get();
        if (view != null && msg != null) {
            String msgJSONString = msg.toString();
            msgJSONString = msgJSONString.replace("\\", "\\\\");
            msgJSONString = msgJSONString.replace("\"", "\\\"");
            msgJSONString = msgJSONString.replace("'", "\\'");
            msgJSONString = msgJSONString.replace("\n", "\\n");
            msgJSONString = msgJSONString.replace("\r", "\\r");
            if ((msgJSONString = msgJSONString.replace("\f", "\\f")) != null) {
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((String)TAG, (String)("xuwakao, dispathMessage msg = " + msgJSONString));
                }
                this.safetyLoadJs(view, "javascript:dispatchMsgToJs('" + msgJSONString + "')");
            }
        }
    }

    private void dispatchJSBridgeReadyEvent(WebView webView) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)"xuwakao dispatchJSBridgeReadyEvent");
        }
        this.safetyLoadJs(webView, "javascript:" + JSBridgeScript);
    }

    private void startFlushMessageQueue(WebView webView) {
        this.safetyLoadJs(webView, "javascript:WebViewJavascriptBridge._fetchQueue();");
    }

    private void sendData(Object data, IJavascriptCallback callback, String handlerName) {
        try {
            JSONObject dataObject = new JSONObject();
            dataObject.put(KEY_DATA, data);
            if (callback != null) {
                String callbackId = "java_CB_" + this.uniqueId++;
                dataObject.put(KEY_CALLBACK_ID, (Object)callbackId);
                this.mResponseCallbacks.put(callbackId, callback);
            }
            if (handlerName != null) {
                dataObject.put(KEY_HANDLER_NAME, (Object)handlerName);
            }
            this.queueMessage(dataObject);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("kuiannan load web url = " + url));
        }
        Uri uri = Uri.parse((String)url);
        if (url.startsWith("weixin://wap/pay?appid")) {
            block16: {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                try {
                    view.getContext().startActivity(intent);
                }
                catch (Exception e) {
                    if (MLog.isLogLevelAboveVerbose()) break block16;
                    MLog.verbose((String)TAG, (String)("start weixin error " + e.toString()));
                }
            }
            return true;
        }
        if (url.startsWith("intent://platformapi/startapp?")) {
            try {
                Intent intent = null;
                try {
                    intent = Intent.parseUri((String)url, (int)1);
                    intent.addCategory("android.intent.category.BROWSABLE");
                    intent.setComponent(null);
                    if (Build.VERSION.SDK_INT >= 15) {
                        intent.setSelector(null);
                    }
                }
                catch (URISyntaxException e) {
                    MLog.error((String)TAG, (String)e.getMessage());
                }
                view.getContext().startActivity(intent);
            }
            catch (Exception e) {
                MLog.error((String)TAG, (String)e.getMessage());
            }
            return true;
        }
        MimeTypeMap.getSingleton();
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if ("mp4".equalsIgnoreCase(extension)) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)TAG, (String)("mp4 url " + url));
            }
        } else if (uri.getScheme().equalsIgnoreCase(kCustomProtocolScheme)) {
            if (uri.getHost().equalsIgnoreCase(kQueueHasMessage)) {
                this.startFlushMessageQueue(view);
            }
        } else {
            this.safetyLoadUrl(view, url);
        }
        return true;
    }

    private void safetyLoadUrl(final WebView view, final String url) {
        if (view != null && url != null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        view.loadUrl(url);
                    }
                    catch (Exception e) {
                        MLog.error((Object)WVJSBridgeClient.TAG, (Throwable)e);
                    }
                }
            });
        }
    }

    private void safetyLoadJs(final WebView view, final String js) {
        if (Build.VERSION.SDK_INT <= 18) {
            this.safetyLoadUrl(view, js);
            return;
        }
        if (view != null && !FP.empty((CharSequence)js)) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                @TargetApi(value=19)
                public void run() {
                    try {
                        if (Build.VERSION.SDK_INT > 18) {
                            try {
                                view.evaluateJavascript(js, null);
                            }
                            catch (Exception e) {
                                MLog.error((Object)WVJSBridgeClient.TAG, (Throwable)e);
                                MLog.info((String)WVJSBridgeClient.TAG, (String)"switch to call loadUrl");
                                view.loadUrl(js);
                            }
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)WVJSBridgeClient.TAG, (Throwable)e);
                    }
                }
            });
        }
    }

    private void tryDispatchUnSupportAPIEvent(String apiStr) {
        try {
            JSONObject eventObj = new JSONObject();
            eventObj.put("type", (Object)BRIDGE_API_UNSUPPORTED_EVENT);
            eventObj.put("apiUri", (Object)apiStr);
            this.callHandler(BRIDGE_EVENT_HANDLER, eventObj);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void onLoadResource(WebView view, String url) {
        super.onLoadResource(view, url);
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("onLoadResource url = " + url));
        }
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        MLog.error((String)TAG, (String)("onReceivedError errorCode:" + errorCode + ",description:" + description + ",failingUrl:" + failingUrl));
        view.clearView();
        this.safetyLoadUrl(view, "file:///android_asset/load_page_fail.html");
    }

    public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
        String errorMsg = "";
        String errorUrl = "";
        if (error != null) {
            errorUrl = error.getUrl();
            errorMsg = error.toString();
        }
        if (!TextUtils.isEmpty((CharSequence)errorUrl)) {
            final String finalErrorUrl = errorUrl;
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    WVJSBridgeClient.this.printSslErrorIp(finalErrorUrl);
                }
            });
        }
        MLog.info((Object)TAG, (String)"onReceivedSslError=%s,%s", (Object[])new Object[]{errorMsg, this.ignoreSslError});
        if (this.ignoreSslError) {
            handler.proceed();
            return;
        }
        Activity activity2 = YYActivityManager.INSTANCE.getCurrentActivity();
        if (this.mWebViewHolder != null && this.mWebViewHolder.get() != null && activity2 != null) {
            DialogLinkManager dialogManager = new DialogLinkManager((Context)activity2);
            dialogManager.showDialog((IBaseDialog)new OkCancelDialog((CharSequence)"\u5f53\u524d\u7f51\u7ad9\u8bc1\u4e66\u975e\u6cd5\u6216\u5305\u542b\u9519\u8bef\uff0c\u662f\u5426\u4fe1\u4efb\u5e76\u7ee7\u7eed\u8bbf\u95ee", (CharSequence)"\u7ee7\u7eed\u8bbf\u95ee", (CharSequence)"\u53d6\u6d88", false, new OkCancelDialogListener(){

                public void onCancel() {
                    WVJSBridgeClient.this.ignoreSslError = false;
                    MLog.info((String)WVJSBridgeClient.TAG, (String)"onReceivedSslError onCancel");
                    handler.cancel();
                }

                public void onOk() {
                    MLog.info((String)WVJSBridgeClient.TAG, (String)"onReceivedSslError onOk");
                    WVJSBridgeClient.this.ignoreSslError = true;
                    handler.proceed();
                }
            }));
        }
    }

    private void printSslErrorIp(String errorUrl) {
        try {
            URL url = new URL(errorUrl);
            String host = url.getHost();
            InetAddress[] addresses = InetAddress.getAllByName(host);
            StringBuilder sb = new StringBuilder();
            for (InetAddress address : addresses) {
                sb.append(address.getHostAddress()).append(";");
            }
            MLog.info((Object)TAG, (String)"onReceivedSslError ip:%s", (Object[])new Object[]{sb.toString()});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (!FP.empty((CharSequence)url) && (url.startsWith("http://") || url.startsWith("https://"))) {
            this.mInsertJS = false;
        }
        super.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("web onPageFinished url = " + url));
        }
        if (!this.mCurrentURLString.equalsIgnoreCase(url)) {
            this.mCurrentURLString = url;
        }
        this.dispatchJSBridgeReadyEvent(view);
        if (this.mStartupMessageQueue != null && !this.mStartupMessageQueue.isEmpty()) {
            for (JSONObject msg : this.mStartupMessageQueue) {
                this.dispathMessage(msg);
            }
            this.mStartupMessageQueue.clear();
        }
        this.mStartupMessageQueue = null;
    }

    @Override
    public void setInsertJs(boolean insertJs) {
        this.mInsertJS = insertJs;
    }

    @Override
    public boolean getInserJs() {
        return this.mInsertJS;
    }

    @TargetApi(value=11)
    public static void removeJavascriptInterface(WebView view, String objName) {
        if (Build.VERSION.SDK_INT >= 11) {
            view.removeJavascriptInterface(objName);
        }
    }

    public static class BridgeWebChromeClient
    extends WebChromeClient {
        private AppearanceCallback mAppearanceCallack;
        UploadMessage uploadMessage = new UploadMessage();

        public void onConsoleMessage(String message, int lineNumber, String sourceID) {
            super.onConsoleMessage(message, lineNumber, sourceID);
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)WVJSBridgeClient.TAG, (String)("javascript console:" + consoleMessage.message() + ",lineNumber=" + consoleMessage.lineNumber() + ",messageLevel=" + consoleMessage.messageLevel()));
            }
            return super.onConsoleMessage(consoleMessage);
        }

        public void onReceivedTitle(WebView view, String title) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)WVJSBridgeClient.TAG, (String)("xuwakao, title = " + title + ", mAppearanceCallack = " + this.mAppearanceCallack));
            }
            super.onReceivedTitle(view, title);
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.onReceivedTitle(view, title);
            }
        }

        @TargetApi(value=21)
        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            this.uploadMessage.setUploadMessageAboveL(filePathCallback);
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.doOpenFileChooser(this.uploadMessage.openImageChooserActivity(fileChooserParams.getAcceptTypes()), this.uploadMessage);
            }
            return true;
        }

        public void openFileChooser(ValueCallback<Uri> valueCallback) {
            this.uploadMessage.setUploadMessage(valueCallback);
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.doOpenFileChooser(this.uploadMessage.openImageChooserActivity("image/*"), this.uploadMessage);
            }
        }

        public void openFileChooser(ValueCallback valueCallback, String acceptType) {
            this.uploadMessage.setUploadMessage((ValueCallback<Uri>)valueCallback);
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.doOpenFileChooser(this.uploadMessage.openImageChooserActivity(acceptType), this.uploadMessage);
            }
        }

        public void openFileChooser(ValueCallback<Uri> valueCallback, String acceptType, String capture) {
            this.uploadMessage.setUploadMessage(valueCallback);
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.doOpenFileChooser(this.uploadMessage.openImageChooserActivity(acceptType), this.uploadMessage);
            }
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            super.onShowCustomView(view, callback);
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)WVJSBridgeClient.TAG, (String)("xuwakao, onShowCustomView1 view = " + view));
            }
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.onShowCustomView(view, callback);
            }
        }

        @TargetApi(value=14)
        public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
            if (Build.VERSION.SDK_INT >= 14) {
                super.onShowCustomView(view, requestedOrientation, callback);
                if (this.mAppearanceCallack != null) {
                    this.mAppearanceCallack.onShowCustomView(view, callback);
                }
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((String)WVJSBridgeClient.TAG, (String)("xuwakao, onShowCustomView2 view = " + view));
                }
            }
        }

        public void onHideCustomView() {
            super.onHideCustomView();
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)WVJSBridgeClient.TAG, (String)"xuwakao, onHideCustomView");
            }
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.onHideCustomView();
            }
        }

        public void setAppearanceCallack(AppearanceCallback appearanceCallack) {
            this.mAppearanceCallack = appearanceCallack;
        }

        public static interface AppearanceCallback {
            public void onReceivedTitle(WebView var1, String var2);

            public void doOpenFileChooser(Intent var1, UploadMessage var2);

            public void onHideCustomView();

            public void onShowCustomView(View var1, WebChromeClient.CustomViewCallback var2);
        }
    }
}

