/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.bridge;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.baseapi.model.store.YYState;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.bizmodel.login.ILoginCore;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthClient_onLogout_EventArgs;
import com.yy.mobile.plugin.main.events.INotification_onPermissionChane_EventArgs;
import com.yy.mobile.plugin.main.events.ISharpTabsClient_onSharpInfos_EventArgs;
import com.yy.mobile.plugin.ycloud.PluginBus;
import com.yy.mobile.sdkwrapper.login.LoginProtocol;
import com.yy.mobile.ui.notify.NotificationsUtils;
import com.yy.mobile.ui.utils.js.bridge.ApiChannel$$EventBinder;
import com.yy.mobile.ui.utils.js.bridge.IApiChannelCallBack;
import com.yy.mobile.ui.utils.js.bridge.IBridgeClient;
import com.yy.mobile.ui.utils.js.bridge.IJavascriptCallback;
import com.yy.mobile.ui.utils.js.bridge.INativeHandler;
import com.yy.mobile.ui.utils.js.bridge.WVJSBridgeClient;
import com.yy.mobile.ui.utils.js.exception.RestAPINotSupportException;
import com.yy.mobile.ui.webview.delegate.UIDelegate;
import com.yy.mobile.util.TelephonyUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.live.gson.RightBtnInfo;
import com.yymobile.core.subscribe.ISubscribeClient;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yymobile.core.subscribe.SubscribeClients;
import com.yymobile.core.subscribe.SubscribeInfo;
import com.yymobile.core.user.UserInfo;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ApiChannel
extends EmptyEventCompat {
    private static final String TAG = "ApiChannel";
    public static final int JS_API_LEVEL = 2;
    private static final String API_REST_CHANNEL = "yyuigoto";
    private static final String API_POP_CHANNEL = "yyuipop";
    private static final String API_CHECK_LOGIN = "isLoggedInWithUserPassword";
    private static final String API_REQ_WEBTOKEN = "requestWebToken";
    private static final String API_FOLLOW_USER = "followUser";
    private static final String API_UNFOLLOW_USER = "unFollowUser";
    private static final String API_GET_API_LEVEL = "getAPILevel";
    private static final String API_GET_APP_INFO = "getAppInfo";
    private static final String API_SET_PHONE_NUMBER = "setPhoneNumber";
    private static final String API_SHOW_ALERT_MESSAGE = "showAlertMessage";
    private static final String API_SET_COMMON_STORAGE_VALUE_FOR_KEY = "setCommonStorageValueForKey";
    private static final String API_GET_COMMON_STORAGE_VALUE_FOR_KEY = "getCommonStorageValueForKey";
    private static final String API_SHOW_PROGRESS_WINDOW = "showProgressWindow";
    private static final String API_HIDE_PROGRESS_WINDOW = "hideProgressWindow";
    private static final String API_POSET_NOTIFICATION = "postNotification";
    private static final String API_DELETE_SHARED_COOKIE = "deleteSharedCookie";
    private static final String API_CLOSE_ALL_WINDOW = "closeAllWindow";
    private static final String API_GOTO_BROWSER = "gotoBrowser";
    private static final String API_SHOW_BACK_BTN = "showBackBtn";
    private static final String API_HIDE_BACK_BTN = "hideBackBtn";
    private static final String API_SET_NAV_RIGHT_ITEMS = "setNavigationRightItems";
    private static final String API_SET_NAV_TITLE = "setNavigationTitle";
    private static final String API_GIRLS_SHARE = "share";
    private static final String API_UPDATE_MSG_STATUS = "updateNavigationBarItemBadge";
    private static final String API_FILE_SELECTOR = "fileSelector";
    private static final String API_SET_NAV_LEFT_ITEMS = "setNavigationLeftItems";
    private static final String API_RESHOW_BACK_BUTTON = "reshowBackButton";
    private static final String API_VOTE_TICKET = "voteTicket";
    private static Map<String, String> memStorage = new HashMap<String, String>();
    private static final String PARAM_URI = "uri";
    private static final String PARAM_URL = "url";
    private static final String BRIDGE_LOGIN_EVENT = "LoginEvent";
    private static final String BRIDGE_LOGOUT_EVENT = "LogoutEvent";
    private static final String BRIDGE_FOLLOW_EVENT = "FollowEvent";
    private static final String BRIDGE_UNFOLLOW_EVENT = "UnFollowEvent";
    public static final String BRIDGE_EVENT_HANDLER = "brdigeEventHandler";
    public static final String ASK_FOR_HANDLER = "askForHandlePopAction";
    public static final String BRIDGE_API_UNSUPPORTED_EVENT = "ApiUnSupportedEvent";
    public static final String BRIDGE_TITLE_RIGHT_CLICK = "1931NavigationBarButtonItemTapped";
    public static final String BLEFT_BUTTON_CLICK = "1931LeftButtonClick";
    public static final String QUIT_CHANNEL = "quitChannel";
    public static final String OPEN_NOTICATION_PERMISSION_EVENT = "onNotificationPermissionEvent";
    public static final String START_RECORD_AUDIO = "startRecordAudio";
    public static final String STOP_RECORD_AUDIO = "stopRecordAudio";
    private WeakReference<IBridgeClient> bridgeClientHolder;
    private UIDelegate uiDelegate = null;
    public Map<String, Object> objectHolder;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private ISubscribeClient subscribeClient = new ISubscribeClient(){

        public void onGetSubscribeList(long uid, List<SubscribeInfo> list, boolean isLastPage) {
        }

        public void onSubscribeResult(long anchorUid, boolean success, String errorMsg) {
            try {
                JSONObject eventObj = new JSONObject();
                eventObj.put("type", (Object)ApiChannel.BRIDGE_FOLLOW_EVENT);
                eventObj.put("isSuccess", success);
                eventObj.put("uid", anchorUid);
                ApiChannel.this.dispathBridgeEvent(eventObj);
            }
            catch (JSONException e) {
                MLog.error((Object)ApiChannel.TAG, (Throwable)e);
            }
        }

        public void onUnSubscribeResult(long anchorUid, boolean success) {
            try {
                JSONObject eventObj = new JSONObject();
                eventObj.put("type", (Object)ApiChannel.BRIDGE_UNFOLLOW_EVENT);
                eventObj.put("isSuccess", success);
                eventObj.put("uid", anchorUid);
                ApiChannel.this.dispathBridgeEvent(eventObj);
            }
            catch (JSONException e) {
                MLog.error((Object)ApiChannel.TAG, (Throwable)e);
            }
        }

        public void onQuerySubscribeNumResult(long uid, long count) {
        }
    };
    private EventBinder mEventBinder;

    public void handleURI(Activity activity2, String uriString) {
        ARouter.getInstance().build(uriString).navigation((Context)activity2);
    }

    public ApiChannel(final Activity actSupport, IBridgeClient client, UIDelegate delegate, final IApiChannelCallBack callBack) {
        this.uiDelegate = delegate;
        this.objectHolder = new HashMap<String, Object>();
        if (actSupport != null) {
            if (client != null) {
                this.bridgeClientHolder = new WeakReference<IBridgeClient>(client);
                client.registerHandler(QUIT_CHANNEL, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        actSupport.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (((YYState)YYStore.INSTANCE.getState()).getChannelState() == ChannelState.In_Channel) {
                                    ICoreManagerBase.getChannelLinkCore().leaveChannel();
                                }
                            }
                        });
                    }
                });
                client.registerHandler(API_GOTO_BROWSER, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            JSONObject dataObj = (JSONObject)data;
                            String urlStr = dataObj.getString(ApiChannel.PARAM_URL);
                            if (callBack != null) {
                                callBack.gotoBrowser(urlStr);
                            } else {
                                ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toUrl((Context)actSupport, urlStr);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                        }
                    }
                });
                client.registerHandler(API_CLOSE_ALL_WINDOW, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        if (callBack != null) {
                            callBack.toMainActivity();
                        } else {
                            ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toMain((Context)actSupport);
                        }
                    }
                });
                client.registerHandler(API_REST_CHANNEL, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            JSONObject dataObj = (JSONObject)data;
                            String uriStr = dataObj.getString(ApiChannel.PARAM_URI);
                            if (uriStr != null) {
                                if (callBack != null) {
                                    callBack.handleNavRestUrl(uriStr);
                                } else {
                                    ApiChannel.this.handleURI(actSupport, uriStr);
                                }
                            } else {
                                MLog.error((String)ApiChannel.TAG, (String)"Error! null uri string.");
                            }
                        }
                        catch (RestAPINotSupportException e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                            ApiChannel.this.dispatcheUnSupportedEvent(e.getUriString());
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                        }
                    }
                });
                client.registerHandler(API_POP_CHANNEL, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        if (callBack != null) {
                            callBack.finishWebActivity();
                        } else {
                            Activity activity2 = actSupport;
                            if (activity2 != null) {
                                activity2.finish();
                            }
                        }
                    }
                });
                client.registerHandler(API_CHECK_LOGIN, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        callback.callback(LoginUtil.isLogined());
                    }
                });
                client.registerHandler(API_REQ_WEBTOKEN, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        String ticket = null;
                        long myuid = LoginUtil.getUid();
                        if (myuid > 0L) {
                            ticket = LoginProtocol.Factory.get().getWebToken();
                        }
                        MLog.info((String)ApiChannel.TAG, (String)("xuwakao, client ticket = " + ticket + ", uid = " + myuid));
                        callback.callback(ticket);
                    }
                });
                client.registerHandler(API_FOLLOW_USER, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            if (!LoginUtil.isLogined()) {
                                if (callBack != null) {
                                    callBack.toLogin(true, false);
                                } else {
                                    Activity activity2 = actSupport;
                                    ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toLogin((Context)activity2, true, false);
                                }
                            } else {
                                long uid = Long.valueOf((String)data);
                                if (uid == 0L) {
                                    uid = ((ILoginCore)ICoreManagerBase.getCore(ILoginCore.class)).getLastLoginAccount().userId;
                                }
                                ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).subscribe(uid);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                        }
                    }
                });
                client.registerHandler(API_UNFOLLOW_USER, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            if (!LoginUtil.isLogined()) {
                                if (callBack != null) {
                                    callBack.toLogin(true, false);
                                } else {
                                    Activity activity2 = actSupport;
                                    ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toLogin((Context)activity2, true, false);
                                }
                            } else {
                                long uid = Long.valueOf((String)data);
                                if (uid == 0L) {
                                    uid = ((ILoginCore)ICoreManagerBase.getCore(ILoginCore.class)).getLastLoginAccount().userId;
                                }
                                MLog.info((String)ApiChannel.TAG, (String)("apichannel call unsubscribe:" + uid));
                                ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).unSubscribe(uid);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                        }
                    }
                });
                client.registerHandler(API_GET_APP_INFO, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            if (callback != null) {
                                JSONObject result = new JSONObject();
                                long uid = LoginUtil.getUid();
                                long imid = 0L;
                                UserInfo info = ICoreManagerBase.getUserCore().getCacheUserInfoByUid(uid);
                                if (info != null) {
                                    imid = info.yyId;
                                }
                                result.put("uid", uid);
                                result.put("imid", imid);
                                result.put("system", (Object)"Android");
                                result.put("systemVersion", (Object)Build.VERSION.RELEASE);
                                result.put("appVersion", (Object)VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext()).getVersionNameFor3GReq());
                                result.put("imei", (Object)TelephonyUtils.getImei((Context)BasicConfig.getInstance().getAppContext()));
                                result.put("imsi", (Object)TelephonyUtils.getIMSI((Context)BasicConfig.getInstance().getAppContext()));
                                MLog.info((String)ApiChannel.TAG, (String)("web get app info:" + result));
                                callback.callback(result);
                            } else {
                                MLog.warn((String)ApiChannel.TAG, (String)"on js call getAppInfo. callback is null.");
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                        }
                    }
                });
                client.registerHandler(API_SHOW_ALERT_MESSAGE, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        this.defaultProc((JSONObject)data, callback);
                    }

                    private void defaultProc(JSONObject data, final IJavascriptCallback callback) {
                        try {
                            JSONObject jsonObject = data;
                            String title = jsonObject.optString("title", "");
                            String message = jsonObject.optString("message", "");
                            JSONArray buttons = jsonObject.optJSONArray("buttons");
                            if (message.length() > 0) {
                                AlertDialog.Builder builder = new AlertDialog.Builder((Context)actSupport);
                                builder.setTitle((CharSequence)title);
                                builder.setMessage((CharSequence)message);
                                if (buttons != null) {
                                    int btnArrLng = buttons.length();
                                    if (btnArrLng > 2) {
                                        btnArrLng = 2;
                                    }
                                    for (int i = 0; i < btnArrLng; ++i) {
                                        if (i == 0) {
                                            builder.setPositiveButton((CharSequence)buttons.optString(i), new DialogInterface.OnClickListener(){

                                                public void onClick(DialogInterface dialog, int which) {
                                                    try {
                                                        JSONObject result = new JSONObject();
                                                        result.put("index", 0);
                                                        result.put("error", null);
                                                        callback.callback(result);
                                                    }
                                                    catch (Exception e) {
                                                        MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                                                    }
                                                    dialog.dismiss();
                                                }
                                            });
                                            continue;
                                        }
                                        builder.setNegativeButton((CharSequence)buttons.optString(i), new DialogInterface.OnClickListener(){

                                            public void onClick(DialogInterface dialog, int which) {
                                                try {
                                                    JSONObject result = new JSONObject();
                                                    result.put("index", 1);
                                                    result.put("error", null);
                                                    callback.callback(result);
                                                }
                                                catch (Exception e) {
                                                    MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                                                }
                                                dialog.dismiss();
                                            }
                                        });
                                    }
                                }
                                builder.create().show();
                            } else if (callback != null) {
                                JSONObject errorMsg = new JSONObject();
                                errorMsg.put("index", -1);
                                errorMsg.put("error", (Object)"Error: message and buttons is required.");
                                callback.callback(errorMsg);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                        }
                    }
                });
                client.registerHandler(API_SHOW_PROGRESS_WINDOW, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            if (ApiChannel.this.uiDelegate != null) {
                                JSONObject jsonObject = (JSONObject)data;
                                jsonObject.put("show", true);
                                ApiChannel.this.uiDelegate.delegateProgress(jsonObject);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                        }
                    }
                });
                client.registerHandler(API_HIDE_PROGRESS_WINDOW, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            if (ApiChannel.this.uiDelegate != null) {
                                JSONObject jsonObject = new JSONObject();
                                jsonObject.put("show", false);
                                ApiChannel.this.uiDelegate.delegateProgress(jsonObject);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                        }
                    }
                });
                client.registerHandler(API_SET_COMMON_STORAGE_VALUE_FOR_KEY, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            JSONObject jsonObject = (JSONObject)data;
                            String key = jsonObject.getString("key");
                            String value = jsonObject.getString("value");
                            if (value != null) {
                                memStorage.put(key, value);
                                MLog.info((String)ApiChannel.TAG, (String)("JS set common storage value for key " + key + ",value:" + value));
                            } else if (memStorage.containsKey(key)) {
                                MLog.info((String)ApiChannel.TAG, (String)("JS remove common storage value for key " + key));
                                memStorage.remove(key);
                            }
                            if (callback != null) {
                                callback.callback(null);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                        }
                    }
                });
                client.registerHandler(API_GET_COMMON_STORAGE_VALUE_FOR_KEY, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            if (data != null) {
                                String key = (String)data;
                                JSONObject result = new JSONObject();
                                MLog.info((String)ApiChannel.TAG, (String)("JS get common storage value for key " + key + ",value:" + (String)memStorage.get(key)));
                                result.put("value", memStorage.get(key));
                                result.put("error", null);
                                if (callback != null) {
                                    callback.callback(result);
                                }
                            } else {
                                JSONObject result = new JSONObject();
                                result.put("value", null);
                                result.put("error", (Object)"Error: key\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u4e3astring\u7c7b\u578b");
                                if (callback != null) {
                                    callback.callback(result);
                                }
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                        }
                    }
                });
                client.registerHandler(API_POSET_NOTIFICATION, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            JSONObject jsonObject = (JSONObject)data;
                            int notificationID = jsonObject.getInt("notificationID");
                            JSONObject userInfo = jsonObject.getJSONObject("userInfo");
                            if (callback != null) {
                                JSONObject result = new JSONObject();
                                result.put("result", true);
                                callback.callback(result);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                            try {
                                if (callback != null) {
                                    JSONObject result = new JSONObject();
                                    result.put("result", false);
                                    callback.callback(result);
                                }
                            }
                            catch (Exception e1) {
                                MLog.error((Object)ApiChannel.TAG, (Throwable)e1);
                            }
                        }
                    }
                });
                client.registerHandler(API_DELETE_SHARED_COOKIE, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            String domain = (String)data;
                            CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance((Context)BasicConfig.getInstance().getAppContext());
                            CookieManager cookieManager = CookieManager.getInstance();
                            cookieManager.setAcceptCookie(true);
                            String cookieStr = cookieManager.getCookie(domain);
                            if (cookieStr != null && cookieStr.length() > 0) {
                                String[] cookies = cookieStr.split(";");
                                for (int i = 0; i < cookies.length; ++i) {
                                    String[] cookieparts = cookies[i].split("=");
                                    cookieManager.setCookie(domain, cookieparts[0].trim() + "=0;");
                                }
                            }
                            MLog.info((String)ApiChannel.TAG, (String)("web delete shared cookie, now is " + cookieManager.getCookie(domain)));
                            cookieSyncManager.sync();
                            if (callback != null) {
                                JSONObject result = new JSONObject();
                                result.put("count", 0);
                                callback.callback(result);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                        }
                    }
                });
                client.registerHandler(API_GET_API_LEVEL, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        if (callback != null) {
                            WVJSBridgeClient holder;
                            if (ApiChannel.this.bridgeClientHolder != null && ApiChannel.this.bridgeClientHolder.get() instanceof WVJSBridgeClient && (holder = (WVJSBridgeClient)ApiChannel.this.bridgeClientHolder.get()) != null) {
                                holder.setInsertJs(true);
                            }
                            callback.callback(2);
                        }
                    }
                });
                client.registerHandler(API_SET_NAV_RIGHT_ITEMS, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        if (!MLog.isLogLevelAboveVerbose()) {
                            MLog.verbose((String)ApiChannel.TAG, (String)("xuwakao, API_SET_NAV_RIGHT_ITEMS data = " + data));
                        }
                        ApiChannel.this.postSharpGirlsInfo(SharpGirlsInfo.Type.SET_RIGHT_BTN, data, callback);
                    }
                });
                client.registerHandler(API_SET_NAV_TITLE, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        if (!MLog.isLogLevelAboveVerbose()) {
                            MLog.verbose((String)ApiChannel.TAG, (String)("xuwakao, API_SET_NAV_TITLE data = " + data));
                        }
                        ApiChannel.this.postSharpGirlsInfo(SharpGirlsInfo.Type.SET_TITLE, data, callback);
                    }
                });
                client.registerHandler(API_GIRLS_SHARE, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        if (!MLog.isLogLevelAboveVerbose()) {
                            MLog.verbose((String)ApiChannel.TAG, (String)("xuwakao, API_GIRLS_SHARE data = " + data));
                        }
                        ApiChannel.this.postSharpGirlsInfo(SharpGirlsInfo.Type.SHARE, data, callback);
                    }
                });
                client.registerHandler(API_UPDATE_MSG_STATUS, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        if (!MLog.isLogLevelAboveVerbose()) {
                            MLog.verbose((String)ApiChannel.TAG, (String)("xuwakao, API_UPDATE_MSG_STATUS data = " + data));
                        }
                        ApiChannel.this.postSharpGirlsInfo(SharpGirlsInfo.Type.UPDATE_MSG_STATUS, data, callback);
                    }
                });
                client.registerHandler(API_FILE_SELECTOR, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        if (!MLog.isLogLevelAboveVerbose()) {
                            MLog.verbose((String)ApiChannel.TAG, (String)("xuwakao, API_UPDATE_MSG_STATUS data = " + data));
                        }
                        ApiChannel.this.postSharpGirlsInfo(SharpGirlsInfo.Type.FILE_SELECTOR, data, callback);
                    }
                });
                client.registerHandler(API_VOTE_TICKET, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            JSONObject jSONObject = (JSONObject)data;
                        }
                        catch (Exception e) {
                            MLog.error((Object)ApiChannel.TAG, (Throwable)e);
                        }
                    }
                });
                client.registerHandler(API_SET_NAV_LEFT_ITEMS, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        if (!MLog.isLogLevelAboveVerbose()) {
                            MLog.verbose((String)ApiChannel.TAG, (String)("xuwakao, API_SET_NAV_LEFT_ITEMS data = " + data));
                        }
                        ApiChannel.this.postSharpGirlsInfo(SharpGirlsInfo.Type.SET_LEFT_BTN, data, callback);
                    }
                });
                client.registerHandler(API_RESHOW_BACK_BUTTON, new INativeHandler(){

                    @Override
                    public void call(Object data, IJavascriptCallback callback) {
                        if (!MLog.isLogLevelAboveVerbose()) {
                            MLog.verbose((String)ApiChannel.TAG, (String)("xuwakao, API_RESHOW_BACK_BUTTON data = " + data));
                        }
                        ApiChannel.this.postSharpGirlsInfo(SharpGirlsInfo.Type.RESHOW_BACK_BUTTON, data, callback);
                    }
                });
            } else {
                MLog.error((String)TAG, (String)"null bridge client.");
            }
        }
    }

    public void postSharpGirlsInfo(SharpGirlsInfo.Type type, Object data, IJavascriptCallback callback) {
        final SharpGirlsInfo info = new SharpGirlsInfo();
        info.type = type;
        info.info = data;
        info.callback = callback;
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MLog.info((String)ApiChannel.TAG, (String)("#postSharpGirlsInfo info = " + info));
                PluginBus.INSTANCE.get().post((Object)new ISharpTabsClient_onSharpInfos_EventArgs((Object)info));
            }
        });
    }

    private void dispatcheUnSupportedEvent(String api) {
        try {
            JSONObject eventObj = new JSONObject();
            eventObj.put("type", (Object)BRIDGE_API_UNSUPPORTED_EVENT);
            eventObj.put("apiUri", (Object)api);
            this.dispathBridgeEvent(eventObj);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    @BusEvent
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        long userId = busEventArgs.getUid();
        try {
            MLog.info((String)TAG, (String)"xuwakao, client dispatch event onLoginSuccess");
            JSONObject eventObj = new JSONObject();
            eventObj.put("type", (Object)BRIDGE_LOGIN_EVENT);
            eventObj.put("isSuccess", true);
            eventObj.put("uid", userId);
            this.dispathBridgeEvent(eventObj);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    @BusEvent
    public void onLogout(IAuthClient_onLogout_EventArgs busEventArgs) {
        try {
            MLog.info((String)TAG, (String)"xuwakao, client dispatch event onLogout");
            JSONObject eventObj = new JSONObject();
            eventObj.put("type", (Object)BRIDGE_LOGOUT_EVENT);
            this.dispathBridgeEvent(eventObj);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void onRightBtnClicked(RightBtnInfo info) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("xuwakao, RightBtnInfo = " + info + ", this = " + (Object)((Object)this)));
        }
        try {
            IBridgeClient client = (IBridgeClient)this.bridgeClientHolder.get();
            if (client != null) {
                JSONObject eventObj = new JSONObject();
                eventObj.put("identifier", info.identifier);
                eventObj.put("selected", info.selected);
                client.callHandler(BRIDGE_TITLE_RIGHT_CLICK, eventObj, null);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void onLeftBackClicked() {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("onLeftBackClicked, this = " + (Object)((Object)this)));
        }
        try {
            IBridgeClient client = (IBridgeClient)this.bridgeClientHolder.get();
            if (client != null) {
                client.callHandler(BLEFT_BUTTON_CLICK);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    @BusEvent
    public void onNotificationPermissionEvent(INotification_onPermissionChane_EventArgs eventArgs) {
        boolean ntyEnable = NotificationsUtils.isNotificationEnable();
        MLog.info((Object)TAG, (String)"onNotificationPermissionEvent, ntyEnable: %s", (Object[])new Object[]{ntyEnable});
        try {
            IBridgeClient client = (IBridgeClient)this.bridgeClientHolder.get();
            if (client != null) {
                JSONObject eventObj = new JSONObject();
                eventObj.put("data", (Object)(ntyEnable ? "1" : "0"));
                eventObj.put("code", (Object)"1");
                client.callHandler(OPEN_NOTICATION_PERMISSION_EVENT, eventObj, null);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void getNavigationBarInformation(String url) {
        try {
            IBridgeClient client;
            if ("about:blank".equals(url)) {
                return;
            }
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)TAG, (String)("xuwakao, SHARP_GIRLS_REQ_ON_PAGE_FINISHED onPageFinished url = " + url));
            }
            if ((client = (IBridgeClient)this.bridgeClientHolder.get()) != null) {
                client.callHandler("get1931NavigationBarInformation", null, new IJavascriptCallback(){

                    @Override
                    public void callback(final Object data) {
                        ApiChannel.this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                JSONObject jsonObject;
                                if (!MLog.isLogLevelAboveVerbose()) {
                                    MLog.verbose((String)ApiChannel.TAG, (String)("xuwakao, SHARP_GIRLS_REQ_ON_PAGE_FINISHED data = " + data));
                                }
                                if (data == null) {
                                    return;
                                }
                                if (data instanceof JSONObject && (jsonObject = (JSONObject)data).length() == 0) {
                                    return;
                                }
                                SharpGirlsInfo info = new SharpGirlsInfo();
                                info.type = SharpGirlsInfo.Type.NAV_TITLE_INFO;
                                info.info = data;
                                PluginBus.INSTANCE.get().post((Object)new ISharpTabsClient_onSharpInfos_EventArgs((Object)info));
                            }
                        });
                    }

                    @Override
                    public void onJsHandlerNotFound(String callbackId, String handlerName) {
                    }
                });
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private void dispathBridgeEvent(JSONObject eventObject) {
        IBridgeClient client = (IBridgeClient)this.bridgeClientHolder.get();
        if (client != null) {
            MLog.info((String)TAG, (String)("client dispatch event:" + eventObject.toString()));
            client.callHandler(BRIDGE_EVENT_HANDLER, eventObject);
        } else {
            MLog.error((String)TAG, (String)"fail dispatch bridge event, client is null.");
        }
    }

    public void dispatchAskForHandlePopActionEvent(JSONObject object, IJavascriptCallback callback) {
        IBridgeClient client = (IBridgeClient)this.bridgeClientHolder.get();
        if (client != null) {
            client.callHandler(ASK_FOR_HANDLER, object, callback);
        }
    }

    public void regsiterNotification() {
        SubscribeClients.addCallBack((ISubscribeClient)this.subscribeClient);
        this.onEventBind();
    }

    public void unregsiternotification() {
        this.onEventUnBind();
        SubscribeClients.removeCallBack((ISubscribeClient)this.subscribeClient);
    }

    public void release() {
        try {
            this.unregsiternotification();
            this.uiDelegate = null;
            if (this.bridgeClientHolder != null) {
                IBridgeClient client = (IBridgeClient)this.bridgeClientHolder.get();
                if (client != null) {
                    client.destory();
                }
                this.bridgeClientHolder.clear();
                this.bridgeClientHolder = null;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new ApiChannel$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    public static class SharpGirlsInfo {
        public Type type;
        public Object info;
        public IJavascriptCallback callback;

        public String toString() {
            return "[ info = " + this.info + ", type = " + this.type.name() + ", callback = " + this.callback + "]";
        }

        public static enum Type {
            SET_RIGHT_BTN,
            SHARE,
            SET_TITLE,
            UPDATE_MSG_STATUS,
            NAV_TITLE_INFO,
            FILE_SELECTOR,
            SET_LEFT_BTN,
            RESHOW_BACK_BUTTON;

        }
    }
}

