/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.homeapi.ui.home.UpdateActivity;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkDialogListener;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IConnectivityClient_onConnectivityChange_EventArgs;
import com.yy.mobile.plugin.main.events.IUpdateClient_onUpdateResult_EventArgs;
import com.yy.mobile.ui.dialog.DialogLinkManager;
import com.yy.mobile.ui.setting.UpdateNotification;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.VersionUpdateHelper$$EventBinder;
import com.yy.mobile.ui.utils.update.IUpdateClickStrategy;
import com.yy.mobile.ui.utils.update.IUpdateStrategyHelper;
import com.yy.mobile.ui.utils.update.NormalUpdateClickStrategy;
import com.yy.mobile.ui.widget.dialog.OkCancelUpdateDialogListener;
import com.yy.mobile.ui.widget.dialog.UpdateDialog;
import com.yy.mobile.ui.widget.dialog.UpdateDialog2;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yy.mobile.util.valid.BlankUtil;
import com.yymobile.baseapi.R;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.update.IUpdateCore;
import com.yymobile.core.update.NewUpdateInfo;
import com.yymobile.core.update.UpdatePref;
import com.yymobile.core.update.UpdateRequest;
import com.yymobile.core.update.UpdateResult;
import com.yymobile.core.update.utils.UpdateReportUtils;
import com.yymobile.core.utils.IConnectivityCore;
import java.lang.ref.WeakReference;

public class VersionUpdateHelper
extends EmptyEventCompat
implements IUpdateStrategyHelper {
    private static final String TAG = "VersionUpdateHelper";
    private boolean ifcheckUpdate = false;
    private boolean ifAuto = false;
    private boolean ifNotify = false;
    private boolean isOnCreate = false;
    private String updateNote;
    private WeakReference<Activity> mReference;
    private IUpdateClickStrategy mUpdateClickStrategy;
    private boolean isForceDialogShow;
    private EventBinder mEventBinder;

    public void setIfNotify(boolean ifNotify, boolean onCreate2) {
        this.ifNotify = ifNotify;
        this.isOnCreate = onCreate2;
    }

    public VersionUpdateHelper(Activity activity2) {
        MLog.info((String)TAG, (String)"create VersionUpdateHelper");
        this.mReference = new WeakReference<Activity>(activity2);
        this.onEventBind();
        this.mUpdateClickStrategy = this.getUpdateClickStrategy();
    }

    private IUpdateClickStrategy getUpdateClickStrategy() {
        MLog.info((String)TAG, (String)"create NormalUpdateClickStrategy");
        return new NormalUpdateClickStrategy(this);
    }

    public void recordFirstStartTime() {
        long firstStartTime = UpdatePref.instance().getAppFirstStartTime();
        if (firstStartTime <= 0L) {
            UpdatePref.instance().setAppFirstStartTime();
        }
    }

    public void checkNotifyUpdate() {
        if (this.ifNotify) {
            this.checkDownloadedApk();
            this.ifNotify = false;
        }
    }

    public void checkAutoUpdate() {
        MLog.info((String)TAG, (String)"checkAutoUpdate");
        this.ifAuto = true;
        this.ifcheckUpdate = false;
        ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).update(UpdateRequest.AutoCheck, false);
    }

    public void checkUpdate() {
        MLog.info((String)TAG, (String)"checkUpdate");
        this.ifAuto = false;
        this.ifcheckUpdate = false;
        ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).update(UpdateRequest.ManualCheck, false);
    }

    public void checkForceUpdate() {
        MLog.info((String)TAG, (String)"checkForceUpdate");
        this.ifAuto = false;
        this.ifcheckUpdate = false;
        CommonPref.instance().putBoolean("MAIN_UPDATE_ID", true);
        ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).update(UpdateRequest.ManualCheck, true);
    }

    private void checkDownloadedApk() {
        ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).update(UpdateRequest.SilentInstall, false);
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUpdateResult(IUpdateClient_onUpdateResult_EventArgs eventArgs) {
        MLog.info((String)TAG, (String)"receive IUpdateClient_onUpdateResult_EventArgs");
        final UpdateResult updateResult = eventArgs.getUpdateResult();
        final boolean isForceUpdate = eventArgs.isForceUpdate();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                VersionUpdateHelper.this.onUpdateResult(updateResult, isForceUpdate);
            }
        });
    }

    private void onUpdateResult(UpdateResult updateResult, boolean isForceUpdate) {
        MLog.info((String)TAG, (String)"onUpdateResult");
        MLog.info((String)TAG, (String)("onUpdateResult:" + updateResult + "  isForceUpdate:" + isForceUpdate));
        if (updateResult != null) {
            Activity activity2 = (Activity)this.mReference.get();
            switch (updateResult) {
                case Updating: {
                    if (this.ifAuto) break;
                    Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)activity2.getString(R.string.download_updating), (int)0).show();
                    break;
                }
                case Error: {
                    if (this.ifAuto && !this.ifcheckUpdate) break;
                    this.showUpdateDialog(1, activity2.getString(R.string.download_error));
                    break;
                }
                case Recent: {
                    if (this.ifAuto) break;
                    this.showUpdateDialog(1, activity2.getString(R.string.update_recent));
                    break;
                }
                case NetworkError: {
                    if (!this.ifAuto || this.ifcheckUpdate) {
                        this.checkNetToast();
                    }
                    if (!this.ifcheckUpdate) break;
                    UpdateNotification.instance().setNotify(activity2.getString(R.string.network_error));
                    break;
                }
                case Downloaded: 
                case NeedDownload: {
                    boolean isDownloaded;
                    NewUpdateInfo updateInfo2 = ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).getUpdateInfo();
                    if (updateInfo2 == null) {
                        updateInfo2 = new NewUpdateInfo();
                        updateInfo2.setNote("\u7a0b\u5e8f\u9700\u8981\u66f4\u65b0\uff01");
                    }
                    MLog.info((String)TAG, (String)("updateInfo.getNote():" + updateInfo2.getNote()));
                    boolean bl = isDownloaded = updateResult == UpdateResult.Downloaded;
                    if (isForceUpdate) {
                        MLog.info((String)TAG, (String)("showUpdateDialog--" + isForceUpdate));
                        this.showUpdateDialog(3, updateInfo2.getNote(), isDownloaded);
                        break;
                    }
                    this.showUpdateDialog(0, updateInfo2.getNote(), isDownloaded);
                    break;
                }
                case Downloading: {
                    break;
                }
                case DownloadError: {
                    if (this.ifAuto && !this.ifcheckUpdate) break;
                    this.showUpdateDialog(2, activity2.getString(R.string.download_error));
                    break;
                }
                case DownloadSuccess: {
                    UpdateNotification.instance().cancel();
                    break;
                }
                case Ready: {
                    if (this.ifcheckUpdate) {
                        UpdateNotification.instance().cancel();
                        ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).update(UpdateRequest.Install, false);
                        break;
                    }
                    this.onUpdateResult(UpdateResult.NeedDownload, false);
                    break;
                }
                case InstallError: {
                    if (this.ifAuto && !this.ifcheckUpdate) break;
                    this.showUpdateDialog(2, activity2.getString(R.string.install_error));
                    break;
                }
                case NeedInstall: {
                    this.showNeedInstallDialog();
                    break;
                }
            }
        }
    }

    private void showUpdateDialog(int r, String msg) {
        this.showUpdateDialog(r, msg, false);
    }

    private void showUpdateDialog(int r, String msg, boolean isDownloaded) {
        final Activity activity2 = (Activity)this.mReference.get();
        if (activity2 != null) {
            switch (r) {
                case 0: {
                    this.showDialog(new UpdateDialog2(0, msg, this.getInstallText(isDownloaded), false, new OkCancelUpdateDialogListener(){

                        @Override
                        public void onCancel(Dialog dialog) {
                            dialog.dismiss();
                            MLog.info((String)VersionUpdateHelper.TAG, (String)"UpdateRequest.RemindLater");
                            UpdateReportUtils.reportHiidoCancelClick();
                            ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).update(UpdateRequest.RemindLater, false);
                        }

                        @Override
                        public void onOk(Dialog dialog) {
                            UpdateReportUtils.reportHiidoUpgradeClick();
                            VersionUpdateHelper.this.mUpdateClickStrategy.onUpdateClick(activity2, dialog);
                        }
                    }));
                    break;
                }
                case 1: {
                    this.showDialog((IBaseDialog)new OkDialog((CharSequence)msg, true, new OkDialogListener(){

                        public void onOk() {
                        }
                    }));
                    break;
                }
                case 3: {
                    if (this.isForceDialogShow) break;
                    this.showDialog(new UpdateDialog(3, msg, activity2.getString(R.string.download_now), activity2.getString(R.string.download_quit), false, new OkCancelUpdateDialogListener(){

                        @Override
                        public void onCancel(Dialog dialog) {
                            dialog.dismiss();
                            MLog.info((String)VersionUpdateHelper.TAG, (String)"UpdateRequest..quit");
                            activity2.finish();
                            System.exit(0);
                        }

                        @Override
                        public void onOk(Dialog dialog) {
                            VersionUpdateHelper.this.mUpdateClickStrategy.onForceUpdateClick(activity2, dialog);
                        }
                    }));
                    this.isForceDialogShow = true;
                    break;
                }
                default: {
                    this.showDialog(new UpdateDialog(2, msg, activity2.getString(R.string.download_again), activity2.getString(R.string.str_later), true, new OkCancelUpdateDialogListener(){

                        @Override
                        public void onCancel(Dialog dialog) {
                            dialog.dismiss();
                            MLog.info((String)VersionUpdateHelper.TAG, (String)"UpdateRequest.RemindLater");
                            ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).update(UpdateRequest.RemindLater, false);
                        }

                        @Override
                        public void onOk(Dialog dialog) {
                            VersionUpdateHelper.this.mUpdateClickStrategy.onUpdateClick(activity2, dialog);
                        }
                    }));
                }
            }
        }
    }

    public String getInstallText(Boolean isDownloaded) {
        if (isDownloaded.booleanValue()) {
            return BasicConfig.getInstance().getAppContext().getString(R.string.update_install);
        }
        return BasicConfig.getInstance().getAppContext().getString(R.string.download_now);
    }

    @Override
    public void startUpdate(Activity activity2) {
        this.ifcheckUpdate = true;
        UpdateNotification.instance().updateIntent();
        UpdateNotification.instance().setNotify(activity2.getString(R.string.download_start), "0%");
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).update(UpdateRequest.Download, false);
            }
        }, (long)200L);
    }

    protected void showNeedInstallDialog() {
        final Activity activity2 = (Activity)this.mReference.get();
        if (activity2 != null) {
            this.updateNote = activity2.getString(R.string.download_install);
            NewUpdateInfo updateInfo = ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).getUpdateInfo();
            if (!BlankUtil.isBlank((String)updateInfo.getNote())) {
                this.updateNote = updateInfo.getNote();
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    VersionUpdateHelper.this.showDialog(new UpdateDialog(4, VersionUpdateHelper.this.updateNote, activity2.getString(R.string.str_install), activity2.getString(R.string.next_install), false, new OkCancelUpdateDialogListener(){

                        @Override
                        public void onCancel(Dialog dialog) {
                            dialog.dismiss();
                            MLog.info((String)VersionUpdateHelper.TAG, (String)"showNeedInstallDialog.onCancel()");
                            ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).setLaterInstall(true);
                        }

                        @Override
                        public void onOk(Dialog dialog) {
                            dialog.dismiss();
                            ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).setLaterInstall(false);
                            ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).update(UpdateRequest.Install, false);
                        }
                    }));
                }
            }, (long)100L);
        }
    }

    @Override
    public void createUpdateTipDialog(String msg) {
        if (YYActivityManager.INSTANCE.getCurrentActivity() instanceof UpdateActivity) {
            AlertDialog.Builder mBuilder = new AlertDialog.Builder((Context)YYActivityManager.INSTANCE.getCurrentActivity());
            AlertDialog dialog = mBuilder.create();
            dialog.getWindow();
            dialog.requestWindowFeature(1);
            dialog.setCancelable(false);
            dialog.setCanceledOnTouchOutside(false);
            dialog.show();
            dialog.setContentView(R.layout.hp_layout_progress_dialog);
            TextView tvTip = (TextView)dialog.findViewById(R.id.tv_tip);
            tvTip.setText((CharSequence)msg);
            dialog.show();
        }
    }

    @BusEvent
    public void onConnectivityChange(IConnectivityClient_onConnectivityChange_EventArgs busEventArgs) {
        NewUpdateInfo info;
        IConnectivityCore.ConnectivityState previousState = busEventArgs.getPreviousState();
        IConnectivityCore.ConnectivityState currentState = busEventArgs.getCurrentState();
        MLog.info((String)TAG, (String)("onConnectivityChange previousState = " + previousState.name() + ", currentState = " + currentState.name()));
        if (previousState == IConnectivityCore.ConnectivityState.NetworkUnavailable && currentState == IConnectivityCore.ConnectivityState.ConnectedViaWifi && (info = ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).getUpdateInfo()) != null && info.downloadState == NewUpdateInfo.SilentDownloadState.NETWORK_ERROR) {
            ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).update(UpdateRequest.SilentDownload, false);
        }
    }

    private boolean checkNetToast() {
        boolean falg = NetworkUtils.isNetworkStrictlyAvailable((Context)BasicConfig.getInstance().getAppContext());
        if (!falg) {
            SingleToastUtil.showToast((Context)BasicConfig.getInstance().getAppContext(), (int)R.string.str_network_not_capable);
        }
        return falg;
    }

    private void showDialog(IBaseDialog dialog) {
        DialogLinkManager manager = new DialogLinkManager((Context)YYActivityManager.INSTANCE.getCurrentActivity());
        manager.showDialog(dialog);
    }

    public void onDestroy() {
        this.onEventUnBind();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new VersionUpdateHelper$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

