/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.DialogManager;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.ProgressDialog;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.ui.utils.PersonInfoHandler$$EventBinder;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.coreapi.PersonInfoHandlerApi;
import com.yymobile.core.CoreError;
import com.yymobile.core.CoreManager;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.user.UserInfo;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public class PersonInfoHandler
extends EmptyEventCompat {
    private static final String TAG = "PersonInfoHandler";
    private SoftReference<PersonInfoHandlerApi.EntInfoListener> mEntInfoListenerRef;
    private WeakReference<PersonInfoHandlerApi.UserInfoListener> mUserInfoListenerRef;
    private EntUserInfo mEntInfo;
    private UserInfo mUserInfo;
    private WeakReference<DialogManager> mDialogManagerRef;
    private long mUid;
    private EventBinder mEventBinder;

    private PersonInfoHandler() {
        CoreManager.addClient((Object)((Object)this));
    }

    public static PersonInfoHandler newInstance() {
        return new PersonInfoHandler();
    }

    public void requestEntUserInfo(long uid, PersonInfoHandlerApi.EntInfoListener listener2) {
        this.requestEntUserInfo(null, false, uid, listener2);
    }

    public void requestEntUserInfo(DialogManager dialogLinkManager, boolean showLoading, long uid, PersonInfoHandlerApi.EntInfoListener listener2) {
        MLog.info((String)TAG, (String)("requestEntUserInfo() called , uid : " + uid));
        if (showLoading && dialogLinkManager != null) {
            dialogLinkManager.showDialog((IBaseDialog)new ProgressDialog());
            this.mDialogManagerRef = new WeakReference<DialogManager>(dialogLinkManager);
        }
        this.mUid = uid;
        this.mEntInfoListenerRef = new SoftReference<PersonInfoHandlerApi.EntInfoListener>(listener2);
        this.mEntInfo = ((IProfileCore)CoreManager.getCore(IProfileCore.class)).getCachedProfileInfo(uid);
        if (this.mEntInfo == null) {
            ((IProfileCore)CoreManager.getCore(IProfileCore.class)).requestProfile(uid);
        } else {
            listener2.onRetrieve(this.mEntInfo);
            CoreManager.removeClient((Object)((Object)this));
            DialogManager manager = null;
            if (this.mDialogManagerRef != null) {
                manager = (DialogManager)this.mDialogManagerRef.get();
            }
            if (this.mDialogManagerRef != null && manager != null) {
                manager.dismissDialog();
            }
        }
    }

    public void requestUserInfo(long uid, PersonInfoHandlerApi.UserInfoListener listener2) {
        MLog.info((String)TAG, (String)("requestUserInfo() called , uid : " + uid));
        this.mUid = uid;
        this.mUserInfoListenerRef = new WeakReference<PersonInfoHandlerApi.UserInfoListener>(listener2);
        this.mUserInfo = CoreManager.getUserCore().getCacheUserInfoByUid(uid);
        if (this.mUserInfo == null) {
            CoreManager.getUserCore().requestDetailUserInfo(uid, true);
        } else {
            MLog.info((String)TAG, (String)"requestUserInfo() getDataFromCache");
            listener2.onRetrieve(this.mUserInfo);
            CoreManager.removeClient((Object)((Object)this));
        }
    }

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userId = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        this.onRequestDetailUserInfo(userId, info, isLocalData, error);
    }

    public void onRequestDetailUserInfo(long userId, UserInfo info, boolean isLocalData, CoreError error) {
        PersonInfoHandlerApi.UserInfoListener listener2 = null;
        if (this.mUserInfoListenerRef != null) {
            listener2 = (PersonInfoHandlerApi.UserInfoListener)this.mUserInfoListenerRef.get();
        }
        if (error == null && info != null && info.userId == this.mUid && this.mUserInfoListenerRef != null && listener2 != null) {
            MLog.info((String)TAG, (String)("onRequestDetailUserInfo() : " + info.toString()));
            listener2.onRetrieve(info);
            CoreManager.removeClient((Object)((Object)this));
        } else {
            MLog.info((String)TAG, (String)"onRequestDetailUserInfo() : CoreError or uid not matches or info==null or mUserInfoListener == null");
        }
    }

    @BusEvent
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs busEventArgs) {
        EntUserInfo info = busEventArgs.getInfo();
        this.onRequestProfile(info);
    }

    public void onRequestProfile(EntUserInfo info) {
        if (info.uid == this.mUid && this.mEntInfoListenerRef != null && this.mEntInfoListenerRef.get() != null) {
            MLog.info((String)TAG, (String)("onRequestProfile() : " + info.toString()));
            try {
                this.mEntInfoListenerRef.get().onRetrieve(info);
            }
            catch (Throwable ex) {
                MLog.error((Object)TAG, (String)"Attempt to invoke interface method onRetrieve() on a null object reference!", (Throwable)ex, (Object[])new Object[0]);
            }
            CoreManager.removeClient((Object)((Object)this));
        } else {
            MLog.info((String)TAG, (String)"onRequestProfile() : uid not matches or info==null");
        }
        DialogManager manager = null;
        if (this.mDialogManagerRef != null) {
            manager = (DialogManager)this.mDialogManagerRef.get();
        }
        if (this.mDialogManagerRef != null && manager != null) {
            manager.dismissDialog();
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new PersonInfoHandler$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

