/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationCompat;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.mobile.baseapi.AppidPlatform;
import com.yy.mobile.bizmodel.login.ILoginCore;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.framework.unionapi.IAppIdCore;
import com.yy.mobile.http.httpsparser.HttpsParser;
import com.yy.mobile.main.channellist.IGo2ChannelListAction;
import com.yy.mobile.main.gamecenter.IGameCenterCore;
import com.yy.mobile.plugin.homeapi.store.HomePageState;
import com.yy.mobile.plugin.homeapi.store.HomePageStore;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.manager.Plugin;
import com.yy.mobile.plugin.manager.loading.PluginLoadingDialog;
import com.yy.mobile.sdkwrapper.login.LoginProtocol;
import com.yy.mobile.small.SmallProxy;
import com.yy.mobile.ui.channel.SignDetailsActivity;
import com.yy.mobile.ui.common.JsSupportWebAcitivity;
import com.yy.mobile.ui.common.OnePieceJsSupportWebAcitivity;
import com.yy.mobile.ui.common.PhotoDisplayActivity;
import com.yy.mobile.ui.gallery.GalleryAnchorDetailActivity;
import com.yy.mobile.ui.gallery.GalleryBigPhotoDisplayActivity;
import com.yy.mobile.ui.gallery.GalleryDisplayActivity;
import com.yy.mobile.ui.gallery.GalleryPickPhotoActivity;
import com.yy.mobile.ui.gallery.StaggeredGridActivity;
import com.yy.mobile.ui.home.LivingSubNavActivity;
import com.yy.mobile.ui.home.label.LivingLabelPageActivity;
import com.yy.mobile.ui.home.navto.LivingMorePageActivity;
import com.yy.mobile.ui.home.navto.PreviewActivity;
import com.yy.mobile.ui.home.navto.TopicDetailActivity;
import com.yy.mobile.ui.home.navto.TopicListActivity;
import com.yy.mobile.ui.messagenotifycenter.InteractiveMessageActivity;
import com.yy.mobile.ui.messagenotifycenter.MessageCenterActivity;
import com.yy.mobile.ui.messagenotifycenter.MessageDetailActivity;
import com.yy.mobile.ui.messagenotifycenter.MessageHistoryActivity;
import com.yy.mobile.ui.messagenotifycenter.SystemMessageActivity;
import com.yy.mobile.ui.profile.anchor.AnchorFansListActivity;
import com.yy.mobile.ui.profile.anchor.AnchorWorksDetailActivity;
import com.yy.mobile.ui.profile.user.UserGalleryActivity;
import com.yy.mobile.ui.report.ReportActivity;
import com.yy.mobile.ui.setting.AboutActivity;
import com.yy.mobile.ui.setting.MsgNoticeActivity;
import com.yy.mobile.ui.setting.PushSettingActivity;
import com.yy.mobile.ui.setting.SafeCenterActivity;
import com.yy.mobile.ui.setting.VRQrCodeActivity;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.widget.photopicker.PhotoPickActivity;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.LinkUriProvider;
import com.yymobile.core.UriProvider;
import com.yymobile.core.gallery.module.CommentInfo;
import com.yymobile.core.gallery.module.PhotoInfo;
import com.yymobile.core.live.livecore.JoinChannelIntent;
import com.yymobile.core.live.livenav.LiveNavInfo;
import com.yymobile.core.live.livenav.SubLiveNavItem;
import com.yymobile.core.moment.MomentCategory;
import com.yymobile.core.moment.MomentInfo;
import com.yymobile.core.moment.request.MomentFrom;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

public class NavigationUtils {
    private static final String TAG = "NavigationUtils";
    public static final int BIND_YY_ACCOUNT_REQUEST_CODE = 546;

    public static void slideStartActivity(Context context, Intent intent) {
        com.yy.mobile.baseapi.NavigationUtils.slideStartActivity((Context)context, (Intent)intent);
    }

    public static void slideStartActivityForResult(Context context, Intent intent, int requestCode) {
        com.yy.mobile.baseapi.NavigationUtils.slideStartActivityForResult((Context)context, (Intent)intent, (int)requestCode);
    }

    public static void fadeStartActivity(Context context, Intent intent) {
        com.yy.mobile.baseapi.NavigationUtils.fadeStartActivity((Context)context, (Intent)intent);
    }

    public static void navToBrower(Context context, String url) {
        Intent it = new Intent("android.intent.action.VIEW");
        url = HttpsParser.convertToHttps((String)url);
        it.setData(Uri.parse((String)url));
        it = Intent.createChooser((Intent)it, null);
        NavigationUtils.slideStartActivity(context, it);
    }

    public static void navTo(Activity context, String uriString) {
        ARouter.getInstance().build(uriString).navigation((Context)context);
    }

    public static void navTo(Activity context, Uri uri) {
        ARouter.getInstance().build(uri).navigation((Context)context);
    }

    public static void navToUri(Activity context, String uriString) {
        if (TextUtils.isEmpty((CharSequence)uriString)) {
            return;
        }
        Uri uri = Uri.parse((String)uriString.trim());
        NavigationUtils.navToUri(context, uri);
    }

    public static void navToUri(Activity context, Uri uri) {
        ARouter.getInstance().build(uri).navigation((Context)context);
    }

    public static void navTo(Activity context, String uriString, Object others) {
        ARouter.getInstance().build(uriString).navigation((Context)context);
    }

    public static void navTo(Activity context, Uri uri, Object others) {
        ARouter.getInstance().build(uri).navigation((Context)context);
    }

    public static void toAnchorWorksDetailActivity(Context act, long anchorId, String category) {
        Intent intent = new Intent(act, AnchorWorksDetailActivity.class);
        intent.putExtra("anchor_uid", anchorId);
        intent.putExtra("category", category);
        NavigationUtils.slideStartActivity(act, intent);
    }

    public static void toPhotoPickActivityForResult(Context context, boolean isPreviewCover, boolean isLandscape, int requestCode) {
        Intent intent = new Intent(context, PhotoPickActivity.class);
        intent.putExtra("params_preview_cover", isPreviewCover);
        intent.putExtra("params_request_landscape", isLandscape);
        NavigationUtils.slideStartActivityForResult(context, intent, requestCode);
    }

    public static void toEditPickActivityForResult(Context context, String converPath, boolean isPreviewCover, boolean isLandscape, int requestCode) {
        Intent intent = new Intent(context, PhotoPickActivity.class);
        intent.putExtra("params_preview_cover", isPreviewCover);
        intent.putExtra("params_request_landscape", isLandscape);
        intent.putExtra("params_request_edit_conver_path", converPath);
        NavigationUtils.slideStartActivityForResult(context, intent, requestCode);
    }

    public static void toQrcodePhotoPickActivityForResult(Context context, boolean isQRcode, boolean isLandscape, int requestCode, String keyOfPath) {
        Intent intent = new Intent(context, PhotoPickActivity.class);
        intent.putExtra("params_qrcode_scan", isQRcode);
        intent.putExtra("params_request_landscape", isLandscape);
        intent.putExtra("params_qrcode_pic_path", keyOfPath);
        NavigationUtils.slideStartActivityForResult(context, intent, requestCode);
    }

    public static void toVideoTopicGroupActivity(Activity context, String topicName, int navId) {
        Intent intent = new Intent("SHENQU_ACTION_SHORTVIDEO_TOPIC");
        intent.putExtra("KEY", "ToActivityVideoTopicGroup");
        if (!BlankUtil.isBlank((String)topicName)) {
            intent.putExtra("group_topic", topicName);
        }
        intent.putExtra("NAV_ID", navId);
        intent.addFlags(0x4000000);
        SmallProxy.startAction((Intent)intent, (Activity)context);
    }

    public static void toLogin(Context act, boolean showBack, boolean isKicked) {
        NavigationUtils.toLogin(act);
    }

    public static void toLogin(Context act) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)"login", (String)("toLogin, act = " + act));
        }
        ARouter.getInstance().build("/Login/Main").navigation(act);
    }

    public static void toLogin(Context act, int requestCode) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)"login", (String)("toLogin, act = " + act));
        }
        ARouter.getInstance().build("/Login/Main").navigation((Activity)act, requestCode);
    }

    public static void toQuPaiProduction(Context context, long uid) {
        if (NetworkUtils.isNetworkAvailable((Context)context)) {
            Intent intent = new Intent("SHENQU_ACTION_SHENQU_LIST");
            intent.putExtra("KEY", "ToActivityProduction");
            intent.putExtra("QuPaiUid", uid);
            SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
        } else {
            Toast.makeText((Context)context, (int)R.string.str_network_not_capable, (int)1).show();
        }
    }

    public static void toAbout(Context context) {
        Intent intent = new Intent(context, AboutActivity.class);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toTestPluginInfo(Context context) {
        ARouter.getInstance().build("/PersonalCenter/TestPluginInfo").navigation(context);
    }

    public static void toAppMarket(Context context) {
        try {
            Intent it = new Intent("android.intent.action.VIEW");
            it.setData(Uri.parse((String)("market://details?id=" + context.getPackageName())));
            ActivityCompat.startActivity((Context)((Activity)context), (Intent)it, null);
        }
        catch (Exception e) {
            Toast.makeText((Context)context, (CharSequence)"\u672a\u68c0\u6d4b\u5230\u6709\u5b89\u88c5\u5e94\u7528\u5e02\u573a", (int)0).show();
            MLog.error((String)"toAppMarket", (String)"no market installed");
        }
    }

    public static void toMainExit(Activity context, boolean exit) {
        ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toMainExit((Context)context, exit);
    }

    public static void toMain(Activity context, Bundle bundle) {
        ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toMain((Context)context, bundle);
    }

    public static void toMain(Activity context) {
        ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toMain((Context)context);
    }

    public static void toLoginAndMain(Activity context, Intent intentLogin, boolean isClearTop) {
        ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toLoginAndMain((Context)context, intentLogin, isClearTop);
    }

    public static void toMainTab(Activity context, String tabId) {
        ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toMainTab((Context)context, tabId);
    }

    public static void toMainTab(Activity context, int index) {
        ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toMainTab((Context)context, index);
    }

    public static void toMyChatTab(Activity context, String tabId) {
        Intent intent = new Intent("IM_TO_MY_CHAT_ACTIVITY");
        intent.putExtra("my_chat_method_name", "toMyChatTab");
        intent.putExtra("my_chat_tab_id", tabId);
        SmallProxy.startAction((Intent)intent, (Activity)context);
    }

    public static void toMyChatActivity(Activity context, boolean isShare, long sid, long ssid) {
        Intent intent = new Intent("IM_TO_MY_CHAT_ACTIVITY");
        intent.putExtra("my_chat_is_share", isShare);
        intent.putExtra("my_chat_sid", sid);
        intent.putExtra("my_chat_ssid", ssid);
        intent.putExtra("my_chat_method_name", "toMyChatActivity_with_channel");
        SmallProxy.startAction((Intent)intent, (Activity)context);
    }

    public static void toMyChatActivityByShareLink(Activity context, String title, String contentText, String url, String imageUrl, int sourceType) {
        Intent intent = new Intent("IM_TO_MY_CHAT_ACTIVITY");
        intent.putExtra("my_chat_method_name", "toMyChatActivity_with_yylink");
        intent.putExtra("my_chat_key_share_title", title);
        intent.putExtra("my_chat_key_share_text", contentText);
        intent.putExtra("my_chat_key_share_url", url);
        intent.putExtra("my_chat_key_share_imageurl", imageUrl);
        intent.putExtra("my_chat_key_share_sourcetype", sourceType);
        SmallProxy.startAction((Intent)intent, (Activity)context);
    }

    public static void toMyChatActivityByShareImage(Activity context, String imageUrl, int sourceType) {
        Intent intent = new Intent("IM_TO_MY_CHAT_ACTIVITY");
        intent.putExtra("my_chat_method_name", "toMyChatActivity_with_imageurl");
        intent.putExtra("my_chat_key_share_imageurl", imageUrl);
        intent.putExtra("my_chat_key_share_sourcetype", sourceType);
        SmallProxy.startAction((Intent)intent, (Activity)context);
    }

    public static void toMainUpdate(Activity context, boolean update2) {
        Intent intent = new Intent((Context)context, ((HomePageState)HomePageStore.INSTANCE.getState()).getMainActivityClass());
        intent.addFlags(0x4000000);
        intent.addFlags(0x20000000);
        intent.putExtra("MAIN_UPDATE_ID", update2);
        NavigationUtils.slideStartActivity((Context)context, intent);
    }

    public static void toUrl(Activity context, String url) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        Uri contentUrl = Uri.parse((String)url);
        intent.setData(contentUrl);
        NavigationUtils.slideStartActivity((Context)context, intent);
    }

    public static void toJSSupportedWebView(Activity context, String url, boolean isFromBindPhoneAfterLogin) {
        NavigationUtils.toJSSupportedWebView(context, url, 17, false, false, false, isFromBindPhoneAfterLogin, null);
    }

    public static void toJSSupportedWebView(Activity context, String url, int requestCode, int isReurnRresh, int isReturnReshPart) {
        NavigationUtils.toJSSupportedWebView(context, url, 17, false, false, requestCode, isReurnRresh, isReturnReshPart, null);
    }

    public static void toJSSupportedWebView(Activity context, String url, int requestCode, int isReurnRresh, int isReturnReshPart, String deepinkChannel, String deeplinkBackUrl) {
        NavigationUtils.toJSSupportedWebView(context, url, 17, false, false, requestCode, isReurnRresh, isReturnReshPart, deepinkChannel, deeplinkBackUrl, null);
    }

    public static void toJSSupportedWebView(Activity context, String url, int requestCode, int isReurnRresh, int isReturnReshPart, String deepinkChannel, String deeplinkBackUrl, Bundle bundle) {
        NavigationUtils.toJSSupportedWebView(context, url, 17, false, false, requestCode, isReurnRresh, isReturnReshPart, deepinkChannel, deeplinkBackUrl, bundle);
    }

    public static void toJSSupportedWebView(Activity context, String url) {
        NavigationUtils.toJSSupportedWebView(context, url, 17, false, false, (Bundle)null);
    }

    public static void toJSSupportedWebView(Activity context, String url, Bundle bundle) {
        NavigationUtils.toJSSupportedWebView(context, url, 17, false, false, bundle);
    }

    public static void toJSSupportedWebView(Activity context, String url, String title) {
        NavigationUtils.toJSSupportedWebView(context, url, title, false, false);
    }

    public static void toJSSupportedWebView(Activity context, String url, boolean disableRefresh, boolean autoFinish) {
        NavigationUtils.toJSSupportedWebView(context, url, 17, disableRefresh, autoFinish, (Bundle)null);
    }

    public static void toJSSupportedWebView(Activity context, String url, String title, boolean disableRefresh, boolean autoFinish) {
        NavigationUtils.toJSSupportedWebView(context, url, title, true, disableRefresh, autoFinish);
    }

    public static void toJSSupportedWebView(Activity context, String url, String title, boolean isForceUseTitle, boolean disableRefresh, boolean autoFinish) {
        NavigationUtils.toJSSupportedWebView(context, url, title, isForceUseTitle, 17, disableRefresh, autoFinish, false, false, (Bundle)null);
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish) {
        NavigationUtils.toJSSupportedWebView(context, url, feature, disableRefresh, autoFinish, false, null);
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish, Bundle bundle) {
        NavigationUtils.toJSSupportedWebView(context, url, feature, disableRefresh, autoFinish, false, bundle);
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish, boolean showFeedback, boolean isFromBindPhoneAfterLogin, Bundle bundle) {
        NavigationUtils.toJSSupportedWebView(context, url, null, true, feature, disableRefresh, autoFinish, showFeedback, isFromBindPhoneAfterLogin, bundle);
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish, boolean showFeedback, Bundle bundle) {
        NavigationUtils.toJSSupportedWebView(context, url, null, true, feature, disableRefresh, autoFinish, showFeedback, false, bundle);
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish, boolean showFeedback) {
        NavigationUtils.toJSSupportedWebView(context, url, null, true, feature, disableRefresh, autoFinish, showFeedback, false, (Bundle)null);
    }

    public static void toJSSupportedWebView(Activity context, String url, String title, boolean forceUsePageTitle, int feature, boolean disableRefresh, boolean autoFinish, boolean showFeedback, boolean isFromBindPhoneAfterLogin, Bundle bundle) {
        if (context == null) {
            MLog.warn((String)"toJSSupportedWebView", (String)"context is null");
            return;
        }
        Intent intent = new Intent();
        intent.setClass((Context)context, JsSupportWebAcitivity.class);
        url = HttpsParser.convertToHttps((String)url);
        intent.putExtra("yyweburl", url);
        if (StringUtils.isEmpty((String)title).booleanValue()) {
            intent.putExtra("yywebtitle", title);
        }
        intent.putExtra("webviewFeature", feature);
        intent.putExtra("usepagetitle", forceUsePageTitle);
        if (disableRefresh) {
            intent.putExtra("disableRefresh", "disableRefresh");
        }
        if (showFeedback) {
            intent.putExtra("usefeedback", true);
        }
        if (autoFinish) {
            intent.putExtra("autoFinish", "autoFinish");
        }
        intent.putExtra("isFromBindPhone", isFromBindPhoneAfterLogin);
        intent.putExtra("raw_uri_string", url);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        NavigationUtils.slideStartActivity((Context)context, intent);
    }

    public static void toJSSupportedWebView(Activity context, String url, String title, boolean forceUsePageTitle, int feature, boolean disableRefresh, boolean autoFinish, boolean showFeedback, boolean isFromBindPhoneAfterLogin, String deeplinkChannel) {
        NavigationUtils.toJSSupportedWebView(context, url, title, forceUsePageTitle, feature, disableRefresh, autoFinish, showFeedback, isFromBindPhoneAfterLogin, deeplinkChannel, "", "", null);
    }

    public static void toJSSupportedWebView(Activity context, String url, String title, boolean forceUsePageTitle, int feature, boolean disableRefresh, boolean autoFinish, boolean showFeedback, boolean isFromBindPhoneAfterLogin, String deeplinkChannel, String deeplinkChannelBackUrl, String rawUri, Bundle bundle) {
        if (context == null) {
            MLog.warn((String)"toJSSupportedWebView", (String)"context is null");
            return;
        }
        Intent intent = new Intent();
        intent.setClass((Context)context, JsSupportWebAcitivity.class);
        url = HttpsParser.convertToHttps((String)url);
        intent.putExtra("yyweburl", url);
        if (StringUtils.isEmpty((String)title).booleanValue()) {
            intent.putExtra("yywebtitle", title);
        }
        intent.putExtra("webviewFeature", feature);
        intent.putExtra("usepagetitle", forceUsePageTitle);
        intent.putExtra("deeplink_channel", deeplinkChannel);
        intent.putExtra("back_url", deeplinkChannelBackUrl);
        if (disableRefresh) {
            intent.putExtra("disableRefresh", "disableRefresh");
        }
        if (showFeedback) {
            intent.putExtra("usefeedback", true);
        }
        if (autoFinish) {
            intent.putExtra("autoFinish", "autoFinish");
        }
        intent.putExtra("isFromBindPhone", isFromBindPhoneAfterLogin);
        intent.putExtra("raw_uri_string", rawUri);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        NavigationUtils.slideStartActivity((Context)context, intent);
    }

    public static void toOnePieceJSSupportedWebView(Activity context, String url, int requestCode, int isReturnResh, int isReturnReshPart) {
        if (context == null) {
            MLog.warn((String)"toJSSupportedWebView", (String)"context is null");
            return;
        }
        Intent intent = new Intent();
        intent.setClass((Context)context, OnePieceJsSupportWebAcitivity.class);
        url = HttpsParser.convertToHttps((String)url);
        intent.putExtra("yyweburl", url);
        intent.putExtra("webviewFeature", 17);
        intent.putExtra("usepagetitle", true);
        intent.putExtra("return_refresh", isReturnResh);
        intent.putExtra("return_refresh_part", isReturnReshPart);
        if (isReturnResh == 1 || isReturnReshPart == 1) {
            NavigationUtils.slideStartActivityForResult((Context)context, intent, requestCode);
        } else {
            NavigationUtils.slideStartActivity((Context)context, intent);
        }
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish, int requestCode, int isReturnResh, int isReturnReshPart, Bundle bundle) {
        if (context == null) {
            MLog.warn((String)"toJSSupportedWebView", (String)"context is null");
            return;
        }
        Intent intent = new Intent();
        intent.setClass((Context)context, JsSupportWebAcitivity.class);
        url = HttpsParser.convertToHttps((String)url);
        intent.putExtra("yyweburl", url);
        intent.putExtra("webviewFeature", feature);
        intent.putExtra("return_refresh", isReturnResh);
        intent.putExtra("return_refresh_part", isReturnReshPart);
        if (disableRefresh) {
            intent.putExtra("disableRefresh", "disableRefresh");
        }
        if (autoFinish) {
            intent.putExtra("autoFinish", "autoFinish");
        }
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        NavigationUtils.slideStartActivityForResult((Context)context, intent, requestCode);
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish, int requestCode, int isReturnResh, int isReturnReshPart, String deeplinkChannel, String deeplinkBackUrl, Bundle bundle) {
        if (context == null) {
            MLog.warn((String)"toJSSupportedWebView", (String)"context is null");
            return;
        }
        Intent intent = new Intent();
        intent.setClass((Context)context, JsSupportWebAcitivity.class);
        url = HttpsParser.convertToHttps((String)url);
        intent.putExtra("yyweburl", url);
        intent.putExtra("webviewFeature", feature);
        intent.putExtra("return_refresh", isReturnResh);
        intent.putExtra("return_refresh_part", isReturnReshPart);
        intent.putExtra("deeplink_channel", deeplinkChannel);
        intent.putExtra("back_url", deeplinkBackUrl);
        if (disableRefresh) {
            intent.putExtra("disableRefresh", "disableRefresh");
        }
        if (autoFinish) {
            intent.putExtra("autoFinish", "autoFinish");
        }
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        NavigationUtils.slideStartActivityForResult((Context)context, intent, requestCode);
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish, String pageBackStyle) {
        if (context == null) {
            MLog.warn((String)"toJSSupportedWebView", (String)"context is null");
            return;
        }
        Intent intent = new Intent();
        intent.setClass((Context)context, JsSupportWebAcitivity.class);
        url = HttpsParser.convertToHttps((String)url);
        intent.putExtra("yyweburl", url);
        intent.putExtra("webviewFeature", feature);
        if (disableRefresh) {
            intent.putExtra("disableRefresh", "disableRefresh");
        }
        if (autoFinish) {
            intent.putExtra("autoFinish", "autoFinish");
        }
        if (pageBackStyle != null && pageBackStyle.equals("history")) {
            intent.putExtra("web_page_back_style", "history");
        }
        NavigationUtils.slideStartActivity((Context)context, intent);
    }

    public static void toJSSupportedWebViewFullScreen(Activity context, String url, Bundle bundle) {
        if (context == null) {
            MLog.warn((String)"toJSSupportedWebView", (String)"context is null");
            return;
        }
        Intent intent = new Intent();
        intent.setClass((Context)context, JsSupportWebAcitivity.class);
        url = HttpsParser.convertToHttps((String)url);
        intent.putExtra("yyweburl", url);
        intent.putExtra("webviewFeature", 17);
        intent.putExtra("full_screen", true);
        if (null != bundle) {
            intent.putExtras(bundle);
        }
        NavigationUtils.fadeStartActivity((Context)context, intent);
    }

    public static void toGenaralWebView(Activity context, String url) {
        if (context == null) {
            MLog.warn((String)"toGenaralWebView", (String)"context is null");
            return;
        }
        Intent intent = new Intent("IM_TO_WEB_VIEW_ORIDINAL_ACTIVITY");
        intent.putExtra("ordinal_url", url);
        SmallProxy.startAction((Intent)intent, (Activity)context);
    }

    public static void toFeedBack(Context context, String appId) {
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("50206", "0006");
        StringBuffer sb = new StringBuffer("https://kf.yy.com/app/im.html");
        sb.append("?");
        int appid = ((IAppIdCore)CoreFactory.getCore(IAppIdCore.class)).getCustomServiceAppId();
        sb.append("ft=app&appid=" + appid);
        sb.append("&uid=" + LoginUtil.getUid());
        sb.append("&feedappid=" + (StringUtils.isEmpty((String)appId) == false ? appId : AppidPlatform.getAppId()));
        sb.append("&ticket=" + LoginProtocol.Factory.get().getWebToken());
        NavigationUtils.toJSSupportedWebView((Activity)context, sb.toString(), 17, false, false, true, null);
    }

    public static void toSuggestFeedBack(Context context, String appId) {
        ARouter.getInstance().build("/PersonalCenter/Feedback").withString("extra_app_id", appId).navigation(context);
    }

    public static void toBugReport(Context context) {
        ARouter.getInstance().build("/PersonalCenter/Feedback").withBoolean("bug_report_entry", true).navigation(context);
    }

    public static void toProfile(Context context, long uid, int userType) {
        NavigationUtils.toPersonPage(context, uid);
    }

    public static void toProfile(Context context, long uid) {
        NavigationUtils.toPersonPage(context, uid);
    }

    public static void toPersonPage(Context context, long uid) {
        ARouter.getInstance().build("/User/View").withLong("extra_anchor_uid", uid).navigation(context);
    }

    public static void toPersonPage(Context context, long uid, boolean isSubscribed) {
        ARouter.getInstance().build("/User/View").withLong("extra_anchor_uid", uid).withBoolean("extra_is_subscribed", isSubscribed).navigation(context);
    }

    public static void toPersonPage(Context context, long uid, int tabId) {
        ARouter.getInstance().build("/User/View").withLong("extra_anchor_uid", uid).withInt("extra_tab_id", tabId).navigation(context);
    }

    public static void toPersonPage(Context context, long uid, boolean isSubscribed, int tabId) {
        ARouter.getInstance().build("/User/View").withLong("extra_anchor_uid", uid).withBoolean("extra_is_subscribed", isSubscribed).withInt("extra_tab_id", tabId).navigation(context);
    }

    public static void toPhotoDisplay(Context context, String photoUrl) {
        Intent intent = new Intent(context, PhotoDisplayActivity.class);
        intent.putExtra("photoUrl", photoUrl);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toMyMessage(Context context) {
        if (context instanceof Activity) {
            Intent intent = new Intent("IM_TO_MY_CHAT_ACTIVITY");
            intent.putExtra("my_chat_method_name", "toMyMessage");
            SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
        }
    }

    public static void toMeVideo(Context context, String fromPath) {
        Intent intent = new Intent("SHENQU_ACTION_ME_SHORT_VIDEO");
        intent.putExtra("KEY", "ToActivityMeVideo");
        intent.putExtra("key_jump_from_path", fromPath);
        SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toPersonalChat(Activity context, long uid) {
        Intent intent = new Intent("IM_TO_PERSONAL_CHAT_ACTIVITY");
        intent.putExtra("personal_chat_uid", uid);
        SmallProxy.startAction((Intent)intent, (Activity)context);
    }

    public static void toPersonalChat(Activity context, long uid, String flag) {
        Intent intent = new Intent("IM_TO_PERSONAL_CHAT_ACTIVITY");
        intent.putExtra("personal_chat_uid", uid);
        intent.putExtra("personal_chat_flag", flag);
        SmallProxy.startAction((Intent)intent, (Activity)context);
    }

    public static void toMsgNotice(Context context) {
        Intent intent = new Intent(context, MsgNoticeActivity.class);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toPushSettingActivity(Context context) {
        Intent intent = new Intent(context, PushSettingActivity.class);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toBlackListSettingActivity(Context context) {
        if (context instanceof Activity) {
            Intent intent = new Intent("IM_TO_BLACK_LIST_SETTING_ACTIVITY");
            SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
        }
    }

    public static void toVRQrCodeActivity(Context context, Bundle bundle) {
        Intent intent = new Intent(context, VRQrCodeActivity.class);
        intent.putExtras(bundle);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toUserInfo(Context context, long uid) {
        NavigationUtils.toPersonPage(context, uid);
    }

    public static void toMessageCenterActivity(Context context) {
        Intent intent = new Intent(context, MessageCenterActivity.class);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toMessageHistoryActivity(Context context, String title, int classifyId) {
        MessageHistoryActivity.navigateFrom(context, title, classifyId);
    }

    public static void toInteractiveMessageActivity(Context context) {
        InteractiveMessageActivity.skipToInteractMsgActivity(context);
    }

    public static void toSystemMessageActivity(Context context) {
        SystemMessageActivity.navigateFrom(context);
    }

    public static void toMessageDetailActivity(Context context, Bundle args) {
        Intent intent = new Intent(context, MessageDetailActivity.class);
        intent.putExtras(args);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toAnchorFansListActivity(Context context, long anchorId) {
        Intent intent = new Intent(context, AnchorFansListActivity.class);
        intent.putExtra("anchor_uid", anchorId);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toPersonChannelListActivity(Context context, long uid) {
        IGo2ChannelListAction iGo2ChannelListAction = (IGo2ChannelListAction)CoreFactory.getCore(IGo2ChannelListAction.class);
        if (iGo2ChannelListAction != null) {
            Intent intent = iGo2ChannelListAction.getChannelListActivityIntent(context, uid);
            if (intent != null) {
                NavigationUtils.slideStartActivity(context, intent);
            }
        } else {
            MLog.info((String)TAG, (String)"iGo2ChannelListAction == null");
        }
    }

    public static void toStaggeredGridAcitivity(Context context, long anchor, String anchorName, long albumId) {
        Intent intent = new Intent(context, StaggeredGridActivity.class);
        intent.putExtra("key_anchor_id", anchor);
        intent.putExtra("key_anchor_name", anchorName);
        intent.putExtra("key_alum_id", albumId);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toGalleryPickPhotoActivity(Context context, long anchorId, long albumId, boolean isEnd, int pageNo) {
        Intent intent = new Intent(context, GalleryPickPhotoActivity.class);
        intent.putExtra("gallery_photo_anchorid", anchorId);
        intent.putExtra("gallery_photo_alumid", albumId);
        intent.putExtra("gallery_isend", isEnd);
        intent.putExtra("gallery_pageno", pageNo);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toGalleryBigPhotoDisplayActivity(Context context, long anchorId, long albumId, PhotoInfo info, int pageNo, boolean isEnd, ArrayList<PhotoInfo> list) {
        Intent intent = new Intent(context, GalleryBigPhotoDisplayActivity.class);
        intent.putExtra("gallery_list_photo", list);
        intent.putExtra("sigle_list_photo", (Parcelable)info);
        intent.putExtra("gallery_big_anchoid", anchorId);
        intent.putExtra("gallery_big_aumbid", albumId);
        intent.putExtra("gallery_pageno", pageNo);
        intent.putExtra("gallery_isend", isEnd);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toGalleryNewDetailActivity(Context context, long anchorId, long albumId, long photoId, int flag, int photoType) {
        Intent intent = new Intent(context, GalleryAnchorDetailActivity.class);
        intent.putExtra("gallery_anthor_id", anchorId);
        intent.putExtra("gallery_alum_id", albumId);
        intent.putExtra("gallery_photo_id", photoId);
        intent.putExtra("gallery_anchor_flag", flag);
        intent.putExtra("gallery_photo_type", photoType);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toGalleryNewDetailActivity(Context context, long anchorId, long albumId, PhotoInfo info, int pageNo, boolean isEnd, int flag, int photoType) {
        Intent intent = new Intent(context, GalleryAnchorDetailActivity.class);
        PhotoInfo infoClone = null;
        try {
            infoClone = (PhotoInfo)info.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        if (infoClone == null) {
            return;
        }
        if (info.comments.size() > 0) {
            CommentInfo commentInfo = (CommentInfo)info.comments.get(0);
            infoClone.comments.clear();
            infoClone.comments.add(commentInfo);
        }
        intent.putExtra("gallery_click_photo", (Parcelable)infoClone);
        intent.putExtra("gallery_anthor_id", anchorId);
        intent.putExtra("gallery_alum_id", albumId);
        intent.putExtra("gallery_anthor_pageno", pageNo);
        intent.putExtra("gallery_stagger_isend", isEnd);
        intent.putExtra("gallery_anchor_flag", flag);
        intent.putExtra("gallery_photo_type", photoType);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toGalleryNewDetailMsgCenterActivity(Context context, String jsonStr, int flag, int photoType) {
        Intent intent = new Intent(context, GalleryAnchorDetailActivity.class);
        try {
            if (FP.empty((CharSequence)jsonStr)) {
                MLog.info((String)"toGalleryNewDetailMsgCenterActivity", (String)"jsonStr=null");
                return;
            }
            JSONObject jsonObject = new JSONObject(URLDecoder.decode(jsonStr, "utf-8"));
            if (jsonObject == null) {
                MLog.info((String)"toGalleryNewDetailMsgCenterActivity", (String)"jsonObject=null");
                return;
            }
            MLog.info((String)"toGalleryNewDetailMsgCenterActivity", (String)("jsonObject.size=" + jsonObject.length()));
            intent.putExtra("gallery_anthor_id", jsonObject.optString("anchorId"));
            intent.putExtra("gallery_alum_id", jsonObject.optString("albumId"));
            PhotoInfo info = new PhotoInfo();
            info.photoAuthorLogo = jsonObject.optString("anchorImlogo");
            info.photoId = jsonObject.optLong("photoId");
            info.photoAuthorName = jsonObject.optString("anchorNick");
            CommentInfo comment = new CommentInfo();
            comment.commentId = jsonObject.optLong("commentId");
            comment.left = jsonObject.optInt("left");
            comment.content = jsonObject.optString("content");
            comment.commentsMyLogo = jsonObject.optString("imlogo");
            comment.top = jsonObject.optInt("top");
            comment.praiseNum = jsonObject.optLong("praiseNum");
            comment.uid = jsonObject.optLong("uid");
            comment.nickCommentsName = jsonObject.optString("nick");
            if (info.comments != null) {
                info.comments.clear();
                info.comments.add(comment);
            }
            intent.putExtra("gallery_click_photo", (Parcelable)info);
            intent.putExtra("gallery_anchor_flag", flag);
            intent.putExtra("gallery_photo_type", photoType);
            NavigationUtils.slideStartActivity(context, intent);
        }
        catch (Throwable e) {
            MLog.warn((Object)context, (String)("toGalleryNewDetailMsgCenterActivity msgMap " + e + ",jsonstr=" + jsonStr), (Object[])new Object[0]);
        }
    }

    public static void toGalleryNewPersonPageActivity(Context context, long anchorId, long albumId, PhotoInfo info, ArrayList<PhotoInfo> list, int flag, int photoType) {
        Intent intent = new Intent(context, GalleryAnchorDetailActivity.class);
        PhotoInfo infoClone = null;
        try {
            infoClone = (PhotoInfo)info.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        if (infoClone == null) {
            return;
        }
        if (info.comments.size() > 0) {
            CommentInfo commentInfo = (CommentInfo)info.comments.get(0);
            infoClone.comments.clear();
            infoClone.comments.add(commentInfo);
        }
        intent.putExtra("gallery_click_photo", (Parcelable)infoClone);
        intent.putExtra("gallery_anthor_id", anchorId);
        intent.putExtra("gallery_alum_id", albumId);
        intent.putParcelableArrayListExtra("gallery_anthor_list", list);
        intent.putExtra("gallery_anchor_flag", flag);
        intent.putExtra("gallery_photo_type", photoType);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void tBindYYAccountActivityForResult(Context context, int requestCode) {
        if (CoreFactory.getCore(ILoginCore.class) != null) {
            ((ILoginCore)CoreFactory.getCore(ILoginCore.class)).toBindYYAccountActivityForResult(context, requestCode);
        }
    }

    public static void toBindPhoneNumberActivity(Context context) {
        StringBuffer sb = new StringBuffer(UriProvider.YY_UDB_BINDPHONE_URL);
        sb.append("?");
        sb.append("appid=" + AppidPlatform.getAppId());
        sb.append("&action=1");
        sb.append("&ticket=" + LoginProtocol.Factory.get().getOTP(AppidPlatform.getAppId()));
        sb.append("&ticketType=2");
        sb.append("&yyuid=" + LoginUtil.getUid());
        sb.append("&deviceData=" + LoginProtocol.Factory.get().getDeviceData());
        NavigationUtils.toJSSupportedWebView((Activity)context, sb.toString());
    }

    public static void toBindPhoneNumberNewActivity(Activity activity2) {
        StringBuffer sb = new StringBuffer(UriProvider.YY_UDB_BINDPHONE_URL);
        sb.append("?");
        sb.append("appid=" + AppidPlatform.getAppId());
        sb.append("&action=1");
        sb.append("&ticket=" + LoginProtocol.Factory.get().getOTP(AppidPlatform.getAppId()));
        sb.append("&ticketType=2");
        sb.append("&yyuid=" + LoginUtil.getUid());
        sb.append("&deviceData=" + LoginProtocol.Factory.get().getDeviceData());
        NavigationUtils.toJSSupportedWebView(activity2, sb.toString());
    }

    public static void toBindPhoneNumberNewActivity(Activity activity2, String extData) {
        StringBuffer sb = new StringBuffer(UriProvider.YY_UDB_BINDPHONE_URL);
        sb.append("?");
        sb.append("appid=" + AppidPlatform.getAppId());
        sb.append("&action=1");
        sb.append("&ticket=" + LoginProtocol.Factory.get().getOTP(AppidPlatform.getAppId()));
        sb.append("&ticketType=2");
        sb.append("&yyuid=" + LoginUtil.getUid());
        sb.append("&deviceData=" + LoginProtocol.Factory.get().getDeviceData());
        sb.append("&extraData=" + extData);
        NavigationUtils.toJSSupportedWebView(activity2, sb.toString());
    }

    public static void toBindPhoneNumberWithoutBack(Activity activity2) {
        StringBuffer sb = new StringBuffer(UriProvider.YY_UDB_BINDPHONE_URL);
        sb.append("?");
        sb.append("appid=" + AppidPlatform.getAppId());
        sb.append("&action=1");
        sb.append("&ticket=" + LoginProtocol.Factory.get().getOTP(AppidPlatform.getAppId()));
        sb.append("&ticketType=2");
        sb.append("&yyuid=" + LoginUtil.getUid());
        sb.append("&deviceData=" + LoginProtocol.Factory.get().getDeviceData());
        sb.append("&isShowBack=false");
        sb.append("&isShowPopBack=false");
        sb.append("&isJumpSuccessed=false");
        if (!(YYActivityManager.INSTANCE.getCurrentActivity() instanceof JsSupportWebAcitivity)) {
            NavigationUtils.toJSSupportedWebView(activity2, sb.toString(), true);
        }
    }

    public static void toBigGalleryDisplayActivity(Context context, PhotoInfo info) {
        Intent intent = new Intent(context, GalleryDisplayActivity.class);
        intent.putExtra("photoUrl", info.photoUrl);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toGalleryCombineActivity(Context context, PhotoInfo photoInfo, long anchorId, long albumId) {
        Intent intent = new Intent();
        intent.setAction("com.yy.mobile.ui.gallery.PhotoCombineActivity");
        intent.putExtra("photoInfo", (Parcelable)photoInfo);
        intent.putExtra("anchorId", anchorId);
        intent.putExtra("albumId", albumId);
        try {
            NavigationUtils.slideStartActivity(context, intent);
        }
        catch (Throwable throwable) {
            MLog.error((Object)context, (String)"had not found activity com.yy.mobile.ui.gallery.PhotoCombineActivity", (Object[])new Object[0]);
            SingleToastUtil.showToast((Context)context, (String)"\u8be5\u6a21\u5757\u6b63\u5728\u66f4\u65b0\u4e2d\uff0c\u656c\u8bf7\u671f\u5f85");
        }
    }

    public static void toUserGallery(Context context, long userId, boolean isSingleTop) {
        Intent intent = new Intent(context, UserGalleryActivity.class);
        intent.putExtra("userId", userId);
        if (isSingleTop) {
            intent.addFlags(131072);
        }
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toSignInfoActivity(Activity context) {
        Intent intent = new Intent((Context)context, SignDetailsActivity.class);
        NavigationUtils.slideStartActivity((Context)context, intent);
    }

    public static void toMobileLiveCameraPerviewViaMain(Activity context) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)"xuwakao", (String)("toMobileLiveCameraPerviewViaMain,context=" + context));
        }
        Intent intent = new Intent((Context)context, ((HomePageState)HomePageStore.INSTANCE.getState()).getMainActivityClass());
        intent.putExtra("EXTRA_START_FROM_ANCHOR_PER", 111);
        intent.addFlags(0x4000000);
        intent.addFlags(0x20000000);
        context.startActivity(intent);
    }

    public static void toLivingPerviewPage(Activity context, int exp) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)"xuwakao", (String)("toLivingPerviewPage,context=" + context));
        }
        Intent intent = new Intent((Context)context, PreviewActivity.class);
        intent.putExtra("expand_id", exp);
        intent.addFlags(0x4000000);
        intent.addFlags(0x20000000);
        context.startActivity(intent);
    }

    public static void toLivingTopicListPage(Activity context) {
        Intent intent = new Intent((Context)context, TopicListActivity.class);
        intent.addFlags(0x4000000);
        intent.addFlags(0x20000000);
        context.startActivity(intent);
    }

    public static void toLivingMorePage(Activity context, String name, LiveNavInfo navInfo, SubLiveNavItem subNavInfo, int moduleId) {
        Intent intent = new Intent((Context)context, LivingMorePageActivity.class);
        intent.putExtra("live_tab_name", name);
        intent.putExtra("live_nav_info", (Parcelable)navInfo);
        intent.putExtra("live_sub_nav_info", (Parcelable)subNavInfo);
        intent.putExtra("live_module_id", moduleId);
        context.startActivity(intent);
    }

    public static void toLivingMorePage(Activity context, String name, LiveNavInfo navInfo, SubLiveNavItem subNavInfo, int from, String value, String deeplinkChannel, String backUrl) {
        Intent intent = new Intent((Context)context, LivingMorePageActivity.class);
        intent.putExtra("live_tab_name", name);
        intent.putExtra("live_nav_info", (Parcelable)navInfo);
        intent.putExtra("live_sub_nav_info", (Parcelable)subNavInfo);
        intent.putExtra("fragment_type", from);
        intent.putExtra("deeplink_channel", deeplinkChannel);
        intent.putExtra("back_url", backUrl);
        if (value != null) {
            intent.putExtra("new_subnavfragment_style", "1");
        }
        context.startActivity(intent);
    }

    public static void toLivingLabelPage(Activity context, String label, String from) {
        Intent intent = new Intent((Context)context, LivingLabelPageActivity.class);
        intent.putExtra("live_tab_label", label);
        intent.putExtra("live_tab_from", from);
        intent.addFlags(0x4000000);
        intent.addFlags(0x20000000);
        context.startActivity(intent);
    }

    public static void toLivingTopicDetailPage(Context context, int id2) {
        Intent intent = new Intent(context, TopicDetailActivity.class);
        intent.putExtra("KEY_ID", id2);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toPlayPreviewVideo(Activity activity2, String videoUrl) {
    }

    public static void toShortVideoDisplayActivity(Context context, long resId, String videoUrl, float dpi, HashMap<String, Object> extend) {
        NavigationUtils.toShortVideoDisplayActivity(context, resId, videoUrl, dpi, null, extend);
    }

    public static void toShortVideoDisplayActivity(final Context context, final long resId, final String videoUrl, final float dpi, final String snapshotUrl, final HashMap<String, Object> extend) {
        PluginLoadingDialog.Companion.createLoader(context).withPlugin(Plugin.ShenQu).post(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent("SHENQU_ACTION_PLAY");
                intent.putExtra("KEY", "ToActivityShortVideoDisplay");
                Bundle bundle = new Bundle();
                bundle.putString("videoUrl", videoUrl);
                bundle.putLong("shenquId", resId);
                if (dpi > 0.0f) {
                    bundle.putFloat("dpi", dpi);
                }
                HashMap<String, String> extendInfo = extend;
                if (snapshotUrl != null) {
                    if (extendInfo == null) {
                        extendInfo = new HashMap<String, String>();
                    }
                    extendInfo.put("extra_key_play_snapshort_url", snapshotUrl);
                }
                if (extendInfo != null) {
                    bundle.putSerializable("extend", extendInfo);
                }
                intent.putExtras(bundle);
                SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
            }
        });
    }

    public static void toShortVideoRecordActivity(Context context, int cameraWorkFlowStrategy) {
        NavigationUtils.toShortVideoRecordActivity(context, cameraWorkFlowStrategy, null, null);
    }

    public static void toShortVideoRecordActivity(final Context context, final int strategy, final String topic, final String jumpPath) {
        PluginLoadingDialog.Companion.createLoader(context).withPlugin(Plugin.ShenQu).post(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent("SHENQU_ACTION_VIDEO_RECORD");
                intent.putExtra("KEY", "ToActivityVideoRecord");
                intent.putExtra("key_camera_workflow_strategy", strategy);
                if (!StringUtils.isEmpty((String)topic).booleanValue()) {
                    intent.putExtra("key_from_topic", topic);
                }
                if (!StringUtils.isEmpty((String)jumpPath).booleanValue()) {
                    intent.putExtra("key_jump_to_path", jumpPath);
                }
                SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
            }
        });
    }

    @Deprecated
    public static void toPublishMomentActivity(final Context context) {
        PluginLoadingDialog.Companion.createLoader(context).withPlugin(Plugin.Moment).post(new Runnable(){

            @Override
            public void run() {
                ARouter.getInstance().build("/Moment/Publish").navigation(context);
            }
        });
    }

    @Deprecated
    public static void toMomentListActivity(final Context context, long userId, final long reqUid, final int type) {
        PluginLoadingDialog.Companion.createLoader(context).withPlugin(Plugin.Moment).post(new Runnable(){

            @Override
            public void run() {
                MomentCategory category = type == 0 ? MomentCategory.MOMENT_MIX_LIST() : MomentCategory.MOMENT_SINGLE_LIST((long)reqUid);
                NavigationUtils.toMomentListActivity(context, category);
            }
        });
    }

    @Deprecated
    public static void toMomentListActivity(Context context, MomentCategory category) {
        NavigationUtils.toMomentListActivity(context, category, MomentFrom.Other);
    }

    public static void toMomentListActivity(final Context context, final MomentCategory category, final MomentFrom from) {
        PluginLoadingDialog.Companion.createLoader(context).withPlugin(Plugin.Moment).post(new Runnable(){

            @Override
            public void run() {
                ARouter.getInstance().build("/Moment/List").withSerializable("listCategory", (Serializable)category).withInt("from", from.getStatistic()).navigation(context);
            }
        });
    }

    @Deprecated
    public static void toMomentNewListActivity(Context context, long userId, long reqUid, int type) {
        NavigationUtils.toMomentNewListActivity(context);
    }

    @Deprecated
    public static void toMomentNewListActivity(Context context) {
        NavigationUtils.toMomentNewListActivity(context, MomentFrom.Other);
    }

    public static void toMomentNewListActivity(final Context context, final MomentFrom from) {
        PluginLoadingDialog.Companion.createLoader(context).withPlugin(Plugin.Moment).post(new Runnable(){

            @Override
            public void run() {
                ARouter.getInstance().build("/Moment/List/NEW").withInt("from", from.getStatistic()).navigation(context);
            }
        });
    }

    @Deprecated
    public static void toReferMomentActivity(Context context, MomentInfo momentInfo) {
        NavigationUtils.toReferMomentActivity(context, momentInfo, MomentFrom.Other);
    }

    public static void toReferMomentActivity(final Context context, final MomentInfo momentInfo, final MomentFrom from) {
        PluginLoadingDialog.Companion.createLoader(context).withPlugin(Plugin.Moment).post(new Runnable(){

            @Override
            public void run() {
                ARouter.getInstance().build("/Moment/Refer").withSerializable("moment_info", (Serializable)momentInfo).withInt("from", from.getStatistic()).navigation(context);
            }
        });
    }

    public static void toShareMomentActivity(final Context context, final MomentInfo momentInfo) {
        PluginLoadingDialog.Companion.createLoader(context).withPlugin(Plugin.Moment).post(new Runnable(){

            @Override
            public void run() {
                ARouter.getInstance().build("/Moment/Share").withSerializable("moment_info", (Serializable)momentInfo).navigation(context);
            }
        });
    }

    public static void toRealNameCertificateWebView(Activity activity2, long uid) {
        String url = UriProvider.USER_INFO_VERIFY + "?" + "appid=yy_mob" + "&ticket=" + LoginProtocol.Factory.get().getToken("5060") + "&ticketAppid=5060" + "&ticketType=0" + "&yyuid=" + uid + "&faceCertAllowed=1" + "&useNewZmxy=true" + "&sourceType=sdk";
        MLog.info((String)TAG, (String)("toJSSupportedWebView: url = " + url));
        NavigationUtils.toJSSupportedWebView(activity2, url);
    }

    public static void toUnderageCertificateWebView(Activity activity2, long uid) {
        String url = UriProvider.USER_INFO_UNDERAGE + "?" + "appid=yy_mob" + "&ticket=" + LoginProtocol.Factory.get().getToken("5060") + "&ticketAppid=5060" + "&ticketType=0" + "&yyuid=" + uid + "&faceCertAllowed=1" + "&useNewZmxy=true" + "&sourceType=sdk";
        MLog.info((String)TAG, (String)("toJSSupportedWebView: url = " + url));
        NavigationUtils.toJSSupportedWebView(activity2, url);
    }

    @Deprecated
    public static void toMomentDetailActivity(Context context, MomentInfo momentInfo) {
        NavigationUtils.toMomentDetailActivity(context, momentInfo, false);
    }

    @Deprecated
    public static void toMomentDetailActivity(Context context, String momentId) {
        ARouter.getInstance().build("/Moment/Detail").withString("moment_id", momentId).navigation(context);
    }

    @Deprecated
    public static void toMomentDetailActivity(Context context, MomentInfo momentInfo, boolean fromComment) {
        NavigationUtils.toMomentDetailActivity(context, momentInfo, fromComment, MomentFrom.Other);
    }

    public static void toMomentDetailActivity(final Context context, final MomentInfo momentInfo, final boolean fromComment, final MomentFrom from) {
        PluginLoadingDialog.Companion.createLoader(context).withPlugin(Plugin.Moment).post(new Runnable(){

            @Override
            public void run() {
                ARouter.getInstance().build("/Moment/Detail").withSerializable("bundle_data_moment_info", (Serializable)momentInfo).withInt("from", from.getStatistic()).withBoolean("is_from_comment", fromComment).navigation(context);
            }
        });
    }

    @Deprecated
    public static void toReplyMomentActivity(Context context, String momentId, long commentToUid, String commentToUserName) {
        NavigationUtils.toReplyMomentActivity(context, momentId, commentToUid, commentToUserName, MomentFrom.Other, "");
    }

    public static void toReplyMomentActivity(final Context context, final String momentId, final long commentToUid, final String commentToUserName, final MomentFrom from, final String token) {
        PluginLoadingDialog.Companion.createLoader(context).withPlugin(Plugin.Moment).post(new Runnable(){

            @Override
            public void run() {
                ARouter.getInstance().build("/Moment/CommentOrReply").withString("comment_id", momentId).withLong("comment_to_uid", commentToUid).withString("comment_to_name", commentToUserName).withInt("from", from.getStatistic()).withString("token", token).navigation(context);
            }
        });
    }

    @Deprecated
    public static void toCommentMomentActivity(Context context, String momentId) {
        NavigationUtils.toCommentMomentActivity(context, momentId, MomentFrom.Other, "");
    }

    public static void toCommentMomentActivity(final Context context, final String momentId, final MomentFrom from, final String token) {
        PluginLoadingDialog.Companion.createLoader(context).withPlugin(Plugin.Moment).post(new Runnable(){

            @Override
            public void run() {
                ARouter.getInstance().build("/Moment/CommentOrReply").withString("comment_id", momentId).withInt("from", from.getStatistic()).withString("token", token).navigation(context);
            }
        });
    }

    public static void toSubNavActivity(Context context, int tabId, LiveNavInfo info, SubLiveNavItem navItem) {
        Intent intent = new Intent(context, LivingSubNavActivity.class);
        intent.putExtra("sub_nav_info", (Parcelable)navItem);
        intent.putExtra("sub_nav_tab_id", tabId);
        intent.putExtra("living_nav_info", (Parcelable)info);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toOfflinePrivacy(Activity activity2) {
        MLog.info((String)TAG, (String)("toOfflinePrivacy activity:" + activity2));
        NavigationUtils.toJSSupportedWebView(activity2, LinkUriProvider.LOCAL_PRIVACY);
    }

    public static void toLianMaiFailed(Activity context) {
        String url = LinkUriProvider.LIANMAI_AUTH_FAILURE;
        MLog.info((String)TAG, (String)("toLianMaiFailed url =" + url));
        NavigationUtils.toJSSupportedWebView(context, url);
    }

    public static void toMain(Context context, String cvodid, int mNotifyId, NotificationCompat.Builder ncb, NotificationManager nm) {
        ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toMain(context, cvodid, mNotifyId, ncb, nm);
    }

    public static void toImUserReportActivity(long mineId, long userId, String path, Context context, int source) {
        Intent intent = new Intent(context, ReportActivity.class);
        intent.putExtra("report_mine_uid", mineId);
        intent.putExtra("report_user_uid", userId);
        intent.putExtra("report_file_path", path);
        intent.putExtra("source", source);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toChannelFilterFeedback(Context context, long sid, long ssid, int src, HashMap<String, String> extendInfo) {
        if (sid == 10L || ssid == 10L) {
            NavigationUtils.toFeedBack(context, null);
        } else {
            JoinChannelIntent.instance((long)sid, (long)ssid).src(src).extendInfo(extendInfo).build().joinChannel(context);
        }
    }

    public static void toMobileReplayLeave(Context context, boolean isIntentReplay, long praiseNum, long guestNum, long guanzhuNum, long timeLength, long anchorId, int mobileType, String replayId, String playurl, String bgImgurl, String mobileLiveTitle, String title, String errorMsg, long tid, long sid, long timeStart) {
        NavigationUtils.toMobileReplayLeave(context, isIntentReplay, praiseNum, guestNum, guanzhuNum, timeLength, anchorId, mobileType, replayId, playurl, bgImgurl, mobileLiveTitle, title, errorMsg, false, -1, tid, sid, timeStart);
    }

    public static void toMobileReplayLeave(Context context, boolean isIntentReplay, long praiseNum, long guestNum, long guanzhuNum, long timeLength, long anchorId, int mobileType, String replayId, String playurl, String bgImgurl, String mobileLiveTitle, String title, String errorMsg, boolean isLiveTurn, int leaveType, long tid, long sid, long timeStart) {
        NavigationUtils.toMobileReplayLeaveWithLandscapeLive(context, isIntentReplay, praiseNum, guestNum, guanzhuNum, timeLength, anchorId, mobileType, replayId, playurl, bgImgurl, mobileLiveTitle, title, errorMsg, isLiveTurn, leaveType, tid, sid, timeStart, false);
    }

    public static void toMobileReplayLeaveWithLandscapeLive(Context context, boolean isIntentReplay, long praiseNum, long guestNum, long guanzhuNum, long timeLength, long anchorId, int mobileType, String replayId, String playurl, String bgImgurl, String mobileLiveTitle, String title, String errorMsg, boolean isLiveTurn, int leaveType, long tid, long sid, long timeStart, boolean isLandscape) {
        Intent intent = new Intent("START_ACTION_REPLAY");
        intent.putExtra("KEY", "toMobileReplayLeaveWithLandscapeLive");
        intent.putExtra("isIntentReplay", isIntentReplay);
        intent.putExtra("praiseNum", praiseNum);
        intent.putExtra("guestNum", guestNum);
        intent.putExtra("guanzhuNum", guanzhuNum);
        intent.putExtra("timeLength", timeLength);
        intent.putExtra("anchorId", anchorId);
        intent.putExtra("mobileType", mobileType);
        intent.putExtra("replayId", replayId);
        intent.putExtra("playurl", playurl);
        intent.putExtra("bgImgurl", bgImgurl);
        intent.putExtra("mobileLiveTitle", mobileLiveTitle);
        intent.putExtra("title", title);
        intent.putExtra("errorMsg", errorMsg);
        intent.putExtra("isLiveTurn", isLiveTurn);
        intent.putExtra("LeaveType", leaveType);
        intent.putExtra("tid", tid);
        intent.putExtra("sid", sid);
        intent.putExtra("timeStart", timeStart);
        intent.putExtra("isLandscape", isLandscape);
        SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toMobileLivePersonalReplayActivity(Context context, long uid) {
        Intent intent = new Intent("START_ACTION_REPLAY");
        intent.putExtra("KEY", "toMobileLivePersonalReplayActivity");
        intent.putExtra("uid", uid);
        SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toMobileLiveReplayWithTitle(Context context, String replayId, long uid, String playUrl, String imgUrl, String title, int toMobileLiveReplayPath) {
        Intent intent = new Intent("START_ACTION_REPLAY");
        intent.putExtra("KEY", "toMobileLiveReplayWithTitle");
        intent.putExtra("replayId", replayId);
        intent.putExtra("uid", uid);
        intent.putExtra("playurl", playUrl);
        intent.putExtra("imgUrl", imgUrl);
        intent.putExtra("title", title);
        intent.putExtra("toMobileLiveReplayPath", toMobileLiveReplayPath);
        SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toMobileLivePricyLeave(Context context, int mobileType, boolean iskickoff, boolean isPricyReason, String errorMsg) {
        MLog.info((String)"toMobileLivePricyLeave", (String)("toMobileLivePricyLeave =" + iskickoff));
        Intent intent = new Intent("START_ACTION_MOBILE_LIVE");
        intent.putExtra("KEY", "toMobileLivePricyLeave");
        intent.putExtra("mobileType", mobileType);
        intent.putExtra("iskickoff", iskickoff);
        intent.putExtra("isPricyReason", isPricyReason);
        intent.putExtra("errorMsg", errorMsg);
        SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toCameraPerviewActivity(Context context, String key, String value) {
        MLog.info((String)TAG, (String)"toCameraPerviewActivity: startAction START_ACTION_MOBILE_LIVE");
        Intent intent = new Intent("START_ACTION_MOBILE_LIVE");
        intent.putExtra("KEY", "toCameraPerviewActivity");
        intent.putExtra("fromKey", key);
        intent.putExtra("fromValue", value);
        SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toCameraPerviewActivity(Context context) {
        Intent intent = new Intent("START_ACTION_MOBILE_LIVE");
        intent.putExtra("KEY", "toCameraPerviewActivity");
        SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toMobileLiveWithCidOfGuest(Context context, long cid) {
        Intent intent = new Intent("START_ACTION_MOBILE_LIVE");
        intent.putExtra("KEY", "toMobileLiveWithCidOfGuest");
        intent.putExtra("cid", cid);
        SmallProxy.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toVoiceRoom(final Context context) {
        PluginLoadingDialog.Companion.createLoader(context).withPlugin(Plugin.VoiceRoom).post(new Runnable(){

            @Override
            public void run() {
                SmallProxy.startAction((Intent)new Intent("START_ACTION_VOICE_HOMEPAGE"), (Activity)((Activity)context));
            }
        });
    }

    public static void toUnicomWspxActivity(Context context) {
        throw new UnsupportedOperationException("Wspx feature no longer support.");
    }

    public static void toGameCenter(Context context) {
        if (CoreFactory.getCore(IGameCenterCore.class) != null) {
            ((IGameCenterCore)CoreFactory.getCore(IGameCenterCore.class)).startPlugin(context);
        }
    }

    public static void toSafeCenterActivity(Context context) {
        Intent intent = new Intent(context, SafeCenterActivity.class);
        NavigationUtils.slideStartActivity(context, intent);
    }
}

