/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import com.yy.mobile.util.log.MLog;
import java.util.Hashtable;

public class FontUtils {
    private static final String TAG = "FontUtils";
    private static Hashtable<FontType, Typeface> fontCache = new Hashtable();

    public static Typeface getTypeFace(Context context, FontType fontType) {
        Typeface typeface = fontCache.get((Object)fontType);
        try {
            if (typeface == null) {
                switch (fontType) {
                    case DIN_MITTELSCHRIFT_ALTERNATE: 
                    case YY_Regular: {
                        typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/YY-Regular.ttf");
                        break;
                    }
                    case REFRIGERATOR_DELUXE_HEAVY: {
                        typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Refrigerator_Deluxe_Heavy.ttf");
                        break;
                    }
                }
                if (typeface != null) {
                    fontCache.put(fontType, typeface);
                } else {
                    MLog.info((String)TAG, (String)("[getTypeFace] can not get font from asset,fonttype=" + (Object)((Object)fontType)));
                }
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
            return null;
        }
        return typeface;
    }

    public static enum FontType {
        DIN_MITTELSCHRIFT_ALTERNATE,
        REFRIGERATOR_DELUXE_HEAVY,
        YY_Regular;

    }
}

