/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.social.nearby;

import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.live.livecore.JoinChannelIntent;
import com.yymobile.core.social.data.LiveItemInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;

public class NearByLivePopupNoticeFragment
extends BaseLinkFragment {
    private static final String EXTRA_LIVE_ITEM_INFO = "extra_live_item_info";
    private static final long DEFAULT_DISMISS_DELAY = 5000L;
    private LiveItemInfo liveInfo;
    private CircleImageView ivPortrait;
    private TextView tvName;
    private TextView tvDesc;

    public static NearByLivePopupNoticeFragment newInstance(LiveItemInfo info) {
        NearByLivePopupNoticeFragment fragment = new NearByLivePopupNoticeFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable(EXTRA_LIVE_ITEM_INFO, (Parcelable)info);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.liveInfo = (LiveItemInfo)this.getArguments().getParcelable(EXTRA_LIVE_ITEM_INFO);
        this.getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                NearByLivePopupNoticeFragment.this.getFragmentManager().beginTransaction().remove((Fragment)NearByLivePopupNoticeFragment.this).commitAllowingStateLoss();
            }
        }, 5000L);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.near_by_live_popup_notice, container, false);
        this.ivPortrait = (CircleImageView)rootView.findViewById(R.id.ivPortrait);
        this.tvName = (TextView)rootView.findViewById(R.id.tvName);
        this.tvDesc = (TextView)rootView.findViewById(R.id.tvDesc);
        rootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NearByLivePopupNoticeFragment.this.liveInfo != null) {
                    JoinChannelIntent.instance((long)((NearByLivePopupNoticeFragment)NearByLivePopupNoticeFragment.this).liveInfo.sid, (long)((NearByLivePopupNoticeFragment)NearByLivePopupNoticeFragment.this).liveInfo.ssid).anchorUid(((NearByLivePopupNoticeFragment)NearByLivePopupNoticeFragment.this).liveInfo.uid).src(6).templateId(((NearByLivePopupNoticeFragment)NearByLivePopupNoticeFragment.this).liveInfo.tpl).thumb(((NearByLivePopupNoticeFragment)NearByLivePopupNoticeFragment.this).liveInfo.thumb2).build().joinChannel(NearByLivePopupNoticeFragment.this.getContext());
                    NearByLivePopupNoticeFragment.this.sendPopupNoticeClickStatic();
                }
            }
        });
        this.updateLiveInfo();
        this.sendPopupNoticeLoadStatic();
        return rootView;
    }

    private void updateLiveInfo() {
        if (this.liveInfo != null) {
            ImageLoader.loadImage((RecycleImageView)this.ivPortrait, (String)this.liveInfo.thumb2, (int)R.drawable.default_portrait_140_140);
            this.tvName.setText((CharSequence)this.liveInfo.name);
            this.tvDesc.setText((CharSequence)this.liveInfo.desc);
        }
    }

    private void sendPopupNoticeLoadStatic() {
        ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50018", "0005");
    }

    private void sendPopupNoticeClickStatic() {
        ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50018", "0006");
    }
}

