/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.social.nearby;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProviders;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadmoreListener;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.RxBus;
import com.yy.mobile.abtest.ui.StyleNoDataResource;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.event.HomeTabClickEvent;
import com.yy.mobile.exposure.InactiveExposureManager;
import com.yy.mobile.exposure.NearByInactiveExMgr;
import com.yy.mobile.exposure.entry.InactiveBizType;
import com.yy.mobile.exposure.entry.InactiveExposureEntryLayout;
import com.yy.mobile.exposure.event.HideInactiveEntryEvent;
import com.yy.mobile.exposure.event.HomeLiveViewScrollEvent;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.perf.PerfSDK;
import com.yy.mobile.plugin.homepage.core.live.livecore.IHomepageLiveCore;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.HomeTabChangedEventArgs;
import com.yy.mobile.plugin.main.events.ILiveClient_hideLiveNoticeViewTips_EventArgs;
import com.yy.mobile.plugin.main.events.ISocialCoreClient_onNearByLivePopupNotice_EventArgs;
import com.yy.mobile.plugin.main.events.ISocialCoreClient_onNotifyNearByHiddenChanged_EventArgs;
import com.yy.mobile.plugin.main.events.ISocialCoreClient_onRequestNearByLive_EventArgs;
import com.yy.mobile.plugin.main.events.ISocialCoreClient_onResetPageNo_EventArgs;
import com.yy.mobile.plugin.main.events.ISocialSelectCityOrSexEventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.rain.RedPacketRainDialogManger;
import com.yy.mobile.sniper.EventBaseFragment;
import com.yy.mobile.statistic.StatisticService;
import com.yy.mobile.ui.cityselect.ChangeHomeNearByCityEvent;
import com.yy.mobile.ui.cityselect.bean.City;
import com.yy.mobile.ui.common.baselist.ItemTypeData;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.ui.home.LiveNoticeController;
import com.yy.mobile.ui.refreshutil.IRefreshToHead;
import com.yy.mobile.ui.social.CityOrSexMenuController;
import com.yy.mobile.ui.social.NearByNoDataFragment;
import com.yy.mobile.ui.social.common.IRadarAnimation;
import com.yy.mobile.ui.social.common.NearByLiveStore;
import com.yy.mobile.ui.social.common.RadarLayout;
import com.yy.mobile.ui.social.nearby.NearByLiveAdapter;
import com.yy.mobile.ui.social.nearby.NearByLiveFragment$$EventBinder;
import com.yy.mobile.ui.social.nearby.NearByLivePopupNoticeFragment;
import com.yy.mobile.ui.social.nearby.inactive.INearByLiveView;
import com.yy.mobile.ui.social.nearby.inactive.NearbyLiveViewModel;
import com.yy.mobile.ui.social.utils.LocationService;
import com.yy.mobile.ui.social.utils.NearStatisticUtil;
import com.yy.mobile.ui.widget.pager.PagerFragment;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.FaceHelper;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYSchedulers;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.CoreError;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.foundation.ILocationClient_onReceiveLocation_EventArgs;
import com.yymobile.core.foundation.LocationCache;
import com.yymobile.core.live.livenav.LiveNavInfo;
import com.yymobile.core.social.INearCore;
import com.yymobile.core.social.NearCoreImpl;
import com.yymobile.core.social.data.LiveItemInfo;
import com.yymobile.core.social.data.ThreeLiveInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.statistic.NearbyPageLoadCostSampling;
import com.yymobile.core.statistic.StatisticUtil;
import com.yymobile.core.user.UserInfo;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Route(path="/Nearby/Home", name="\u9644\u8fd1\u4e3b\u64ad")
@RouteDoc(desc="\u9644\u8fd1\u76f4\u64ad", minVer="7.16.0", eg="yymobile://Nearby/Home")
public class NearByLiveFragment
extends PagerFragment
implements IRefreshToHead,
INearByLiveView {
    public static final String BIZ_LIVING_NAV_TAB = "closeby";
    public static final String PREF_TEST_LOCATE_FAIL = "pref_test_locate_fail";
    public static final String KEY_LEAVE_TIME = "key_leave_time";
    private static final String TAG = "NearByLiveFragment";
    private static final String SHAREED_PREF_NAME_RADAR_LOADING = "shareed_pref_name_radar_loading";
    private View mRadarLayout;
    private IRadarAnimation mIRadarInterface;
    private CircleImageView mHeadImage;
    private RecyclerView mRecyclerView;
    private RefreshLayout mRefreshLayout;
    private NearByLiveAdapter mAdapter;
    private View mLocateTipsView;
    private boolean isLastPage = false;
    private int mPageNo = 1;
    private INearCore mSocialCore;
    private long leaveTime = 0L;
    private UserInfo mUserInfo;
    private boolean isHidden = false;
    private long now;
    private LiveItemInfo mPendingPopupNotice;
    private int mPagerIndex = -1;
    private List<Disposable> mDisposableList = new ArrayList<Disposable>();
    private Disposable refreshDispose;
    private ViewGroup selectLayout;
    private CityOrSexMenuController mCityOrSexMenuController;
    private List<ItemTypeData> mData = new ArrayList<ItemTypeData>();
    private NearbyLiveViewModel mViewModel;
    private InactiveExposureEntryLayout mNearByInactiveLayout;
    private FrameLayout mInactiveLayout;
    private boolean mIsInNearBy = false;
    private boolean mIsOutFromNearBy = false;
    int oldPos = 0;
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            NearByLiveFragment.this.mRefreshLayout.finishLoadmore();
            NearByLiveFragment.this.mRefreshLayout.finishRefresh();
            NearByLiveFragment.this.hideRadarLoading();
            if ((NearByLiveFragment.this.mAdapter == null || NearByLiveFragment.this.mAdapter.getItemCount() == 0) && (NearByLiveFragment.this.mRadarLayout != null && NearByLiveFragment.this.mRadarLayout.getVisibility() == 8 || NearByLiveFragment.this.mIRadarInterface != null && !NearByLiveFragment.this.mIRadarInterface.isRadarAnimationRunning())) {
                NearByLiveFragment.this.showNoNearByData(StyleNoDataResource.INSTANCE.getNoAnchorDrawableId(), R.string.str_no_data_near_by_live, R.string.attemp_to_refresh);
            }
            NearByLiveFragment.this.showLocateTips(!NearByLiveFragment.this.isLocationValid());
        }
    };
    Consumer<ISocialCoreClient_onRequestNearByLive_EventArgs> mRequestNearByLiveEventArgsConsumer = new Consumer<ISocialCoreClient_onRequestNearByLive_EventArgs>(){

        public void accept(ISocialCoreClient_onRequestNearByLive_EventArgs eventArgs) throws Exception {
            NearByLiveFragment.this.onRequestNearByLive(eventArgs);
        }
    };
    View.OnClickListener mOnclick = new View.OnClickListener(){

        public void onClick(View v) {
            NearByLiveFragment.this.loadFirstPage(true);
        }
    };
    private VirtualLayoutManager mVirtualLayoutManager;
    private boolean changeHomeNearByCityEventFlag;
    private EventBinder mEventBinder;

    public void onCreate(Bundle savedInstanceState) {
        Bundle args;
        super.onCreate(savedInstanceState);
        this.mSocialCore = NearCoreImpl.get();
        if (LoginUtil.isLogined()) {
            this.mUserInfo = CoreManager.getUserCore().getCacheLoginUserInfo();
        }
        if ((args = this.getArguments()) != null) {
            this.mPagerIndex = args.getInt("key_sub_page_index", -1);
        }
        MLog.debug((String)TAG, (String)("onCreate mPagerIndex = " + this.mPagerIndex));
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.layout_near_by_live_fragment, container, false);
        this.initView(view);
        if (savedInstanceState != null) {
            this.leaveTime = savedInstanceState.getLong(KEY_LEAVE_TIME, 0L);
            this.loadFirstPage(true);
        } else if (FP.empty(this.mData)) {
            this.loadFirstPage(true);
        } else {
            this.mAdapter.setData(this.mData, true, this.isLastPage);
            this.hideRadarLoading();
        }
        this.isSelected = true;
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.registerRxBus();
        IHomepageLiveCore liveCore = (IHomepageLiveCore)ICoreManagerBase.getCore(IHomepageLiveCore.class);
        int curPos = liveCore.getCurPos();
        List list = liveCore.getNavList();
        String biz = null;
        if (!FP.empty((Collection)list) && curPos >= 0 && list.size() > curPos) {
            biz = ((LiveNavInfo)list.get((int)curPos)).biz;
        }
        MLog.info((String)TAG, (String)("curPos:" + curPos + " biz:" + biz));
        if (this.mViewModel != null && this.getActivity() != null) {
            this.mViewModel.getShowEntry().observe((LifecycleOwner)this.getActivity(), (Observer)new Observer<Boolean>(){

                public void onChanged(Boolean isShow) {
                    MLog.info((String)NearByLiveFragment.TAG, (String)("getShowEntry isShow = " + isShow));
                    if (isShow.booleanValue()) {
                        NearByLiveFragment.this.showNearByInactiveLayout();
                    } else {
                        NearByLiveFragment.this.hideNearByInactiveLayout();
                    }
                }
            });
        }
    }

    private void showNearByInactiveLayout() {
        if (!this.checkActivityValid() || this.getContext() == null) {
            return;
        }
        if (this.getContext() == null) {
            return;
        }
        MLog.info((String)TAG, (String)"showNearByInactiveLayout start");
        if (this.mNearByInactiveLayout == null) {
            this.mNearByInactiveLayout = new InactiveExposureEntryLayout((EventBaseFragment)this, InactiveBizType.NEAR_BY);
            this.mInactiveLayout.addView(this.mNearByInactiveLayout.getRootView());
        }
        this.mNearByInactiveLayout.show(NearByInactiveExMgr.INSTANCE.getMNearbyEntryInfo());
    }

    private void hideNearByInactiveLayout() {
        if (this.mNearByInactiveLayout != null) {
            this.mNearByInactiveLayout.hide();
        }
        this.mNearByInactiveLayout = null;
        this.mInactiveLayout.removeAllViews();
    }

    @BusEvent
    public void onHideNearByLiveEntryLayout(HideInactiveEntryEvent event) {
        if (event.getType() == InactiveBizType.NEAR_BY) {
            YYSchedulers.mainThread.scheduleDirect(new Runnable(){

                @Override
                public void run() {
                    NearByLiveFragment.this.hideNearByInactiveLayout();
                }
            });
        }
    }

    @BusEvent
    public void onHomeTabClickEvent(HomeTabClickEvent event) {
        if (event.getInfo() != null && event.getInfo().getTabId() != null) {
            String id2 = event.getInfo().getTabId().getId();
            MLog.info((String)TAG, (String)("onHomeTabClickEvent id = " + id2));
            if (this.mViewModel != null && "/YY5LiveIndex/Home".equals(id2) && this.mViewModel.isInNearBy()) {
                this.mViewModel.handleEnterNearBy();
            }
        }
    }

    @BusEvent
    public void onHomeTabChangeEvent(HomeTabChangedEventArgs eventArgs) {
        if (eventArgs != null) {
            LiveNavInfo navInfo = eventArgs.getNavInfo();
            boolean inNearBy = BIZ_LIVING_NAV_TAB.equals(navInfo.biz);
            MLog.info((String)TAG, (String)("onHomeTabChangeEvent mInNearBy = " + inNearBy));
            if (inNearBy) {
                if (this.mViewModel != null) {
                    this.mViewModel.setInNearBy(true);
                    this.mIsOutFromNearBy = true;
                    this.mViewModel.handleEnterNearBy();
                }
            } else {
                if (this.mViewModel != null) {
                    this.mViewModel.setInNearBy(false);
                }
                if (this.mViewModel != null) {
                    boolean isNotInHomeTab = this.mViewModel.isNotHomeTab();
                    MLog.info((String)TAG, (String)("onHomeTabChangeEvent isNotInHomeTab = " + isNotInHomeTab));
                    if (this.mIsOutFromNearBy && !isNotInHomeTab) {
                        this.mIsOutFromNearBy = false;
                        this.mViewModel.unSelectedNearByLive();
                    }
                }
            }
        }
    }

    private void initSelectMenuLayout(View view) {
        this.selectLayout = (ViewGroup)view.findViewById(R.id.city_sex_select_bar);
        ViewGroup menuContainer = (ViewGroup)view.findViewById(R.id.select_menu);
        this.mCityOrSexMenuController = new CityOrSexMenuController(menuContainer, this.selectLayout);
    }

    private void initView(View view) {
        this.initSelectMenuLayout(view);
        this.mInactiveLayout = (FrameLayout)view.findViewById(R.id.nearby_inactive_layout);
        this.mRadarLayout = view.findViewById(R.id.radar_layout);
        this.mIRadarInterface = (RadarLayout)view.findViewById(R.id.radar_layout_animation);
        this.mHeadImage = (CircleImageView)view.findViewById(R.id.radar_circle_headImage);
        ((TextView)view.findViewById(R.id.nearby_search_tips)).setText(this.getText(R.string.nearby_live_search_tips));
        this.mRefreshLayout = (RefreshLayout)view.findViewById(R.id.near_by_refresh);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.near_by_list_view);
        NearByLiveStore.INSTANCE.setIndex(this.mPagerIndex);
        this.mVirtualLayoutManager = new VirtualLayoutManager(this.getContext());
        this.mAdapter = new NearByLiveAdapter(this.getContext(), this.mVirtualLayoutManager, this);
        MLog.debug((String)TAG, (String)("initView mPagerIndex = " + this.mPagerIndex));
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mVirtualLayoutManager);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mRefreshLayout.setEnableRefresh(true);
        this.mRefreshLayout.setOnRefreshLoadmoreListener(new OnRefreshLoadmoreListener(){

            public void onLoadmore(RefreshLayout refreshlayout) {
                MLog.info((String)NearByLiveFragment.TAG, (String)"[onLoadmore]");
                if (NearByLiveFragment.this.checkNetToast()) {
                    if (!NearByLiveFragment.this.isLastPage) {
                        NearByLiveFragment.this.loadMorePage();
                        NearByLiveFragment.this.mRefreshLayout.finishLoadmore(1000);
                    }
                } else {
                    NearByLiveFragment.this.mRefreshLayout.finishLoadmore();
                    NearByLiveFragment.this.mRefreshLayout.finishRefresh();
                    NearByLiveFragment.this.mRefreshLayout.setEnableLoadmore(false);
                }
            }

            public void onRefresh(RefreshLayout refreshlayout) {
                MLog.info((String)NearByLiveFragment.TAG, (String)"[onRefresh]");
                NearByLiveFragment.this.mRefreshLayout.setEnableLoadmore(true);
                NearByLiveFragment.this.hideStatus();
                NearByLiveFragment.this.loadFirstPage(false);
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("52301", "0012");
                NearByLiveFragment.this.mRefreshLayout.finishRefresh(1000);
                RedPacketRainDialogManger.INSTANCE.dealRefresh();
            }
        });
        this.mRecyclerView.clearOnScrollListeners();
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                MLog.debug((String)NearByLiveFragment.TAG, (String)("onScrollStateChanged :" + newState));
                if (!RedPacketRainDialogManger.INSTANCE.isNearByScrolled()) {
                    RedPacketRainDialogManger.INSTANCE.setNearByScrolled(true);
                }
                if (newState == 0) {
                    int lastVisiblePos = ((VirtualLayoutManager)recyclerView.getLayoutManager()).findLastVisibleItemPosition();
                    NearByLiveFragment.this.sendContentLoadStatic(lastVisiblePos);
                    MLog.debug((Object)NearByLiveFragment.TAG, (String)"lastVisiblePos:%s oldPos:%s", (Object[])new Object[]{lastVisiblePos, NearByLiveFragment.this.oldPos});
                } else {
                    NearByLiveFragment.this.oldPos = ((VirtualLayoutManager)recyclerView.getLayoutManager()).findLastVisibleItemPosition();
                }
                if (NearByInactiveExMgr.INSTANCE.isShowing()) {
                    NearByLiveFragment.this.mNearByInactiveLayout.scrollChangeEntryStatus(newState);
                }
                if (InactiveExposureManager.Companion.getInstance().isShowing()) {
                    RxBus.getDefault().post((Object)new HomeLiveViewScrollEvent(newState, InactiveBizType.HOME_PAGE));
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
            }
        });
        this.mViewModel = (NearbyLiveViewModel)ViewModelProviders.of((Fragment)this).get(NearbyLiveViewModel.class);
    }

    private void loadFirstPage(boolean showLoading) {
        MLog.info((String)TAG, (String)("[loadFirstPage] showLoading = " + showLoading));
        this.mPageNo = 1;
        if (showLoading) {
            if (!CommonPref.instance().getBoolean(SHAREED_PREF_NAME_RADAR_LOADING, false)) {
                this.showFirstRadarLoading();
                CommonPref.instance().putBoolean(SHAREED_PREF_NAME_RADAR_LOADING, true);
                return;
            }
            this.showRadarLoading();
        }
        this.getHandler().postDelayed(this.checkRequestTimeoutTask, 10000L);
        if (this.mSocialCore != null) {
            RxUtils.dispose((Disposable)this.refreshDispose);
            ((NearbyPageLoadCostSampling)StatisticService.instance().get(NearbyPageLoadCostSampling.class)).begin();
            PerfSDK.instance().start(50021, "nearby_page_load_timecost");
            this.refreshDispose = this.mSocialCore.requestNearByLiveWithSingle(this.mPageNo).subscribe(this.mRequestNearByLiveEventArgsConsumer, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) throws Exception {
                    MLog.error((Object)NearByLiveFragment.TAG, (Throwable)throwable);
                }
            });
            this.mDisposableList.add(this.refreshDispose);
        }
    }

    private void loadMorePage() {
        ++this.mPageNo;
        MLog.info((String)TAG, (String)("[loadMorePage] mPageNo = " + this.mPageNo));
        this.getHandler().postDelayed(this.checkRequestTimeoutTask, 10000L);
        if (this.mSocialCore != null) {
            this.mDisposableList.add(this.mSocialCore.requestNearByLiveWithSingle(this.mPageNo).subscribe(this.mRequestNearByLiveEventArgsConsumer, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) throws Exception {
                    MLog.error((Object)NearByLiveFragment.TAG, (Throwable)throwable);
                }
            }));
        }
    }

    public void onPause() {
        super.onPause();
        this.changeHomeNearByCityEventFlag = false;
        if (this.leaveTime == 0L) {
            this.leaveTime = System.currentTimeMillis();
        }
        if (this.mRefreshLayout.isRefreshing()) {
            this.mRefreshLayout.finishRefresh();
        }
    }

    public void onResume() {
        MLog.info((String)TAG, (String)"[onResume]");
        super.onResume();
        if (this.changeHomeNearByCityEventFlag) {
            this.refreshData();
            this.changeHomeNearByCityEventFlag = false;
        } else {
            this.onReturnPage();
        }
    }

    @Override
    public void handleLocationPop(int curPos) {
        MLog.info((String)TAG, (String)("handleLocationPop curPos = " + curPos));
        if (this.mViewModel != null) {
            this.mViewModel.handleLocationPop(curPos);
        }
    }

    @BusEvent
    public void onReceiveLocation(ILocationClient_onReceiveLocation_EventArgs busEventArgs) {
        long taskID = busEventArgs.getTaskID();
        LocationCache location = busEventArgs.getLocation();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("onReceiveLocation: " + location));
        }
        this.showLocateTips(location == null || CommonPref.instance().getBoolean(PREF_TEST_LOCATE_FAIL, false));
    }

    private void showDefaultHeadImage() {
        if (LoginUtil.isLogined() && this.mUserInfo != null) {
            if (this.mUserInfo.iconIndex == 0 && !StringUtils.isEmptyString((String)this.mUserInfo.iconUrl_144_144)) {
                FaceHelper.loadFace((String)this.mUserInfo.iconUrl_144_144, (int)this.mUserInfo.iconIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)this.mHeadImage, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait_140_140);
            } else {
                FaceHelper.loadFace((String)this.mUserInfo.iconUrl, (int)this.mUserInfo.iconIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)this.mHeadImage, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait_140_140);
            }
            MLog.info((String)TAG, (String)("[showDefaultHeadImage]: mUserInfo = " + this.mUserInfo));
        } else {
            FaceHelper.loadFace((String)"", (int)-1, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)this.mHeadImage, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait_140_140);
        }
    }

    private void registerRxBus() {
        this.mDisposableList.add(RxBus.getDefault().register(ChangeHomeNearByCityEvent.class).subscribe((Consumer)new Consumer<ChangeHomeNearByCityEvent>(){

            public void accept(ChangeHomeNearByCityEvent event) throws Exception {
                MLog.info((String)NearByLiveFragment.TAG, (String)"[registerRxBus] ChangeHomeNearByCityEvent");
                NearByLiveFragment.this.changeHomeNearByCityEventFlag = true;
            }
        }, RxUtils.errorConsumer((String)TAG)));
    }

    @BusEvent(busType=1)
    public void onCityOrSexChangeEvent(ISocialSelectCityOrSexEventArgs event) {
        MLog.info((String)TAG, (String)("onCityOrSexChangeEvent, city: " + event.getDesCity() + "; sex: " + event.getDesSex()));
        City city = event.getDesCity();
        if (city != null) {
            NearCoreImpl.get().setHomeLiveNearBySelectedLocation(city.getCode(), city.getName());
            ChangeHomeNearByCityEvent e = new ChangeHomeNearByCityEvent();
            e.desCity = city;
            RxBus.getDefault().post((Object)e);
            this.forceRefreshWhenRefreshing();
        }
        if (event.getDesSex() != null) {
            NearCoreImpl.get().setmGender(event.getDesSex().ordinal());
            this.forceRefreshWhenRefreshing();
        }
        if (city == null && event.getDesSex() == null && this.selectLayout != null) {
            this.selectLayout.setVisibility(0);
            this.mCityOrSexMenuController.init();
        }
    }

    private void forceRefreshWhenRefreshing() {
        MLog.info((String)TAG, (String)"forceRefreshWhenRefreshing");
        if (this.mRecyclerView != null) {
            RefreshState refreshState = this.mRefreshLayout.getState();
            MLog.info((String)TAG, (String)("forceRefreshWhenRefreshing state:" + refreshState.name()));
            if (this.mRefreshLayout.getState() != RefreshState.None) {
                this.loadFirstPage(false);
            } else {
                this.mRefreshLayout.autoRefresh();
                this.mRecyclerView.smoothScrollToPosition(0);
            }
        }
    }

    private void showFirstRadarLoading() {
        MLog.info((String)TAG, (String)"[showFirstRadarLoading]");
        if (this.mRadarLayout != null && this.mRecyclerView != null) {
            if (this.mIRadarInterface != null && !this.mIRadarInterface.isRadarAnimationRunning()) {
                this.hideStatus();
                this.mRecyclerView.setVisibility(8);
                this.showDefaultHeadImage();
                this.mIRadarInterface.startRadarAnimation();
                this.mRadarLayout.setVisibility(0);
                this.mRadarLayout.setBackgroundResource(R.drawable.bkg_radar_layout);
                this.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (NearByLiveFragment.this.mIRadarInterface != null && NearByLiveFragment.this.mIRadarInterface.isRadarAnimationRunning()) {
                            NearByLiveFragment.this.getHandler().postDelayed(NearByLiveFragment.this.checkRequestTimeoutTask, 10000L);
                            if (NearByLiveFragment.this.mSocialCore != null) {
                                NearByLiveFragment.this.mDisposableList.add(NearByLiveFragment.this.mSocialCore.requestNearByLiveWithSingle(NearByLiveFragment.this.mPageNo).subscribe(NearByLiveFragment.this.mRequestNearByLiveEventArgsConsumer, (Consumer)new Consumer<Throwable>(){

                                    public void accept(Throwable throwable) throws Exception {
                                        MLog.error((Object)NearByLiveFragment.TAG, (Throwable)throwable);
                                    }
                                }));
                            }
                        }
                    }
                }, 2000L);
            } else {
                this.showLoading();
            }
        }
    }

    private void showRadarLoading() {
        if (this.mRadarLayout != null && this.mRecyclerView != null) {
            if (this.mIRadarInterface != null && !this.mIRadarInterface.isRadarAnimationRunning()) {
                this.hideStatus();
                this.mRecyclerView.setVisibility(8);
                this.showDefaultHeadImage();
                this.mIRadarInterface.startRadarAnimation();
                this.mRadarLayout.setVisibility(0);
                try {
                    this.mRadarLayout.setBackgroundResource(R.drawable.bkg_radar_layout);
                }
                catch (OutOfMemoryError e) {
                    this.mRadarLayout.setBackgroundDrawable(null);
                    MLog.info((String)TAG, (String)"showRadarLoading setBackgroundResource OOM");
                }
                this.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (NearByLiveFragment.this.mIRadarInterface != null && NearByLiveFragment.this.mIRadarInterface.isRadarAnimationRunning()) {
                            NearByLiveFragment.this.mIRadarInterface.stopRadarAnimation();
                            NearByLiveFragment.this.mRadarLayout.setVisibility(8);
                            NearByLiveFragment.this.mRadarLayout.setBackgroundDrawable(null);
                            NearByLiveFragment.this.mRecyclerView.setVisibility(0);
                        }
                    }
                }, 10000L);
            } else {
                this.showLoading();
            }
        }
    }

    private void hideRadarLoading() {
        if (this.mRadarLayout != null) {
            this.mRadarLayout.setVisibility(8);
            this.mRadarLayout.setBackgroundDrawable(null);
            if (this.mIRadarInterface != null && this.mIRadarInterface.isRadarAnimationRunning()) {
                this.mIRadarInterface.stopRadarAnimation();
            }
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.setVisibility(0);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.leaveTime == 0L) {
            this.leaveTime = System.currentTimeMillis();
        }
        outState.putLong(KEY_LEAVE_TIME, this.leaveTime);
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mIRadarInterface != null) {
            this.mIRadarInterface.onReleaseRadarResource();
        }
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        }
        RxUtils.dispose((Disposable)this.refreshDispose);
        if (this.mDisposableList != null && !this.mDisposableList.isEmpty()) {
            for (Disposable disposable2 : this.mDisposableList) {
                if (disposable2 == null || disposable2.isDisposed()) continue;
                disposable2.dispose();
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onNotifyNearByHiddenChanged(ISocialCoreClient_onNotifyNearByHiddenChanged_EventArgs busEventArgs) {
        boolean hidden = busEventArgs.getHidden();
        MLog.info((String)TAG, (String)("[onNotifyNearByHiddenChanged] hidden " + hidden));
        if (hidden) {
            this.isHidden = true;
            if (this.leaveTime == 0L) {
                this.leaveTime = System.currentTimeMillis();
            }
        } else {
            this.isHidden = false;
            this.onReturnPage();
        }
    }

    private void showLivePage(List<ItemTypeData> data, boolean isClean, boolean isLastPage) {
        MLog.info((Object)TAG, (String)"showLivePage isClean: %s isLastPage: %s", (Object[])new Object[]{isClean, isLastPage});
        if (FP.empty(data) && this.mAdapter.getItemCount() == 0) {
            --this.mPageNo;
            this.mAdapter.clearData();
            this.mData.clear();
            if (this.isNetworkAvailable()) {
                this.showNoNearByData(StyleNoDataResource.INSTANCE.getNoAnchorDrawableId(), R.string.str_no_data_near_by_live, R.string.attemp_to_refresh);
            } else {
                this.showNetworkErr();
            }
        } else {
            if (FP.empty(data) && !this.checkNetToast()) {
                return;
            }
            MLog.info((Object)TAG, (String)"showLivePage data size: %s", (Object[])new Object[]{data.size()});
            this.mAdapter.setData(data, isClean, isLastPage);
            if (isClean) {
                this.mData.clear();
            }
            this.mData.addAll(data);
            if (isLastPage) {
                this.mData.add(new ItemTypeData(210));
            }
            this.mRefreshLayout.setEnableLoadmore(!isLastPage);
            this.sendModuleLoadStatic(data, isClean);
        }
        StatisticUtil.instance().getCostStatistic("nearby_page_load_timecost").end();
    }

    private void sendModuleLoadStatic(List<ItemTypeData> data, boolean isFirstPage) {
        if (FP.empty(data)) {
            return;
        }
        boolean hasRecommendLive = false;
        for (ItemTypeData item : data) {
            if (item.moduleType != 240) continue;
            hasRecommendLive = true;
            break;
        }
        if (hasRecommendLive) {
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic("50018", "0001");
        }
        if (!isFirstPage) {
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic("50018", "0003");
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onResetPageNo(ISocialCoreClient_onResetPageNo_EventArgs busEventArgs) {
        int pageNo = busEventArgs.getPageNo();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("onResetPageNo: " + pageNo));
        }
        this.mPageNo = pageNo;
        if (pageNo == 1) {
            this.showLoading();
            this.getHandler().postDelayed(this.checkRequestTimeoutTask, 10000L);
            if (this.mSocialCore != null) {
                this.mDisposableList.add(this.mSocialCore.requestNearByLiveWithSingle(this.mPageNo).subscribe(this.mRequestNearByLiveEventArgsConsumer, (Consumer)new Consumer<Throwable>(){

                    public void accept(Throwable throwable) throws Exception {
                        MLog.error((Object)NearByLiveFragment.TAG, (Throwable)throwable);
                    }
                }));
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onRequestNearByLive(ISocialCoreClient_onRequestNearByLive_EventArgs busEventArgs) {
        List data = busEventArgs.getData();
        boolean isLast = busEventArgs.getIsLast();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("onRequestNearByLive isLast:" + isLast + ", data:" + data));
        }
        this.isLastPage = isLast;
        this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.mRefreshLayout.finishLoadmore();
        this.mRefreshLayout.finishRefresh();
        this.hideStatus();
        this.hideRadarLoading();
        if (this.mPageNo == 1) {
            this.mRecyclerView.clearFocus();
            this.mRecyclerView.post(new Runnable(){

                @Override
                public void run() {
                    NearByLiveFragment.this.mRecyclerView.smoothScrollToPosition(0);
                }
            });
            this.showLivePage(data, true, isLast);
            ((NearbyPageLoadCostSampling)StatisticService.instance().get(NearbyPageLoadCostSampling.class)).end();
            PerfSDK.instance().end(50021, "nearby_page_load_timecost");
            this.sendAccessStatic();
        } else {
            this.showLivePage(data, false, isLast);
        }
        this.showLocateTips(!this.isLocationValid());
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onNearByLivePopupNotice(ISocialCoreClient_onNearByLivePopupNotice_EventArgs busEventArgs) {
        LiveItemInfo info = busEventArgs.getInfo();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("onNearByLivePopupNotice: " + info));
        }
        this.mPendingPopupNotice = info;
        this.showPopupNotice(0L);
    }

    @BusEvent
    public void hideLiveNoticeViewTips(ILiveClient_hideLiveNoticeViewTips_EventArgs busEventArgs) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)"hideLiveNoticeViewTips");
        }
        if (this.mPendingPopupNotice != null) {
            this.showPopupNotice(3000L);
        }
    }

    private void showPopupNotice(long delayMillis) {
        this.getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (NearByLiveFragment.this.mPendingPopupNotice != null && LiveNoticeController.getInstance().getLiveNoticeTips() == 0) {
                    NearByLiveFragment.this.getChildFragmentManager().beginTransaction().replace(R.id.flPopupNotice, (Fragment)NearByLivePopupNoticeFragment.newInstance(NearByLiveFragment.this.mPendingPopupNotice)).commitAllowingStateLoss();
                    NearByLiveFragment.this.mPendingPopupNotice = null;
                }
            }
        }, delayMillis);
    }

    private void mustRefreshToHead() {
        MLog.info((String)TAG, (String)"[mustRefreshToHead]");
        if (this.mRecyclerView != null) {
            this.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    NearByLiveFragment.this.mRecyclerView.smoothScrollToPosition(0);
                }
            }, 10L);
            this.mRefreshLayout.autoRefresh();
        }
    }

    private void onReturnPage() {
        MLog.info((String)TAG, (String)("[onReturnPage] isHidden = " + this.isHidden + ", isSelected = " + this.isSelected));
        if (!this.isHidden && this.isSelected) {
            this.now = System.currentTimeMillis();
            MLog.info((String)TAG, (String)("[onReturnPage] now = " + this.now + ", leaveTime = " + this.leaveTime + "now - leaveTime = " + (this.now - this.leaveTime)));
            if (this.leaveTime != 0L && this.now - this.leaveTime > 120000L) {
                this.mustRefreshToHead();
            }
            this.leaveTime = 0L;
        }
    }

    public View.OnClickListener getLoadListener() {
        return this.mOnclick;
    }

    public View.OnClickListener getNoMobileLiveDataListener() {
        return this.mOnclick;
    }

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long uid = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        if (info != null && LoginUtil.getUid() == info.userId) {
            this.mUserInfo = info;
            this.showDefaultHeadImage();
        }
    }

    public void onSelected(int position) {
        MLog.info((String)TAG, (String)("[onSelected] position = " + position));
        super.onSelected(position);
        this.isSelected = true;
        this.onReturnPage();
        this.sendAccessStatic();
        ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).setCurPos(position);
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onUnSelected(int position) {
        MLog.info((String)TAG, (String)("[onUnSelected] position = " + position));
        super.onUnSelected(position);
        this.isSelected = false;
        if (this.leaveTime == 0L) {
            this.leaveTime = System.currentTimeMillis();
        }
    }

    private void sendAccessStatic() {
        Property property = new Property();
        property.putString("key1", LocationService.isHasLocationPermission(this.getContext()) ? "1" : "0");
        ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic("52301", "0001", (Serializable)property);
        if (this.mRecyclerView != null) {
            int last = ((VirtualLayoutManager)this.mRecyclerView.getLayoutManager()).findLastVisibleItemPosition();
            if (last > 0) {
                this.sendContentLoadStatic(last);
            } else {
                this.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        NearByLiveFragment.this.sendContentLoadStatic(((VirtualLayoutManager)NearByLiveFragment.this.mRecyclerView.getLayoutManager()).findLastVisibleItemPosition());
                    }
                }, 1000L);
            }
        }
    }

    private void sendContentLoadStatic(int count) {
        MLog.info((Object)TAG, (String)"sendContentLoadStatic:%s", (Object[])new Object[]{count});
        if (count > 0) {
            int start;
            for (int i = start = (start = ((VirtualLayoutManager)this.mRecyclerView.getLayoutManager()).findFirstVisibleItemPosition()) < 0 ? 0 : start; i < count && i < this.mAdapter.getItemCount(); ++i) {
                Object item = this.mAdapter.getItem(i);
                if (!(item instanceof ItemTypeData)) continue;
                ItemTypeData itemTypeData = (ItemTypeData)item;
                if (!(itemTypeData.data instanceof ThreeLiveInfo)) continue;
                ThreeLiveInfo threeLiveInfo = (ThreeLiveInfo)itemTypeData.data;
                if (this.mPagerIndex != ((IHomepageLiveCore)ICoreManagerBase.getCore(IHomepageLiveCore.class)).getCurPos()) continue;
                NearStatisticUtil.INSTANCE.nearExposure(threeLiveInfo);
            }
        }
    }

    public void refreshData() {
        MLog.info((String)TAG, (String)"[refreshData]");
        if (this.mRecyclerView != null && !this.mRefreshLayout.isRefreshing()) {
            this.mRefreshLayout.autoRefresh();
            this.mRecyclerView.smoothScrollToPosition(0);
        }
    }

    private boolean isLocationValid() {
        return this.mSocialCore.getIsBDLocationValid() && !CommonPref.instance().getBoolean(PREF_TEST_LOCATE_FAIL, false);
    }

    private void showLocateTips(boolean show2) {
        if (show2) {
            if (this.mLocateTipsView == null) {
                this.mLocateTipsView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_near_by_locate_tips_newstyle, (ViewGroup)this.mRecyclerView, false);
            }
            this.mAdapter.addLocationTipsWithHeader();
        } else if (this.mLocateTipsView != null) {
            this.mAdapter.removeLocationTipsWithHeader();
        }
    }

    public void showNoNearByData(int drawable2, int tips, int btn) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.getView() == null) {
            MLog.error((String)TAG, (String)"showNoNearByData getView is NULL");
            return;
        }
        View view = this.getView().findViewById(R.id.status_layout);
        if (view == null || view.getId() == -1) {
            MLog.error((String)TAG, (String)"had not set layout id");
            return;
        }
        NearByNoDataFragment fragment = NearByNoDataFragment.newInstance(drawable2, tips, btn);
        fragment.setListener(this.getLoadListener());
        this.getChildFragmentManager().beginTransaction().replace(view.getId(), (Fragment)fragment, "STATUS_TAG").commitAllowingStateLoss();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new NearByLiveFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

