/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.social.adapter;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.social.utils.NearStatisticUtil;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.live.livedata.HomeTagInfo;
import java.util.ArrayList;
import java.util.List;

public class TagRecyclerViewAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = "TagRecyclerViewAdapter";
    private List<HomeTagInfo> mData = new ArrayList<HomeTagInfo>();
    private Context mContext;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();

    public TagRecyclerViewAdapter(Context mContext) {
        this.mContext = mContext;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hp_item_living_tag_newstyle, null);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(final @NonNull ViewHolder holder, final int position) {
        int flag;
        if (position >= this.mData.size()) {
            return;
        }
        final HomeTagInfo item = this.mData.get(position);
        holder.mHotmageView.setVisibility(8);
        final String key = "hotspot_nearby_" + item.id;
        if (item.hotSpot > 0 && item.hotSpot > (flag = CommonPref.instance().getInt(key, 0))) {
            holder.mHotmageView.setVisibility(0);
        }
        holder.mWrapLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TagRecyclerViewAdapter.this.mTimeSlotTool.isProcessing()) {
                    return;
                }
                if (holder.mHotmageView.getVisibility() == 0) {
                    CommonPref.instance().putInt(key, item.hotSpot);
                }
                TagRecyclerViewAdapter.this.notifyItemChanged(position);
                ARouter.getInstance().build(Uri.parse((String)item.url)).navigation(TagRecyclerViewAdapter.this.mContext);
                NearStatisticUtil.INSTANCE.tagListItemClick(item.id);
            }
        });
        holder.mTitle.setText((CharSequence)item.name);
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public void setData(List<HomeTagInfo> datas) {
        this.mData.clear();
        this.mData.addAll(datas);
        this.notifyDataSetChanged();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ImageView mHotmageView;
        public TextView mTitle;
        public View mWrapLayout;

        public ViewHolder(View v) {
            super(v);
            this.mTitle = (TextView)v.findViewById(R.id.txt_title);
            this.mHotmageView = (ImageView)v.findViewById(R.id.img_tips);
            this.mWrapLayout = v.findViewById(R.id.tag_Wrap_layout);
        }
    }
}

