/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.social;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.common.AbsStatusFragment;
import com.yy.mobile.util.NetworkUtils;

public class NearByNoDataFragment
extends AbsStatusFragment {
    public static final String TIP_PARAM = "TIP_PARAM";
    public static final String DRAWABLE_PARAM = "DRAWABLE_PARAM";
    public static final String BTN_PARAM = "BTN_PARAM";
    private int mTip;
    private int mDrawable;
    private int mBtn;
    private View.OnClickListener mSelfListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!NetworkUtils.isNetworkStrictlyAvailable((Context)NearByNoDataFragment.this.getActivity())) {
                NearByNoDataFragment.this.checkNetToast();
                return;
            }
            if (NearByNoDataFragment.this.mLoadListener != null) {
                NearByNoDataFragment.this.mLoadListener.onClick(v);
            }
        }
    };

    public static NearByNoDataFragment newInstance(int drawable2, int tips, int btn) {
        Bundle bundle = new Bundle();
        bundle.putInt(TIP_PARAM, tips);
        bundle.putInt(DRAWABLE_PARAM, drawable2);
        bundle.putInt(BTN_PARAM, btn);
        NearByNoDataFragment fragment = new NearByNoDataFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        TextView btn;
        RecycleImageView imageView;
        TextView textView;
        View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.fragment_no_data_near_by, container, false);
        view.setOnClickListener(this.mSelfListener);
        if (savedInstanceState != null) {
            this.mTip = savedInstanceState.getInt(TIP_PARAM, 0);
            this.mDrawable = savedInstanceState.getInt(DRAWABLE_PARAM, 0);
            this.mBtn = savedInstanceState.getInt(BTN_PARAM, 0);
        } else {
            Bundle bundle = this.getArguments();
            if (bundle != null) {
                this.mTip = bundle.getInt(TIP_PARAM, 0);
                this.mDrawable = bundle.getInt(DRAWABLE_PARAM, 0);
                this.mBtn = bundle.getInt(BTN_PARAM, 0);
            }
        }
        if (this.mTip > 0 && (textView = (TextView)view.findViewById(R.id.near_by_no_data_txt)) != null) {
            textView.setText((CharSequence)this.getResources().getString(this.mTip));
        }
        if (this.mDrawable > 0 && (imageView = (RecycleImageView)view.findViewById(R.id.near_by_no_data_icon)) != null) {
            ImageLoader.loadImageResource((int)this.mDrawable, (RecycleImageView)imageView, (ImageConfig)ImageConfig.fullImageConfig());
            imageView.setImageResource(this.mDrawable);
        }
        if ((btn = (TextView)view.findViewById(R.id.near_by_no_data_btn)) != null) {
            if (this.mBtn > 0) {
                btn.setText((CharSequence)this.getResources().getString(this.mBtn));
            } else {
                btn.setVisibility(8);
            }
        }
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(TIP_PARAM, this.mTip);
        outState.putInt(DRAWABLE_PARAM, this.mDrawable);
        outState.putInt(BTN_PARAM, this.mBtn);
    }
}

