/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.sharpgirls;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.util.Base64Utils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebViewUtils {
    private static final String TAG = "WebViewUtils";

    public static String handleImageToBase64JsonStr(String[] clipPaths) {
        if (clipPaths != null && clipPaths.length > 0) {
            JSONArray bitmapJsonArray = new JSONArray();
            for (String clipPath : clipPaths) {
                JSONObject jsonObject = WebViewUtils.handleImageToBase64(clipPath, 1080, 1080);
                if (jsonObject == null) continue;
                bitmapJsonArray.put((Object)jsonObject);
            }
            if (bitmapJsonArray.length() > 0) {
                MLog.info((String)TAG, (String)("handleImageToBase64JsonStr imgSizes = " + bitmapJsonArray.length()));
                return bitmapJsonArray.toString();
            }
        }
        return "";
    }

    public static String handleImageToBase64JsonStrWithCompress(List<String> clipPaths, int reqWidth, int reqHeight) {
        if (clipPaths != null && clipPaths.size() > 0) {
            JSONArray bitmapJsonArray = new JSONArray();
            for (int i = 0; i < clipPaths.size(); ++i) {
                JSONObject jsonObject = WebViewUtils.handleImageToBase64(clipPaths.get(i), reqWidth, reqHeight);
                if (jsonObject == null) continue;
                bitmapJsonArray.put((Object)jsonObject);
            }
            if (bitmapJsonArray.length() > 0) {
                MLog.info((String)TAG, (String)("handleImageToBase64JsonStr imgSizes = " + bitmapJsonArray.length()));
                return bitmapJsonArray.toString();
            }
        }
        return "";
    }

    public static JSONObject handleImageToBase64(String imgPath, int reqWidth, int reqHeight) {
        if (FP.empty((CharSequence)imgPath)) {
            MLog.warn((String)TAG, (String)"handleImageToBase64 imgPath is null");
            return null;
        }
        JSONObject bitmapJsonObject = null;
        OutputStream baos = null;
        Bitmap bitmap = null;
        int quality = 100;
        try {
            int inSampleSize;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)options);
            options.inSampleSize = inSampleSize = ImageUtil.calculateInSampleSize((BitmapFactory.Options)options, (int)reqWidth, (int)reqHeight);
            MLog.info((String)TAG, (String)("handleImageToBase64 options w = " + options.outWidth + ", h = " + options.outHeight + ", req w = " + reqWidth + ", h = " + reqHeight + ", simple = " + options.inSampleSize));
            options.inJustDecodeBounds = false;
            baos = new ByteArrayOutputStream();
            bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)options);
            int pos = imgPath.lastIndexOf(".");
            String suffix = null;
            if (pos + 1 < imgPath.length()) {
                suffix = imgPath.substring(pos + 1, imgPath.length());
            }
            if (!FP.empty(suffix) && (suffix.equalsIgnoreCase("jpg") || suffix.equalsIgnoreCase("jpeg"))) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, quality, baos);
            } else {
                bitmap.compress(Bitmap.CompressFormat.PNG, quality, baos);
            }
            String base64Img = Base64Utils.encodeToString((byte[])((ByteArrayOutputStream)baos).toByteArray(), (int)2);
            MLog.info((String)TAG, (String)("handleImageToBase64 nowOptions w = " + options.outWidth + ", h = " + options.outHeight + ", inSampleSize = " + options.inSampleSize + ", base64ImgSize = " + base64Img.length() + ", baos size = " + ((ByteArrayOutputStream)baos).toByteArray().length));
            bitmapJsonObject = new JSONObject();
            bitmapJsonObject.put("thumbnail", (Object)base64Img);
            bitmapJsonObject.put("localFileName", (Object)imgPath);
            ((ByteArrayOutputStream)baos).close();
            bitmap.recycle();
            bitmap = null;
            baos = null;
        }
        catch (Throwable t) {
            if (baos != null) {
                try {
                    baos.flush();
                    ((ByteArrayOutputStream)baos).close();
                }
                catch (IOException e) {
                    MLog.error((String)TAG, (String)("handleImageToBase64 IOException = " + e.getMessage()));
                }
            }
            if (bitmap != null) {
                bitmap.recycle();
            }
            MLog.error((String)TAG, (String)("handleImageToBase64 error msg = " + t + ", imgPath = " + imgPath));
        }
        return bitmapJsonObject;
    }

    public static String getUrlParam(String param, String url) {
        MLog.info((String)TAG, (String)("getUrlParam param = " + param + ", url = " + url));
        String result = "";
        Pattern p = Pattern.compile("(\\?|&+)" + param + "=([^&]*)");
        Matcher m = p.matcher(url);
        while (m.find()) {
            try {
                result = m.group(2);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                result = "";
            }
            catch (Throwable e) {
                result = "";
            }
        }
        return result;
    }
}

