/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.share.ui;

import android.app.Dialog;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentManager;
import com.yy.immersion.ImmersionBar;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.share.SharePlatform;
import com.yy.mobile.ui.share.model.ShareModule;
import com.yy.mobile.ui.share.model.ShareModuleFactory;
import com.yy.mobile.ui.share.presenter.SharePresenter;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.shenqu.ShenquUtils;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.File;

public class ShareComponent
extends DialogFragment {
    public static final String TAG = "ShareComponent";
    public static final String SHARE_MODULE_ARGS_TYPE = "SHARE_MODULE_ARGS_TYPE";
    public static final String SHARE_MODULE_ARGS_BIZ = "SHARE_MODULE_ARGS_BIZ";
    public static final String SHARE_MODULE_ARGS_JSON = "SHARE_MODULE_ARGS_JSON";
    private ShareModule module;
    private RelativeLayout placeHolder;
    private ImageView imgQq;
    private ImageView imgWechat;
    private ImageView imgComment;
    private ImageView imgQzone;
    private ImageView imgSina;
    private ImageView ivClose;
    private SharePresenter mPresenter;
    protected String biz;
    protected int type;
    protected String json;
    private View.OnClickListener noDoubleClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v.getId() == R.id.img_qq) {
                this.handleShare(SharePlatform.QQ);
            } else if (v.getId() == R.id.img_wechat) {
                this.handleShare(SharePlatform.Wechat);
            } else if (v.getId() == R.id.img_comment) {
                this.handleShare(SharePlatform.WechatMoments);
            } else if (v.getId() == R.id.img_qzone) {
                this.handleShare(SharePlatform.QZone);
            } else if (v.getId() == R.id.img_sina) {
                this.handleShare(SharePlatform.Sina_Weibo);
            } else if (v.getId() == R.id.iv_close) {
                ShareComponent.this.dismiss();
            }
        }

        private void handleShare(final SharePlatform sharePlatform) {
            MLog.info((String)ShareComponent.TAG, (String)("handleShare " + sharePlatform.name()));
            long timestamp = System.currentTimeMillis();
            File screenShotDir = new File(ShenquUtils.getVideoScreenDir());
            final String filePath = screenShotDir.getAbsolutePath() + File.separator + "game_share_" + timestamp + ".png";
            final Bitmap bitmap = ShareComponent.this.mPresenter.getCacheBitmapFromView((View)ShareComponent.this.placeHolder);
            Observable.just((Object)"").observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<String>(){

                public void accept(@NonNull String ignore) throws Exception {
                    MLog.info((String)ShareComponent.TAG, (String)("mFilePath:" + filePath));
                    if (bitmap != null) {
                        if (ShareComponent.this.mPresenter.saveBitmapToSdCard(bitmap, filePath)) {
                            ShareComponent.this.mPresenter.sharePic(filePath, sharePlatform);
                        } else {
                            MLog.error((String)ShareComponent.TAG, (String)"saveBitmapToSdCard failed ");
                        }
                    } else {
                        MLog.error((String)ShareComponent.TAG, (String)"sharePic,bitmap == null ");
                    }
                }
            }, RxUtils.errorConsumer((String)ShareComponent.TAG));
            ShareComponent.this.dismiss();
        }
    };

    public static void show(String biz, int type, String json, FragmentManager manager) {
        ShareComponent component = new ShareComponent();
        Bundle bundle = new Bundle();
        bundle.putString(SHARE_MODULE_ARGS_BIZ, biz);
        bundle.putInt(SHARE_MODULE_ARGS_TYPE, type);
        bundle.putString(SHARE_MODULE_ARGS_JSON, json);
        component.setArguments(bundle);
        component.show(manager, "\u5566\u5566\u5566\u5566");
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.json = this.getArguments().getString(SHARE_MODULE_ARGS_JSON);
            this.biz = this.getArguments().getString(SHARE_MODULE_ARGS_BIZ);
            this.type = this.getArguments().getInt(SHARE_MODULE_ARGS_TYPE);
            this.module = ShareModuleFactory.getShareModule(this.biz, this.type, this.json);
            this.mPresenter = new SharePresenter(this.getContext(), this.module);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_game_share_component, container, false);
        this.placeHolder = (RelativeLayout)view.findViewById(R.id.rl_place_holder);
        if (this.module != null) {
            this.module.getContentView(this.getContext(), inflater, (ViewGroup)this.placeHolder);
        }
        this.ivClose = (ImageView)view.findViewById(R.id.iv_close);
        this.imgQq = (ImageView)view.findViewById(R.id.img_qq);
        this.imgQzone = (ImageView)view.findViewById(R.id.img_qzone);
        this.imgWechat = (ImageView)view.findViewById(R.id.img_wechat);
        this.imgComment = (ImageView)view.findViewById(R.id.img_comment);
        this.imgSina = (ImageView)view.findViewById(R.id.img_sina);
        this.ivClose.setOnClickListener(this.noDoubleClickListener);
        this.imgQq.setOnClickListener(this.noDoubleClickListener);
        this.imgQzone.setOnClickListener(this.noDoubleClickListener);
        this.imgWechat.setOnClickListener(this.noDoubleClickListener);
        this.imgComment.setOnClickListener(this.noDoubleClickListener);
        this.imgSina.setOnClickListener(this.noDoubleClickListener);
        return view;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = new Dialog(this.getContext());
        dialog.requestWindowFeature(1);
        dialog.setCanceledOnTouchOutside(false);
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        int uiOptions = 5890;
        dialog.getWindow().getDecorView().setSystemUiVisibility(uiOptions);
        WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
        lp.width = -1;
        lp.height = -1;
        dialog.getWindow().setAttributes(lp);
        if (ImmersionBar.needHandleStatusBar() && Build.VERSION.SDK_INT >= 21) {
            dialog.getWindow().clearFlags(0x4000000);
            dialog.getWindow().addFlags(Integer.MIN_VALUE);
            dialog.getWindow().setStatusBarColor(this.getResources().getColor(17170445));
        }
        return dialog;
    }

    public ShareModule getModule() {
        return this.module;
    }
}

