/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.share.ui;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;
import com.trello.rxlifecycle3.components.support.RxFragmentActivity;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IGameSystemShareResult_EventArgs;
import com.yy.mobile.share.SharePlatform;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.ui.share.gamesystem.GameSystemShareModule;
import com.yy.mobile.ui.share.gamesystem.GameSystemShareResultManager;
import com.yy.mobile.ui.share.model.ShareModule;
import com.yy.mobile.ui.share.presenter.SharePresenter;
import com.yy.mobile.ui.share.ui.GameSystemShareStatisticUtil;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.share.GameSystemShareResultEvent;
import com.yymobile.core.share.IGameSystemShareCore;
import com.yymobile.core.shenqu.ShenquUtils;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.Serializable;

public class GameSystemShareComponent
extends PopupComponent {
    public static final String TAG = "GameSystemShareComponent";
    public static final String SHARE_RANKING = "SHARE_RANKING";
    public static final String SHARE_SCORE = "SHARE_SCORE";
    public static final String SHARE_RANKING_PERCENT = "SHARE_RANKING_PERCENT";
    public static final String SHARE_TYPE = "SHARE_TYPE";
    private GameSystemShareModule module;
    private RelativeLayout placeHolder;
    private ImageView imgQq;
    private ImageView imgWechat;
    private ImageView imgComment;
    private ImageView ivClose;
    private TextView tvTitle;
    private SharePresenter sharePresenter;
    private SharePlatform mSharePlatform;
    protected IGameSystemShareCore.ShareType mShareType;
    private IGameSystemShareCore.ShareResultListener mShareResultListener;
    private View.OnClickListener noDoubleClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v.getId() == R.id.img_qq) {
                GameSystemShareComponent.this.handleShare(SharePlatform.QQ);
            } else if (v.getId() == R.id.img_wechat) {
                GameSystemShareComponent.this.handleShare(SharePlatform.Wechat);
            } else if (v.getId() == R.id.img_comment) {
                GameSystemShareComponent.this.handleShare(SharePlatform.WechatMoments);
            } else if (v.getId() == R.id.ivClose) {
                RxBus.getDefault().post((Object)new GameSystemShareResultEvent(null, GameSystemShareResultEvent.ResultStatus.CANCELED, 0));
                GameSystemShareComponent.this.dismiss();
            }
        }
    };

    public static GameSystemShareComponent show(IGameSystemShareCore.ShareType type, FragmentManager manager) {
        return GameSystemShareComponent.show(type, manager, 0, 0, "", null);
    }

    public static GameSystemShareComponent show(IGameSystemShareCore.ShareType type, FragmentManager manager, int ranking, int score, String rankingPercent, IGameSystemShareCore.ShareResultListener resultListener) {
        GameSystemShareComponent component = new GameSystemShareComponent();
        Bundle bundle = new Bundle();
        bundle.putSerializable(SHARE_TYPE, (Serializable)type);
        bundle.putInt(SHARE_RANKING, ranking);
        bundle.putInt(SHARE_SCORE, score);
        bundle.putString(SHARE_RANKING_PERCENT, rankingPercent);
        component.setArguments(bundle);
        component.show(manager, "");
        component.setShareResultListener(resultListener);
        return component;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mShareType = (IGameSystemShareCore.ShareType)this.getArguments().getSerializable(SHARE_TYPE);
            if (this.mShareType != null) {
                this.module = new GameSystemShareModule(this.mShareType, this.getArguments().getInt(SHARE_RANKING, 0), this.getArguments().getInt(SHARE_SCORE, 0), this.getArguments().getString(SHARE_RANKING_PERCENT));
            }
            this.sharePresenter = new SharePresenter(this.getContext(), this.module);
            this.setShareResultListener(this.mShareResultListener);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_quiz_share_component, container, false);
        this.placeHolder = (RelativeLayout)view.findViewById(R.id.view_place_holder);
        if (this.module != null) {
            this.module.getContentView(this.getContext(), inflater, (ViewGroup)this.placeHolder);
        }
        this.ivClose = (ImageView)view.findViewById(R.id.ivClose);
        this.imgQq = (ImageView)view.findViewById(R.id.img_qq);
        this.imgWechat = (ImageView)view.findViewById(R.id.img_wechat);
        this.imgComment = (ImageView)view.findViewById(R.id.img_comment);
        this.tvTitle = (TextView)view.findViewById(R.id.tv_title);
        this.setTitle();
        GameSystemShareStatisticUtil.INSTANCE.shareExposure(this.mShareType);
        this.ivClose.setOnClickListener(this.noDoubleClickListener);
        this.imgQq.setOnClickListener(this.noDoubleClickListener);
        this.imgWechat.setOnClickListener(this.noDoubleClickListener);
        this.imgComment.setOnClickListener(this.noDoubleClickListener);
        return view;
    }

    private void setTitle() {
        if (this.mShareType.getEnumType() == IGameSystemShareCore.ShareType.H5ShareType.EVERY_DAY_SHARE || this.mShareType.getEnumType() == IGameSystemShareCore.ShareType.H5ShareType.ROSHAMBO_EVERY_DAY_SHARE) {
            this.tvTitle.setText((CharSequence)"\u6bcf\u65e5\u5206\u4eab");
        } else if (this.mShareType.getEnumType() == IGameSystemShareCore.ShareType.H5ShareType.APPRENTICE_SHARE) {
            this.tvTitle.setText((CharSequence)"\u62db\u6536\u8ddf\u73ed");
        } else if (this.mShareType.getEnumType() == IGameSystemShareCore.ShareType.H5ShareType.OTHER_SHARE_TYPE) {
            this.tvTitle.setText((CharSequence)"\u5206\u4eab");
        } else {
            this.tvTitle.setText((CharSequence)"\u5206\u4eab\u9886\u597d\u793c");
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = new Dialog(this.getContext());
        dialog.requestWindowFeature(1);
        dialog.setCanceledOnTouchOutside(false);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setGravity(17);
        dialog.getWindow().setLayout(-1, -1);
        return dialog;
    }

    public ShareModule getModule() {
        return this.module;
    }

    public void setShareResultListener(IGameSystemShareCore.ShareResultListener listener2) {
        this.mShareResultListener = listener2;
        if (this.sharePresenter != null) {
            this.sharePresenter.setShareResultListener(this.mShareResultListener);
            this.sharePresenter.setShowShareResultDialogListener(new ShowShareResultListener(){

                @Override
                public void onShowResultDialog(Context context, boolean isSuc, SharePlatform sharePlatform, IGameSystemShareCore.ShareType shareType) {
                    if (context != null && context instanceof RxFragmentActivity) {
                        new GameSystemShareResultManager((RxFragmentActivity)context, isSuc, sharePlatform, shareType);
                    }
                    if (isSuc) {
                        GameSystemShareStatisticUtil.INSTANCE.shareSuccess(GameSystemShareComponent.this.mShareType, sharePlatform);
                    }
                }

                @Override
                public void onShowResultToast() {
                    SingleToastUtil.showToast((String)"\u5206\u4eab\u4e4b\u540e\u9700\u8fd4\u56deYY\u624d\u53ef\u83b7\u5f97\u91d1\u5e01");
                }
            });
        }
    }

    private void handleShare(final SharePlatform sharePlatform) {
        GameSystemShareStatisticUtil.INSTANCE.shareClick(this.mShareType, sharePlatform);
        this.mSharePlatform = sharePlatform;
        this.sharePresenter.setSharePlatform(this.mSharePlatform);
        this.sharePresenter.setShareType(this.mShareType);
        MLog.info((String)TAG, (String)("handleShare " + sharePlatform.name()));
        long timestamp = System.currentTimeMillis();
        File screenShotDir = new File(ShenquUtils.getVideoScreenDir());
        final String filePath = screenShotDir.getAbsolutePath() + File.separator + "game_share_" + timestamp + ".png";
        final Bitmap bitmap = this.sharePresenter.getCacheBitmapFromView((View)this.placeHolder);
        Observable.just((Object)"").observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<String>(){

            public void accept(@NonNull String ignore) throws Exception {
                MLog.info((String)GameSystemShareComponent.TAG, (String)("mFilePath:" + filePath));
                if (bitmap != null) {
                    if (GameSystemShareComponent.this.sharePresenter.saveBitmapToSdCard(bitmap, filePath)) {
                        GameSystemShareComponent.this.sharePresenter.sharePic(filePath, sharePlatform);
                    } else {
                        MLog.error((String)GameSystemShareComponent.TAG, (String)"saveBitmapToSdCard failed ");
                    }
                } else {
                    MLog.error((String)GameSystemShareComponent.TAG, (String)"sharePic,bitmap == null ");
                }
            }
        }, RxUtils.errorConsumer((String)TAG));
        this.dismiss();
    }

    public void onDestroy() {
        if (this.module != null) {
            this.module.onDestroy();
        }
        RxBus.getDefault().post((Object)new IGameSystemShareResult_EventArgs());
        super.onDestroy();
    }

    public static interface ShowShareResultListener {
        public void onShowResultDialog(Context var1, boolean var2, SharePlatform var3, IGameSystemShareCore.ShareType var4);

        public void onShowResultToast();
    }
}

