/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.share.presenter;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.view.View;
import com.alibaba.android.arouter.utils.TextUtils;
import com.yy.mobile.share.BasePlatform;
import com.yy.mobile.share.BasePlatformActionListener;
import com.yy.mobile.share.BaseShareContentCustomizeCallback;
import com.yy.mobile.share.ShareApi;
import com.yy.mobile.share.SharePlatform;
import com.yy.mobile.share.ShareRequest;
import com.yy.mobile.ui.share.model.ShareContext;
import com.yy.mobile.ui.share.model.ShareModule;
import com.yy.mobile.ui.share.ui.GameSystemShareComponent;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yymobile.core.share.IGameSystemShareCore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class SharePresenter {
    public static final String TAG = "GameShare";
    private Context mContext;
    private ShareModule mModule;
    private SharePlatform mSharePlatform;
    private IGameSystemShareCore.ShareType mShareType;
    private BaseShareContentCustomizeCallback shareContentCustomizeCallback = new BaseShareContentCustomizeCallback(){

        public boolean onShare(BasePlatform platform, BasePlatform.ShareParams paramsToShare) {
            String platformName = platform.getName();
            MLog.info((String)SharePresenter.TAG, (String)("[shareContentCustomizeCallback] platformName=" + platformName));
            return false;
        }
    };
    IGameSystemShareCore.ShareResultListener mResultListener;
    GameSystemShareComponent.ShowShareResultListener mShowShareResultDialogListener;
    BasePlatformActionListener platformActionListener = new BasePlatformActionListener(){

        public void onComplete(BasePlatform platform, int i, HashMap<String, Object> stringObjectHashMap) {
            MLog.info((String)SharePresenter.TAG, (String)"[onComplete] share ok");
            if (SharePresenter.this.mResultListener != null) {
                SharePresenter.this.mResultListener.onShareSuc();
            }
            if (SharePresenter.this.mShowShareResultDialogListener != null) {
                SharePresenter.this.mShowShareResultDialogListener.onShowResultDialog(SharePresenter.this.mContext, true, SharePresenter.this.mSharePlatform, SharePresenter.this.mShareType);
            } else {
                SingleToastUtil.showToast((String)"\u5206\u4eab\u6210\u529f");
            }
            SharePresenter.this.mContext = null;
        }

        public void onError(BasePlatform platform, int i, Throwable throwable) {
            MLog.error((Object)SharePresenter.TAG, (String)"[onError] share error=%s", (Throwable)throwable, (Object[])new Object[0]);
            if (SharePresenter.this.mResultListener != null) {
                SharePresenter.this.mResultListener.onShareFailed();
            }
            if (SharePresenter.this.mShowShareResultDialogListener != null) {
                SharePresenter.this.mShowShareResultDialogListener.onShowResultDialog(SharePresenter.this.mContext, false, SharePresenter.this.mSharePlatform, SharePresenter.this.mShareType);
            }
            SharePresenter.this.mContext = null;
        }

        public void onCancel(BasePlatform platform, int i) {
            MLog.info((String)SharePresenter.TAG, (String)"[onCancel] share cancel");
            if (SharePresenter.this.mResultListener != null) {
                SharePresenter.this.mResultListener.onShareFailed();
            }
            if (SharePresenter.this.mShowShareResultDialogListener != null) {
                SharePresenter.this.mShowShareResultDialogListener.onShowResultDialog(SharePresenter.this.mContext, false, SharePresenter.this.mSharePlatform, SharePresenter.this.mShareType);
            }
            SharePresenter.this.mContext = null;
        }
    };

    public SharePresenter(Context context, ShareModule module) {
        this.mContext = context;
        this.mModule = module;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void setShareType(IGameSystemShareCore.ShareType shareType) {
        this.mShareType = shareType;
    }

    public void setSharePlatform(SharePlatform sharePlatform) {
        this.mSharePlatform = sharePlatform;
    }

    public void setShareResultListener(IGameSystemShareCore.ShareResultListener listener2) {
        this.mResultListener = listener2;
    }

    public void setShowShareResultDialogListener(GameSystemShareComponent.ShowShareResultListener listener2) {
        this.mShowShareResultDialogListener = listener2;
    }

    public void sharePic(String mFilePath, SharePlatform platform) {
        String imgPath;
        if (this.mModule == null) {
            return;
        }
        ShareContext shareContent = null;
        if (this.mModule != null) {
            shareContent = (ShareContext)this.mModule.getShareContext();
        }
        if (shareContent == null) {
            return;
        }
        String string2 = imgPath = TextUtils.isEmpty((CharSequence)shareContent.imagePath()) ? mFilePath : shareContent.imagePath();
        if (platform == SharePlatform.Sina_Weibo) {
            ShareRequest request2 = new ShareRequest();
            request2.context = this.mContext == null ? this.mContext : this.mContext.getApplicationContext();
            request2.title = shareContent.title();
            request2.text = shareContent.text();
            request2.titleUrl = shareContent.titleUrl();
            request2.url = shareContent.url();
            request2.imagePath = imgPath;
            request2.showText = shareContent.showText();
            request2.notificationIcon = shareContent.notificationIconResId();
            request2.plateform = platform;
            MLog.info((String)TAG, (String)("[sharePic] Sina_Weibo request=" + request2));
            ((ShareApi)CoreApiManager.getInstance().getApi(ShareApi.class)).showShare(this.mContext, request2, this.shareContentCustomizeCallback);
        } else {
            BasePlatform.ShareParams shareParams = new BasePlatform.ShareParams();
            shareParams.setImagePath(imgPath);
            shareParams.setShareType(2);
            ((ShareApi)CoreApiManager.getInstance().getApi(ShareApi.class)).shareDirect(this.mContext, platform, shareParams, this.shareContentCustomizeCallback, this.platformActionListener);
        }
    }

    public boolean saveBitmapToSdCard(Bitmap mybitmap, String filePath) {
        MLog.info((String)TAG, (String)("[saveBitmapToSdCard],filePath:" + filePath));
        boolean result = false;
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        } else {
            try {
                FileOutputStream fileOutputStream = null;
                if (Environment.getExternalStorageState().equals("mounted")) {
                    fileOutputStream = new FileOutputStream(file);
                    mybitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    result = true;
                } else {
                    MLog.error((String)TAG, (String)"[saveBitmapToSdCard] can not find sdcard!");
                }
            }
            catch (IOException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return result;
    }

    public Bitmap getCacheBitmapFromView(View view) {
        if (view != null) {
            Bitmap bitmap;
            MLog.info((String)TAG, (String)"[getCacheBitmapFromView]");
            view.setDrawingCacheEnabled(true);
            view.buildDrawingCache(true);
            Bitmap drawingCache = view.getDrawingCache();
            if (drawingCache != null) {
                bitmap = Bitmap.createBitmap((Bitmap)drawingCache);
                view.setDrawingCacheEnabled(false);
            } else {
                MLog.info((String)TAG, (String)"[getCacheBitmapFromView] get cache bitmap from view error");
                bitmap = null;
            }
            return bitmap;
        }
        MLog.info((String)TAG, (String)"[getCacheBitmapFromView] view ==null ");
        return null;
    }
}

