/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.share.model;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.main.zxing.IZxingCore;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.share.model.BaseShareContext;
import com.yy.mobile.ui.share.model.BaseShareData;
import com.yy.mobile.ui.share.model.ShareModule;
import com.yymobile.core.ICoreManagerBase;

public abstract class BaseShareModule<T extends BaseShareData, S extends BaseShareContext>
implements ShareModule<T, S> {
    protected T mData;
    protected Context mContext;
    protected ImageView mLogoImageView;
    protected ImageView mQRCodeImageView;
    protected TextView mShareDefeat;
    protected TextView mShareRank;
    protected TextView mTotalScore;
    protected TextView mNickName;
    protected RelativeLayout mShareRoot;
    protected View mRankLayout;

    @Override
    public View getContentView(Context context, LayoutInflater inflater, ViewGroup parent) {
        this.mContext = context;
        View view = inflater.inflate(this.getLayoutResource(), parent, true);
        this.bindView(view);
        this.bindData(view, this.mData);
        return view;
    }

    public void setData(String json) {
        this.mData = this.convertData(json);
    }

    protected int getLayoutResource() {
        return R.layout.layout_share_contain;
    }

    protected void bindView(View view) {
        this.mShareRoot = (RelativeLayout)view.findViewById(R.id.rl_share_root);
        this.mLogoImageView = (ImageView)view.findViewById(R.id.iv_share_logo);
        this.mQRCodeImageView = (ImageView)view.findViewById(R.id.iv_share_qrcode);
        this.mShareDefeat = (TextView)view.findViewById(R.id.tv_game_share_defeat);
        this.mShareRank = (TextView)view.findViewById(R.id.tv_game_share_rank);
        this.mTotalScore = (TextView)view.findViewById(R.id.tv_total_score);
        this.mRankLayout = view.findViewById(R.id.ll_game_share_rank_layout);
        this.mNickName = (TextView)view.findViewById(R.id.tv_game_share_nickname);
    }

    @SuppressLint(value={"DefaultLocale"})
    protected void bindData(View root, T data) {
        this.mShareDefeat.setText((CharSequence)String.format("%.0f%%", Float.valueOf(((BaseShareData)data).defeatRate)));
        this.mShareRank.setText((CharSequence)String.valueOf(((BaseShareData)data).ranking));
        this.mTotalScore.setText((CharSequence)String.valueOf(((BaseShareData)data).score));
        this.mNickName.setText((CharSequence)((BaseShareData)data).nick);
        if (((BaseShareData)data).ranking <= 0 || ((BaseShareData)data).ranking > 50) {
            this.mRankLayout.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)((BaseShareData)data).qrcodeurl)) {
            this.attachQRCode(this.mQRCodeImageView, ((BaseShareData)data).qrcodeurl);
        } else {
            this.mQRCodeImageView.setImageResource(((BaseShareData)data).qrcoderesid);
        }
    }

    protected void attachQRCode(final ImageView imageView, final String url) {
        final Bitmap logo = ((BitmapDrawable)this.mContext.getResources().getDrawable(R.mipmap.ic_launcher_yy)).getBitmap();
        imageView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                IZxingCore zxingCore;
                int width = right - left;
                if (width > 0 && (zxingCore = (IZxingCore)ICoreManagerBase.getCore(IZxingCore.class)) != null) {
                    Bitmap bitmap = zxingCore.syncEncodeQRCode(url, width, -16777216, 0xFFFFFF, logo);
                    imageView.setImageBitmap(bitmap);
                }
            }
        });
    }

    protected abstract T convertData(String var1);

    @Override
    public T getData() {
        return this.mData;
    }
}

