/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting.widget;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.setting.item.Data;
import com.yy.mobile.ui.setting.item.NaviSettingItem;
import com.yy.mobile.ui.setting.widget.SettingItemView;
import com.yy.mobile.ui.widget.extend.RxViewExt;
import io.reactivex.functions.Consumer;

public class NaviSettingItemView
extends SettingItemView<NaviSettingItem> {
    private TextView mDescTextView;
    private Uri naviUri = null;
    private View.OnClickListener onClickListener;

    public NaviSettingItemView(Context context) {
        super(context);
    }

    @Override
    protected View initView(LayoutInflater inflater) {
        final View root = this.getRootView(inflater);
        this.mTitle = (TextView)root.findViewById(R.id.tv_setting_title);
        this.mSubTitle = (TextView)root.findViewById(R.id.tv_setting_subtitle);
        this.mDescTextView = (TextView)root.findViewById(R.id.tv_setting_desc);
        RxViewExt.safelyClicks((View)root, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                if (NaviSettingItemView.this.naviUri != null) {
                    ARouter.getInstance().build(NaviSettingItemView.this.naviUri).navigation(NaviSettingItemView.this.getContext());
                }
                if (NaviSettingItemView.this.onClickListener != null) {
                    NaviSettingItemView.this.onClickListener.onClick(root);
                }
            }
        });
        return root;
    }

    protected View getRootView(LayoutInflater inflater) {
        return inflater.inflate(R.layout.activity_setting_arrow_item, (ViewGroup)this);
    }

    @Override
    protected void initData(NaviSettingItem item) {
        item.title().get(new Data.BindData<CharSequence>(){

            @Override
            public void get(@Nullable CharSequence title) {
                NaviSettingItemView.this.mTitle.setText(title);
            }
        });
        item.subTitle().get(new Data.BindData<CharSequence>(){

            @Override
            public void get(@Nullable CharSequence subTitle) {
                if (subTitle != null) {
                    NaviSettingItemView.this.mSubTitle.setVisibility(0);
                    NaviSettingItemView.this.mSubTitle.setText(subTitle);
                } else {
                    NaviSettingItemView.this.mSubTitle.setVisibility(8);
                }
            }
        });
        item.naviDescText().get(new Data.BindData<CharSequence>(){

            @Override
            public void get(@Nullable CharSequence desc) {
                if (desc != null) {
                    NaviSettingItemView.this.mDescTextView.setVisibility(0);
                    NaviSettingItemView.this.mDescTextView.setText(desc);
                } else {
                    NaviSettingItemView.this.mDescTextView.setVisibility(8);
                }
            }
        });
        item.naviCommand().get(new Data.BindData<Uri>(){

            @Override
            public void get(@Nullable Uri data) {
                NaviSettingItemView.this.naviUri = data;
            }
        });
        item.naviDescColor().get(new Data.BindData<Integer>(){

            @Override
            public void get(@Nullable Integer color2) {
                if (color2 != null) {
                    NaviSettingItemView.this.mDescTextView.setTextColor(color2.intValue());
                }
            }
        });
        item.titleColor().get(new Data.BindData<Integer>(){

            @Override
            public void get(@Nullable Integer color2) {
                if (color2 != null) {
                    NaviSettingItemView.this.mTitle.setTextColor(color2.intValue());
                }
            }
        });
        item.onClickListener().get(new Data.BindData<View.OnClickListener>(){

            @Override
            public void get(@Nullable View.OnClickListener data) {
                NaviSettingItemView.this.onClickListener = data;
            }
        });
    }
}

