/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.setting.item.BooleanSettingItem;
import com.yy.mobile.ui.setting.item.Data;
import com.yy.mobile.ui.setting.widget.SettingItemView;
import com.yy.mobile.ui.setting.widget.SwitchButton;

public class BooleanSettingItemView
extends SettingItemView<BooleanSettingItem> {
    private SwitchButton switchButton;

    public BooleanSettingItemView(Context context) {
        super(context);
    }

    @Override
    protected View initView(LayoutInflater inflater) {
        View root = inflater.inflate(R.layout.activity_setting_toggle_item, (ViewGroup)this);
        this.switchButton = (SwitchButton)root.findViewById(R.id.mobpush_switch);
        this.mTitle = (TextView)root.findViewById(R.id.setting_item_title);
        this.mSubTitle = (TextView)root.findViewById(R.id.setting_item_subtitle);
        root.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BooleanSettingItemView.this.switchButton.toggle();
            }
        });
        this.switchButton.setOnCheckedChangeListener(new SwitchButton.OnCheckedChangeListener(){

            @Override
            public void onCheckedChanged(SwitchButton view, boolean isChecked, boolean isChangeByTouch) {
                ((BooleanSettingItem)BooleanSettingItemView.this.mData).setIsChangeByTouch(isChangeByTouch);
                ((BooleanSettingItem)BooleanSettingItemView.this.mData).isCheck().set(isChecked);
            }
        });
        return root;
    }

    @Override
    protected void initData(BooleanSettingItem item) {
        item.isCheck().get(new Data.BindData<Boolean>(){

            @Override
            public void get(@Nullable Boolean isChecked) {
                boolean isCheck = isChecked != null && isChecked != false;
                BooleanSettingItemView.this.switchButton.setChecked(isCheck);
            }
        });
        item.title().get(new Data.BindData<CharSequence>(){

            @Override
            public void get(@Nullable CharSequence data) {
                BooleanSettingItemView.this.mTitle.setText(data);
            }
        });
        item.subTitle().get(new Data.BindData<CharSequence>(){

            @Override
            public void get(@Nullable CharSequence subTitle) {
                if (subTitle == null) {
                    BooleanSettingItemView.this.mSubTitle.setVisibility(8);
                } else {
                    BooleanSettingItemView.this.mSubTitle.setVisibility(0);
                    BooleanSettingItemView.this.mSubTitle.setText(subTitle);
                }
            }
        });
    }

    public void setSwitch(boolean isCheck) {
        this.switchButton.setChecked(isCheck);
    }
}

