/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting.env;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.DialogManager;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkDialogListener;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.BaseEnv;
import com.yymobile.core.EnvUriSetting;

public class EnvChangeDetector {
    private static final String TAG = "EnvChangeDetector";
    private EnvUriSetting mUriSetting;
    private BaseEnv.SvcSetting mSvcSetting;
    private boolean mOpenBugBoolean;
    private boolean mThunder15013flag;
    private Activity mActivity;
    private Callback mCallback;

    public EnvChangeDetector(Activity activity2, Callback callback) {
        this.mActivity = activity2;
        this.mCallback = callback;
    }

    public void initEnv(boolean thunderFlag, EnvUriSetting uriEnv, BaseEnv.SvcSetting svcSetting, boolean openBugBoolean) {
        MLog.info((String)TAG, (String)("initEnv() called with: thunderFlag = [" + thunderFlag + "], uriEnv = [" + uriEnv + "], svcSetting = [" + svcSetting + "], openBugBoolean = [" + openBugBoolean + "]"));
        this.mUriSetting = uriEnv;
        this.mSvcSetting = svcSetting;
        this.mOpenBugBoolean = openBugBoolean;
        this.mThunder15013flag = thunderFlag;
    }

    public boolean onBackPressed(boolean thunderFlag, EnvUriSetting uriEnv, BaseEnv.SvcSetting svcSetting, boolean openBugBoolean) {
        if (this.mThunder15013flag != thunderFlag || this.mUriSetting != uriEnv || this.mSvcSetting != svcSetting || this.mOpenBugBoolean != openBugBoolean) {
            this.showDialog();
            return true;
        }
        return false;
    }

    public boolean onBackPressed(boolean isLogcatSettingChanged) {
        if (isLogcatSettingChanged) {
            this.showDialog();
            return true;
        }
        return false;
    }

    public void showDialog() {
        DialogManager dialogManager = new DialogManager((Context)this.mActivity);
        dialogManager.showDialog((IBaseDialog)new OkDialog((CharSequence)"\u73af\u5883\u53d8\u91cf\u6709\u53d8\u5316\uff0c\u9700\u8981\u91cd\u542f", true, new OkDialogListener(){

            public void onOk() {
                MLog.info((String)EnvChangeDetector.TAG, (String)"exit app on env changed");
                EnvChangeDetector.this.mCallback.beforeExitApp();
                if (EnvChangeDetector.this.mActivity != null) {
                    EnvChangeDetector.this.mActivity.getWindow().getDecorView().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            PackageManager packageManager = EnvChangeDetector.this.mActivity.getPackageManager();
                            Intent intent = packageManager.getLaunchIntentForPackage(EnvChangeDetector.this.mActivity.getPackageName());
                            ComponentName componentName = intent.getComponent();
                            Intent mainIntent = Intent.makeRestartActivityTask((ComponentName)componentName);
                            EnvChangeDetector.this.mActivity.startActivity(mainIntent);
                            EnvChangeDetector.this.mActivity.finish();
                            Runtime.getRuntime().exit(0);
                        }
                    }, 600L);
                }
            }
        }));
    }

    public static interface Callback {
        public void beforeExitApp();
    }
}

