/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting;

import android.content.ClipboardManager;
import android.content.Context;
import android.os.Bundle;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewStub;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.StringRes;
import com.google.gson.JsonElement;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IMobileLiveInvitePushClient_onAnchorLivePushRspRsp_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveInvitePushClient_onQueryPushPopStatusRsp_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.plugin.main.events.ISettingClient_onHandleQrCode_EventArgs;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.setting.VRSettingActivity$$EventBinder;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.dialog.InputDialog;
import com.yy.mobile.ui.utils.dialog.InputDialogListener;
import com.yy.mobile.ui.widget.SimpleRightTextTitleBar;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.IMobileLiveInvitePushCore;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.setting.ISettingCore;
import com.yymobile.core.setting.ISettingCoreEx;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VRSettingActivity
extends BaseActivity
implements View.OnClickListener {
    private static final String TAG = "VRSettingActivity";
    private static final String KEY_VR_URL = "push";
    private static final String KEY_COMMON_URL = "openPush";
    private static final String KEY_OBS_URL = "obsPush";
    private static final String KEY_OBS_CODE = "obsCode";
    private SimpleRightTextTitleBar mTitleBar;
    private String mVRUrl;
    private String mCommonUrl;
    private String mObsUrl;
    private String mObsCode;
    private ImageView mHelpManualVR;
    private Button mBtCopyUrlVR;
    private ImageView mHelpManualCommon;
    private Button mBtCopyUrlCommon;
    private ImageView mHelpManualObs;
    private Button mBtCopyObsUrl;
    private Button mBtCopyObsCode;
    private ViewStub mLayoutHelpGuide;
    private long mSid;
    private EntUserInfo mEntUserInfo;
    private List<GuideConfig> mGuideConfigs = Arrays.asList(new GuideConfig(R.id.vr_help_manual, R.string.push_stream_vr_manual_title, R.string.push_stream_vr_manual_top, R.drawable.vr_help_step1, R.string.push_stream_vr_manual_center, R.drawable.vr_help_step2, R.string.push_stream_vr_manual_bottom), new GuideConfig(R.id.common_help_manual, R.string.push_stream_common_manual_title, R.string.push_stream_common_manual_top, R.drawable.vr_help_step1, R.string.push_stream_common_manual_center, R.drawable.vr_help_step2, R.string.push_stream_common_manual_bottom), new GuideConfig(R.id.obs_help_manual, R.string.push_stream_obs_manual_title, R.string.push_stream_obs_manual_top, R.drawable.obs_help_step1, R.string.push_stream_obs_manual_center, R.drawable.obs_help_step2, R.string.push_stream_obs_manual_bottom));
    private EventBinder mEventBinder;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_vr_setting);
        this.initView();
        this.initData();
        this.initTitleBar();
    }

    private void initView() {
        this.mBtCopyUrlVR = (Button)this.findViewById(R.id.vr_bt_copy_url);
        this.mHelpManualVR = (ImageView)this.findViewById(R.id.vr_help_manual);
        this.mBtCopyUrlCommon = (Button)this.findViewById(R.id.common_bt_copy_url);
        this.mHelpManualCommon = (ImageView)this.findViewById(R.id.common_help_manual);
        this.mBtCopyObsUrl = (Button)this.findViewById(R.id.obs_bt_copy_url);
        this.mHelpManualObs = (ImageView)this.findViewById(R.id.obs_help_manual);
        this.mBtCopyObsCode = (Button)this.findViewById(R.id.obs_bt_copy_live_code);
        this.mTitleBar = (SimpleRightTextTitleBar)this.findViewById(R.id.title_bar);
        this.mLayoutHelpGuide = (ViewStub)this.findViewById(R.id.layout_help_guide);
        this.findViewById(R.id.bt_goto_qr_code).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.common_goto_qr_code).setOnClickListener((View.OnClickListener)this);
        this.mBtCopyUrlVR.setOnClickListener((View.OnClickListener)this);
        this.mHelpManualVR.setOnClickListener((View.OnClickListener)this);
        this.mBtCopyUrlCommon.setOnClickListener((View.OnClickListener)this);
        this.mHelpManualCommon.setOnClickListener((View.OnClickListener)this);
        this.mBtCopyObsUrl.setOnClickListener((View.OnClickListener)this);
        this.mHelpManualObs.setOnClickListener((View.OnClickListener)this);
        this.mBtCopyObsCode.setOnClickListener((View.OnClickListener)this);
    }

    private void initData() {
        if (this.getIntent().getExtras() != null) {
            this.mSid = this.getIntent().getExtras().getLong("sid");
            ((ISettingCoreEx)CoreManager.getCore(ISettingCore.class)).requestQrCode(this.mSid);
        }
    }

    private void initTitleBar() {
        this.mTitleBar.setTitlte(this.getString(R.string.push_stream_addr));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                VRSettingActivity.this.finish();
            }
        });
        this.mTitleBar.setRightText(this.getString(R.string.push_stream_invite), new View.OnClickListener(){

            public void onClick(View v) {
                long uid = LoginUtil.getUid();
                VRSettingActivity.this.mEntUserInfo = null;
                ((IProfileCore)CoreManager.getCore(IProfileCore.class)).requestProfile(uid);
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51411", "0001");
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.vr_help_manual || id2 == R.id.common_help_manual || id2 == R.id.obs_help_manual) {
            this.showGuide(id2);
        } else if (id2 == R.id.vr_guide_close_btn) {
            this.mLayoutHelpGuide.setVisibility(8);
            this.getWindow().clearFlags(1024);
        } else if (id2 == R.id.vr_bt_copy_url) {
            this.copyToClipboard(this.mVRUrl, this.getString(R.string.push_stream_copy_success));
        } else if (id2 == R.id.common_bt_copy_url) {
            this.copyToClipboard(this.mCommonUrl, this.getString(R.string.push_stream_copy_success));
        } else if (id2 == R.id.obs_bt_copy_url) {
            this.copyToClipboard(this.mObsUrl, this.getString(R.string.push_stream_copy_obs_url_success));
        } else if (id2 == R.id.obs_bt_copy_live_code) {
            this.copyToClipboard(this.mObsCode, this.getString(R.string.push_stream_copy_obs_code_success));
        } else if (id2 == R.id.bt_goto_qr_code) {
            this.toVRQrCodeActivity(this.mVRUrl, this.getString(R.string.push_stream_type_vr));
        } else if (id2 == R.id.common_goto_qr_code) {
            this.toVRQrCodeActivity(this.mCommonUrl, this.getString(R.string.push_stream_type_common));
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onHandleQrCode(ISettingClient_onHandleQrCode_EventArgs busEventArgs) {
        Map entryMap = busEventArgs.getEntryMap();
        Exception e = busEventArgs.getE();
        if (entryMap == null || e != null) {
            Toast.makeText((Context)this.getContext(), (int)R.string.push_stream_request_url_failed, (int)1).show();
            return;
        }
        int result = ((JsonElement)entryMap.get("result")).getAsInt();
        if (result == 0) {
            if (entryMap.containsKey(KEY_VR_URL)) {
                this.mVRUrl = ((JsonElement)entryMap.get(KEY_VR_URL)).getAsString();
            }
            if (entryMap.containsKey(KEY_COMMON_URL)) {
                this.mCommonUrl = ((JsonElement)entryMap.get(KEY_COMMON_URL)).getAsString();
            }
            if (entryMap.containsKey(KEY_OBS_URL)) {
                this.mObsUrl = ((JsonElement)entryMap.get(KEY_OBS_URL)).getAsString();
            }
            if (entryMap.containsKey(KEY_OBS_CODE)) {
                this.mObsCode = ((JsonElement)entryMap.get(KEY_OBS_CODE)).getAsString();
            }
        } else {
            MLog.error((Object)TAG, (String)"onHandleQrCode, result: %d", (Object[])new Object[]{result});
            Toast.makeText((Context)this.getContext(), (int)R.string.push_stream_request_url_failed, (int)1).show();
        }
    }

    private void copyToClipboard(String content, String tips) {
        if (!StringUtils.isEmpty((String)content).booleanValue()) {
            ClipboardManager cmb = (ClipboardManager)this.getContext().getSystemService("clipboard");
            cmb.setText((CharSequence)content);
            Toast.makeText((Context)this.getContext(), (CharSequence)tips, (int)0).show();
        }
    }

    private void toVRQrCodeActivity(String url, String title) {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_VR_URL, url);
        bundle.putString("title", title);
        NavigationUtils.toVRQrCodeActivity(this.getContext(), bundle);
    }

    @BusEvent
    public void onQueryPushPopStatusRsp(IMobileLiveInvitePushClient_onQueryPushPopStatusRsp_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        int popStatus = busEventArgs.getPopStatus();
        int leftTime = busEventArgs.getLeftTime();
        Map extendInfo = busEventArgs.getExtendInfo();
        int invitestate = busEventArgs.getInvitestate();
        String lastTitle = busEventArgs.getLastTitle();
        MLog.info((String)TAG, (String)("onQueryPushPopStatusRsp:result" + result + " pop_status " + popStatus + " left_time" + leftTime + " extendInfo\uff1a" + extendInfo + "invitestate:" + invitestate));
        if (result == 0) {
            if (popStatus == 1 && invitestate == 2) {
                String title = this.getString(R.string.push_stream_invite_title);
                String hint = this.getString(R.string.push_stream_invite_hint);
                String okText = this.getString(R.string.push_stream_invite_send);
                InputDialogListener adapter = new InputDialogListener(){

                    public void cancel() {
                        ((IMobileLiveInvitePushCore)ICoreManagerBase.getCore(IMobileLiveInvitePushCore.class)).setHaveSendUnInvite(true);
                    }

                    public boolean confirm(String input) {
                        if (TextUtils.isEmpty((CharSequence)(input = input.trim()))) {
                            return false;
                        }
                        if (input.length() > 16) {
                            VRSettingActivity.this.toast(R.string.push_stream_invite_over_length);
                            return false;
                        }
                        HashMap<String, String> extendInfo = new HashMap<String, String>();
                        if (VRSettingActivity.this.mEntUserInfo != null && ((VRSettingActivity)VRSettingActivity.this).mEntUserInfo.topId > 0L) {
                            extendInfo.put("topCid", String.valueOf(((VRSettingActivity)VRSettingActivity.this).mEntUserInfo.topId));
                            extendInfo.put("subCid", String.valueOf(((VRSettingActivity)VRSettingActivity.this).mEntUserInfo.subId));
                            extendInfo.put("rtmpFlag", "1");
                        }
                        ((IMobileLiveInvitePushCore)ICoreManagerBase.getCore(IMobileLiveInvitePushCore.class)).anchorLivePushReq(input, false, extendInfo);
                        ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51302", "0023");
                        return true;
                    }

                    public void onExit() {
                    }
                };
                this.getDialogLinkManager().showDialog((IBaseDialog)new InputDialog(this.getContext(), (CharSequence)title, null, null, (CharSequence)hint, okText, true, true, true, adapter, false));
            } else if (popStatus == 2 && invitestate == 2) {
                this.toast(leftTime < 60 ? leftTime + this.getString(R.string.push_stream_invite_again_1) : leftTime / 60 + this.getString(R.string.push_stream_invite_again_2));
            }
        } else if (invitestate == 2) {
            this.toast(R.string.push_stream_invite_failed);
        }
    }

    @BusEvent
    public void onAnchorLivePushRspRsp(IMobileLiveInvitePushClient_onAnchorLivePushRspRsp_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        Map extendInfo = busEventArgs.getExtendInfo();
        MLog.info((String)TAG, (String)("onAnchorLivePushRspRsp : result=" + result + ", extendInfo : " + extendInfo.toString()));
        String msg = this.getString(R.string.push_stream_invite_success);
        if (result != 0) {
            msg = extendInfo.containsKey("msg") ? (String)extendInfo.get("msg") : this.getString(R.string.push_stream_invite_generic_error, new Object[]{result});
        }
        this.toast(msg);
    }

    @BusEvent
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs busEventArgs) {
        EntUserInfo info = busEventArgs.getInfo();
        MLog.info((String)TAG, (String)"onRequestProfile");
        if (info != null && LoginUtil.getUid() == info.uid) {
            this.mEntUserInfo = info;
            if (info.isLiving == 1) {
                ((IMobileLiveInvitePushCore)CoreManager.getCore(IMobileLiveInvitePushCore.class)).queryPushPopStatus(2);
            } else {
                this.toast(R.string.push_stream_invite_before_push);
            }
        }
    }

    private void showGuide(@IdRes int id2) {
        this.mLayoutHelpGuide.setVisibility(0);
        TextView titleText = (TextView)this.findViewById(R.id.tv_title);
        TextView topText = (TextView)this.findViewById(R.id.tv_tips_top);
        TextView centerText = (TextView)this.findViewById(R.id.tv_tips_center);
        TextView bottomText = (TextView)this.findViewById(R.id.tv_tips_bottom);
        ImageView step1View = (ImageView)this.findViewById(R.id.iv_step1);
        ImageView step2View = (ImageView)this.findViewById(R.id.iv_step2);
        this.findViewById(R.id.vr_guide_close_btn).setOnClickListener((View.OnClickListener)this);
        this.getWindow().setFlags(1024, 1024);
        for (GuideConfig config : this.mGuideConfigs) {
            if (id2 != config.mManualResId) continue;
            titleText.setText(config.mTitleResId);
            topText.setText((CharSequence)Html.fromHtml((String)this.getString(config.mTopResId)));
            centerText.setText((CharSequence)Html.fromHtml((String)this.getString(config.mCenterResId)));
            bottomText.setText(config.mBottomResId);
            step1View.setImageResource(config.mStep1ResId);
            step2View.setImageResource(config.mStep2ResId);
            break;
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new VRSettingActivity$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    private static class GuideConfig {
        int mManualResId;
        int mTitleResId;
        int mTopResId;
        int mStep1ResId;
        int mCenterResId;
        int mStep2ResId;
        int mBottomResId;

        GuideConfig(@IdRes int manualResId, @StringRes int titleResId, @StringRes int topResId, @DrawableRes int step1ResId, @StringRes int centerResId, @DrawableRes int step2ResId, @StringRes int bottomResId) {
            this.mManualResId = manualResId;
            this.mTitleResId = titleResId;
            this.mTopResId = topResId;
            this.mStep1ResId = step1ResId;
            this.mCenterResId = centerResId;
            this.mStep2ResId = step2ResId;
            this.mBottomResId = bottomResId;
        }
    }
}

