/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.core.app.NotificationCompat;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.NotificationChannelManager;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.homeapi.store.HomePageState;
import com.yy.mobile.plugin.homeapi.store.HomePageStore;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IUpdateClient_onUpdateProgress_EventArgs;
import com.yy.mobile.plugin.main.events.IUpdateClient_onUpdateResult_EventArgs;
import com.yy.mobile.ui.setting.UpdateNotification$$EventBinder;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.update.IUpdateCore;
import com.yymobile.core.update.UpdateRequest;
import com.yymobile.core.update.UpdateResult;

public class UpdateNotification
extends EmptyEventCompat {
    private static final String TAG = "UpdateNotification";
    private static UpdateNotification instance = new UpdateNotification();
    private NotificationReciver notificationReciver = new NotificationReciver();
    private NotificationManager updateNotificationManager = null;
    private NotificationCompat.Builder updateNotification = null;
    private Intent updateIntent = null;
    private PendingIntent updatePendingIntent = null;
    private Integer notifyId = 998;
    private int downloadCount = 0;
    private final Context mContext = BasicConfig.getInstance().getAppContext();
    private IntentFilter againIF = new IntentFilter();
    private IntentFilter mInstallIF = new IntentFilter();
    private static final String UPDATE_AGAIN = "UPDATE_AGAIN";
    private static final String UPDATE_INSTALL = "UPDATE_INSTALL";
    private EventBinder mEventBinder;

    public static synchronized UpdateNotification instance() {
        return instance;
    }

    private UpdateNotification() {
        this.againIF.addAction(UPDATE_AGAIN);
        this.mInstallIF.addAction(UPDATE_INSTALL);
        this.updateNotification = new NotificationCompat.Builder(this.mContext, NotificationChannelManager.getInstance().getDefaultNotificationChannelId(this.mContext));
        this.updateNotification.setSmallIcon(this.mContext.getApplicationInfo().icon);
        this.updateNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
    }

    public void init(Context context) {
        try {
            CoreManager.addClient((Object)((Object)this));
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUpdateProgress(IUpdateClient_onUpdateProgress_EventArgs eventArgs) {
        long progress = eventArgs.getProgress();
        long total = eventArgs.getTotal();
        this.onUpdateProgress(progress, total);
    }

    public void onUpdateProgress(long progress, long total) {
        this.updateNotification.setContentTitle((CharSequence)this.mContext.getString(R.string.download_start));
        this.updateNotification.setContentText((CharSequence)((int)((double)progress / (double)total * 100.0) + "%"));
        this.updateNotification.setProgress((int)total, (int)progress, false);
        this.updateNotification.setContentIntent(this.updatePendingIntent);
        this.updateNotificationManager.notify(this.notifyId.intValue(), this.updateNotification.build());
    }

    public void setErrorNotify(int msg) {
        this.mContext.registerReceiver((BroadcastReceiver)this.notificationReciver, this.againIF);
        this.updateIntent = new Intent(UPDATE_AGAIN);
        this.updatePendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)this.updateIntent, (int)0);
        this.setNotify(this.mContext.getString(msg));
    }

    public void setNotify(String msg) {
        this.setNotify(msg, msg);
    }

    public void setNotify(String ticker, String msg) {
        this.updateNotification.setTicker((CharSequence)ticker);
        this.updateNotification.setContentTitle((CharSequence)this.mContext.getString(R.string.app_name));
        this.updateNotification.setContentText((CharSequence)msg);
        this.updateNotification.setContentIntent(this.updatePendingIntent);
        this.updateNotificationManager.notify(this.notifyId.intValue(), this.updateNotification.build());
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUpdateResult(IUpdateClient_onUpdateResult_EventArgs eventArgs) {
        UpdateResult updateResult = eventArgs.getUpdateResult();
        boolean isForceUpdate = eventArgs.isForceUpdate();
        this.onUpdateResult(updateResult, isForceUpdate);
    }

    public void onUpdateResult(UpdateResult updateResult, boolean isForceUpdate) {
        switch (updateResult) {
            case Updating: {
                break;
            }
            case Error: {
                break;
            }
            case Recent: {
                break;
            }
            case NetworkError: {
                break;
            }
            case NeedDownload: {
                break;
            }
            case Downloading: {
                break;
            }
            case DownloadError: {
                this.setErrorNotify(R.string.download_error);
                break;
            }
            case DownloadSuccess: {
                this.cancel();
                break;
            }
            case Ready: {
                break;
            }
            case InstallError: {
                this.setErrorNotify(R.string.install_error);
                break;
            }
        }
    }

    public void cancel() {
        this.updateNotificationManager.cancel(this.notifyId.intValue());
    }

    public void updateIntent() {
        this.updateIntent = new Intent(this.mContext, ((HomePageState)HomePageStore.INSTANCE.getState()).getMainActivityClass());
        this.updatePendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)this.updateIntent, (int)0);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new UpdateNotification$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    public static class NotificationReciver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(UpdateNotification.UPDATE_AGAIN)) {
                UpdateNotification.instance().cancel();
                ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).update(UpdateRequest.Download, false);
            }
            if (intent.getAction().equals(UpdateNotification.UPDATE_INSTALL)) {
                UpdateNotification.instance().cancel();
                ((IUpdateCore)CoreFactory.getCore(IUpdateCore.class)).update(UpdateRequest.Install, false);
            }
        }
    }
}

