/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting;

import android.app.Activity;
import android.content.Context;
import android.os.Environment;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.AndPermission;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.DiskCache;
import com.yy.mobile.sdkwrapper.flowmanagement.api.athroom.AthRoomManager;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import tv.athena.live.api.callback.JoinChannelListener;
import tv.athena.live.streambase.model.Channel;

public class TransVodDump
implements JoinChannelListener {
    private static final String TAG = "TransVodDump";
    private boolean mEnableDump = false;
    private static TransVodDump instance = new TransVodDump();

    public static TransVodDump getInstance() {
        return instance;
    }

    private TransVodDump() {
        AthRoomManager.INSTANCE.getLiveKitChannelComponentApi().addJoinChannelListener((JoinChannelListener)this);
    }

    public void updateDump(Activity activity2, boolean enableDump) {
        MLog.info((Object)TAG, (String)"enableDump: %b", (Object[])new Object[]{enableDump});
        this.mEnableDump = enableDump;
        AndPermission.with((Activity)activity2).runtime().permission(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}).onGranted((Action)new Action<List<String>>(){

            public void onAction(List<String> data) {
                MLog.info((Object)TransVodDump.TAG, (String)"updateDump onGrant: %b", (Object[])new Object[]{TransVodDump.this.mEnableDump});
                if (TransVodDump.this.mEnableDump) {
                    TransVodDump.this.createDump();
                } else {
                    TransVodDump.this.deleteDump();
                }
            }
        }).onDenied((Action)new Action<List<String>>(){

            public void onAction(List<String> data) {
                MLog.error((String)TransVodDump.TAG, (String)"trans vod dump fail, no permission");
                SingleToastUtil.showToast((String)"\u6ca1\u6709\u6743\u9650\uff0c\u65e0\u6cd5\u4fdd\u5b58dump");
            }
        }).start();
    }

    private void createDump() {
        String path = this.getSDPath() + "/transvod/enable_dump";
        MLog.info((Object)TAG, (String)"createDump, path: %s", (Object[])new Object[]{path});
        FileUtil.createNewFile((String)path);
    }

    private void deleteDump() {
        String path = this.getSDPath() + "/transvod";
        MLog.info((Object)TAG, (String)"deleteDump, path: %s", (Object[])new Object[]{path});
        FileUtil.delete((String)path);
    }

    public void onJoinFailed(int i, @Nullable String s) {
    }

    public void onJoinSuccess(@Nullable Channel channel) {
    }

    public void onLeave() {
    }

    public void willJoin(@Nullable Channel channel) {
        if (this.mEnableDump) {
            MLog.info((String)TAG, (String)"onJoinSuccess: delete dump");
            this.deleteDump();
            this.createDump();
        }
    }

    public String getSDPath() {
        File sdDir = null;
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        if (sdCardExist && DiskCache.hasExternalStoragePermission((Context)BasicConfig.getInstance().getAppContext())) {
            sdDir = Environment.getExternalStorageDirectory();
        }
        if (sdDir != null) {
            return sdDir.toString();
        }
        return null;
    }
}

