/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.URLUtil;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.alibaba.android.arouter.launcher.ARouter;
import com.example.configcenter.Publess;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.immersion.ImmersionBar;
import com.yy.mobile.baseapi.AppidPlatform;
import com.yy.mobile.bizmodel.login.Account;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.bizmodel.login.ThirdType;
import com.yy.mobile.config.DeleteAccountConfig;
import com.yy.mobile.memoryrecycle.views.YYLinearLayout;
import com.yy.mobile.model.Action;
import com.yy.mobile.model.action.UpdateCurrentAccountAction;
import com.yy.mobile.model.store.YCloudStore;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IAuthClient_onModifyPwdKickOff_EventArgs;
import com.yy.mobile.plugin.main.events.IBindStateClient_onQueryBindState_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onBroadcastPhoneBindState_EventArgs;
import com.yy.mobile.plugin.main.events.IUserInfoClient_onRequestRealNameVerifyStatus_EventArgs;
import com.yy.mobile.sdkwrapper.login.LoginProtocol;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.setting.SafeCenterActivity$$EventBinder;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.extend.RxViewExt;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.UriProvider;
import com.yymobile.core.UrlSettings;
import com.yymobile.core.auth.bind.IBindStateCore;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.user.IUserInfoCore;
import com.yymobile.core.utils.infotoast.InfoCollectToastUtil;
import com.yymobile.core.utils.infotoast.InfoCollectType;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

@Route(path="/setting/safeCenter", name="\u8d26\u53f7\u4e0e\u5b89\u5168")
@RouteDoc(desc="\u4e2a\u4eba\u4e2d\u5fc3\u8bbe\u7f6e-\u8d26\u53f7\u4e0e\u5b89\u5168", minVer="7.16.0", eg="yymobile://setting/safeCenter")
public class SafeCenterActivity
extends BaseActivity {
    private static final String TAG = "SafeCenterActivity";
    private static final int UNBIND_THIRD_ENTRY = 1;
    public static final String SP_KEY_CAN_SHOW_UNBIND_ENTRY = "CAN_SHOW_UNBIND_ENTRY";
    public static final String YY_CANCEL_ACCOUNT_URL = "https://aq.yy.com/acct/off/index.do";
    public static final String YY_CANCEL_ACCOUNT_LOGINED_URL = "https://lgn.yy.com/lgn/jump/authentication.do";
    public static final String ACCOUNT_CANCEL_EVENT_ID = "51408";
    public static final String ACCOUNT_CANCEL_EVENT_LABEL_ID = "0003";
    private SimpleTitleBar mTitleBar;
    private ViewGroup mViolationQueryGroup;
    private ViewGroup mFindPwdGroup;
    private YYLinearLayout mCancelAccountLL;
    private ViewGroup mAccountLiftbanGroup;
    private ViewGroup mOverseasLogin;
    private ViewGroup mPhoneNumGroup;
    private ViewGroup mPersonalAuthGroup;
    private ViewGroup mLoginDevicesGroup;
    private TextView mPhoneNumText;
    private TextView mAuthText;
    private TextView mFindPwdTitle;
    private TextView mFindPwdDesc;
    private static final String YY_REGISTER_SAFECENTER_URL = "https://order.yy.com/mobile/html/auth/register.html";
    private static final String UNBIND_THIRD_BASE_URL = "https://thirdlogin.yy.com/open/unbind/index.do";
    private static final String YY_UDB_FIND_PWD = "https://aq.yy.com/p/pwd/fgt/mnew/indexv2.do";
    private static final String YY_UDB_MODIFY_PWD = "https://aq.yy.com/p/pwd/chg/m/indexv2.do";
    private ConstraintLayout mClUnbindThird;
    private DeleteAccountConfig mDeleteAccountConfig = null;
    private EventBinder mEventBinder;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_safecenter);
        this.initData();
        this.initTitleBar();
        this.initViolationQuery();
        this.initFindPwd();
        this.initAccountLiftban();
        this.initOverseasLogin();
        this.initPhoneNum();
        this.initLoginDevices();
        this.initPersonalAuth();
        this.initUnbindThird();
        this.initCancelAccount();
    }

    private void initPhoneAndAuthView() {
        if (LoginUtil.isLogined()) {
            this.mPhoneNumGroup.setVisibility(0);
            this.mPersonalAuthGroup.setVisibility(0);
            this.findViewById(R.id.phone_down_devide).setVisibility(0);
            ((IUserInfoCore)CoreManager.getCore(IUserInfoCore.class)).requestRealNameVerifyStatus(LoginUtil.getUid());
            ((IProfileCore)CoreManager.getCore(IProfileCore.class)).reqPhoneBindState(UrlSettings.UDB_PHONE_BIND_STATE_URL);
        } else {
            this.mPhoneNumGroup.setVisibility(8);
            this.mPersonalAuthGroup.setVisibility(8);
            this.findViewById(R.id.phone_down_devide).setVisibility(8);
        }
    }

    private void initUnbindThirdView() {
        this.mClUnbindThird.setVisibility(this.canUnbind() ? 0 : 8);
    }

    protected void onStart() {
        super.onStart();
        this.initPhoneAndAuthView();
        this.initUnbindThirdView();
    }

    public void onResume() {
        super.onResume();
    }

    private void initTitleBar() {
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        this.mTitleBar.setTitlte(this.getString(R.string.str_safe_center));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                SafeCenterActivity.this.finish();
            }
        });
    }

    public void initViolationQuery() {
        this.mViolationQueryGroup = (ViewGroup)this.findViewById(R.id.ll_violation_query);
        RxViewExt.safelyClicks((View)this.mViolationQueryGroup, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                ((IHiidoStatisticCore)CoreManager.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), SafeCenterActivity.ACCOUNT_CANCEL_EVENT_ID, "0002");
                SafeCenterActivity.this.navViolationQuery();
            }
        });
    }

    public void initCancelAccount() {
        this.mCancelAccountLL = (YYLinearLayout)this.findViewById(R.id.ll_cancel_account);
        RxViewExt.safelyClicks((View)this.mCancelAccountLL, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                String toUrl = SafeCenterActivity.YY_CANCEL_ACCOUNT_URL;
                if (!LoginUtil.isLogined()) {
                    SafeCenterActivity.this.showLoginDialog();
                    SingleToastUtil.showToast((Context)SafeCenterActivity.this.getContext(), (int)R.string.str_acc_not_capable);
                    return;
                }
                SafeCenterActivity.this.realToDeletaAccount(toUrl);
            }
        });
    }

    private void realToDeletaAccount(String toUrl) {
        if (NetworkUtils.isNetworkStrictlyAvailable((Context)this.getContext())) {
            if (LoginUtil.isLogined()) {
                String url;
                MLog.info((Object)TAG, (String)"mDeleteAccountConfig:%s", (Object[])new Object[]{this.mDeleteAccountConfig});
                boolean isOptimized = false;
                if (this.mDeleteAccountConfig != null && this.mDeleteAccountConfig.isOpen() && !TextUtils.isEmpty((CharSequence)(url = this.mDeleteAccountConfig.getCurrentUrl()))) {
                    toUrl = url;
                    isOptimized = true;
                }
                if (!isOptimized) {
                    String ticket = LoginProtocol.Factory.get().getWebToken();
                    String busiId = "5719";
                    String appid = "5060";
                    int direct = 1;
                    String action = "authenticate";
                    StringBuffer builder = new StringBuffer(YY_CANCEL_ACCOUNT_LOGINED_URL);
                    builder.append("?ticket=").append(ticket).append("&busiId=").append(busiId).append("&appid=").append(appid).append("&direct=").append(direct).append("&action=").append(action).append("&yyuid=").append(LoginUtil.getUid()).append("&busiUrl=").append(YY_CANCEL_ACCOUNT_URL);
                    toUrl = builder.toString();
                }
            }
            ARouter.getInstance().build("/Web/View").withString("url", toUrl).withString("isSupportZoom", "1").navigation(this.getContext());
        } else {
            SingleToastUtil.showToast((Context)this.getContext(), (int)R.string.str_network_not_capable);
        }
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(ACCOUNT_CANCEL_EVENT_ID, ACCOUNT_CANCEL_EVENT_LABEL_ID);
        MLog.info((Object)TAG, (String)"cancel account clicked toUrl:%s", (Object[])new Object[]{toUrl});
    }

    public void initFindPwd() {
        this.mFindPwdGroup = (ViewGroup)this.findViewById(R.id.ll_find_pwd);
        this.mFindPwdTitle = (TextView)this.findViewById(R.id.tv_fp_title);
        this.mFindPwdDesc = (TextView)this.findViewById(R.id.tv_fp_desc);
        if (LoginUtil.isLogined()) {
            this.mFindPwdTitle.setText((CharSequence)"\u91cd\u7f6e\u5bc6\u7801");
            this.mFindPwdDesc.setText((CharSequence)"\u8bbe\u7f6e\u5bc6\u7801\uff0c\u4fee\u6539\u5bc6\u7801\uff0c\u5728\u8fd9\u91cc\u64cd\u4f5c\uff01");
        } else {
            this.mFindPwdTitle.setText((CharSequence)"\u5fd8\u8bb0\u5bc6\u7801");
            this.mFindPwdDesc.setText((CharSequence)"\u5fd8\u8bb0YY\u5bc6\u7801\uff0c\u4ece\u8fd9\u91cc\u627e\u56de\uff01");
        }
        RxViewExt.safelyClicks((View)this.mFindPwdGroup, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                MLog.info((String)SafeCenterActivity.TAG, (String)"mFindPwdGroup clicked");
                if (!SafeCenterActivity.this.checkNetToast()) {
                    return;
                }
                NavigationUtils.toJSSupportedWebView((Activity)SafeCenterActivity.this, SafeCenterActivity.urlWithParams());
            }
        });
    }

    public void initAccountLiftban() {
        this.mAccountLiftbanGroup = (ViewGroup)this.findViewById(R.id.ll_account_liftban);
        this.mAccountLiftbanGroup.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
            }
        });
    }

    public void initOverseasLogin() {
        this.mOverseasLogin = (ViewGroup)this.findViewById(R.id.ll_overseas_login);
        RxViewExt.safelyClicks((View)this.mOverseasLogin, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                NavigationUtils.toJSSupportedWebView((Activity)SafeCenterActivity.this, SafeCenterActivity.YY_REGISTER_SAFECENTER_URL);
            }
        });
    }

    private String getUnbindUrl() {
        StringBuffer sb = new StringBuffer(UNBIND_THIRD_BASE_URL);
        sb.append("?");
        sb.append("appid=" + AppidPlatform.getAppId());
        sb.append("&ticket=" + LoginProtocol.Factory.get().getWebToken());
        sb.append("&ticketAppid=5060");
        sb.append("&yyuid=" + LoginUtil.getUid());
        return sb.toString();
    }

    private boolean unbindEntryFilter(ThirdType thirdType) {
        switch (thirdType) {
            case QQ: 
            case WECHAT: 
            case SINA: {
                int unbindThirdConf = CommonPref.instance().getInt("UNBIND_THIRD_SWITCH", 0);
                MLog.debug((String)TAG, (String)("Has ThirdPartyType " + thirdType + ", Value of sp \"UNBIND_THIRD_SWITCH\"  is: " + unbindThirdConf));
                return unbindThirdConf == 1;
            }
        }
        return false;
    }

    private boolean canUnbind() {
        Account yyaccount = LoginUtil.getCurrentAccount();
        if (yyaccount == null) {
            return false;
        }
        if (LoginUtil.getThirdPartyLoginType().equals((Object)ThirdType.None) && yyaccount.thirdPartyType.equals((Object)ThirdType.None)) {
            ((IBindStateCore)CoreManager.getCore(IBindStateCore.class)).queryBindState(LoginUtil.getUid(), 0);
            return false;
        }
        return this.unbindEntryFilter(yyaccount.thirdPartyType);
    }

    private void initUnbindThird() {
        this.mClUnbindThird = (ConstraintLayout)this.findViewById(R.id.cl_unbind_third);
        RxViewExt.safelyClicks((View)this.mClUnbindThird, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                NavigationUtils.toJSSupportedWebView((Activity)SafeCenterActivity.this, SafeCenterActivity.this.getUnbindUrl(), 1, 1, 0);
            }
        });
    }

    private void initPhoneNum() {
        this.mPhoneNumGroup = (ViewGroup)this.findViewById(R.id.ll_phone_num);
        this.mPhoneNumText = (TextView)this.findViewById(R.id.tv_phone_num);
        RxViewExt.safelyClicks((View)this.mPhoneNumGroup, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                MLog.info((String)SafeCenterActivity.TAG, (String)"BindPhoneNumBtn clicked.");
                NavigationUtils.toBindPhoneNumberActivity((Context)SafeCenterActivity.this);
            }
        });
    }

    private void initLoginDevices() {
        this.mLoginDevicesGroup = (ViewGroup)this.findViewById(R.id.ll_login_devices);
        this.mLoginDevicesGroup.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
            }
        });
    }

    private void initPersonalAuth() {
        this.mPersonalAuthGroup = (ViewGroup)this.findViewById(R.id.ll_personal_auth);
        this.mAuthText = (TextView)this.findViewById(R.id.tv_personal_auth);
        RxViewExt.safelyClicks((View)this.mPersonalAuthGroup, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                boolean isShow = CommonPref.instance().getBoolean(InfoCollectType.REAL_VERIFIED.getValue(), false);
                if (!isShow) {
                    InfoCollectToastUtil.INSTANCE.showToast(InfoCollectType.REAL_VERIFIED);
                } else {
                    ARouter.getInstance().build("/RealNameAuth/Home").navigation(SafeCenterActivity.this.getContext());
                }
            }
        });
    }

    private void initData() {
        this.initDeleteAccountConfig();
    }

    private void initDeleteAccountConfig() {
        Disposable d2 = Publess.of(DeleteAccountConfig.class).pull().subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<DeleteAccountConfig>(){

            public void accept(DeleteAccountConfig deleteAccountConfig) throws Exception {
                MLog.info((String)SafeCenterActivity.TAG, (String)("getDeleteAccountConfig -> " + deleteAccountConfig));
                SafeCenterActivity.this.mDeleteAccountConfig = deleteAccountConfig;
            }
        }, RxUtils.errorConsumer((String)TAG));
    }

    private void navViolationQuery() {
        String url = UriProvider.SAFE_CENTER_VIOLATION_QUERY;
        if (url != null && url.length() > 0 && !url.startsWith("http://") && !url.startsWith("https://")) {
            url = "http://" + url;
        }
        if (URLUtil.isValidUrl((String)url)) {
            long uid = LoginUtil.getUid();
            if (uid != 0L && LoginUtil.isLogined()) {
                url = url + "/index?uid=" + uid + "&ticket=" + LoginProtocol.Factory.get().getWebToken();
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((String)TAG, (String)("violation: " + url));
                }
            }
            NavigationUtils.toJSSupportedWebView((Activity)this, url, 17, false, false, "history");
        } else {
            this.toast("invalid url!");
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            CookieSyncManager.createInstance((Context)this);
            CookieSyncManager.getInstance().startSync();
            CookieManager.getInstance().removeSessionCookie();
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    private void navBindPhoneNumberWeb() {
        StringBuffer sb = new StringBuffer(UriProvider.YY_UDB_BINDPHONE_URL);
        sb.append("?");
        sb.append("appid=" + AppidPlatform.getAppId());
        sb.append("&action=1");
        sb.append("&ticket=" + LoginProtocol.Factory.get().getOTP(AppidPlatform.getAppId()));
        sb.append("&ticketType=2");
        sb.append("&yyuid=" + LoginUtil.getUid());
        sb.append("&deviceData=" + LoginProtocol.Factory.get().getDeviceData());
        NavigationUtils.toJSSupportedWebView((Activity)this, sb.toString());
    }

    @BusEvent
    public void onRequestRealNameVerifyStatus(IUserInfoClient_onRequestRealNameVerifyStatus_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        int status = busEventArgs.getStatus();
        MLog.info((String)TAG, (String)("onRequestRealNameVerifyStatus:result:" + result + "uid:" + uid + "status:" + status));
        if (this.mAuthText == null) {
            return;
        }
        if (result == 0) {
            if (status == 0) {
                this.mAuthText.setText((CharSequence)this.getResources().getString(R.string.str_safe_personal_state_auth));
                this.mAuthText.setTextColor(Color.parseColor((String)"#5bd505"));
            } else if (status == 3) {
                this.mAuthText.setText((CharSequence)this.getResources().getString(R.string.str_safe_personal_state_check));
                this.mAuthText.setTextColor(Color.parseColor((String)"#999999"));
            } else {
                this.mAuthText.setText((CharSequence)this.getResources().getString(R.string.str_safe_personal_state_unauth));
                this.mAuthText.setTextColor(Color.parseColor((String)"#999999"));
            }
        }
    }

    @BusEvent
    public void onBroadcastPhoneBindState(IProfileClient_onBroadcastPhoneBindState_EventArgs busEventArgs) {
        int status = busEventArgs.getStatus();
        if (this.mPhoneNumText == null) {
            return;
        }
        if (status == 0) {
            this.mLoginDevicesGroup.setVisibility(8);
            this.mPhoneNumText.setText((CharSequence)this.getResources().getString(R.string.str_safe_phone_bind));
            this.mPhoneNumText.setTextColor(Color.parseColor((String)"#5bd505"));
        } else {
            this.mLoginDevicesGroup.setVisibility(8);
            this.mPhoneNumText.setText((CharSequence)this.getResources().getString(R.string.str_safe_phone_unbind));
            this.mPhoneNumText.setTextColor(Color.parseColor((String)"#999999"));
        }
    }

    @BusEvent
    public void onModifyPwdKickOff(IAuthClient_onModifyPwdKickOff_EventArgs busEventArgs) {
        this.finish();
    }

    public static String urlWithParams() {
        StringBuffer sb;
        if (LoginUtil.isLogined()) {
            String url = YY_UDB_MODIFY_PWD;
            sb = new StringBuffer(url);
            sb.append("?");
            sb.append("appid=" + AppidPlatform.getAppId());
            sb.append("&action=1");
            sb.append("&ticket=" + LoginProtocol.Factory.get().getOTP(AppidPlatform.getAppId()));
            sb.append("&ticketType=2");
            sb.append("&yyuid=" + LoginUtil.getUid());
            sb.append("&deviceData=" + LoginProtocol.Factory.get().getDeviceData());
        } else {
            String url = YY_UDB_FIND_PWD;
            sb = new StringBuffer(url);
            sb.append("?");
            sb.append("appid=" + AppidPlatform.getAppId());
            sb.append("&action=1");
            sb.append("&deviceData=" + LoginProtocol.Factory.get().getDeviceData());
        }
        MLog.info((String)TAG, (String)("FindOrModifyPwd url : " + sb.toString()));
        return sb.toString();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (1 == requestCode) {
            MLog.debug((Object)TAG, (String)"requestDetailUserInfo(id: %d), onActivityResult. Enter From UNBIND_THIRD_ENTRY.", (Object[])new Object[]{LoginUtil.getUid()});
            CoreManager.getUserCore().requestDetailUserInfo(LoginUtil.getUid(), true);
        }
    }

    @BusEvent
    public void onQueryBindState(IBindStateClient_onQueryBindState_EventArgs busEventArgs) {
        if (busEventArgs == null) {
            MLog.error((String)TAG, (String)"QueryBindState success, But IBindStateClient_onQueryBindState_EventArgs is null");
            return;
        }
        ThirdType thirdType = busEventArgs.getThirdType();
        MLog.debug((String)TAG, (String)("QueryBindState success, isBindThird: " + busEventArgs.getBind() + ", thirdType is :" + thirdType));
        if (this.unbindEntryFilter(thirdType)) {
            this.mClUnbindThird.setVisibility(0);
            Account account = LoginUtil.getCurrentAccount();
            if (account == null) {
                MLog.error((String)TAG, (String)("QueryBindState success, Ready to update currentAccount's thirdType to " + thirdType + ",but CurrentAccount is null."));
                return;
            }
            Account newAccount = new Account.Builder(account).setThirdPartyType(thirdType).build();
            YCloudStore.INSTANCE.dispatch((Action)new UpdateCurrentAccountAction(newAccount));
        } else {
            this.mClUnbindThird.setVisibility(8);
        }
    }

    protected boolean handleStatusBar() {
        if (ScreenUtil.isInDarkMode()) {
            this.immersionBar = ImmersionBar.with((Activity)this).fitsSystemWindows(true).statusBarColor(R.color.background_color).navigationBarColor(R.color.background_color).init();
            return true;
        }
        return false;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new SafeCenterActivity$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

