/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.CompoundButton;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IDontDisturbClient_onQueryDontDisturbStatus_EventArgs;
import com.yy.mobile.plugin.main.events.IDontDisturbClient_onSetDontDisturbResult_EventArgs;
import com.yy.mobile.plugin.main.events.ISettingClient_onQueryPushStatus_EventArgs;
import com.yy.mobile.plugin.main.events.ISettingClient_onUpdatePushStatus_EventArgs;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.setting.PushSettingActivity$$EventBinder;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.switchbutton.Switch;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.AccountPref;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.setting.IDontDisturbCore;
import com.yymobile.core.setting.ISettingCore;

public class PushSettingActivity
extends BaseActivity {
    private static final String TAG = "PushSettingActivity";
    public static final String PRE_SETTING_DONT_DISTURB_SWITCH = "PRE_SETTING_DONT_DISTURB_SWITCH";
    private SimpleTitleBar mTitleBar;
    private Switch mMobPushBtn;
    private Switch mSwtDontDisturb;
    private CompoundButton.OnCheckedChangeListener mSwithOnChangelistener = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (isChecked) {
                ((ISettingCore)CoreFactory.getCore(ISettingCore.class)).reqUpdatePushStatus(0);
            } else {
                ((ISettingCore)CoreFactory.getCore(ISettingCore.class)).reqUpdatePushStatus(1);
            }
            ((ISettingCore)CoreFactory.getCore(ISettingCore.class)).setPushChangeStatus(true);
        }
    };
    private EventBinder mEventBinder;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_push_setting);
        this.initTitleBar();
        this.initMobPush();
        this.initDontDisturbSetting();
    }

    private void initTitleBar() {
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        this.mTitleBar.setTitlte(this.getString(R.string.str_setting_push));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                PushSettingActivity.this.finish();
            }
        });
    }

    private void initMobPush() {
        this.mMobPushBtn = (Switch)this.findViewById(R.id.mobpush_switch);
        this.mMobPushBtn.setChecked(((ISettingCore)CoreFactory.getCore(ISettingCore.class)).getPushStatus() == 0L);
        this.mMobPushBtn.setOnCheckedChangeListener(this.mSwithOnChangelistener);
    }

    private void initDontDisturbSetting() {
        View dontDisturbLayout = this.findViewById(R.id.ll_dont_disturb_setting);
        this.mSwtDontDisturb = (Switch)dontDisturbLayout.findViewById(R.id.switch_setting_disturb);
        boolean isLogined = LoginUtil.isLogined();
        dontDisturbLayout.setVisibility(isLogined ? 0 : 8);
        if (isLogined) {
            long uid = LoginUtil.getUid();
            int prefStatus = AccountPref.instance((long)uid).getInt(PRE_SETTING_DONT_DISTURB_SWITCH, -1);
            if (prefStatus < 0) {
                ((IDontDisturbCore)CoreManager.getCore(IDontDisturbCore.class)).queryDontDisturbStatus(uid);
            } else {
                this.mSwtDontDisturb.setChecked(prefStatus == 1);
            }
        }
        this.mSwtDontDisturb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ((IDontDisturbCore)CoreManager.getCore(IDontDisturbCore.class)).updateDontDisturbSetting(isChecked ? 1 : 0);
            }
        });
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryDontDisturbStatus(IDontDisturbClient_onQueryDontDisturbStatus_EventArgs busEventArgs) {
        long result = busEventArgs.getResult();
        boolean enable = busEventArgs.getEnable();
        this.mSwtDontDisturb.setChecked(result == 0L && enable);
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onSetDontDisturbResult(IDontDisturbClient_onSetDontDisturbResult_EventArgs busEventArgs) {
        long result = busEventArgs.getResult();
        if (result != 0L) {
            this.toast("\u8bbe\u7f6e\u514d\u6253\u6270\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002");
            this.mSwtDontDisturb.setChecked(this.mSwtDontDisturb.isChecked());
        } else {
            AccountPref.instance((long)LoginUtil.getUid()).putInt(PRE_SETTING_DONT_DISTURB_SWITCH, this.mSwtDontDisturb.isChecked() ? 1 : 0);
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUpdatePushStatus(ISettingClient_onUpdatePushStatus_EventArgs busEventArgs) {
        long result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        long status = busEventArgs.getStatus();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onUpdatePushStatus,result=%d,uid=%d,status=%d", (Object[])new Object[]{result, uid, status});
        }
        if (result == 0L) {
            if (status == 0L) {
                Toast.makeText((Context)this, (int)R.string.str_setting_mobpush_on, (int)0).show();
            } else {
                Toast.makeText((Context)this, (int)R.string.str_setting_mobpush_off, (int)0).show();
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryPushStatus(ISettingClient_onQueryPushStatus_EventArgs busEventArgs) {
        long result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        long status = busEventArgs.getStatus();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new PushSettingActivity$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

