/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.setting.adpater.LogAdapter;
import com.yy.mobile.ui.widget.EasyClearEditText;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.ImeUtil;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.YYSchedulers;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogActivity
extends BaseActivity {
    private static final String TAG = "LogActivity";
    private SimpleTitleBar mTitleBar;
    private ListView mLogListView;
    private LogAdapter mAdapter;
    private EasyClearEditText mSearchInput;
    private View mSearchBtn;
    private String mSearchKey;
    private Button mPreButton;
    private Button mNextButton;
    private TextView mResultTextView;
    private List<String> mMatchPageList;
    private HashMap<String, List<String>> mPagePosMap;
    private int mSearchIndex;
    private int mMatchPageIndex;
    private int mCurrentPage;
    private List<SpannableStringBuilder> mSpannableList;
    private CharacterStyle mLastSpan;
    private String mLogContent;
    private List<String> mLogList;
    private int mResultCount;
    private int mGlobalIndex;
    private TextWatcher textWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            String searchKey = s.toString().trim();
            try {
                while (searchKey.startsWith("\u3000")) {
                    searchKey = searchKey.substring(1, LogActivity.this.mSearchKey.length()).trim();
                }
                while (searchKey.endsWith("\u3000")) {
                    searchKey = searchKey.substring(0, LogActivity.this.mSearchKey.length() - 1).trim();
                }
            }
            catch (Exception e) {
                MLog.error((Object)"[AboutActivity]", (String)"\u6570\u636e\u8d8a\u754c\u5f02\u5e38: ", (Throwable)e, (Object[])new Object[0]);
            }
            if (searchKey != null && searchKey.length() > 0) {
                LogActivity.this.mSearchInput.setBackgroundResource(R.drawable.bg_search_top_btn_actived);
                LogActivity.this.mSearchBtn.setVisibility(0);
            } else {
                LogActivity.this.mSearchInput.setBackgroundResource(R.drawable.bg_search_top_btn_unactived);
                LogActivity.this.mSearchBtn.setVisibility(8);
            }
        }
    };
    public Handler mHandler = new LogHandler(this);

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_log);
        this.mMatchPageIndex = 0;
        this.initTitleBar();
        this.readLog();
        this.mLogListView = (ListView)this.findViewById(R.id.log_listview);
        this.mAdapter = new LogAdapter((Context)this);
        this.mLogListView.setAdapter((ListAdapter)this.mAdapter);
        this.mResultTextView = (TextView)this.findViewById(R.id.result_textview);
        this.mSearchBtn = this.findViewById(R.id.search_img);
        this.mSearchBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LogActivity.this.search();
            }
        });
        this.mSearchInput = (EasyClearEditText)this.findViewById(R.id.search_input);
        this.mSearchInput.setSmartIconClickListener(EasyClearEditText.getDefaultSmartIconClickListener());
        this.mSearchInput.setBackgroundResource(R.drawable.bg_search_top_btn_unactived);
        this.mSearchInput.addTextChangedListener(this.textWatcher);
        this.mSearchInput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int i, KeyEvent keyEvent) {
                if (i == 3) {
                    LogActivity.this.mSearchKey = LogActivity.this.mSearchInput.getText().toString();
                    LogActivity.this.search();
                }
                return false;
            }
        });
        this.mPreButton = (Button)this.findViewById(R.id.pre_btn);
        this.mNextButton = (Button)this.findViewById(R.id.next_btn);
        this.mPreButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogActivity.this.searchPre();
            }
        });
        this.mNextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogActivity.this.searchNext();
            }
        });
    }

    private void initTitleBar() {
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        this.mTitleBar.setTitlte("Log");
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                LogActivity.this.finish();
            }
        });
    }

    public void resetData() {
        this.mSearchIndex = 0;
        this.mMatchPageIndex = 0;
        this.mResultCount = 0;
        this.mGlobalIndex = 1;
        if (this.mMatchPageList == null) {
            this.mMatchPageList = new ArrayList<String>();
        } else {
            this.mMatchPageList.clear();
        }
        if (this.mSpannableList == null) {
            this.mSpannableList = new ArrayList<SpannableStringBuilder>();
        } else {
            this.mSpannableList.clear();
        }
        if (this.mPagePosMap == null) {
            this.mPagePosMap = new HashMap();
        } else {
            this.mPagePosMap.clear();
        }
    }

    public void calculateStartPos(String target) {
        boolean isFirstMatch = true;
        for (int index = 0; index < this.mLogList.size(); ++index) {
            String content = this.mLogList.get(index);
            Pattern p = Pattern.compile(target, 2);
            Matcher m = p.matcher(content);
            String key = String.valueOf(index);
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)content);
            this.mSpannableList.add(spannableStringBuilder);
            while (m.find()) {
                List<String> subList;
                ++this.mResultCount;
                if (!this.mMatchPageList.contains(key)) {
                    this.mMatchPageList.add(key);
                }
                if ((subList = this.mPagePosMap.get(key)) == null) {
                    subList = new ArrayList<String>();
                    this.mPagePosMap.put(key, subList);
                }
                subList.add(String.valueOf(m.start()));
                ForegroundColorSpan span = new ForegroundColorSpan(-65536);
                if (isFirstMatch) {
                    BackgroundColorSpan span1 = new BackgroundColorSpan(-16776961);
                    spannableStringBuilder.setSpan((Object)span1, m.start(), m.end(), 33);
                    isFirstMatch = false;
                    this.mLastSpan = span1;
                }
                spannableStringBuilder.setSpan((Object)span, m.start(), m.end(), 33);
            }
        }
    }

    public void updateResultCount() {
        if (this.mResultCount == 0) {
            this.mResultTextView.setText((CharSequence)"\u51710\u6761\u7ed3\u679c");
            this.resetTextview();
        } else {
            this.mResultTextView.setText((CharSequence)("\u5339\u914d\u7ed3\u679c\uff1a" + this.mGlobalIndex + "/" + this.mResultCount + "\u6761"));
        }
    }

    public int startPostion(int page, int searchIndex) {
        if (this.mPagePosMap != null) {
            List<String> subList = this.mPagePosMap.get(String.valueOf(page));
            if (searchIndex >= 0 && searchIndex < subList.size()) {
                String postion = subList.get(searchIndex);
                return Integer.parseInt(postion);
            }
        }
        return -1;
    }

    public List<String> postionList(int page) {
        if (this.mPagePosMap != null) {
            List<String> subList = this.mPagePosMap.get(String.valueOf(page));
            return subList;
        }
        return null;
    }

    public String matchPage(int index) {
        if (this.mMatchPageList != null && index >= 0 && index < this.mMatchPageList.size()) {
            return this.mMatchPageList.get(index);
        }
        return null;
    }

    public SpannableStringBuilder spannableStringBuilder(int index) {
        if (this.mSpannableList != null && index >= 0 && index < this.mSpannableList.size()) {
            return this.mSpannableList.get(index);
        }
        return null;
    }

    public void highlight(final String target) {
        YYSchedulers.computation.scheduleDirect(new Runnable(){

            @Override
            public void run() {
                LogActivity.this.calculateStartPos(target);
                Message message = new Message();
                message.what = 2;
                LogActivity.this.mHandler.sendMessage(message);
            }
        });
    }

    public void resetTextview() {
        this.mSpannableList.clear();
        this.mAdapter.setSpannableList(this.mSpannableList);
    }

    public void search() {
        ImeUtil.hideIME((Activity)this);
        this.resetData();
        this.mSearchKey = this.mSearchInput.getText().toString();
        if (this.mSearchKey != null && this.mSearchKey.length() > 0) {
            this.mSearchInput.setBackgroundResource(R.drawable.bg_search_top_btn_actived);
            this.mSearchBtn.setVisibility(0);
            this.highlight(this.mSearchKey);
        } else {
            this.mSearchInput.setBackgroundResource(R.drawable.bg_search_top_btn_unactived);
            this.mSearchBtn.setVisibility(8);
        }
    }

    public void searchPre() {
        if (this.mMatchPageList == null || this.mMatchPageList.size() == 0) {
            return;
        }
        List<String> subList = this.postionList(this.mCurrentPage);
        if (subList == null) {
            MLog.info((String)"[LogActivity]", (String)"not exit subList:");
            return;
        }
        if (this.mMatchPageList.size() == 1 && subList.size() == 1) {
            return;
        }
        this.removeLastHighlightPos();
        if (this.mSearchIndex == 0) {
            this.mMatchPageIndex = this.mMatchPageIndex == 0 ? this.mMatchPageList.size() - 1 : --this.mMatchPageIndex;
            String lastPage = this.matchPage(this.mMatchPageIndex);
            this.mCurrentPage = Integer.parseInt(lastPage);
            subList = this.postionList(this.mCurrentPage);
            if (subList != null) {
                this.mSearchIndex = subList.size() - 1;
            }
        } else {
            --this.mSearchIndex;
        }
        this.mGlobalIndex = this.mGlobalIndex == 1 ? this.mResultCount : --this.mGlobalIndex;
        this.highlightCurPos();
        this.updateResultCount();
        this.scrollToPage(this.mCurrentPage);
    }

    public void searchNext() {
        if (this.mMatchPageList == null || this.mMatchPageList.size() == 0) {
            return;
        }
        List<String> subList = this.postionList(this.mCurrentPage);
        if (subList == null) {
            MLog.info((String)"[LogActivity]", (String)"not exit subList:");
            return;
        }
        if (this.mMatchPageList.size() == 1 && subList.size() == 1) {
            return;
        }
        this.removeLastHighlightPos();
        if (this.mSearchIndex == subList.size() - 1) {
            this.mMatchPageIndex = this.mMatchPageIndex == this.mMatchPageList.size() - 1 ? 0 : ++this.mMatchPageIndex;
            String nextPage = this.matchPage(this.mMatchPageIndex);
            this.mCurrentPage = Integer.parseInt(nextPage);
            this.mSearchIndex = 0;
        } else {
            ++this.mSearchIndex;
        }
        this.mGlobalIndex = this.mGlobalIndex == this.mResultCount ? 1 : ++this.mGlobalIndex;
        this.highlightCurPos();
        this.updateResultCount();
        this.scrollToPage(this.mCurrentPage);
    }

    public void removeLastHighlightPos() {
        SpannableStringBuilder spannableStringBuilder = this.spannableStringBuilder(this.mCurrentPage);
        if (spannableStringBuilder != null) {
            spannableStringBuilder.removeSpan((Object)this.mLastSpan);
        }
    }

    public void highlightCurPos() {
        int startPos = this.startPostion(this.mCurrentPage, this.mSearchIndex);
        if (startPos != -1) {
            SpannableStringBuilder spannableStringBuilder = this.spannableStringBuilder(this.mCurrentPage);
            if (spannableStringBuilder != null) {
                BackgroundColorSpan span = new BackgroundColorSpan(-16776961);
                spannableStringBuilder.setSpan((Object)span, startPos, startPos + this.mSearchKey.length(), 33);
                this.mLastSpan = span;
            }
            this.mAdapter.setSpannableList(this.mSpannableList);
        }
    }

    public void scrollToPage(int page) {
        this.mLogListView.setSelection(page);
    }

    public void scrollToFirst() {
        if (this.mMatchPageList != null && this.mMatchPageList.size() > 0) {
            String firstPageString = this.mMatchPageList.get(0);
            this.mCurrentPage = Integer.parseInt(firstPageString);
            this.mAdapter.setSpannableList(this.mSpannableList);
            this.scrollToPage(this.mCurrentPage);
        }
    }

    public void sliceLog() {
        if (this.mLogContent != null && this.mLogContent.length() > 0) {
            if (this.mLogList == null) {
                this.mLogList = new ArrayList<String>();
            } else {
                this.mLogList.clear();
            }
            int slicePerCharCount = 900;
            int sliceCount = this.mLogContent.length() / slicePerCharCount;
            if (this.mLogContent.length() % slicePerCharCount != 0) {
                ++sliceCount;
            }
            for (int i = 0; i < sliceCount; ++i) {
                String subString;
                int start = i * slicePerCharCount;
                int end = (i + 1) * slicePerCharCount;
                if (i == sliceCount - 1) {
                    end = this.mLogContent.length();
                }
                if ((subString = this.mLogContent.substring(start, end)) == null || subString.length() <= 0) continue;
                this.mLogList.add(subString);
            }
        }
    }

    public void readLog() {
        YYSchedulers.io.scheduleDirect(new Runnable(){

            @Override
            public void run() {
                MLog.info((String)"[LogActivity]", (String)"is reading log");
                String logPath = MLog.getLogPath();
                MLog.LogOptions options = MLog.getOptions();
                String logFilePath = logPath + File.separator + options.logFileName;
                MLog.info((String)"[LogActivity]", (String)logFilePath);
                byte[] content = YYFileUtils.getBytes((String)logFilePath);
                if (content != null) {
                    LogActivity.this.mLogContent = new String(content);
                    Message message = new Message();
                    message.what = 1;
                    LogActivity.this.mHandler.sendMessage(message);
                }
            }
        });
    }

    private static class LogHandler
    extends SafeDispatchHandler {
        WeakReference<LogActivity> mActivity;

        LogHandler(LogActivity activity2) {
            this.mActivity = new WeakReference<LogActivity>(activity2);
        }

        public void handleMessage(Message msg) {
            LogActivity activity2 = (LogActivity)((Object)this.mActivity.get());
            if (activity2 == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    activity2.sliceLog();
                    activity2.mAdapter.setLogList(activity2.mLogList);
                    break;
                }
                case 2: {
                    activity2.updateResultCount();
                    activity2.scrollToFirst();
                    break;
                }
            }
            super.handleMessage(msg);
        }
    }
}

