/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting;

import android.content.Context;
import android.content.SharedPreferences;
import com.duowan.mobile.main.feature.FeatureStorage;
import com.duowan.mobile.main.feature.Features;
import com.duowan.mobile.main.feature.FeaturesFactory;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.pref2.SharedPreferencesUtils;
import com.yy.mobile.util.log.MLog;

public class FeatureManager {
    private static final String TAG = "FeatureManager";

    public static void init() {
        Features.init((FeatureStorage)new SPStorage(), (FeaturesFactory)new FeaturesFactory());
        Features.addFeatureMap((String)"main");
    }

    public static class SPStorage
    implements FeatureStorage {
        private SharedPreferences storage() {
            return SharedPreferencesUtils.getSharedPreferences((Context)BasicConfig.getInstance().getAppContext(), (String)"Settings", (int)0);
        }

        public int getInt(String key, int defaultValue) {
            try {
                return this.storage().getInt(key, defaultValue);
            }
            catch (Throwable e) {
                this.clearKey(key);
                return defaultValue;
            }
        }

        public String getString(String key, String defaultValue) {
            try {
                return this.storage().getString(key, defaultValue);
            }
            catch (Throwable e) {
                this.clearKey(key);
                return defaultValue;
            }
        }

        public boolean getBoolean(String key, boolean defaultValue) {
            try {
                return this.storage().getBoolean(key, defaultValue);
            }
            catch (Throwable e) {
                this.clearKey(key);
                return defaultValue;
            }
        }

        public void putInt(String key, int value) {
            this.storage().edit().putInt(key, value).apply();
        }

        public void putString(String key, String value) {
            this.storage().edit().putString(key, value).apply();
        }

        public void putBoolean(String key, boolean value) {
            this.storage().edit().putBoolean(key, value).apply();
        }

        public boolean isDebug() {
            return false;
        }

        private void clearKey(String key) {
            this.storage().edit().remove(key).apply();
            MLog.error((Object)6, (String)FeatureManager.TAG, (Object[])new Object[]{"clear key:" + key});
        }
    }
}

