/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.NotificationChannelManager;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IDownLoadClient_onDownLoadProgress_EventArgs;
import com.yy.mobile.plugin.main.events.IDownLoadClient_onDownLoadResult_EventArgs;
import com.yy.mobile.plugin.main.events.IDownLoadClient_setNotificationInfo_EventArgs;
import com.yy.mobile.ui.setting.DownLoadNotification$$EventBinder;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.download.DownLoadFileInfo;
import com.yymobile.core.download.DownLoadResult;

public class DownLoadNotification
extends EmptyEventCompat {
    private static final String TAG = "DownLoadNotification";
    private static DownLoadNotification instance = new DownLoadNotification();
    private NotificationManager downLoadNotificationManager = null;
    private NotificationCompat.Builder downLoadNotification = null;
    private Integer notifyId = 1000;
    private Context mContext;
    protected DownLoadFileInfo mDownLoadFileInfo;
    private Intent downLoadIntent = null;
    private PendingIntent downLoadPendingIntent = null;
    private EventBinder mEventBinder;

    private DownLoadNotification() {
    }

    public static synchronized DownLoadNotification instance() {
        return instance;
    }

    public void init(Context context) {
        try {
            this.onEventBind();
            this.mContext = context;
            this.downLoadNotificationManager = (NotificationManager)context.getSystemService("notification");
            this.downLoadNotification = new NotificationCompat.Builder(this.mContext);
            this.downLoadNotification.setSmallIcon(0x1080081);
            if (Build.VERSION.SDK_INT >= 26) {
                this.downLoadNotification.setChannelId(NotificationChannelManager.getInstance().getDefaultNotificationChannelId(this.mContext));
            }
            this.downLoadIntent = new Intent("DOWNLOAD");
            this.downLoadPendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)this.downLoadIntent, (int)0);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    @BusEvent
    public void onDownLoadProgress(IDownLoadClient_onDownLoadProgress_EventArgs args) {
        long total = args.getTotal();
        long progress = args.getProgress();
        this.downLoadNotification.setProgress((int)total, (int)progress, false);
        this.downLoadNotification.setContentIntent(this.downLoadPendingIntent);
        this.downLoadNotificationManager.notify(this.notifyId.intValue(), this.downLoadNotification.build());
    }

    @BusEvent
    public void setNotificationInfo(IDownLoadClient_setNotificationInfo_EventArgs args) {
        DownLoadFileInfo downLoadFileInfo = args.getDownLoadFileInfo();
        if (downLoadFileInfo == null) {
            return;
        }
        this.mDownLoadFileInfo = downLoadFileInfo;
        this.downLoadNotification.setTicker((CharSequence)("\u5f00\u59cb\u4e0b\u8f7d  " + downLoadFileInfo.fileName));
        this.downLoadNotification.setContentText((CharSequence)this.mDownLoadFileInfo.fileDescription);
        this.downLoadNotification.setContentIntent(this.downLoadPendingIntent);
        this.downLoadNotification.setContentTitle((CharSequence)(FP.empty((CharSequence)this.mDownLoadFileInfo.fileName) ? this.mContext.getString(R.string.download_start) : this.mDownLoadFileInfo.fileName));
        this.downLoadNotificationManager.notify(this.notifyId.intValue(), this.downLoadNotification.build());
    }

    @BusEvent
    public void onDownLoadResult(IDownLoadClient_onDownLoadResult_EventArgs args) {
        DownLoadResult downLoadResult = args.getDownLoadResult();
        switch (downLoadResult) {
            case DownloadSuccess: {
                this.downLoadNotificationManager.cancel(this.notifyId.intValue());
                break;
            }
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new DownLoadNotification$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

