/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.immersion.ImmersionBar;
import com.yy.mobile.plugin.homeapi.ui.home.UpdateActivity;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.setting.LogActivity;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.extend.RxViewExt;
import com.yy.mobile.util.AppMetaDataUtil;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.VersionUtil;
import com.yymobile.core.UriProvider;
import io.reactivex.functions.Consumer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AboutActivity
extends UpdateActivity {
    private SimpleTitleBar mTitleBar;
    private View btnCheck;
    private View mPolicyView;
    private String mInputString;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_about);
        this.initTitleBar();
        this.mPolicyView = this.findViewById(R.id.policy);
        RxViewExt.safelyClicks((View)this.mPolicyView, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                if (!NetworkUtils.isNetworkAvailable((Context)AboutActivity.this)) {
                    NavigationUtils.toOfflinePrivacy((Activity)AboutActivity.this);
                    return;
                }
                Uri uri = Uri.parse((String)(UriProvider.ABOUT_POLICY_URL + "#" + AppMetaDataUtil.getChannelID((Context)AboutActivity.this)));
                Intent it = new Intent("android.intent.action.VIEW", uri);
                AboutActivity.this.startActivity(it);
            }
        });
        TextView versionTextView = (TextView)this.findViewById(R.id.version);
        VersionUtil.Ver ver = VersionUtil.getLocalVer((Context)this);
        versionTextView.setText((CharSequence)(this.getString(R.string.str_about_version_str_prefix) + ver.aboutDisplayName((Context)this)));
        this.btnCheck = this.findViewById(R.id.btn_check_new_version);
        RxViewExt.safelyClicks((View)this.btnCheck, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                AboutActivity.this.checkUpdate();
            }
        });
        ImageView imageView = (ImageView)this.findViewById(R.id.about_logo);
        imageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return false;
            }
        });
    }

    private void initTitleBar() {
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        this.mTitleBar.setTitlte(this.getString(R.string.str_about));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                AboutActivity.this.finish();
            }
        });
    }

    public void onClickButton(View v) {
        String tag = (String)v.getTag();
        this.handleInput(tag);
    }

    private String getCurrentTime() {
        SimpleDateFormat formatter = CommonUtils.getSimpleDateFormat((String)"HH:mm");
        Date curDate = new Date(System.currentTimeMillis());
        String str = formatter.format(curDate);
        str = str.replace(":", "");
        return str;
    }

    private void handleInput(String inputString) {
        if (TextUtils.isEmpty((CharSequence)inputString)) {
            return;
        }
        if (this.mInputString == null) {
            this.mInputString = new String();
        }
        this.mInputString = this.mInputString + inputString;
        int length = 4;
        int inputLength = this.mInputString.length();
        if (inputLength >= length) {
            String currentTime = this.getCurrentTime();
            boolean isCorrect = true;
            String subString = this.mInputString.substring(inputLength - length, inputLength);
            for (int i = 0; i < subString.length(); ++i) {
                char c1 = subString.charAt(i);
                char c2 = currentTime.charAt(i);
                if (c2 == '0' || c1 == c2) continue;
                isCorrect = false;
                break;
            }
            if (isCorrect) {
                this.goLog();
                this.mInputString = "";
            }
        }
    }

    private void goLog() {
        Intent intent = new Intent((Context)this, LogActivity.class);
        this.startActivity(intent);
    }

    protected boolean handleStatusBar() {
        if (ScreenUtil.isInDarkMode()) {
            this.immersionBar = ImmersionBar.with((Activity)this).fitsSystemWindows(true).statusBarColor(R.color.color_white).navigationBarColor(R.color.color_white).init();
            return true;
        }
        return false;
    }
}

