/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.report;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.FragmentActivity;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.report.ReportPagerFragment;
import com.yy.mobile.ui.report.listener.ReportViewPageChangedListener;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.im.event.AddToBlackListEventArgs;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;

public class ReportFeedbackFragment
extends ReportPagerFragment {
    private static final String TAG = "ReportFeedbackFragment";
    public static final String REPORT_USER_ID = "report_user_id";
    private View mRootView;
    private View mFeedbackDesc2;
    private View mDivider;
    private ReportViewPageChangedListener mListener;
    private long mUserId;
    List<Disposable> mEventDisposable = new ArrayList<Disposable>();

    public static ReportFeedbackFragment newInstance(long userId) {
        ReportFeedbackFragment feedbackFragment = new ReportFeedbackFragment();
        Bundle bundle = new Bundle();
        bundle.putLong(REPORT_USER_ID, userId);
        feedbackFragment.setArguments(bundle);
        return feedbackFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Disposable disposable2 = RxBus.getDefault().register(AddToBlackListEventArgs.class, (Object)this).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<AddToBlackListEventArgs>(){

            public void accept(@NonNull AddToBlackListEventArgs eventArgs) throws Exception {
                ReportFeedbackFragment.this.onMoveBuddyToBackListNotify(eventArgs.getUid(), eventArgs.getResCode());
            }
        }, RxUtils.errorConsumer((String)TAG));
        this.mEventDisposable.add(disposable2);
    }

    private void unregisterEvent() {
        if (this.mEventDisposable != null) {
            for (Disposable disposable2 : this.mEventDisposable) {
                if (disposable2 == null || disposable2.isDisposed()) continue;
                disposable2.dispose();
            }
            this.mEventDisposable.clear();
        }
    }

    @Override
    public void setReportViewPageChangedListener(ReportViewPageChangedListener listener2) {
        this.mListener = listener2;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.getArguments() != null) {
            this.mUserId = this.getArguments().getLong(REPORT_USER_ID, 0L);
        }
        this.mRootView = inflater.inflate(R.layout.fragment_report_feedback, container, false);
        this.mFeedbackDesc2 = this.mRootView.findViewById(R.id.icon_feedback_success_desc2);
        this.mDivider = this.mRootView.findViewById(R.id.icon_feedback_line);
        this.mRootView.findViewById(R.id.report_close_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ReportFeedbackFragment.this.mListener == null) {
                    FragmentActivity activity2 = ReportFeedbackFragment.this.getActivity();
                    if (activity2 != null) {
                        activity2.finish();
                    }
                } else {
                    ReportFeedbackFragment.this.mListener.onReportViewPageClosed();
                }
            }
        });
        return this.mRootView;
    }

    public void onDestroy() {
        super.onDestroy();
        this.unregisterEvent();
    }

    public void onMoveBuddyToBackListNotify(long buddyUid, int resCode) {
        if (this.mFeedbackDesc2 == null) {
            return;
        }
        if (this.mUserId == buddyUid && resCode == 200) {
            this.mFeedbackDesc2.setVisibility(0);
            this.mDivider.setVisibility(0);
        } else {
            this.mFeedbackDesc2.setVisibility(8);
            this.mDivider.setVisibility(8);
            MLog.error((String)TAG, (String)("checkActivityValid = " + this.checkActivityValid() + ", mUserId = " + this.mUserId));
        }
    }
}

