/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.report;

import android.app.Activity;
import android.content.DialogInterface;
import android.text.TextUtils;
import com.yy.android.sniper.annotation.sneak.DartsRegister;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.common.ReportManager;
import com.yy.mobile.http.DefaultRequestParam;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.plugin.main.events.IReportClientOnChatSettingGetScreenShotEventArgs;
import com.yy.mobile.plugin.main.events.IReportClient_onReport_EventArgs;
import com.yy.mobile.plugin.main.events.IReportUploadClient_onUploadFail_EventArgs;
import com.yy.mobile.plugin.main.events.IReportUploadClient_onUploadSuccess_EventArgs;
import com.yy.mobile.sdkwrapper.login.LoginProtocol;
import com.yy.mobile.ui.report.SoundReportHelper;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.AbstractBaseCore;
import com.yymobile.core.LinkUriProvider;
import com.yymobile.core.ent.ProtosMapper;
import com.yymobile.core.ent.event.IEntClient_onReceive_EventArgs;
import com.yymobile.core.ent.protos.IEntProtocol;
import com.yymobile.core.report.IReportCore;
import com.yymobile.core.report.OnReportItemClickListener;
import com.yymobile.core.report.ReportProtocol;
import com.yymobile.core.report.event.IReportClientOnBroadChatSettingGetScreenShotEventArgs;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.functions.Function;
import java.io.File;
import java.util.Map;
import org.json.JSONObject;

@DartsRegister(dependent=IReportCore.class)
public class ReportCoreImpl
extends AbstractBaseCore
implements IReportCore {
    private static final String TAG = "ReportCoreImpl";
    public static final String PIC_NAME = "upload.jpg";
    public static final String KEY_PHOTOURL = "photoUrl";
    public static final String KEY_BUCKETNAME = "bucketName";
    public static final String KEY_UID = "uid";
    public static final String KEY_TOKEN = "token";

    public ReportCoreImpl() {
        this.onEventBind();
        ReportProtocol.registerProtocols();
        ProtosMapper.registerAbstractCore((long)ReportProtocol.MsgMaxType.ACTIVITY_MAX.longValue(), (AbstractBaseCore)this);
    }

    public void sendReport(int type, long chid, int style2, long suid, String content, String extParUrlEncoder, String extProductorParm, Map<String, String> extendInfo) {
        ReportProtocol.ReportReq req = new ReportProtocol.ReportReq();
        req.type = Uint32.toUInt((int)type);
        req.chid = Uint32.toUInt((long)chid);
        req.style = Uint32.toUInt((int)style2);
        req.suid = Uint32.toUInt((long)suid);
        if (content != null) {
            req.content = content;
        }
        if (extParUrlEncoder != null) {
            req.extParUrlEncoder = extParUrlEncoder;
        }
        if (extProductorParm != null) {
            req.extProductorParm = extProductorParm;
        }
        if (extendInfo != null) {
            req.extendInfo = extendInfo;
        }
        MLog.info((Object)TAG, (String)"sendReport %s", (Object[])new Object[]{req});
        this.sendEntRequest((IEntProtocol)req);
    }

    public void onProtocolSuccess(IEntClient_onReceive_EventArgs busEventArgs) {
        IEntProtocol entProtocol = busEventArgs.getProtocol();
        if (ReportProtocol.ReportResp.sMinType.equals((Object)entProtocol.getMinType())) {
            this.onReportRespond((ReportProtocol.ReportResp)entProtocol);
        }
    }

    private void onReportRespond(ReportProtocol.ReportResp entProtocol) {
        int code = entProtocol.code;
        RxBus.getDefault().post((Object)new IReportClient_onReport_EventArgs(code, entProtocol.mData));
    }

    public void uploadScreenshot(String filepath, final int style2, final String title, final String context) {
        if (TextUtils.isEmpty((CharSequence)filepath)) {
            MLog.info((String)TAG, (String)"[uploadScreenshot TextUtils.isEmpty(filepath)]");
            RxBus.getDefault().post((Object)new IReportUploadClient_onUploadFail_EventArgs(context));
            return;
        }
        File mScreenShot = new File(filepath);
        if (!mScreenShot.exists()) {
            MLog.info((String)TAG, (String)"[uploadScreenshot !mScreenShot.exists()]");
            RxBus.getDefault().post((Object)new IReportUploadClient_onUploadFail_EventArgs(context));
            return;
        }
        String url = LinkUriProvider.REPORT_PIC_UPLOAD;
        String bucketName = "fansorder";
        String token = LoginProtocol.Factory.get().getWebToken();
        String uid = "" + LoginUtil.getUid();
        ResponseListener<String> successListener = new ResponseListener<String>(){

            public void onResponse(String response) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((String)ReportCoreImpl.TAG, (String)("uploadScreenshot upload pic success:" + response));
                }
                try {
                    String url;
                    JSONObject jData;
                    JSONObject jResult = new JSONObject(response);
                    int result = jResult.optInt("result");
                    if (result == 0 && (jData = jResult.getJSONObject("data")).has("url") && !TextUtils.isEmpty((CharSequence)(url = jData.getString("url")))) {
                        RxBus.getDefault().post((Object)new IReportUploadClient_onUploadSuccess_EventArgs(url, style2, title, context));
                        return;
                    }
                    MLog.info((String)ReportCoreImpl.TAG, (String)"[uploadScreenshot.IReportUploadClient_onUploadFail_EventArgs]");
                    RxBus.getDefault().post((Object)new IReportUploadClient_onUploadFail_EventArgs(context));
                }
                catch (Exception e) {
                    MLog.info((String)ReportCoreImpl.TAG, (String)"[uploadScreenshot.Exception IReportUploadClient_onUploadFail_EventArgs]");
                    RxBus.getDefault().post((Object)new IReportUploadClient_onUploadFail_EventArgs(context));
                    MLog.error((Object)ReportCoreImpl.TAG, (Throwable)e);
                }
            }
        };
        ResponseErrorListener errorListener = new ResponseErrorListener(){

            public void onErrorResponse(RequestError error) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(ReportCoreImpl.class, (String)"upload pic fail", (Object[])new Object[0]);
                }
                RxBus.getDefault().post((Object)new IReportUploadClient_onUploadFail_EventArgs(context));
            }
        };
        DefaultRequestParam params = new DefaultRequestParam();
        params.put(KEY_BUCKETNAME, bucketName);
        params.put(KEY_UID, uid);
        params.put(KEY_TOKEN, token);
        params.put(KEY_PHOTOURL, new RequestParam.FileWrapper(mScreenShot, PIC_NAME));
        RequestManager.instance().submitMultipartPostRequest(url, (RequestParam)params, (ResponseListener)successListener, errorListener, true);
    }

    public Flowable<IReportCore.Result> uploadScreenshot(final String filepath) {
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<String>(){

            public void subscribe(final FlowableEmitter<String> e) throws Exception {
                File mScreenShot;
                if (TextUtils.isEmpty((CharSequence)filepath)) {
                    e.onError((Throwable)new IllegalStateException("filepath is empty"));
                }
                if (!(mScreenShot = new File(filepath)).exists()) {
                    e.onError((Throwable)new IllegalStateException("file of " + filepath + " is not exist"));
                }
                String url = LinkUriProvider.REPORT_PIC_UPLOAD;
                String bucketName = "fansorder";
                String token = LoginProtocol.Factory.get().getWebToken();
                String uid = String.valueOf(LoginUtil.getUid());
                DefaultRequestParam params = new DefaultRequestParam();
                params.put(ReportCoreImpl.KEY_BUCKETNAME, bucketName);
                params.put(ReportCoreImpl.KEY_UID, uid);
                params.put(ReportCoreImpl.KEY_TOKEN, token);
                params.put(ReportCoreImpl.KEY_PHOTOURL, new RequestParam.FileWrapper(mScreenShot, ReportCoreImpl.PIC_NAME));
                RequestManager.instance().submitMultipartPostRequest(url, (RequestParam)params, (ResponseListener)new ResponseListener<String>(){

                    public void onResponse(String response) {
                        e.onNext((Object)response);
                    }
                }, new ResponseErrorListener(){

                    public void onErrorResponse(RequestError error) {
                        e.onError((Throwable)new IllegalStateException("uploadFail"));
                    }
                }, true);
            }
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER).map((Function)new Function<String, IReportCore.Result>(){

            public IReportCore.Result apply(String response) throws Exception {
                String url;
                JSONObject jData;
                JSONObject jResult = new JSONObject(response);
                int result = jResult.optInt("result");
                if (result == 0 && (jData = jResult.getJSONObject("data")).has("url") && !TextUtils.isEmpty((CharSequence)(url = jData.getString("url")))) {
                    IReportCore.Result r = new IReportCore.Result();
                    r.reuslt = result;
                    r.url = url;
                    return r;
                }
                throw new IllegalStateException("result code != 0");
            }
        });
    }

    public void getChatSettingGetScreenShot(String contextTag) {
        RxBus.getDefault().post((Object)new IReportClientOnChatSettingGetScreenShotEventArgs(contextTag));
    }

    public void broadChatSettingGetScreenShot(String contextTag, String screenShotPath) {
        RxBus.getDefault().post((Object)new IReportClientOnBroadChatSettingGetScreenShotEventArgs(contextTag, screenShotPath));
    }

    public void showReportDialog(Activity activity2, int type, long child, long suid, String content, String extParUrlEncoder, String extProductorParm, Map<String, String> extendInfo, OnReportItemClickListener mOnReportItemClickListener, DialogInterface.OnDismissListener dismissListener, int source) {
        ReportManager.showReportDialog((Activity)activity2, (int)type, (long)child, (long)suid, (String)content, (String)extParUrlEncoder, (String)extProductorParm, extendInfo, (OnReportItemClickListener)mOnReportItemClickListener, (DialogInterface.OnDismissListener)dismissListener, (int)source);
    }

    public void onSoundReportJoinChannel() {
        SoundReportHelper.Companion.getInstance().onJoinChannel();
    }

    public void onSoundReportonLeaveChannel() {
        SoundReportHelper.Companion.getInstance().onLeaveChannel();
    }
}

